/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.bsp2D;

import org.thenesis.planetino2.bsp2D.BSPPolygon;
import org.thenesis.planetino2.bsp2D.BSPTree;
import org.thenesis.planetino2.bsp2D.BSPTreeTraverseListener;
import org.thenesis.planetino2.game.GameObjectManager;
import org.thenesis.planetino2.math3D.Vector3D;

public class BSPTreeTraverser {
    private boolean traversing;
    private float x;
    private float z;
    private GameObjectManager objectManager;
    private BSPTreeTraverseListener listener;

    public BSPTreeTraverser() {
        this(null);
    }

    public BSPTreeTraverser(BSPTreeTraverseListener listener) {
        this.setListener(listener);
    }

    public void setListener(BSPTreeTraverseListener listener) {
        this.listener = listener;
    }

    public void setGameObjectManager(GameObjectManager objectManager) {
        this.objectManager = objectManager;
    }

    public void traverse(BSPTree tree, Vector3D viewLocation) {
        this.x = viewLocation.x;
        this.z = viewLocation.z;
        this.traversing = true;
        this.traverseDrawOrder(tree.getRoot());
    }

    public void traverse(BSPTree tree) {
        this.traversing = true;
        this.traverseInOrder(tree.getRoot());
    }

    private void traverseDrawOrder(BSPTree.Node node) {
        if (this.traversing && node != null) {
            if (node instanceof BSPTree.Leaf) {
                this.visitNode(node);
            } else if (node.partition.getSideThin(this.x, this.z) != -1) {
                this.traverseDrawOrder(node.front);
                this.visitNode(node);
                this.traverseDrawOrder(node.back);
            } else {
                this.traverseDrawOrder(node.back);
                this.visitNode(node);
                this.traverseDrawOrder(node.front);
            }
        }
    }

    private void traverseInOrder(BSPTree.Node node) {
        if (this.traversing && node != null) {
            this.traverseInOrder(node.front);
            this.visitNode(node);
            this.traverseInOrder(node.back);
        }
    }

    private void visitNode(BSPTree.Node node) {
        if (!this.traversing || node.polygons == null) {
            return;
        }
        boolean isBack = false;
        if (node instanceof BSPTree.Leaf) {
            BSPTree.Leaf leaf = (BSPTree.Leaf)node;
            isBack = leaf.isBack;
            if (this.objectManager != null && leaf.bounds != null) {
                this.objectManager.markVisible(leaf.bounds);
            }
        }
        for (int i = 0; this.traversing && i < node.polygons.size(); ++i) {
            BSPPolygon poly = (BSPPolygon)node.polygons.elementAt(i);
            this.traversing = this.listener.visitPolygon(poly, isBack);
        }
    }
}

