/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.game;

import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import org.thenesis.planetino2.game.GameObject;
import org.thenesis.planetino2.game.GameObjectManager;
import org.thenesis.planetino2.game.GameObjectRenderer;
import org.thenesis.planetino2.math3D.Rectangle;

public class SimpleGameObjectManager
implements GameObjectManager {
    private Vector allObjects = new Vector();
    private Vector visibleObjects = new Vector();
    private GameObject player = null;

    public void markAllVisible() {
        for (int i = 0; i < this.allObjects.size(); ++i) {
            GameObject object = (GameObject)this.allObjects.elementAt(i);
            if (this.visibleObjects.contains(object)) continue;
            this.visibleObjects.addElement(object);
        }
    }

    public void markVisible(Rectangle bounds) {
        for (int i = 0; i < this.allObjects.size(); ++i) {
            GameObject object = (GameObject)this.allObjects.elementAt(i);
            if (!bounds.contains((int)object.getX(), (int)object.getZ()) || this.visibleObjects.contains(object)) continue;
            this.visibleObjects.addElement(object);
        }
    }

    public void add(GameObject object) {
        if (object != null) {
            this.allObjects.addElement(object);
        }
    }

    public void addPlayer(GameObject player) {
        this.player = player;
        if (player != null) {
            player.notifyVisible(true);
            this.allObjects.insertElementAt(player, 0);
        }
    }

    public GameObject getPlayer() {
        return this.player;
    }

    public void remove(GameObject object) {
        this.allObjects.removeElement(object);
        this.visibleObjects.removeElement(object);
    }

    public void update(long elapsedTime) {
        for (int i = 0; i < this.allObjects.size(); ++i) {
            GameObject object = (GameObject)this.allObjects.elementAt(i);
            object.update(this.player, elapsedTime);
            if (!object.isDestroyed()) continue;
            this.allObjects.removeElementAt(i);
            this.visibleObjects.removeElement(object);
            --i;
        }
    }

    public void draw(Graphics g, GameObjectRenderer r) {
        Enumeration i = this.visibleObjects.elements();
        while (i.hasMoreElements()) {
            GameObject object = (GameObject)i.nextElement();
            boolean visible = r.draw(g, object);
            object.notifyVisible(visible);
        }
        this.visibleObjects.removeAllElements();
    }
}

