/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.graphics3D.texture;

import org.thenesis.planetino2.graphics.Color;
import org.thenesis.planetino2.graphics.DirectColorModel;
import org.thenesis.planetino2.graphics3D.texture.Texture;

public final class ShadedTexture
extends Texture {
    public static final int NUM_SHADE_LEVELS = 64;
    public static final int MAX_LEVEL = 63;
    private static final int PALETTE_SIZE_BITS = 8;
    private static final int PALETTE_SIZE = 256;
    private int[] buffer;
    private DirectColorModel palette;
    private short[] shadeTable;
    private int defaultShadeLevel;
    private int widthBits;
    private int widthMask;
    private int heightBits;
    private int heightMask;
    private int currRow;

    public ShadedTexture(int[] buffer, int widthBits, int heightBits, DirectColorModel palette) {
        this(buffer, widthBits, heightBits, palette, Color.BLACK);
    }

    public ShadedTexture(int[] buffer, int widthBits, int heightBits, DirectColorModel palette, Color targetShade) {
        super(1 << widthBits, 1 << heightBits);
        this.buffer = buffer;
        this.widthBits = widthBits;
        this.heightBits = heightBits;
        this.widthMask = this.getWidth() - 1;
        this.heightMask = this.getHeight() - 1;
        this.palette = palette;
        this.defaultShadeLevel = 63;
    }

    public void setDefaultShadeLevel(int level) {
        this.defaultShadeLevel = level;
    }

    public int getDefaultShadeLevel() {
        return this.defaultShadeLevel;
    }

    public int getColor(int x, int y) {
        return this.getColor(x, y, this.defaultShadeLevel);
    }

    public int getColor(int x, int y, int shadeLevel) {
        return this.buffer[x & this.widthMask | (y & this.heightMask) << this.widthBits];
    }

    public void setCurrRow(int y) {
        this.currRow = (y & this.heightMask) << this.widthBits;
    }

    public short getColorCurrRow(int x, int shadeLevel) {
        return this.shadeTable[shadeLevel << 8 | 0xFF & this.buffer[x & this.widthMask | this.currRow]];
    }

    public int[] getRawData() {
        return this.buffer;
    }

    public int getHeightBits() {
        return this.heightBits;
    }

    public int getHeightMask() {
        return this.heightMask;
    }

    public int getWidthBits() {
        return this.widthBits;
    }

    public int getWidthMask() {
        return this.widthMask;
    }
}

