/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.math3D;

public class Rectangle {
    public int x;
    public int y;
    public int width;
    public int height;

    public Rectangle() {
    }

    public Rectangle(Rectangle r) {
        this.x = r.x;
        this.y = r.y;
        this.width = r.width;
        this.height = r.height;
    }

    public Rectangle(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Rectangle(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public Rectangle getBounds() {
        return new Rectangle(this);
    }

    public void setRect(double x, double y, double width, double height) {
        this.x = (int)Math.floor(x);
        this.y = (int)Math.floor(y);
        this.width = (int)Math.ceil(x + width) - this.x;
        this.height = (int)Math.ceil(y + height) - this.y;
    }

    public void translate(int dx, int dy) {
        this.x += dx;
        this.y += dy;
    }

    public boolean contains(int x, int y) {
        return this.inside(x, y);
    }

    public boolean contains(int x, int y, int w, int h) {
        return this.width > 0 && this.height > 0 && w > 0 && h > 0 && x >= this.x && x + w <= this.x + this.width && y >= this.y && y + h <= this.y + this.height;
    }

    public boolean inside(int x, int y) {
        return this.width > 0 && this.height > 0 && x >= this.x && x < this.x + this.width && y >= this.y && y < this.y + this.height;
    }

    public boolean intersects(Rectangle r) {
        return r.width > 0 && r.height > 0 && this.width > 0 && this.height > 0 && r.x < this.x + this.width && r.x + r.width > this.x && r.y < this.y + this.height && r.y + r.height > this.y;
    }

    public void grow(int h, int v) {
        this.x -= h;
        this.y -= v;
        this.width += h + h;
        this.height += v + v;
    }

    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Rectangle)) {
            return false;
        }
        Rectangle r = (Rectangle)obj;
        return r.getX() == (double)this.x && r.getY() == (double)this.y && r.getWidth() == (double)this.width && r.getHeight() == (double)this.height;
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",width=" + this.width + ",height=" + this.height + ']';
    }
}

