/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.math3D;

import org.thenesis.planetino2.math3D.Rectangle;
import org.thenesis.planetino2.math3D.Vector3D;

public class ViewWindow {
    private Rectangle bounds = new Rectangle();
    private float angle;
    private float distanceToCamera;

    public ViewWindow(int left, int top, int width, int height, float angle) {
        this.angle = angle;
        this.setBounds(left, top, width, height);
    }

    public void setBounds(int left, int top, int width, int height) {
        this.bounds.x = left;
        this.bounds.y = top;
        this.bounds.width = width;
        this.bounds.height = height;
        this.distanceToCamera = (float)(this.bounds.width / 2) / (float)Math.tan(this.angle / 2.0f);
    }

    public void setAngle(float angle) {
        this.angle = angle;
        this.distanceToCamera = (float)(this.bounds.width / 2) / (float)Math.tan(angle / 2.0f);
    }

    public float getAngle() {
        return this.angle;
    }

    public int getWidth() {
        return this.bounds.width;
    }

    public int getHeight() {
        return this.bounds.height;
    }

    public int getTopOffset() {
        return this.bounds.y;
    }

    public int getLeftOffset() {
        return this.bounds.x;
    }

    public float getDistance() {
        return this.distanceToCamera;
    }

    public float convertFromViewXToScreenX(float x) {
        return x + (float)this.bounds.x + (float)(this.bounds.width / 2);
    }

    public float convertFromViewYToScreenY(float y) {
        return -y + (float)this.bounds.y + (float)(this.bounds.height / 2);
    }

    public float convertFromScreenXToViewX(float x) {
        return x - (float)this.bounds.x - (float)(this.bounds.width / 2);
    }

    public float convertFromScreenYToViewY(float y) {
        return -y + (float)this.bounds.y + (float)(this.bounds.height / 2);
    }

    public void project(Vector3D v) {
        v.x = this.distanceToCamera * v.x / -v.z;
        v.y = this.distanceToCamera * v.y / -v.z;
        v.x = this.convertFromViewXToScreenX(v.x);
        v.y = this.convertFromViewYToScreenY(v.y);
    }
}

