/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.path;

import java.util.Vector;
import org.thenesis.planetino2.path.AStarNode;
import org.thenesis.planetino2.util.Comparable;

public class AStarSearch {
    protected Vector constructPath(AStarNode node) {
        Vector<AStarNode> path = new Vector<AStarNode>();
        while (node.pathParent != null) {
            path.insertElementAt(node, 0);
            node = node.pathParent;
        }
        return path;
    }

    public Vector findPath(AStarNode startNode, AStarNode goalNode) {
        PriorityList openList = new PriorityList();
        Vector<AStarNode> closedList = new Vector<AStarNode>();
        startNode.costFromStart = 0.0f;
        startNode.estimatedCostToGoal = startNode.getEstimatedCost(goalNode);
        startNode.pathParent = null;
        openList.addElement(startNode);
        while (!openList.isEmpty()) {
            AStarNode node = (AStarNode)openList.elementAt(0);
            openList.removeElementAt(0);
            if (node == goalNode) {
                return this.constructPath(goalNode);
            }
            Vector neighbors = node.getNeighbors();
            for (int i = 0; i < neighbors.size(); ++i) {
                AStarNode neighborNode = (AStarNode)neighbors.elementAt(i);
                boolean isOpen = openList.contains(neighborNode);
                boolean isClosed = closedList.contains(neighborNode);
                float costFromStart = node.costFromStart + node.getCost(neighborNode);
                if ((isOpen || isClosed) && !(costFromStart < neighborNode.costFromStart)) continue;
                neighborNode.pathParent = node;
                neighborNode.costFromStart = costFromStart;
                neighborNode.estimatedCostToGoal = neighborNode.getEstimatedCost(goalNode);
                if (isClosed) {
                    closedList.removeElement(neighborNode);
                }
                if (isOpen) continue;
                openList.addElement(neighborNode);
            }
            closedList.addElement(node);
        }
        return null;
    }

    public static class PriorityList
    extends Vector {
        public void add(Comparable object) {
            for (int i = 0; i < this.size(); ++i) {
                if (object.compareTo(this.elementAt(i)) > 0) continue;
                this.insertElementAt(object, i);
                return;
            }
            this.addElement(object);
        }
    }
}

