/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.test;

import org.thenesis.planetino2.engine.GameCore3D;
import org.thenesis.planetino2.graphics.Screen;
import org.thenesis.planetino2.graphics3D.FastTexturedPolygonRenderer;
import org.thenesis.planetino2.graphics3D.texture.Texture;
import org.thenesis.planetino2.input.InputManager;
import org.thenesis.planetino2.math3D.Rectangle3D;
import org.thenesis.planetino2.math3D.TexturedPolygon3D;
import org.thenesis.planetino2.math3D.Transform3D;
import org.thenesis.planetino2.math3D.Vector3D;
import org.thenesis.planetino2.math3D.ViewWindow;

public class TextureMapTest2
extends GameCore3D {
    public TextureMapTest2(Screen screen, InputManager inputManager) {
        super(screen, inputManager);
        this.inputManager = inputManager;
    }

    public void createPolygons() {
        Texture wall = this.loadTexture("/res/", "wall1.png");
        Texture roof = this.loadTexture("/res/", "roof1.png");
        TexturedPolygon3D poly = new TexturedPolygon3D(new Vector3D(-200.0f, 250.0f, -1000.0f), new Vector3D(-200.0f, 0.0f, -1000.0f), new Vector3D(200.0f, 0.0f, -1000.0f), new Vector3D(200.0f, 250.0f, -1000.0f));
        this.setTexture(poly, wall);
        this.polygons.addElement(poly);
        poly = new TexturedPolygon3D(new Vector3D(200.0f, 250.0f, -1400.0f), new Vector3D(200.0f, 0.0f, -1400.0f), new Vector3D(-200.0f, 0.0f, -1400.0f), new Vector3D(-200.0f, 250.0f, -1400.0f));
        this.setTexture(poly, wall);
        this.polygons.addElement(poly);
        poly = new TexturedPolygon3D(new Vector3D(-200.0f, 250.0f, -1400.0f), new Vector3D(-200.0f, 0.0f, -1400.0f), new Vector3D(-200.0f, 0.0f, -1000.0f), new Vector3D(-200.0f, 250.0f, -1000.0f));
        this.setTexture(poly, wall);
        this.polygons.addElement(poly);
        poly = new TexturedPolygon3D(new Vector3D(200.0f, 250.0f, -1000.0f), new Vector3D(200.0f, 0.0f, -1000.0f), new Vector3D(200.0f, 0.0f, -1400.0f), new Vector3D(200.0f, 250.0f, -1400.0f));
        this.setTexture(poly, wall);
        this.polygons.addElement(poly);
        poly = new TexturedPolygon3D(new Vector3D(-200.0f, 250.0f, -1000.0f), new Vector3D(200.0f, 250.0f, -1000.0f), new Vector3D(75.0f, 400.0f, -1200.0f), new Vector3D(-75.0f, 400.0f, -1200.0f));
        this.setTexture(poly, roof);
        this.polygons.addElement(poly);
        poly = new TexturedPolygon3D(new Vector3D(-200.0f, 250.0f, -1400.0f), new Vector3D(-200.0f, 250.0f, -1000.0f), new Vector3D(-75.0f, 400.0f, -1200.0f));
        this.setTexture(poly, roof);
        this.polygons.addElement(poly);
        poly = new TexturedPolygon3D(new Vector3D(200.0f, 250.0f, -1400.0f), new Vector3D(-200.0f, 250.0f, -1400.0f), new Vector3D(-75.0f, 400.0f, -1200.0f), new Vector3D(75.0f, 400.0f, -1200.0f));
        this.setTexture(poly, roof);
        this.polygons.addElement(poly);
        poly = new TexturedPolygon3D(new Vector3D(200.0f, 250.0f, -1000.0f), new Vector3D(200.0f, 250.0f, -1400.0f), new Vector3D(75.0f, 400.0f, -1200.0f));
        this.setTexture(poly, roof);
        this.polygons.addElement(poly);
    }

    public void setTexture(TexturedPolygon3D poly, Texture texture) {
        Vector3D origin = poly.getVertex(0);
        Vector3D dv = new Vector3D(poly.getVertex(1));
        dv.subtract(origin);
        Vector3D du = new Vector3D();
        du.setToCrossProduct(poly.getNormal(), dv);
        Rectangle3D textureBounds = new Rectangle3D(origin, du, dv, texture.getWidth(), texture.getHeight());
        poly.setTexture(texture, textureBounds);
    }

    public Texture loadTexture(String path, String imageName) {
        return Texture.createTexture(path, imageName);
    }

    public void createPolygonRenderer() {
        this.viewWindow = new ViewWindow(0, 0, this.screen.getWidth(), this.screen.getHeight(), (float)Math.toRadians(75.0));
        Transform3D camera = new Transform3D(0.0f, 100.0f, 0.0f);
        this.polygonRenderer = new FastTexturedPolygonRenderer(camera, this.viewWindow);
    }
}

