/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.ai.pattern;

import java.util.Enumeration;
import org.thenesis.planetino2.bsp2D.BSPTree;
import org.thenesis.planetino2.game.GameObject;
import org.thenesis.planetino2.math3D.Vector3D;
import org.thenesis.planetino2.path.PathFinder;

public abstract class AIPattern
implements PathFinder {
    protected BSPTree bspTree;

    public AIPattern(BSPTree bspTree) {
        this.bspTree = bspTree;
    }

    public void setBSPTree(BSPTree bspTree) {
        this.bspTree = bspTree;
    }

    public Enumeration find(Vector3D start, Vector3D goal) {
        return null;
    }

    public abstract Enumeration find(GameObject var1, GameObject var2);

    protected void calcFloorHeight(Vector3D v, float defaultY) {
        BSPTree.Leaf leaf = this.bspTree.getLeaf(v.x, v.z);
        v.y = leaf == null || leaf.floorHeight == Float.MIN_VALUE ? defaultY : leaf.floorHeight;
    }

    protected Vector3D getLocationFromPlayer(GameObject bot, GameObject player, float desiredDistSq) {
        float distSq = bot.getLocation().getDistanceSq(player.getLocation());
        if (Math.abs(desiredDistSq - distSq) < 25.0f) {
            return new Vector3D(bot.getLocation());
        }
        Vector3D goal = new Vector3D(bot.getLocation());
        goal.subtract(player.getLocation());
        goal.multiply((float)Math.sqrt(desiredDistSq / distSq));
        goal.add(player.getLocation());
        this.calcFloorHeight(goal, bot.getFloorHeight());
        return goal;
    }

    public String toString() {
        String fullName = this.getClass().getName();
        int index = fullName.lastIndexOf(46);
        return fullName.substring(index + 1);
    }
}

