/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.bsp2D;

import org.thenesis.planetino2.bsp2D.BSPLine;
import org.thenesis.planetino2.math3D.TexturedPolygon3D;
import org.thenesis.planetino2.math3D.Vector3D;

public class BSPPolygon
extends TexturedPolygon3D {
    public static final int TYPE_FLOOR = 0;
    public static final int TYPE_WALL = 1;
    public static final int TYPE_PASSABLE_WALL = 2;
    public static final int PASSABLE_WALL_THRESHOLD = 32;
    public static final int PASSABLE_ENTRYWAY_THRESHOLD = 128;
    private int type;
    private float ambientLightIntensity;
    private BSPLine line;

    public BSPPolygon(Vector3D[] vertices, int type) {
        super(vertices);
        this.type = type;
        this.ambientLightIntensity = 0.5f;
        if (this.isWall()) {
            this.line = new BSPLine(this);
        }
    }

    public BSPPolygon clone(Vector3D[] vertices) {
        BSPPolygon clone = new BSPPolygon(vertices, this.type);
        clone.setNormal(this.getNormal());
        clone.setAmbientLightIntensity(this.getAmbientLightIntensity());
        if (this.getTexture() != null) {
            clone.setTexture(this.getTexture(), this.getTextureBounds());
        }
        return clone;
    }

    public boolean isWall() {
        return this.type == 1 || this.type == 2;
    }

    public boolean isSolidWall() {
        return this.type == 1;
    }

    public BSPLine getLine() {
        return this.line;
    }

    public void setAmbientLightIntensity(float a) {
        this.ambientLightIntensity = a;
    }

    public float getAmbientLightIntensity() {
        return this.ambientLightIntensity;
    }
}

