/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.bsp2D;

import java.util.Enumeration;
import java.util.Vector;
import org.thenesis.planetino2.bsp2D.BSPLine;
import org.thenesis.planetino2.bsp2D.BSPPolygon;
import org.thenesis.planetino2.bsp2D.BSPTree;
import org.thenesis.planetino2.bsp2D.BSPTreeTraverseListener;
import org.thenesis.planetino2.bsp2D.BSPTreeTraverser;
import org.thenesis.planetino2.math3D.Rectangle;
import org.thenesis.planetino2.math3D.Vector3D;

public class BSPTreeBuilder {
    protected BSPTree currentTree;

    public BSPTree build(Vector polygons) {
        this.currentTree = new BSPTree(this.createNewNode(polygons));
        this.buildNode(this.currentTree.getRoot());
        return this.currentTree;
    }

    protected void buildNode(BSPTree.Node node) {
        if (node instanceof BSPTree.Leaf) {
            return;
        }
        Vector<BSPPolygon> collinearList = new Vector<BSPPolygon>();
        Vector<BSPPolygon> frontList = new Vector<BSPPolygon>();
        Vector<BSPPolygon> backList = new Vector<BSPPolygon>();
        Vector allPolygons = node.polygons;
        node.polygons = null;
        for (int i = 0; i < allPolygons.size(); ++i) {
            BSPPolygon poly = (BSPPolygon)allPolygons.elementAt(i);
            int side = node.partition.getSide(poly);
            if (side == 0) {
                collinearList.addElement(poly);
                continue;
            }
            if (side == 1) {
                frontList.addElement(poly);
                continue;
            }
            if (side == -1) {
                backList.addElement(poly);
                continue;
            }
            if (side != 2) continue;
            BSPPolygon front = this.clipBack(poly, node.partition);
            BSPPolygon back = this.clipFront(poly, node.partition);
            if (front != null) {
                frontList.addElement(front);
            }
            if (back == null) continue;
            backList.addElement(back);
        }
        collinearList.trimToSize();
        frontList.trimToSize();
        backList.trimToSize();
        node.polygons = collinearList;
        node.front = this.createNewNode(frontList);
        node.back = this.createNewNode(backList);
        this.buildNode(node.front);
        this.buildNode(node.back);
        if (node.back instanceof BSPTree.Leaf) {
            ((BSPTree.Leaf)node.back).isBack = true;
        }
    }

    protected BSPTree.Node createNewNode(Vector polygons) {
        BSPLine partition = this.choosePartition(polygons);
        if (partition == null) {
            BSPTree.Leaf leaf = new BSPTree.Leaf();
            leaf.polygons = polygons;
            this.buildLeaf(leaf);
            return leaf;
        }
        BSPTree.Node node = new BSPTree.Node();
        node.polygons = polygons;
        node.partition = partition;
        return node;
    }

    protected void buildLeaf(BSPTree.Leaf leaf) {
        BSPPolygon poly;
        if (leaf.polygons.size() == 0) {
            leaf.ceilHeight = Float.MAX_VALUE;
            leaf.floorHeight = Float.MIN_VALUE;
            leaf.bounds = null;
            return;
        }
        float minX = Float.MAX_VALUE;
        float maxX = Float.MIN_VALUE;
        float minY = Float.MAX_VALUE;
        float maxY = Float.MIN_VALUE;
        float minZ = Float.MAX_VALUE;
        float maxZ = Float.MIN_VALUE;
        Enumeration i = leaf.polygons.elements();
        while (i.hasMoreElements()) {
            poly = (BSPPolygon)i.nextElement();
            for (int j = 0; j < poly.getNumVertices(); ++j) {
                Vector3D v = poly.getVertex(j);
                minX = Math.min(minX, v.x);
                maxX = Math.max(maxX, v.x);
                minY = Math.min(minY, v.y);
                maxY = Math.max(maxY, v.y);
                minZ = Math.min(minZ, v.z);
                maxZ = Math.max(maxZ, v.z);
            }
        }
        i = leaf.polygons.elements();
        while (i.hasMoreElements()) {
            float y;
            poly = (BSPPolygon)i.nextElement();
            if (poly.getNormal().y != 1.0f || !((y = poly.getVertex((int)0).y) > minY) || !(y < maxY)) continue;
            minY = y;
        }
        leaf.ceilHeight = maxY;
        leaf.floorHeight = minY;
        leaf.bounds = new Rectangle((int)Math.floor(minX), (int)Math.floor(minZ), (int)Math.ceil(maxX - minX + 1.0f), (int)Math.ceil(maxZ - minZ + 1.0f));
    }

    protected BSPLine choosePartition(Vector polygons) {
        for (int i = 0; i < polygons.size(); ++i) {
            BSPPolygon poly = (BSPPolygon)polygons.elementAt(i);
            if (!poly.isWall()) continue;
            return new BSPLine(poly);
        }
        return null;
    }

    protected BSPPolygon clipFront(BSPPolygon poly, BSPLine line) {
        return this.clip(poly, line, 1);
    }

    protected BSPPolygon clipBack(BSPPolygon poly, BSPLine line) {
        return this.clip(poly, line, -1);
    }

    protected BSPPolygon clip(BSPPolygon poly, BSPLine line, int clipSide) {
        int i;
        Vector<Vector3D> vertices = new Vector<Vector3D>();
        BSPLine polyEdge = new BSPLine();
        for (i = 0; i < poly.getNumVertices(); ++i) {
            int next = (i + 1) % poly.getNumVertices();
            Vector3D v1 = poly.getVertex(i);
            Vector3D v2 = poly.getVertex(next);
            int side1 = line.getSideThin(v1.x, v1.z);
            int side2 = line.getSideThin(v2.x, v2.z);
            if (side1 != clipSide) {
                vertices.addElement(v1);
            }
            if ((side1 != 1 || side2 != -1) && (side2 != 1 || side1 != -1)) continue;
            if (v1.z > v2.z) {
                Vector3D temp = v1;
                v1 = v2;
                v2 = temp;
            }
            polyEdge.setLine(v1.x, v1.z, v2.x, v2.z);
            float f = polyEdge.getIntersection(line);
            Vector3D tPoint = new Vector3D(v1.x + f * (v2.x - v1.x), v1.y + f * (v2.y - v1.y), v1.z + f * (v2.z - v1.z));
            vertices.addElement(tPoint);
            this.removeTJunctions(v1, v2, tPoint);
        }
        for (i = 0; i < vertices.size(); ++i) {
            Vector3D next;
            Vector3D v = (Vector3D)vertices.elementAt(i);
            if (!v.equals(next = (Vector3D)vertices.elementAt((i + 1) % vertices.size()))) continue;
            vertices.removeElementAt(i);
            --i;
        }
        if (vertices.size() < 3) {
            return null;
        }
        Object[] array = new Vector3D[vertices.size()];
        vertices.copyInto(array);
        return poly.clone((Vector3D[])array);
    }

    protected void removeTJunctions(final Vector3D v1, final Vector3D v2, final Vector3D tPoint) {
        BSPTreeTraverser traverser = new BSPTreeTraverser(new BSPTreeTraverseListener(){

            public boolean visitPolygon(BSPPolygon poly, boolean isBackLeaf) {
                BSPTreeBuilder.this.removeTJunctions(poly, v1, v2, tPoint);
                return true;
            }
        });
        traverser.traverse(this.currentTree);
    }

    protected void removeTJunctions(BSPPolygon poly, Vector3D v1, Vector3D v2, Vector3D tPoint) {
        for (int i = 0; i < poly.getNumVertices(); ++i) {
            int next = (i + 1) % poly.getNumVertices();
            Vector3D p1 = poly.getVertex(i);
            Vector3D p2 = poly.getVertex(next);
            if ((!p1.equals(v1) || !p2.equals(v2)) && (!p1.equals(v2) || !p2.equals(v1))) continue;
            poly.insertVertex(next, tPoint);
            return;
        }
    }
}

