/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.bsp2D;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.thenesis.planetino2.bsp2D.BSPTree;
import org.thenesis.planetino2.bsp2D.BSPTreeBuilder;
import org.thenesis.planetino2.bsp2D.RoomDef;
import org.thenesis.planetino2.math3D.ObjectLoader;
import org.thenesis.planetino2.math3D.PointLight3D;
import org.thenesis.planetino2.math3D.PolygonGroup;
import org.thenesis.planetino2.math3D.Transform3D;
import org.thenesis.planetino2.math3D.Vector3D;
import org.thenesis.planetino2.util.StringTokenizer;

public class MapLoader
extends ObjectLoader {
    private BSPTreeBuilder builder;
    private Hashtable loadedObjects;
    private Transform3D playerStart;
    private RoomDef currentRoom;
    private Vector rooms;
    private Vector mapObjects;
    private ObjectLoader objectLoader;

    public MapLoader() {
        this(null);
    }

    public MapLoader(BSPTreeBuilder builder) {
        this.builder = builder == null ? new BSPTreeBuilder() : builder;
        this.parsers.put("map", new MapLineParser());
        this.objectLoader = new ObjectLoader();
        this.loadedObjects = new Hashtable();
        this.rooms = new Vector();
        this.mapObjects = new Vector();
    }

    public BSPTree loadMap(String path, String filename) throws IOException {
        this.path = path;
        this.currentRoom = null;
        this.rooms.removeAllElements();
        this.vertices.removeAllElements();
        this.mapObjects.removeAllElements();
        this.playerStart = new Transform3D();
        this.parseFile(filename);
        return this.createBSPTree();
    }

    protected BSPTree createBSPTree() {
        Vector allPolygons = new Vector();
        for (int i = 0; i < this.rooms.size(); ++i) {
            RoomDef room = (RoomDef)this.rooms.elementAt(i);
            Enumeration e = room.createPolygons().elements();
            while (e.hasMoreElements()) {
                allPolygons.addElement(e.nextElement());
            }
        }
        BSPTree tree = this.builder.build(allPolygons);
        tree.createSurfaces(this.lights);
        return tree;
    }

    public Vector getObjectsInMap() {
        return this.mapObjects;
    }

    public Transform3D getPlayerStartLocation() {
        return this.playerStart;
    }

    public void setObjectLights(Vector lights, float ambientLightIntensity) {
        this.objectLoader.setLights(lights, ambientLightIntensity);
    }

    protected class MapLineParser
    implements ObjectLoader.LineParser {
        protected MapLineParser() {
        }

        public void parseLine(String line) throws IOException, NoSuchElementException {
            StringTokenizer tokenizer = new StringTokenizer(line);
            String command = tokenizer.nextToken();
            if (command.equals("v")) {
                MapLoader.this.vertices.addElement(new Vector3D(Float.parseFloat(tokenizer.nextToken()), Float.parseFloat(tokenizer.nextToken()), Float.parseFloat(tokenizer.nextToken())));
            } else if (command.equals("mtllib")) {
                String name = tokenizer.nextToken();
                MapLoader.this.parseFile(name);
            } else if (command.equals("usemtl")) {
                String name = tokenizer.nextToken();
                if ("null".equals(name)) {
                    MapLoader.this.currentMaterial = new ObjectLoader.Material();
                } else {
                    MapLoader.this.currentMaterial = (ObjectLoader.Material)MapLoader.this.materials.get(name);
                    if (MapLoader.this.currentMaterial == null) {
                        MapLoader.this.currentMaterial = new ObjectLoader.Material();
                        System.out.println("no material: " + name);
                    }
                }
            } else if (command.equals("pointlight")) {
                Vector3D loc = MapLoader.this.getVector(tokenizer.nextToken());
                float intensity = 1.0f;
                float falloff = -1.0f;
                if (tokenizer.hasMoreTokens()) {
                    intensity = Float.parseFloat(tokenizer.nextToken());
                }
                if (tokenizer.hasMoreTokens()) {
                    falloff = Float.parseFloat(tokenizer.nextToken());
                }
                MapLoader.this.lights.addElement(new PointLight3D(loc.x, loc.y, loc.z, intensity, falloff));
            } else if (command.equals("ambientLightIntensity")) {
                MapLoader.this.ambientLightIntensity = Float.parseFloat(tokenizer.nextToken());
            } else if (command.equals("player")) {
                MapLoader.this.playerStart.getLocation().setTo(MapLoader.this.getVector(tokenizer.nextToken()));
                if (tokenizer.hasMoreTokens()) {
                    MapLoader.this.playerStart.setAngleY(Float.parseFloat(tokenizer.nextToken()));
                }
            } else if (command.equals("obj")) {
                String uniqueName = tokenizer.nextToken();
                String filename = tokenizer.nextToken();
                PolygonGroup object = (PolygonGroup)MapLoader.this.loadedObjects.get(filename);
                if (object == null) {
                    object = MapLoader.this.objectLoader.loadObject(MapLoader.this.path, filename);
                    MapLoader.this.loadedObjects.put(filename, object);
                }
                Vector3D loc = MapLoader.this.getVector(tokenizer.nextToken());
                PolygonGroup mapObject = (PolygonGroup)object.clone();
                mapObject.getTransform().getLocation().setTo(loc);
                if (!uniqueName.equals("null")) {
                    mapObject.setName(uniqueName);
                }
                if (tokenizer.hasMoreTokens()) {
                    mapObject.getTransform().setAngleY(Float.parseFloat(tokenizer.nextToken()));
                }
                MapLoader.this.mapObjects.addElement(mapObject);
            } else if (command.equals("room")) {
                MapLoader.this.currentRoom = new RoomDef(MapLoader.this.ambientLightIntensity);
                MapLoader.this.rooms.addElement(MapLoader.this.currentRoom);
            } else if (command.equals("floor")) {
                float y = Float.parseFloat(tokenizer.nextToken());
                MapLoader.this.currentRoom.setFloor(y, ((MapLoader)MapLoader.this).currentMaterial.texture);
            } else if (command.equals("ceil")) {
                float y = Float.parseFloat(tokenizer.nextToken());
                MapLoader.this.currentRoom.setCeil(y, ((MapLoader)MapLoader.this).currentMaterial.texture);
            } else if (command.equals("wall")) {
                float x = Float.parseFloat(tokenizer.nextToken());
                float z = Float.parseFloat(tokenizer.nextToken());
                if (tokenizer.hasMoreTokens()) {
                    float bottom = Float.parseFloat(tokenizer.nextToken());
                    float top = Float.parseFloat(tokenizer.nextToken());
                    MapLoader.this.currentRoom.addVertex(x, z, bottom, top, ((MapLoader)MapLoader.this).currentMaterial.texture);
                } else {
                    MapLoader.this.currentRoom.addVertex(x, z, ((MapLoader)MapLoader.this).currentMaterial.texture);
                }
            } else {
                System.out.println("Unknown command: " + command);
            }
        }
    }
}

