/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.engine;

import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import org.thenesis.planetino2.graphics.Screen;

public abstract class GameCore
implements Runnable {
    protected static final int DEFAULT_FONT_SIZE = 24;
    private boolean isRunning;
    protected Screen screen;
    protected int fontSize = 24;

    public GameCore(Screen screen) {
        this.screen = screen;
    }

    public void stop() {
        this.isRunning = false;
    }

    public void run() {
        try {
            this.init();
            this.gameLoop();
        }
        finally {
            if (this.screen != null) {
                this.screen.restoreScreen();
            }
            this.lazilyExit();
        }
    }

    public void lazilyExit() {
        Thread thread = new Thread(){

            public void run() {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.exit(0);
            }
        };
        thread.start();
    }

    public void init() {
        this.isRunning = true;
    }

    public Image loadImage(String fileName) throws IOException {
        return Image.createImage((String)fileName);
    }

    public void gameLoop() {
        long startTime;
        long currTime = startTime = System.currentTimeMillis();
        while (this.isRunning) {
            long elapsedTime = System.currentTimeMillis() - currTime;
            currTime += elapsedTime;
            this.update(elapsedTime);
            Graphics g = this.screen.getGraphics();
            this.draw(g);
            this.screen.update();
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void update(long elapsedTime) {
    }

    public abstract void draw(Graphics var1);
}

