/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.engine.shooter3D;

import org.thenesis.planetino2.game.GameObject;
import org.thenesis.planetino2.math3D.MovingTransform3D;
import org.thenesis.planetino2.math3D.PolygonGroup;
import org.thenesis.planetino2.math3D.Vector3D;

public class Bot
extends GameObject {
    private static final float TURN_SPEED = 5.0E-4f;
    private static final long DECISION_TIME = 2000L;
    protected MovingTransform3D mainTransform;
    protected MovingTransform3D turretTransform;
    protected long timeUntilDecision;
    protected Vector3D lastPlayerLocation;

    public Bot(PolygonGroup polygonGroup) {
        super(polygonGroup);
        this.mainTransform = polygonGroup.getTransform();
        PolygonGroup turret = polygonGroup.getGroup("turret");
        if (turret != null) {
            this.turretTransform = turret.getTransform();
        } else {
            System.out.println("No turret defined!");
        }
        this.lastPlayerLocation = new Vector3D();
    }

    public void notifyVisible(boolean visible) {
        if (!this.isDestroyed()) {
            if (visible) {
                this.setState(1);
            } else {
                this.setState(0);
            }
        }
    }

    public void update(GameObject player, long elapsedTime) {
        if (this.turretTransform == null || this.isIdle()) {
            return;
        }
        Vector3D playerLocation = player.getLocation();
        if (playerLocation.equals(this.lastPlayerLocation)) {
            this.timeUntilDecision = 2000L;
        } else {
            this.timeUntilDecision -= elapsedTime;
            if (this.timeUntilDecision <= 0L || !this.turretTransform.isTurningY()) {
                float x = player.getX() - this.getX();
                float z = player.getZ() - this.getZ();
                this.turretTransform.turnYTo(x, z, -this.mainTransform.getAngleY(), 5.0E-4f);
                this.lastPlayerLocation.setTo(playerLocation);
                this.timeUntilDecision = 2000L;
            }
        }
        super.update(player, elapsedTime);
    }
}

