/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.game;

import org.thenesis.planetino2.game.GameObject;
import org.thenesis.planetino2.game.Physics;
import org.thenesis.planetino2.math3D.PolygonGroup;

public class JumpingGameObject
extends GameObject {
    public static final float DEFAULT_JUMP_HEIGHT = 64.0f;
    protected float jumpVelocity;

    public JumpingGameObject(PolygonGroup group) {
        super(group);
        this.setJumpHeight(64.0f);
    }

    public void setJumpHeight(float jumpHeight) {
        this.jumpVelocity = Physics.getInstance().getJumpVelocity(jumpHeight);
    }

    public void setJumping(boolean isJumping) {
        if (this.isJumping() != isJumping) {
            super.setJumping(isJumping);
            if (isJumping) {
                Physics.getInstance().jump(this, this.jumpVelocity);
            }
        }
    }

    public void notifyFloorCollision() {
        this.setJumping(false);
    }
}

