/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.math3D;

import java.util.Vector;
import org.thenesis.planetino2.math3D.MovingTransform3D;
import org.thenesis.planetino2.math3D.Polygon3D;
import org.thenesis.planetino2.math3D.Transform3D;
import org.thenesis.planetino2.math3D.Transformable;
import org.thenesis.planetino2.math3D.Vector3D;

public class PolygonGroup
implements Transformable {
    private String name;
    private String filename;
    private Vector objects;
    private MovingTransform3D transform;
    private int iteratorIndex;

    public PolygonGroup() {
        this("unnamed");
    }

    public PolygonGroup(String name) {
        this.setName(name);
        this.objects = new Vector();
        this.transform = new MovingTransform3D();
        this.iteratorIndex = 0;
    }

    public MovingTransform3D getTransform() {
        return this.transform;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void addPolygon(Polygon3D o) {
        this.objects.addElement(o);
    }

    public void addPolygonGroup(PolygonGroup p) {
        this.objects.addElement(p);
    }

    public Object clone() {
        PolygonGroup group = new PolygonGroup(this.name);
        group.setFilename(this.filename);
        for (int i = 0; i < this.objects.size(); ++i) {
            Object obj = this.objects.elementAt(i);
            if (obj instanceof Polygon3D) {
                group.addPolygon((Polygon3D)obj);
                continue;
            }
            PolygonGroup grp = (PolygonGroup)obj;
            group.addPolygonGroup((PolygonGroup)grp.clone());
        }
        group.transform = (MovingTransform3D)this.transform.clone();
        return group;
    }

    public PolygonGroup getGroup(String name) {
        if (this.name != null && this.name.equals(name)) {
            return this;
        }
        for (int i = 0; i < this.objects.size(); ++i) {
            PolygonGroup subgroup;
            Object obj = this.objects.elementAt(i);
            if (!(obj instanceof PolygonGroup) || (subgroup = ((PolygonGroup)obj).getGroup(name)) == null) continue;
            return subgroup;
        }
        return null;
    }

    public void resetIterator() {
        this.iteratorIndex = 0;
        for (int i = 0; i < this.objects.size(); ++i) {
            Object obj = this.objects.elementAt(i);
            if (!(obj instanceof PolygonGroup)) continue;
            ((PolygonGroup)obj).resetIterator();
        }
    }

    public boolean hasNext() {
        return this.iteratorIndex < this.objects.size();
    }

    public Polygon3D nextPolygon() {
        Object obj = this.objects.elementAt(this.iteratorIndex);
        if (obj instanceof PolygonGroup) {
            PolygonGroup group = (PolygonGroup)obj;
            Polygon3D poly = group.nextPolygon();
            if (!group.hasNext()) {
                ++this.iteratorIndex;
            }
            return poly;
        }
        ++this.iteratorIndex;
        return (Polygon3D)obj;
    }

    public void nextPolygonTransformed(Polygon3D cache) {
        Object obj = this.objects.elementAt(this.iteratorIndex);
        if (obj instanceof PolygonGroup) {
            PolygonGroup group = (PolygonGroup)obj;
            group.nextPolygonTransformed(cache);
            if (!group.hasNext()) {
                ++this.iteratorIndex;
            }
        } else {
            ++this.iteratorIndex;
            cache.setTo((Polygon3D)obj);
        }
        cache.add(this.transform);
    }

    public void update(long elapsedTime) {
        this.transform.update(elapsedTime);
        for (int i = 0; i < this.objects.size(); ++i) {
            Object obj = this.objects.elementAt(i);
            if (!(obj instanceof PolygonGroup)) continue;
            PolygonGroup group = (PolygonGroup)obj;
            group.update(elapsedTime);
        }
    }

    public void add(Vector3D u) {
        this.transform.getLocation().add(u);
    }

    public void subtract(Vector3D u) {
        this.transform.getLocation().subtract(u);
    }

    public void add(Transform3D xform) {
        this.addRotation(xform);
        this.add(xform.getLocation());
    }

    public void subtract(Transform3D xform) {
        this.subtract(xform.getLocation());
        this.subtractRotation(xform);
    }

    public void addRotation(Transform3D xform) {
        this.transform.rotateAngleX(xform.getAngleX());
        this.transform.rotateAngleY(xform.getAngleY());
        this.transform.rotateAngleZ(xform.getAngleZ());
    }

    public void subtractRotation(Transform3D xform) {
        this.transform.rotateAngleX(-xform.getAngleX());
        this.transform.rotateAngleY(-xform.getAngleY());
        this.transform.rotateAngleZ(-xform.getAngleZ());
    }
}

