/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.math3D;

import org.thenesis.planetino2.math3D.Polygon3D;
import org.thenesis.planetino2.math3D.PolygonGroup;
import org.thenesis.planetino2.math3D.Vector3D;

public class PolygonGroupBounds {
    private float topHeight;
    private float bottomHeight;
    private float radius;

    public PolygonGroupBounds() {
    }

    public PolygonGroupBounds(PolygonGroup group) {
        this.setToBounds(group);
    }

    public void setToBounds(PolygonGroup group) {
        this.topHeight = Float.MIN_VALUE;
        this.bottomHeight = Float.MAX_VALUE;
        this.radius = 0.0f;
        group.resetIterator();
        while (group.hasNext()) {
            Polygon3D poly = group.nextPolygon();
            for (int i = 0; i < poly.getNumVertices(); ++i) {
                Vector3D v = poly.getVertex(i);
                this.topHeight = Math.max(this.topHeight, v.y);
                this.bottomHeight = Math.min(this.bottomHeight, v.y);
                this.radius = Math.max(this.radius, v.x * v.x + v.z * v.z);
            }
        }
        if (this.radius == 0.0f) {
            this.topHeight = 0.0f;
            this.bottomHeight = 0.0f;
        } else {
            this.radius = (float)Math.sqrt(this.radius);
        }
    }

    public float getTopHeight() {
        return this.topHeight;
    }

    public void setTopHeight(float topHeight) {
        this.topHeight = topHeight;
    }

    public float getBottomHeight() {
        return this.bottomHeight;
    }

    public void setBottomHeight(float bottomHeight) {
        this.bottomHeight = bottomHeight;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }
}

