/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.math3D;

import org.thenesis.planetino2.math3D.Transform3D;
import org.thenesis.planetino2.math3D.Transformable;

public class Vector3D
implements Transformable {
    public float x;
    public float y;
    public float z;

    public Vector3D() {
        this(0.0f, 0.0f, 0.0f);
    }

    public Vector3D(Vector3D v) {
        this(v.x, v.y, v.z);
    }

    public Vector3D(float x, float y, float z) {
        this.setTo(x, y, z);
    }

    public boolean equals(Object obj) {
        Vector3D v = (Vector3D)obj;
        return v.x == this.x && v.y == this.y && v.z == this.z;
    }

    public boolean equals(float x, float y, float z) {
        return this.x == x && this.y == y && this.z == z;
    }

    public void setTo(Vector3D v) {
        this.setTo(v.x, v.y, v.z);
    }

    public void setTo(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void add(float x, float y, float z) {
        this.x += x;
        this.y += y;
        this.z += z;
    }

    public void subtract(float x, float y, float z) {
        this.add(-x, -y, -z);
    }

    public void add(Vector3D v) {
        this.add(v.x, v.y, v.z);
    }

    public void subtract(Vector3D v) {
        this.add(-v.x, -v.y, -v.z);
    }

    public void multiply(float s) {
        this.x *= s;
        this.y *= s;
        this.z *= s;
    }

    public void divide(float s) {
        this.x /= s;
        this.y /= s;
        this.z /= s;
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public void normalize() {
        this.divide(this.length());
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public void rotateX(float angle) {
        this.rotateX((float)Math.cos(angle), (float)Math.sin(angle));
    }

    public void rotateY(float angle) {
        this.rotateY((float)Math.cos(angle), (float)Math.sin(angle));
    }

    public void rotateZ(float angle) {
        this.rotateZ((float)Math.cos(angle), (float)Math.sin(angle));
    }

    public void rotateX(float cosAngle, float sinAngle) {
        float newY = this.y * cosAngle - this.z * sinAngle;
        float newZ = this.y * sinAngle + this.z * cosAngle;
        this.y = newY;
        this.z = newZ;
    }

    public void rotateY(float cosAngle, float sinAngle) {
        float newX = this.z * sinAngle + this.x * cosAngle;
        float newZ = this.z * cosAngle - this.x * sinAngle;
        this.x = newX;
        this.z = newZ;
    }

    public void rotateZ(float cosAngle, float sinAngle) {
        float newX = this.x * cosAngle - this.y * sinAngle;
        float newY = this.x * sinAngle + this.y * cosAngle;
        this.x = newX;
        this.y = newY;
    }

    public void add(Transform3D xform) {
        this.addRotation(xform);
        this.add(xform.getLocation());
    }

    public void subtract(Transform3D xform) {
        this.subtract(xform.getLocation());
        this.subtractRotation(xform);
    }

    public void addRotation(Transform3D xform) {
        this.rotateX(xform.getCosAngleX(), xform.getSinAngleX());
        this.rotateZ(xform.getCosAngleZ(), xform.getSinAngleZ());
        this.rotateY(xform.getCosAngleY(), xform.getSinAngleY());
    }

    public void subtractRotation(Transform3D xform) {
        this.rotateY(xform.getCosAngleY(), -xform.getSinAngleY());
        this.rotateZ(xform.getCosAngleZ(), -xform.getSinAngleZ());
        this.rotateX(xform.getCosAngleX(), -xform.getSinAngleX());
    }

    public float getDotProduct(Vector3D v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public void setToCrossProduct(Vector3D u, Vector3D v) {
        float x = u.y * v.z - u.z * v.y;
        float y = u.z * v.x - u.x * v.z;
        float z = u.x * v.y - u.y * v.x;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public float getDistanceSq(Vector3D v) {
        float dx = v.x - this.x;
        float dy = v.y - this.y;
        float dz = v.z - this.z;
        return dx * dx + dy * dy + dz * dz;
    }
}

