/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.path;

import java.util.Enumeration;
import org.thenesis.planetino2.game.GameObject;
import org.thenesis.planetino2.math3D.PolygonGroup;
import org.thenesis.planetino2.math3D.Vector3D;
import org.thenesis.planetino2.path.PathFinder;
import org.thenesis.planetino2.util.MoreMath;

public class PathBot
extends GameObject {
    private static final float DEFAULT_TURN_SPEED = 0.005f;
    private static final float DEFAULT_SPEED = 0.25f;
    private static final long DEFAULT_PATH_RECALC_TIME = 4000L;
    private static final float DEFAULT_FLY_HEIGHT = 64.0f;
    protected PathFinder pathFinder;
    protected Enumeration currentPath;
    private Vector3D nextPathLocation = new Vector3D();
    protected long timeUntilPathRecalc;
    private long pathRecalcTime;
    private Vector3D facing;
    private float turnSpeed;
    private float speed;
    private float flyHeight;

    public PathBot(PolygonGroup polygonGroup) {
        super(polygonGroup);
        this.setPathRecalcTime(4000L);
        this.setSpeed(0.25f);
        this.setTurnSpeed(0.005f);
        this.setFlyHeight(64.0f);
        this.setState(1);
    }

    public void setFacing(Vector3D facing) {
        this.facing = facing;
    }

    public void setPathFinder(PathFinder pathFinder) {
        if (this.pathFinder != pathFinder) {
            this.pathFinder = pathFinder;
            this.currentPath = null;
            this.timeUntilPathRecalc = (long)(MoreMath.random() * 1000.0f);
        }
    }

    public void setPathRecalcTime(long pathRecalcTime) {
        this.pathRecalcTime = pathRecalcTime;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public void setTurnSpeed(float turnSpeed) {
        this.turnSpeed = turnSpeed;
    }

    public void setFlyHeight(float flyHeight) {
        this.getTransform().getLocation().y += flyHeight - this.flyHeight;
        this.flyHeight = flyHeight;
    }

    public float getFlyHeight() {
        return this.flyHeight;
    }

    public void update(GameObject player, long elapsedTime) {
        if (this.pathFinder == null) {
            super.update(player, elapsedTime);
            return;
        }
        this.timeUntilPathRecalc -= elapsedTime;
        if (this.timeUntilPathRecalc <= 0L) {
            this.currentPath = this.pathFinder.find(this, player);
            if (this.currentPath != null) {
                this.getTransform().stop();
            }
            this.timeUntilPathRecalc = this.pathRecalcTime;
        }
        if (this.currentPath != null && !this.getTransform().isMovingIgnoreY()) {
            if (this.currentPath.hasMoreElements()) {
                this.nextPathLocation.setTo((Vector3D)this.currentPath.nextElement());
                this.nextPathLocation.y += this.flyHeight;
                this.getTransform().moveTo(this.nextPathLocation, this.speed);
                Vector3D faceLocation = this.facing;
                if (faceLocation == null) {
                    faceLocation = this.nextPathLocation;
                }
                this.getTransform().turnYTo(faceLocation.x - this.getX(), faceLocation.z - this.getZ(), -1.5707964f, this.turnSpeed);
            } else {
                this.currentPath = null;
                this.notifyEndOfPath();
            }
        }
        super.update(player, elapsedTime);
    }

    protected void backupAndRecomputePath() {
        this.nextPathLocation.setTo(this.getTransform().getVelocity());
        if (!this.isFlying()) {
            this.nextPathLocation.y = 0.0f;
        }
        this.nextPathLocation.multiply(-1.0f);
        this.getTransform().setVelocity(this.nextPathLocation, 200L);
        this.currentPath = null;
        this.timeUntilPathRecalc = (long)(MoreMath.random() * 1000.0f);
    }

    public boolean isFlying() {
        return this.flyHeight > 0.0f;
    }

    public void notifyEndOfPath() {
    }

    public void notifyWallCollision() {
        this.backupAndRecomputePath();
    }

    public void notifyObjectCollision(GameObject object) {
        this.backupAndRecomputePath();
    }
}

