/*
 * Decompiled with CFR 0.152.
 */
package main;

import com.doctordrive.scrobbler.Scrobbler;
import com.doctordrive.scrobbler.Session;
import com.sonyericsson.multimedia.ControlEvent;
import com.sonyericsson.multimedia.Media;
import com.sonyericsson.multimedia.MetaData;
import com.sonyericsson.multimedia.MultimediaService;
import com.sonyericsson.multimedia.MultimediaServiceManager;
import com.sonyericsson.multimedia.control.MediaControl;
import com.sonyericsson.multimedia.control.MediaControlListener;
import java.util.Date;
import javax.microedition.lcdui.Displayable;
import main.Main;
import main.Settings;
import main.Song;
import ui.MessageForm;

public final class Monitor
implements MediaControlListener {
    public boolean available;
    private MultimediaService player;
    private MediaControl mediaControl;
    private MetaData data;
    private Media media;
    private final Song song = new Song();
    private long lastupdate;

    public Monitor() {
        try {
            this.player = MultimediaServiceManager.getMultimediaService("MediaPlayer");
        }
        catch (NoClassDefFoundError ncdfe) {
            // empty catch block
        }
        if (this.player == null) {
            this.available = false;
            Main.log.write("Service is not available");
            Main.disp.setCurrent((Displayable)new MessageForm("Error", "The service is not available. Application will be closed.", 'e'));
        } else {
            Main.log.write("Service is available");
            this.mediaControl = (MediaControl)this.player.getControl("MediaControl");
            this.mediaControl.addMediaControlListener(this);
            if (!Main.cc.isAlive() && !Settings.offline) {
                try {
                    Main.cc.start();
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    // empty catch block
                }
            }
            Main.session = new Session();
            this.lastupdate = 0L;
        }
    }

    public void mediaControlUpdate(int eventId, ControlEvent event) {
        try {
            switch (eventId) {
                case 1: {
                    this.media = (Media)event.getData();
                    this.data = this.media.getMetaData();
                    if (System.currentTimeMillis() - this.lastupdate > 30000L || !this.updateEqual()) {
                        this.updateSong();
                        if (this.song.artist.length() > 0 && this.song.track.length() > 0) {
                            Scrobbler.updateNowPlaying(this.song);
                        }
                    }
                    this.lastupdate = System.currentTimeMillis();
                    break;
                }
                case 5: {
                    if (this.data == null) {
                        this.media = (Media)event.getData();
                        this.data = this.media.getMetaData();
                        this.updateSong();
                    }
                    if (this.song.artist.length() <= 0 || this.song.track.length() <= 0) break;
                    Scrobbler.scrobble(this.song);
                }
            }
        }
        catch (Throwable t) {
            Main.log.write(t.toString());
        }
    }

    private void updateSong() {
        this.song.album = this.data.getValue("ALBUM");
        this.song.artist = this.data.getValue("ARTIST");
        this.song.track = this.data.getValue("TITLE");
        this.song.timestamp = Long.toString(new Date().getTime() / 1000L);
    }

    private boolean updateEqual() {
        return this.song.album.equals(this.data.getValue("ALBUM")) && this.song.artist.equals(this.data.getValue("ARTIST")) && this.song.track.equals(this.data.getValue("TITLE"));
    }
}

