/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ImageEffects {
    public static int GRAY_SCALE_MODE = 1;
    public static int INVERT_COLOURS_MODE = 2;
    public static int SEPIA_MODE = 3;
    public static int SOFTEN_MODE = 4;
    public static int EMBOSS_MODE = 5;
    public static int STATIC_MODE = 6;
    public static int CONTUR_MODE = 7;
    public static double PI = 3.1415926;
    public static int max;
    public static int[] picture;
    public static int[] buffer;
    public static int[][] glassnew;
    public static int[][] glassold;
    public static int[][] CORE_SOFTEN;
    public static int[][] CORE_EMBOSS;
    public static int[][] CORE_CONTUR;

    static {
        CORE_SOFTEN = new int[][]{{3, 3, 9, 0}, {0, 1, 0, 1, 5, 1, 0, 1, 0}};
        CORE_EMBOSS = new int[][]{{3, 3, 1, 128}, {0, 0, 0, 0, 1, 0, 0, 0, -1}};
        CORE_CONTUR = new int[][]{{2, 2, 4, 0}, {3, -2, 0, 3}};
    }

    public static Image setEffect(Image image, int n) throws  {
        if (n == SOFTEN_MODE) {
            return ImageEffects.core(image, CORE_SOFTEN);
        }
        if (n == EMBOSS_MODE) {
            return ImageEffects.core(image, CORE_EMBOSS);
        }
        if (n == CONTUR_MODE) {
            return ImageEffects.core(image, CORE_CONTUR);
        }
        int n2 = image.getWidth();
        int n3 = image.getHeight();
        int[] nArray = new int[n2 * n3];
        image.getRGB(nArray, 0, n2, 0, 0, n2, n3);
        image = null;
        System.gc();
        Image image2 = null;
        int n4 = 0;
        while (n4 < nArray.length) {
            int n5;
            int n6 = (nArray[n4] & 0xFF000000) >> 24;
            int n7 = (nArray[n4] & 0xFF0000) >> 16;
            int n8 = (nArray[n4] & 0xFF00) >> 8;
            int n9 = nArray[n4] & 0xFF;
            if (n == GRAY_SCALE_MODE) {
                n7 = n5 = (int)(0.3 * (double)n7 + 0.59 * (double)n8 + 0.11 * (double)n9);
                n8 = n5;
                n9 = n5;
            } else if (n == INVERT_COLOURS_MODE) {
                n7 = 255 - n7;
                n8 = 255 - n8;
                n9 = 255 - n9;
            } else if (n == SEPIA_MODE) {
                n5 = (int)(0.3 * (double)n7 + 0.59 * (double)n8 + 0.11 * (double)n9);
                if ((n7 = n5 + 34) > 255) {
                    n7 = 255;
                }
                n8 = n5;
                n9 = n5 - 49;
                if (n9 < 0) {
                    n9 = 0;
                }
            } else if (n == STATIC_MODE) {
                n5 = (int)(0.3 * (double)n7 + 0.59 * (double)n8 + 0.11 * (double)n9);
                int n10 = n5 > 128 ? 255 : 0;
                n7 = n10;
                n8 = n10;
                n9 = n10;
            }
            nArray[n4] = n6 << 24 | n7 << 16 | n8 << 8 | n9;
            ++n4;
        }
        image2 = Image.createRGBImage((int[])nArray, (int)n2, (int)n3, (boolean)true);
        nArray = null;
        System.gc();
        return image2;
    }

    public static Image core(Image image, int[][] nArray) throws  {
        int[][] nArray2 = nArray;
        int n = image.getWidth();
        int n2 = image.getHeight();
        int[] nArray3 = new int[n * n2];
        image.getRGB(nArray3, 0, n, 0, 0, n, n2);
        image = null;
        System.gc();
        Image image2 = null;
        int[] nArray4 = nArray3;
        int n3 = nArray2[0][2];
        int n4 = nArray2[0][3];
        int n5 = nArray2[0][0];
        int n6 = nArray2[0][1];
        int n7 = n5 / 2;
        while (n7 < n - n5 / 2) {
            int n8 = n6 / 2;
            while (n8 < n2 - n6 / 2) {
                int n9;
                int n10;
                int n11;
                int n12 = n7 + n8 * n;
                int n13 = 0;
                int n14 = 0;
                int n15 = 0;
                int n16 = 0;
                while (n16 < n5) {
                    int n17 = 0;
                    while (n17 < n6) {
                        int n18 = (nArray3[n12 + (n16 - n5 / 2) + (n17 - n6 / 2) * n] & 0xFF0000) >> 16;
                        int n19 = (nArray3[n12 + (n16 - n5 / 2) + (n17 - n6 / 2) * n] & 0xFF00) >> 8;
                        int n20 = nArray3[n12 + (n16 - n5 / 2) + (n17 - n6 / 2) * n] & 0xFF;
                        n11 = n18 * nArray2[1][n16 + n17 * n5];
                        n10 = n19 * nArray2[1][n16 + n17 * n5];
                        n9 = n20 * nArray2[1][n16 + n17 * n5];
                        n13 += n11;
                        n14 += n10;
                        n15 += n9;
                        ++n17;
                    }
                    ++n16;
                }
                int n21 = (nArray3[n12] & 0xFF000000) >> 24;
                n11 = n13 / n3 + n4;
                n10 = n14 / n3 + n4;
                n9 = n15 / n3 + n4;
                if (n11 > 255) {
                    n11 = 255;
                }
                if (n10 > 255) {
                    n10 = 255;
                }
                if (n9 > 255) {
                    n9 = 255;
                }
                if (n11 < 0) {
                    n11 = 0;
                }
                if (n10 < 0) {
                    n10 = 0;
                }
                if (n9 < 0) {
                    n9 = 0;
                }
                nArray4[n12] = n21 << 24 | n11 << 16 | n10 << 8 | n9;
                ++n8;
            }
            ++n7;
        }
        nArray3 = null;
        System.gc();
        image2 = Image.createRGBImage((int[])nArray4, (int)n, (int)n2, (boolean)true);
        nArray4 = null;
        System.gc();
        return image2;
    }

    public static final Image resizeImage(Image image, int n, int n2, boolean bl) throws  {
        if (image != null) {
            int n3 = image.getWidth();
            int n4 = image.getHeight();
            int[] nArray = new int[n3 * n4];
            image.getRGB(nArray, 0, n3, 0, 0, n3, n4);
            image = null;
            Image image2 = null;
            System.gc();
            int[] nArray2 = new int[n * n2];
            if (nArray != null && nArray2 != null) {
                int n5 = (n3 - 1 << 12) / n;
                int n6 = (n4 - 1 << 12) / n2;
                int n7 = 0;
                int n8 = 0;
                if (bl) {
                    int n9 = 0;
                    int n10 = 0;
                    while (n10 < n2) {
                        int n11 = 0;
                        int n12 = 0;
                        while (n12 < n) {
                            int n13 = (n11 >> 12) + n7;
                            int n14 = nArray[n13];
                            int n15 = nArray[n13 + 1];
                            int n16 = nArray[n13 += n3];
                            int n17 = nArray[n13 + 1];
                            int n18 = n11 & 0xFFF;
                            int n19 = 4096 - n18;
                            int n20 = n9 & 0xFFF;
                            int n21 = 4096 - n20;
                            int n22 = ((n14 & 0xFF) * n19 + (n15 & 0xFF) * n18 >>> 12) * n21 + ((n16 & 0xFF) * n19 + (n17 & 0xFF) * n18 >>> 12) * n20 >>> 12;
                            int n23 = (((n14 & 0xFF00) >>> 8) * n19 + ((n15 & 0xFF00) >>> 8) * n18 >>> 12) * n21 + (((n16 & 0xFF00) >>> 8) * n19 + ((n17 & 0xFF00) >>> 8) * n18 >>> 12) * n20 >>> 12;
                            int n24 = (((n14 & 0xFF0000) >>> 16) * n19 + ((n15 & 0xFF0000) >>> 16) * n18 >>> 12) * n21 + (((n16 & 0xFF0000) >>> 16) * n19 + ((n17 & 0xFF0000) >>> 16) * n18 >>> 12) * n20 >>> 12;
                            int n25 = (((n14 & 0xFF000000) >>> 24) * n19 + ((n15 & 0xFF000000) >>> 24) * n18 >>> 12) * n21 + (((n16 & 0xFF000000) >>> 24) * n19 + ((n17 & 0xFF000000) >>> 24) * n18 >>> 12) * n20 >>> 12;
                            nArray2[n8 + n12] = (n25 << 24) + (n24 << 16) + (n23 << 8) + n22;
                            n11 += n5;
                            ++n12;
                        }
                        n7 = ((n9 += n6) >> 12) * n3;
                        n8 += n;
                        ++n10;
                    }
                } else {
                    int n26 = 2048;
                    int n27 = 0;
                    while (n27 < n2) {
                        int n28 = 2048;
                        int n29 = 0;
                        while (n29 < n) {
                            nArray2[n8 + n29] = nArray[n7 + (n28 >> 12)];
                            n28 += n5;
                            ++n29;
                        }
                        n7 = ((n26 += n6) >> 12) * n3;
                        n8 += n;
                        ++n27;
                    }
                }
            }
            nArray = null;
            System.gc();
            image2 = Image.createRGBImage((int[])nArray2, (int)n, (int)n2, (boolean)true);
            nArray2 = null;
            System.gc();
            return image2;
        }
        return null;
    }

    public static final void initLens(int n, int n2) throws  {
        max = n;
        if (max < 5) {
            max = 5;
        }
        glassnew = new int[2 * max][2 * max];
        glassold = new int[2 * max][2 * max];
        int n3 = -max;
        while (n3 < max) {
            int n4 = -max;
            while (n4 < max) {
                double d = Math.sin(PI / 2.0 + PI / 2.0 / ((double)max * 2.2) * Math.sqrt(n3 * n3 + n4 * n4));
                double d2 = (double)n3 * d;
                double d3 = (double)n4 * d;
                ImageEffects.glassnew[n3 + ImageEffects.max][n4 + ImageEffects.max] = (int)d2 + (int)d3 * n2;
                ImageEffects.glassold[n3 + ImageEffects.max][n4 + ImageEffects.max] = n3 / 2 + n4 / 2 * n2;
                ++n4;
            }
            ++n3;
        }
    }

    public static final Image imageLens(Image image) throws  {
        int n = image.getWidth() / 2;
        int n2 = image.getHeight() / 2;
        int n3 = n + n2 * image.getWidth();
        picture = new int[image.getWidth() * image.getHeight()];
        buffer = new int[image.getWidth() * image.getHeight()];
        image.getRGB(picture, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
        int n4 = 0;
        while (n4 < 2 * max) {
            int n5 = 0;
            while (n5 < 2 * max) {
                ImageEffects.buffer[n3 + ImageEffects.glassnew[n4][n5]] = picture[n3 + glassold[n4][n5]];
                ++n5;
            }
            ++n4;
        }
        return Image.createRGBImage((int[])buffer, (int)image.getWidth(), (int)image.getHeight(), (boolean)true);
    }

    public static Image createCheckedField(int n, int n2, int n3, int n4, int n5) throws  {
        Image image = Image.createImage((int)n3, (int)n4);
        Graphics graphics = image.getGraphics();
        graphics.setColor(n);
        graphics.fillRect(0, 0, n3, n4);
        graphics.setColor(n2);
        boolean bl = false;
        int n6 = n5 * 2;
        int n7 = 0;
        while (n7 < n3) {
            int n8;
            if (bl) {
                n8 = n5;
                bl = false;
            } else {
                n8 = 0;
                bl = true;
            }
            while (n8 < n4) {
                graphics.fillRect(n7, n8, n5, n5);
                n8 += n6;
            }
            n7 += n5;
        }
        return image;
    }

    public static void drawString(Graphics graphics, String string, int n, int n2, int n3) throws  {
        graphics.drawString(string, n, n2 - 1, n3);
        graphics.drawString(string, n + 1, n2 - 1, n3);
        graphics.drawString(string, n + 1, n2, n3);
        graphics.drawString(string, n + 1, n2 + 1, n3);
        graphics.drawString(string, n, n2 + 1, n3);
        graphics.drawString(string, n - 1, n2 + 1, n3);
        graphics.drawString(string, n - 1, n2, n3);
        graphics.drawString(string, n - 1, n2 - 1, n3);
    }

    public static void drawSpray(Graphics graphics, int n, int n2, int n3, int n4) throws  {
        Random random = new Random();
        double d = Math.PI / 180 * (double)(random.nextInt() % 360);
        double d2 = n - random.nextInt() % n3;
        double d3 = n2 - random.nextInt() % n4;
        int n5 = (int)((double)n + (d2 - (double)n) * Math.cos(d) - (d3 - (double)n2) * Math.sin(d));
        int n6 = (int)((double)n2 + (d2 - (double)n2) * Math.sin(d) + (d3 - (double)n2) * Math.cos(d));
        graphics.drawLine(n5, n6, n5, n6);
    }

    public static void drawSpray(Graphics graphics, int n, int n2, int n3, int n4, int n5) throws  {
        int n6 = 0;
        while (n6 < n5) {
            ImageEffects.drawSpray(graphics, n, n2, n3, n4);
            ++n6;
        }
    }

    ImageEffects() throws  {
        System.out.println("EDWARD SUPANITSKY");
        System.out.println("SUPANITSKY IS NOT FREE SOFTWARE");
    }
}

