/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.lcdui.Image;

public class JpegEncoder {
    DataOutputStream outStream;
    JpegInfo JpegObj;
    Huffman Huf;
    DCT dct;
    int imageHeight;
    int imageWidth;
    int fpos;
    int fsize;
    int Quality;
    public static int[] jpegNaturalOrder = new int[]{0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63};

    public void setQuality(int n) throws  {
        this.dct = new DCT(n);
    }

    public int getQuality() throws  {
        return this.Quality;
    }

    public void Compress() throws  {
        this.WriteHeaders(this.outStream);
        this.WriteCompressedData(this.outStream);
        this.WriteEOI(this.outStream);
        try {
            this.outStream.flush();
        }
        catch (IOException iOException) {
            PhotoCanvas.progressbar = false;
            System.out.println("IO Error: ".concat(String.valueOf(iOException.getMessage())));
        }
        PhotoCanvas.progressbar = false;
    }

    public void WriteCompressedData(DataOutputStream dataOutputStream) throws  {
        boolean bl = false;
        float[][] fArray = new float[8][8];
        double[][] dArray = new double[8][8];
        int[] nArray = new int[64];
        int[] nArray2 = new int[this.JpegObj.NumberOfComponents];
        int[] nArray3 = new int[64];
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        int n3 = this.imageWidth % 8 == 0 ? this.imageWidth : (int)(Math.floor((double)this.imageWidth / 8.0) + 1.0) * 8;
        int n4 = this.imageHeight % 8 == 0 ? this.imageHeight : (int)(Math.floor((double)this.imageHeight / 8.0) + 1.0) * 8;
        int n5 = 0;
        while (n5 < this.JpegObj.NumberOfComponents) {
            n3 = Math.min(n3, this.JpegObj.BlockWidth[n5]);
            n4 = Math.min(n4, this.JpegObj.BlockHeight[n5]);
            ++n5;
        }
        this.fsize = n3 * n4;
        PhotoCanvas.progressbar = true;
        n5 = 0;
        int n6 = 0;
        while (n6 < n4) {
            int n7 = 0;
            while (n7 < n3) {
                n5 = n7 * 8;
                int n8 = n6 * 8;
                int n9 = 0;
                while (n9 < this.JpegObj.NumberOfComponents) {
                    n = this.JpegObj.BlockWidth[n9];
                    n2 = this.JpegObj.BlockHeight[n9];
                    int n10 = 0;
                    while (n10 < this.JpegObj.VsampFactor[n9]) {
                        int n11 = 0;
                        while (n11 < this.JpegObj.HsampFactor[n9]) {
                            int n12 = n11 * 8;
                            int n13 = n10 * 8;
                            int n14 = 0;
                            while (n14 < 8) {
                                int n15 = 0;
                                while (n15 < 8) {
                                    fArray[n14][n15] = this.JpegObj.inputPixel(n8 + n13 + n14, n5 + n12 + n15, n9);
                                    ++n15;
                                }
                                ++n14;
                            }
                            dArray = this.dct.forwardDCT(fArray);
                            nArray = this.dct.quantizeBlock(dArray, this.JpegObj.QtableNumber[n9]);
                            this.Huf.HuffmanBlockEncoder(dataOutputStream, nArray, nArray2[n9], this.JpegObj.DCtableNumber[n9], this.JpegObj.ACtableNumber[n9]);
                            nArray2[n9] = nArray[0];
                            ++n11;
                        }
                        ++n10;
                    }
                    ++n9;
                }
                this.fpos = n7 + n6 * n3;
                this.calc();
                ++n7;
            }
            ++n6;
        }
        this.Huf.flushBuffer(dataOutputStream);
    }

    public void WriteEOI(DataOutputStream dataOutputStream) throws  {
        byte[] byArray = new byte[]{-1, -39};
        this.WriteMarker(byArray, dataOutputStream);
    }

    public void WriteHeaders(DataOutputStream dataOutputStream) throws  {
        int n;
        int n2;
        byte[] byArray = new byte[]{-1, -40};
        this.WriteMarker(byArray, dataOutputStream);
        byte[] byArray2 = new byte[]{-1, -32, 0, 16, 74, 70, 73, 70, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0};
        this.WriteArray(byArray2, dataOutputStream);
        String string = new String();
        string = this.JpegObj.getComment();
        int n3 = string.length();
        byte[] byArray3 = new byte[n3 + 4];
        byArray3[0] = -1;
        byArray3[1] = -2;
        byArray3[2] = (byte)(n3 >> 8 & 0xFF);
        byArray3[3] = (byte)(n3 & 0xFF);
        System.arraycopy(this.JpegObj.Comment.getBytes(), 0, byArray3, 4, this.JpegObj.Comment.length());
        this.WriteArray(byArray3, dataOutputStream);
        byte[] byArray4 = new byte[134];
        byArray4[0] = -1;
        byArray4[1] = -37;
        byArray4[2] = 0;
        byArray4[3] = -124;
        int n4 = 4;
        int n5 = 0;
        while (n5 < 2) {
            byArray4[n4++] = (byte)(0 + n5);
            int[] nArray = (int[])this.dct.quantum[n5];
            n2 = 0;
            while (n2 < 64) {
                byArray4[n4++] = (byte)nArray[jpegNaturalOrder[n2]];
                ++n2;
            }
            ++n5;
        }
        this.WriteArray(byArray4, dataOutputStream);
        byte[] byArray5 = new byte[19];
        byArray5[0] = -1;
        byArray5[1] = -64;
        byArray5[2] = 0;
        byArray5[3] = 17;
        byArray5[4] = (byte)this.JpegObj.Precision;
        byArray5[5] = (byte)(this.JpegObj.imageHeight >> 8 & 0xFF);
        byArray5[6] = (byte)(this.JpegObj.imageHeight & 0xFF);
        byArray5[7] = (byte)(this.JpegObj.imageWidth >> 8 & 0xFF);
        byArray5[8] = (byte)(this.JpegObj.imageWidth & 0xFF);
        byArray5[9] = (byte)this.JpegObj.NumberOfComponents;
        int n6 = 10;
        n2 = 0;
        while (n2 < byArray5[9]) {
            byArray5[n6++] = (byte)this.JpegObj.CompID[n2];
            byArray5[n6++] = (byte)((this.JpegObj.HsampFactor[n2] << 4) + this.JpegObj.VsampFactor[n2]);
            byArray5[n6++] = (byte)this.JpegObj.QtableNumber[n2];
            ++n2;
        }
        this.WriteArray(byArray5, dataOutputStream);
        n3 = 2;
        n6 = 4;
        n2 = 4;
        byte[] byArray6 = new byte[17];
        byte[] byArray7 = new byte[4];
        byArray7[0] = -1;
        byArray7[1] = -60;
        int n7 = 0;
        while (n7 < 4) {
            n = 0;
            byArray6[n6++ - n2] = (byte)((int[])this.Huf.bits.elementAt(n7))[0];
            int n8 = 1;
            while (n8 < 17) {
                int n9 = ((int[])this.Huf.bits.elementAt(n7))[n8];
                byArray6[n6++ - n2] = (byte)n9;
                n += n9;
                ++n8;
            }
            n8 = n6;
            byte[] byArray8 = new byte[n];
            int n10 = 0;
            while (n10 < n) {
                byArray8[n6++ - n8] = (byte)((int[])this.Huf.val.elementAt(n7))[n10];
                ++n10;
            }
            byte[] byArray9 = new byte[n6];
            System.arraycopy(byArray7, 0, byArray9, 0, n2);
            System.arraycopy(byArray6, 0, byArray9, n2, 17);
            System.arraycopy(byArray8, 0, byArray9, n2 + 17, n);
            byArray7 = byArray9;
            n2 = n6;
            ++n7;
        }
        byArray7[2] = (byte)(n6 - 2 >> 8 & 0xFF);
        byArray7[3] = (byte)(n6 - 2 & 0xFF);
        this.WriteArray(byArray7, dataOutputStream);
        byte[] byArray10 = new byte[14];
        byArray10[0] = -1;
        byArray10[1] = -38;
        byArray10[2] = 0;
        byArray10[3] = 12;
        byArray10[4] = (byte)this.JpegObj.NumberOfComponents;
        n6 = 5;
        n = 0;
        while (n < byArray10[4]) {
            byArray10[n6++] = (byte)this.JpegObj.CompID[n];
            byArray10[n6++] = (byte)((this.JpegObj.DCtableNumber[n] << 4) + this.JpegObj.ACtableNumber[n]);
            ++n;
        }
        byArray10[n6++] = (byte)this.JpegObj.Ss;
        byArray10[n6++] = (byte)this.JpegObj.Se;
        byArray10[n6++] = (byte)((this.JpegObj.Ah << 4) + this.JpegObj.Al);
        this.WriteArray(byArray10, dataOutputStream);
    }

    void WriteMarker(byte[] byArray, DataOutputStream dataOutputStream) throws  {
        try {
            dataOutputStream.write(byArray, 0, 2);
        }
        catch (IOException iOException) {
            System.out.println("IO Error: ".concat(String.valueOf(iOException.getMessage())));
        }
    }

    void WriteArray(byte[] byArray, DataOutputStream dataOutputStream) throws  {
        try {
            int n = ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF) + 2;
            dataOutputStream.write(byArray, 0, n);
        }
        catch (IOException iOException) {
            System.out.println("IO Error: ".concat(String.valueOf(iOException.getMessage())));
        }
    }

    public void calc() throws  {
        PhotoCanvas.pbpos = this.fpos * 100 / this.fsize;
    }

    public JpegEncoder(Image image, int n, OutputStream outputStream) throws  {
        this.Quality = n;
        this.JpegObj = new JpegInfo(image);
        this.imageHeight = this.JpegObj.imageHeight;
        this.imageWidth = this.JpegObj.imageWidth;
        this.fpos = 0;
        this.fsize = 1;
        this.outStream = new DataOutputStream(outputStream);
        this.dct = new DCT(this.Quality);
        this.Huf = new Huffman(this.imageWidth, this.imageHeight);
        this.Compress();
    }
}

