/*
 * Decompiled with CFR 0.152.
 */
package ntr.ttme;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import ntr.ttme.PolygonFiller;
import ntr.ttme.QuickSort;

public class NtrPolygonFiller
implements PolygonFiller {
    public void fillPolygon(Graphics g, int[] xPoints, int[] yPoints, int nPoints) {
        int height = g.getClipHeight();
        Vector[] lines = new Vector[height];
        int i = 0;
        while (i < nPoints - 1) {
            this.calcLine(height, lines, xPoints[i], yPoints[i], xPoints[i + 1], yPoints[i + 1]);
            ++i;
        }
        int y = 0;
        while (y < height) {
            if (lines[y] != null) {
                this.sortLine(lines[y]);
                this.fillLineBinary(g, lines[y], y);
            }
            ++y;
        }
    }

    private void calcLine(int height, Vector[] lines, int x1, int y1, int x2, int y2) {
        if (y1 < 0 && y2 < 0 || y1 >= height && y2 >= height) {
            return;
        }
        if (y2 < y1) {
            int tmp = y1;
            y1 = y2;
            y2 = tmp;
            tmp = x1;
            x1 = x2;
            x2 = tmp;
        }
        int dx = x2 - x1;
        int dy = y2 - y1;
        int adx = Math.abs(dx);
        int ady = Math.abs(dy);
        if (y1 == y2) {
            if (y1 >= 0 && y1 < height) {
                Vector<Integer> yline = lines[y1];
                if (yline == null) {
                    lines[y1] = yline = new Vector<Integer>();
                }
                yline.addElement(new Integer(x1));
                yline.addElement(new Integer(x2));
            }
            return;
        }
        if (adx > ady) {
            int sgnx = dx / adx;
            int sgny = dy / ady;
            int x = x1;
            int y = y1;
            int ymeasure = adx;
            int levelx = x;
            do {
                x += sgnx;
                if (ymeasure < ady) {
                    if (y >= 0 && y < height) {
                        Vector<Integer> yline = lines[y];
                        if (yline == null) {
                            lines[y] = yline = new Vector<Integer>();
                        }
                        yline.addElement(new Integer(levelx));
                        levelx = x;
                    }
                    ymeasure += adx;
                    y += sgny;
                }
                ymeasure -= ady;
            } while (y != y2);
        } else if (dx == 0) {
            int sgny = dy / ady;
            int x = x1;
            int y = y1;
            do {
                if (y < 0 || y >= height) continue;
                Vector<Integer> yline = lines[y];
                if (yline == null) {
                    lines[y] = yline = new Vector<Integer>();
                }
                yline.addElement(new Integer(x));
            } while ((y += sgny) != y2);
        } else {
            int sgnx = dx / adx;
            int sgny = dy / ady;
            int x = x1;
            int y = y1;
            int xmeasure = ady;
            do {
                if (y >= 0 && y < height) {
                    Vector<Integer> yline = lines[y];
                    if (yline == null) {
                        lines[y] = yline = new Vector<Integer>();
                    }
                    yline.addElement(new Integer(x));
                }
                y += sgny;
                if (xmeasure < adx) {
                    xmeasure += ady;
                    x += sgnx;
                }
                xmeasure -= adx;
            } while (y != y2);
        }
    }

    private void sortLine(Vector vector) {
        new QuickSort(vector).run();
    }

    private void fillLineBinary(Graphics g, Vector vector, int y) {
        int width = g.getClipWidth();
        int size = vector.size();
        boolean penDown = false;
        int penx = Integer.MIN_VALUE;
        boolean outside = false;
        int i = 0;
        while (i < size) {
            block10: {
                int x;
                block9: {
                    x = (Integer)vector.elementAt(i);
                    if (x < width) break block9;
                    if (x == Integer.MAX_VALUE) break block10;
                    if (outside) {
                        return;
                    }
                    if (penx != x) {
                        outside = true;
                    }
                }
                if (x >= 0 && penDown) {
                    if (penx < 0) {
                        penx = 0;
                    }
                    if (x >= width) {
                        g.drawLine(penx, y, width, y);
                        return;
                    }
                    g.drawLine(penx, y, x, y);
                }
                penDown = !penDown;
                penx = x;
            }
            ++i;
        }
    }
}

