/*
 * Decompiled with CFR 0.152.
 */
package ntr.ttme;

import java.io.IOException;
import java.io.InputStream;
import ntr.ttme.Bitwise;
import ntr.ttme.TTConstants;
import ntr.ttme.TTContour;
import ntr.ttme.TTGlyph;
import ntr.ttme.TTKernPair;
import ntr.ttme.TTPoint;
import ntr.ttme.TrueTypeBusinessException;
import ntr.ttme.TrueTypeException;
import ntr.ttme.TrueTypeKerningBusinessException;
import ntr.ttme.TrueTypeTechnicalException;

public class TrueTypeDefinition {
    private byte[] fontData;
    private TTGlyph[] glyphs;
    private byte[] cmap;
    private int[] glyphOffsetArray;
    private TTKernPair[] kernPairs;
    private short cmapFormat;
    private short numTables;
    private short numberOfHMetrics;
    private short numKernPairs;
    private short indexToLocFormat;
    private short numGlyphs;
    private byte[] copyright;
    private byte[] familyName;
    private byte[] fullName;
    private byte[] subfamilyName;
    private byte[] uniqueName;
    private byte[] versionName;
    private short xMax;
    private short xMin;
    private short yMax;
    private short yMin;
    private short unitsPerMSqr;
    private short ascender;
    private short descender;
    private short lineGap;
    private short platformID;
    private short specificID;
    private short languageID;
    private String[] specificList;
    private short[] PIDList;
    private short[] SIDList;
    private int specificListTotal;
    private boolean loadingCompleted;

    public TrueTypeDefinition(InputStream inputStream, short platformID, short specificID, short languageID) throws TrueTypeBusinessException, TrueTypeTechnicalException {
        this.platformID = platformID;
        this.specificID = specificID;
        this.languageID = languageID;
        this.readFontData(inputStream);
        this.processFontHeaderTable();
        this.processMaximumProfileTable();
        this.processNamingTable();
        this.processIndexToLocationTable();
        this.processCharacterMappingTable();
        this.processGlyphDataTable();
        this.processHorizontalHeaderTable();
        this.processHorizontalMetricsTable();
        try {
            this.processKerningTable();
        }
        catch (TrueTypeException trueTypeException) {
            // empty catch block
        }
        if (this.fontData != null) {
            this.fontData = null;
        }
        this.loadingCompleted = true;
    }

    public TrueTypeDefinition(InputStream inputStream, boolean completeWithDefaults) throws TrueTypeBusinessException, TrueTypeTechnicalException {
        this.readFontData(inputStream);
        this.processFontHeaderTable();
        this.processMaximumProfileTable();
        this.processNamingTableNoQuestionsAsked();
        this.processIndexToLocationTable();
        this.retrieveSpecificList();
        if (completeWithDefaults) {
            if (this.specificListTotal == 0) {
                throw new TrueTypeBusinessException("Specific list is empty, unable to complete loading!");
            }
            this.completeLoading(this.PIDList[0], this.SIDList[0]);
        }
    }

    public void completeLoading(short platformID, short specificID) throws TrueTypeBusinessException, TrueTypeTechnicalException {
        if (this.loadingCompleted) {
            throw new IllegalStateException("Loading already completed!");
        }
        this.platformID = platformID;
        this.specificID = specificID;
        this.processCharacterMappingTable();
        this.processGlyphDataTable();
        this.processHorizontalHeaderTable();
        this.processHorizontalMetricsTable();
        try {
            this.processKerningTable();
        }
        catch (TrueTypeException trueTypeException) {
            // empty catch block
        }
        if (this.fontData != null) {
            this.fontData = null;
        }
        this.loadingCompleted = true;
    }

    private void readFontData(InputStream in) throws TrueTypeBusinessException, TrueTypeTechnicalException {
        try {
            int fileLength = 0;
            byte[] offsetTableData = new byte[12];
            int i = 0;
            while (i < 12) {
                int b = in.read();
                if (b != -1) {
                    offsetTableData[i] = (byte)b;
                    ++fileLength;
                } else {
                    throw new TrueTypeBusinessException("Could not read 12 bytes of offset-table information! (File length: " + fileLength + ")");
                }
                ++i;
            }
            this.numTables = Bitwise.toUSHORT(offsetTableData[4], offsetTableData[5]);
            int tableDirSize = 16 * this.numTables;
            byte[] tableDir = new byte[tableDirSize];
            int tableDataSize = 0;
            int i2 = 0;
            while (i2 < tableDirSize) {
                int totalBytesRead = in.read(tableDir, i2, 16);
                fileLength += totalBytesRead;
                if (totalBytesRead != 16) {
                    throw new TrueTypeBusinessException("Could not read 16 bytes of tableDir information! Instead, read returned " + totalBytesRead + " (File length: " + fileLength + ")");
                }
                long tableLength = Bitwise.toULONG(tableDir[i2 + 12], tableDir[i2 + 13], tableDir[i2 + 14], tableDir[i2 + 15]);
                if (tableLength / 4L * 4L != tableLength) {
                    tableLength = (tableLength / 4L + 1L) * 4L;
                }
                tableDataSize = (int)((long)tableDataSize + tableLength);
                i2 += 16;
            }
            int fontDataSize = 12 + tableDirSize + tableDataSize;
            this.fontData = new byte[fontDataSize];
            System.arraycopy(offsetTableData, 0, this.fontData, 0, 12);
            System.arraycopy(tableDir, 0, this.fontData, 12, tableDirSize);
            int start = 12 + tableDirSize;
            int restBytesToRead = fontDataSize - start;
            int totalBytesRead = in.read(this.fontData, start, restBytesToRead);
            fileLength += totalBytesRead;
            if (totalBytesRead != restBytesToRead) {
                throw new TrueTypeBusinessException("Could not read " + restBytesToRead + " bytes of tableDir information! Instead, read returned " + totalBytesRead + " (File length: " + fileLength + ")");
            }
        }
        catch (IOException e) {
            throw new TrueTypeTechnicalException("IOException!" + e.getMessage());
        }
        catch (TrueTypeBusinessException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new TrueTypeTechnicalException("Throwable!" + t.getMessage());
        }
    }

    private int getTableDirEntryParamOffset(long tag) throws TrueTypeBusinessException, TrueTypeTechnicalException {
        try {
            int pos = 12;
            int i = 0;
            while (i < this.numTables) {
                long currentTag = Bitwise.toULONG(this.fontData[pos], this.fontData[pos + 1], this.fontData[pos + 2], this.fontData[pos + 3]);
                if (currentTag == tag) {
                    return Bitwise.toULONG(this.fontData[pos + 8], this.fontData[pos + 9], this.fontData[pos + 10], this.fontData[pos + 11]);
                }
                pos += 16;
                ++i;
            }
            throw new TrueTypeBusinessException("TableDirEntry with tag=" + tag + " NOT found!");
        }
        catch (TrueTypeBusinessException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new TrueTypeTechnicalException("Throwable!" + t.getMessage());
        }
    }

    private void processFontHeaderTable() throws TrueTypeBusinessException, TrueTypeTechnicalException {
        try {
            long tag = Bitwise.toULONG((byte)104, (byte)101, (byte)97, (byte)100);
            int pos = this.getTableDirEntryParamOffset(tag);
            pos += 4;
            pos += 4;
            pos += 4;
            pos += 4;
            this.unitsPerMSqr = Bitwise.toUSHORT(this.fontData[pos += 2], this.fontData[pos + 1]);
            pos += 2;
            pos += 8;
            this.xMin = Bitwise.toSHORT(this.fontData[pos += 8], this.fontData[pos + 1]);
            this.yMin = Bitwise.toSHORT(this.fontData[pos += 2], this.fontData[pos + 1]);
            this.xMax = Bitwise.toSHORT(this.fontData[pos += 2], this.fontData[pos + 1]);
            this.yMax = Bitwise.toSHORT(this.fontData[pos += 2], this.fontData[pos + 1]);
            pos += 2;
            pos += 2;
            pos += 2;
            this.indexToLocFormat = Bitwise.toSHORT(this.fontData[pos += 2], this.fontData[pos + 1]);
            pos += 2;
        }
        catch (TrueTypeBusinessException e) {
            throw e;
        }
        catch (TrueTypeTechnicalException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new TrueTypeTechnicalException("Throwable!" + t.getMessage());
        }
    }

    private void processMaximumProfileTable() throws TrueTypeBusinessException, TrueTypeTechnicalException {
        try {
            long tag = Bitwise.toULONG((byte)109, (byte)97, (byte)120, (byte)112);
            int pos = this.getTableDirEntryParamOffset(tag);
            this.numGlyphs = Bitwise.toUSHORT(this.fontData[pos += 4], this.fontData[pos + 1]);
        }
        catch (TrueTypeBusinessException e) {
            throw e;
        }
        catch (TrueTypeTechnicalException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new TrueTypeTechnicalException("Throwable!" + t.getMessage());
        }
    }

    private void processNamingTable() throws TrueTypeBusinessException, TrueTypeTechnicalException {
        try {
            int paramOffset;
            long tag = Bitwise.toULONG((byte)110, (byte)97, (byte)109, (byte)101);
            int pos = paramOffset = this.getTableDirEntryParamOffset(tag);
            int numNameRecords = Bitwise.toUSHORT(this.fontData[pos += 2], this.fontData[pos + 1]);
            int stringStorageOffset = Bitwise.toUSHORT(this.fontData[pos += 2], this.fontData[pos + 1]);
            pos += 2;
            stringStorageOffset += paramOffset;
            boolean processedCopyright = false;
            boolean processedFamily = false;
            boolean processedSubfamily = false;
            boolean processedUniqueId = false;
            boolean processedFullName = false;
            boolean processedVersion = false;
            int i = 0;
            while (i < numNameRecords) {
                short currentPlatformID = Bitwise.toUSHORT(this.fontData[pos], this.fontData[pos + 1]);
                short currentSpecificID = Bitwise.toUSHORT(this.fontData[pos += 2], this.fontData[pos + 1]);
                short currentLanguageID = Bitwise.toUSHORT(this.fontData[pos += 2], this.fontData[pos + 1]);
                short currentNameID = Bitwise.toUSHORT(this.fontData[pos += 2], this.fontData[pos + 1]);
                int currentStringLength = Bitwise.toUSHORT(this.fontData[pos += 2], this.fontData[pos + 1]);
                short currentStringOffset = Bitwise.toUSHORT(this.fontData[pos += 2], this.fontData[pos + 1]);
                pos += 2;
                if (currentPlatformID == this.platformID && currentSpecificID == this.specificID && currentLanguageID == this.languageID) {
                    boolean nameFound = false;
                    switch (currentNameID) {
                        case 0: {
                            if (processedCopyright) break;
                            nameFound = true;
                            break;
                        }
                        case 1: {
                            if (processedFamily) break;
                            nameFound = true;
                            break;
                        }
                        case 2: {
                            if (processedSubfamily) break;
                            nameFound = true;
                            break;
                        }
                        case 3: {
                            if (processedUniqueId) break;
                            nameFound = true;
                            break;
                        }
                        case 4: {
                            if (processedFullName) break;
                            nameFound = true;
                            break;
                        }
                        case 5: {
                            if (processedVersion) break;
                            nameFound = true;
                        }
                    }
                    if (nameFound) {
                        int c;
                        byte[] stringToFill;
                        if (currentPlatformID == 3) {
                            stringToFill = new byte[currentStringLength / 2 + 1];
                            c = 1;
                            while (c < currentStringLength) {
                                stringToFill[c / 2] = this.fontData[stringStorageOffset + currentStringOffset + c];
                                c += 2;
                            }
                            stringToFill[c / 2] = 0;
                        } else {
                            stringToFill = new byte[currentStringLength + 1];
                            c = 0;
                            while (c < currentStringLength) {
                                stringToFill[c] = this.fontData[stringStorageOffset + currentStringOffset + c];
                                ++c;
                            }
                            stringToFill[c] = 0;
                        }
                        switch (currentNameID) {
                            case 0: {
                                this.copyright = stringToFill;
                                break;
                            }
                            case 1: {
                                this.familyName = stringToFill;
                                break;
                            }
                            case 2: {
                                this.subfamilyName = stringToFill;
                                break;
                            }
                            case 3: {
                                this.uniqueName = stringToFill;
                                break;
                            }
                            case 4: {
                                this.fullName = stringToFill;
                                break;
                            }
                            case 5: {
                                this.versionName = stringToFill;
                            }
                        }
                    }
                }
                ++i;
            }
        }
        catch (TrueTypeBusinessException e) {
            throw e;
        }
        catch (TrueTypeTechnicalException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new TrueTypeTechnicalException("Throwable!" + t.getMessage());
        }
    }

    private void processNamingTableNoQuestionsAsked() throws TrueTypeBusinessException, TrueTypeTechnicalException {
        try {
            int paramOffset;
            long tag = Bitwise.toULONG((byte)110, (byte)97, (byte)109, (byte)101);
            int pos = paramOffset = this.getTableDirEntryParamOffset(tag);
            int numNameRecords = Bitwise.toUSHORT(this.fontData[pos += 2], this.fontData[pos + 1]);
            int stringStorageOffset = Bitwise.toUSHORT(this.fontData[pos += 2], this.fontData[pos + 1]);
            pos += 2;
            stringStorageOffset += paramOffset;
            boolean processedCopyright = false;
            boolean processedFamily = false;
            boolean processedSubfamily = false;
            boolean processedUniqueId = false;
            boolean processedFullName = false;
            boolean processedVersion = false;
            int i = 0;
            while (i < numNameRecords) {
                short currentPlatformID = Bitwise.toUSHORT(this.fontData[pos], this.fontData[pos + 1]);
                Bitwise.toUSHORT(this.fontData[pos += 2], this.fontData[pos + 1]);
                Bitwise.toUSHORT(this.fontData[pos += 2], this.fontData[pos + 1]);
                short currentNameID = Bitwise.toUSHORT(this.fontData[pos += 2], this.fontData[pos + 1]);
                int currentStringLength = Bitwise.toUSHORT(this.fontData[pos += 2], this.fontData[pos + 1]);
                short currentStringOffset = Bitwise.toUSHORT(this.fontData[pos += 2], this.fontData[pos + 1]);
                pos += 2;
                boolean nameFound = false;
                switch (currentNameID) {
                    case 0: {
                        if (processedCopyright) break;
                        nameFound = true;
                        break;
                    }
                    case 1: {
                        if (processedFamily) break;
                        nameFound = true;
                        break;
                    }
                    case 2: {
                        if (processedSubfamily) break;
                        nameFound = true;
                        break;
                    }
                    case 3: {
                        if (processedUniqueId) break;
                        nameFound = true;
                        break;
                    }
                    case 4: {
                        if (processedFullName) break;
                        nameFound = true;
                        break;
                    }
                    case 5: {
                        if (processedVersion) break;
                        nameFound = true;
                    }
                }
                if (nameFound) {
                    int c;
                    byte[] stringToFill;
                    if (currentPlatformID == 3) {
                        stringToFill = new byte[currentStringLength / 2 + 1];
                        c = 1;
                        while (c < currentStringLength) {
                            stringToFill[c / 2] = this.fontData[stringStorageOffset + currentStringOffset + c];
                            c += 2;
                        }
                        stringToFill[c / 2] = 0;
                    } else {
                        stringToFill = new byte[currentStringLength + 1];
                        c = 0;
                        while (c < currentStringLength) {
                            stringToFill[c] = this.fontData[stringStorageOffset + currentStringOffset + c];
                            ++c;
                        }
                        stringToFill[c] = 0;
                    }
                    switch (currentNameID) {
                        case 0: {
                            this.copyright = stringToFill;
                            processedCopyright = true;
                            break;
                        }
                        case 1: {
                            this.familyName = stringToFill;
                            processedFamily = true;
                            break;
                        }
                        case 2: {
                            this.subfamilyName = stringToFill;
                            processedSubfamily = true;
                            break;
                        }
                        case 3: {
                            this.uniqueName = stringToFill;
                            processedUniqueId = true;
                            break;
                        }
                        case 4: {
                            this.fullName = stringToFill;
                            processedFullName = true;
                            break;
                        }
                        case 5: {
                            this.versionName = stringToFill;
                            processedVersion = true;
                        }
                    }
                }
                ++i;
            }
        }
        catch (TrueTypeBusinessException e) {
            throw e;
        }
        catch (TrueTypeTechnicalException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new TrueTypeTechnicalException("Throwable!" + t.getMessage());
        }
    }

    private void processIndexToLocationTable() throws TrueTypeBusinessException, TrueTypeTechnicalException {
        try {
            long tag = Bitwise.toULONG((byte)108, (byte)111, (byte)99, (byte)97);
            int pos = this.getTableDirEntryParamOffset(tag);
            this.glyphOffsetArray = new int[this.numGlyphs + 1];
            int i = 0;
            while (i < this.numGlyphs + 1) {
                int currentOffset;
                if (this.indexToLocFormat == 0) {
                    currentOffset = Bitwise.toULONG((byte)0, (byte)0, this.fontData[pos], this.fontData[pos + 1]);
                    currentOffset *= 2;
                    pos += 2;
                } else {
                    currentOffset = Bitwise.toULONG(this.fontData[pos], this.fontData[pos + 1], this.fontData[pos + 2], this.fontData[pos + 3]);
                    pos += 4;
                }
                this.glyphOffsetArray[i] = currentOffset;
                ++i;
            }
        }
        catch (TrueTypeBusinessException e) {
            throw e;
        }
        catch (TrueTypeTechnicalException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new TrueTypeTechnicalException("Throwable!" + t.getMessage());
        }
    }

    private void processHorizontalHeaderTable() throws TrueTypeBusinessException, TrueTypeTechnicalException {
        try {
            long tag = Bitwise.toULONG((byte)104, (byte)104, (byte)101, (byte)97);
            int pos = this.getTableDirEntryParamOffset(tag);
            this.ascender = Bitwise.toSHORT(this.fontData[pos += 4], this.fontData[pos + 1]);
            this.descender = Bitwise.toSHORT(this.fontData[pos += 2], this.fontData[pos + 1]);
            this.lineGap = Bitwise.toSHORT(this.fontData[pos += 2], this.fontData[pos + 1]);
            pos += 2;
            pos += 2;
            pos += 2;
            pos += 2;
            pos += 2;
            pos += 2;
            pos += 2;
            pos += 10;
            this.numberOfHMetrics = Bitwise.toUSHORT(this.fontData[pos += 2], this.fontData[pos + 1]);
        }
        catch (TrueTypeBusinessException e) {
            throw e;
        }
        catch (TrueTypeTechnicalException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new TrueTypeTechnicalException("Throwable!" + t.getMessage());
        }
    }

    private void processHorizontalMetricsTable() throws TrueTypeBusinessException, TrueTypeTechnicalException {
        try {
            long tag = Bitwise.toULONG((byte)104, (byte)109, (byte)116, (byte)120);
            int pos = this.getTableDirEntryParamOffset(tag);
            int g = 0;
            while (g < this.numberOfHMetrics) {
                this.glyphs[g].advanceWidth = Bitwise.toUSHORT(this.fontData[pos], this.fontData[pos + 1]);
                this.glyphs[g].leftSideBearing = Bitwise.toSHORT(this.fontData[pos += 2], this.fontData[pos + 1]);
                pos += 2;
                this.glyphs[g].rightSideBearing = (short)(this.glyphs[g].advanceWidth - this.glyphs[g].leftSideBearing - this.glyphs[g].xMax + this.glyphs[g].xMin);
                ++g;
            }
            if (g == this.numGlyphs) {
                return;
            }
            short lastAdvanceWidth = this.glyphs[g].advanceWidth;
            int i = this.numberOfHMetrics;
            while (i < this.numGlyphs) {
                this.glyphs[i].advanceWidth = lastAdvanceWidth;
                this.glyphs[i].leftSideBearing = Bitwise.toSHORT(this.fontData[pos], this.fontData[pos + 1]);
                pos += 2;
                this.glyphs[i].rightSideBearing = (short)(this.glyphs[i].advanceWidth - this.glyphs[i].leftSideBearing - this.glyphs[i].xMax + this.glyphs[i].xMin);
                ++i;
            }
        }
        catch (TrueTypeBusinessException e) {
            throw e;
        }
        catch (TrueTypeTechnicalException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new TrueTypeTechnicalException("Throwable!" + t.getMessage());
        }
    }

    private void processKerningTable() throws TrueTypeKerningBusinessException, TrueTypeBusinessException, TrueTypeTechnicalException {
        try {
            long tag = Bitwise.toULONG((byte)107, (byte)101, (byte)114, (byte)110);
            int pos = this.getTableDirEntryParamOffset(tag);
            pos += 2;
            pos += 2;
            pos += 2;
            byte coverageHi = this.fontData[pos += 2];
            byte coverageLo = this.fontData[pos + 1];
            pos += 2;
            if (Bitwise.isBitSet(coverageLo, 1) || coverageHi != 0) {
                throw new TrueTypeKerningBusinessException("Unknown Kern-format!");
            }
            this.numKernPairs = Bitwise.toUSHORT(this.fontData[pos], this.fontData[pos + 1]);
            pos += 2;
            pos += 2;
            pos += 2;
            pos += 2;
            this.kernPairs = new TTKernPair[this.numKernPairs];
            int i = 0;
            while (i < this.numKernPairs) {
                this.kernPairs[i] = new TTKernPair();
                ++i;
            }
            i = 0;
            while (i < this.numKernPairs) {
                this.kernPairs[i].left = Bitwise.toUSHORT(this.fontData[pos], this.fontData[pos + 1]);
                this.kernPairs[i].right = Bitwise.toUSHORT(this.fontData[pos += 2], this.fontData[pos + 1]);
                this.kernPairs[i].value = Bitwise.toSHORT(this.fontData[pos += 2], this.fontData[pos + 1]);
                pos += 2;
                ++i;
            }
        }
        catch (TrueTypeKerningBusinessException e) {
            throw e;
        }
        catch (TrueTypeBusinessException e) {
            throw e;
        }
        catch (TrueTypeTechnicalException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new TrueTypeTechnicalException("Throwable!" + t.getMessage());
        }
    }

    private void retrieveSpecificList() throws TrueTypeBusinessException, TrueTypeTechnicalException {
        try {
            int paramOffset;
            long tag = Bitwise.toULONG((byte)99, (byte)109, (byte)97, (byte)112);
            int pos = paramOffset = this.getTableDirEntryParamOffset(tag);
            int numSubtables = Bitwise.toUSHORT(this.fontData[pos += 2], this.fontData[pos + 1]);
            pos += 2;
            if (numSubtables <= 0) {
                throw new TrueTypeBusinessException("Character map NOT found! (numTables must be > 0)");
            }
            this.specificList = new String[numSubtables];
            this.PIDList = new short[numSubtables];
            this.SIDList = new short[numSubtables];
            this.specificListTotal = 0;
            boolean subtableFound = false;
            int i = 0;
            while (!subtableFound && i < numSubtables) {
                short currentPlatformID = Bitwise.toUSHORT(this.fontData[pos], this.fontData[pos + 1]);
                short currentSpecificID = Bitwise.toUSHORT(this.fontData[pos += 2], this.fontData[pos + 1]);
                Bitwise.toULONG(this.fontData[pos += 2], this.fontData[pos + 1], this.fontData[pos + 2], this.fontData[pos + 3]);
                pos += 4;
                String tmpStr = null;
                if (currentPlatformID >= 0 && currentPlatformID <= 3) {
                    if (currentPlatformID == 0) {
                        tmpStr = TTConstants.PLATFORM_NAMES[currentPlatformID];
                    } else if (currentPlatformID == 1) {
                        if (currentSpecificID >= 0 && currentSpecificID <= 32) {
                            tmpStr = String.valueOf(TTConstants.PLATFORM_NAMES[currentPlatformID]) + "/" + TTConstants.MAC_SPECIFIC_NAMES[currentSpecificID];
                        }
                    } else if (currentPlatformID == 2) {
                        if (currentSpecificID >= 0 && currentSpecificID <= 2) {
                            tmpStr = String.valueOf(TTConstants.PLATFORM_NAMES[currentPlatformID]) + "/" + TTConstants.ISO_SPECIFIC_NAMES[currentSpecificID];
                        }
                    } else if (currentSpecificID >= 0 && currentSpecificID <= 1) {
                        tmpStr = String.valueOf(TTConstants.PLATFORM_NAMES[currentPlatformID]) + "/" + TTConstants.MS_SPECIFIC_NAMES[currentSpecificID];
                    }
                    if (tmpStr == null) {
                        tmpStr = String.valueOf(TTConstants.PLATFORM_NAMES[currentPlatformID]) + "/" + "Unknown";
                    }
                } else {
                    tmpStr = "Unknown/Unknown";
                }
                int cmapPos = paramOffset + 0;
                this.cmapFormat = Bitwise.toUSHORT(this.fontData[cmapPos], this.fontData[cmapPos + 1]);
                if (this.cmapFormat == 0 || this.cmapFormat == 4 || this.cmapFormat == 6) {
                    this.specificList[this.specificListTotal] = tmpStr;
                    this.PIDList[this.specificListTotal] = currentPlatformID;
                    this.SIDList[this.specificListTotal] = currentSpecificID;
                    ++this.specificListTotal;
                }
                ++i;
            }
        }
        catch (TrueTypeBusinessException e) {
            throw e;
        }
        catch (TrueTypeTechnicalException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new TrueTypeTechnicalException("Throwable!" + t.getMessage());
        }
    }

    private void processCharacterMappingTable() throws TrueTypeBusinessException, TrueTypeTechnicalException {
        try {
            int paramOffset;
            long tag = Bitwise.toULONG((byte)99, (byte)109, (byte)97, (byte)112);
            int pos = paramOffset = this.getTableDirEntryParamOffset(tag);
            int numSubtables = Bitwise.toUSHORT(this.fontData[pos += 2], this.fontData[pos + 1]);
            pos += 2;
            int subtableOffset = 0;
            boolean subtableFound = false;
            int i = 0;
            while (!subtableFound && i < numSubtables) {
                short currentPlatformID = Bitwise.toUSHORT(this.fontData[pos], this.fontData[pos + 1]);
                short currentSpecificID = Bitwise.toUSHORT(this.fontData[pos += 2], this.fontData[pos + 1]);
                int currentSubtableOffset = Bitwise.toULONG(this.fontData[pos += 2], this.fontData[pos + 1], this.fontData[pos + 2], this.fontData[pos + 3]);
                pos += 4;
                if (currentPlatformID == this.platformID && currentSpecificID == this.specificID) {
                    subtableOffset = currentSubtableOffset;
                    subtableFound = true;
                }
                ++i;
            }
            if (!subtableFound) {
                throw new TrueTypeBusinessException("Character map subtable NOT found! (numSubtables=" + numSubtables + "; platformID=" + this.platformID + "; specificID=" + this.specificID + ")");
            }
            pos = paramOffset + subtableOffset;
            this.cmapFormat = Bitwise.toUSHORT(this.fontData[pos], this.fontData[pos + 1]);
            int subtableLength = Bitwise.toUSHORT(this.fontData[pos += 2], this.fontData[pos + 1]);
            pos += 2;
            if (this.cmapFormat != 0 && this.cmapFormat != 4 && this.cmapFormat != 6) {
                throw new TrueTypeBusinessException("Unsupported character map! Only formats TTConstants.CMAP_FORMAT0, TTConstants.CMAP_FORMAT4 and TTConstants.CMAP_FORMAT6 are supported. (" + this.cmapFormat + ")");
            }
            this.cmap = new byte[subtableLength];
            int k = 0;
            while (k < subtableLength) {
                this.cmap[k] = this.fontData[paramOffset + subtableOffset + k];
                ++k;
            }
        }
        catch (TrueTypeBusinessException e) {
            throw e;
        }
        catch (TrueTypeTechnicalException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new TrueTypeTechnicalException("Throwable!" + t.getMessage());
        }
    }

    private void processGlyphDataTable() throws TrueTypeBusinessException, TrueTypeTechnicalException {
        try {
            long tag = Bitwise.toULONG((byte)103, (byte)108, (byte)121, (byte)102);
            int paramOffset = this.getTableDirEntryParamOffset(tag);
            this.glyphs = new TTGlyph[this.numGlyphs];
            int gi = 0;
            while (gi < this.numGlyphs) {
                this.glyphs[gi] = new TTGlyph();
                ++gi;
            }
            gi = 0;
            while (gi < Math.min(this.numGlyphs, 200)) {
                int nextGlyphOffset = this.glyphOffsetArray[gi + 1];
                int currGlyphOffset = this.glyphOffsetArray[gi];
                int currGlyphLength = nextGlyphOffset - currGlyphOffset;
                if (currGlyphLength != 0) {
                    int pos = paramOffset + currGlyphOffset;
                    this.glyphs[gi].numContours = Bitwise.toSHORT(this.fontData[pos], this.fontData[pos + 1]);
                    int numberOfContours = this.glyphs[gi].numContours;
                    this.glyphs[gi].xMin = Bitwise.toSHORT(this.fontData[pos += 2], this.fontData[pos + 1]);
                    this.glyphs[gi].yMin = Bitwise.toSHORT(this.fontData[pos += 2], this.fontData[pos + 1]);
                    this.glyphs[gi].xMax = Bitwise.toSHORT(this.fontData[pos += 2], this.fontData[pos + 1]);
                    this.glyphs[gi].yMax = Bitwise.toSHORT(this.fontData[pos += 2], this.fontData[pos + 1]);
                    pos += 2;
                    if (numberOfContours < 0) {
                        this.glyphs[gi].numContours = 0;
                        this.glyphs[gi].contour = null;
                    } else {
                        byte currentFlag;
                        int j;
                        int endPoint;
                        short[] endPtsOfContours = new short[numberOfContours];
                        int i = 0;
                        while (i < numberOfContours) {
                            endPtsOfContours[i] = Bitwise.toUSHORT(this.fontData[pos], this.fontData[pos + 1]);
                            pos += 2;
                            ++i;
                        }
                        this.glyphs[gi].contour = new TTContour[numberOfContours];
                        i = 0;
                        while (i < numberOfContours) {
                            this.glyphs[gi].contour[i] = new TTContour();
                            ++i;
                        }
                        int numberOfPoints = endPtsOfContours[numberOfContours - 1] + 1;
                        short instructionLength = Bitwise.toUSHORT(this.fontData[pos], this.fontData[pos + 1]);
                        pos += 2;
                        pos += instructionLength;
                        byte[] flags = new byte[numberOfPoints];
                        int i2 = 0;
                        while (i2 < numberOfPoints) {
                            flags[i2] = this.fontData[pos];
                            ++pos;
                            if (Bitwise.isBitSet(flags[i2], 3)) {
                                short repeatCount = this.fontData[pos];
                                if (repeatCount < 0) {
                                    repeatCount = (short)(256 + repeatCount);
                                }
                                ++pos;
                                while (repeatCount > 0) {
                                    flags[++i2] = flags[i2 - 1];
                                    repeatCount = (short)(repeatCount - 1);
                                }
                            }
                            ++i2;
                        }
                        int startPoint = 0;
                        int i3 = 0;
                        while (i3 < numberOfContours) {
                            endPoint = endPtsOfContours[i3];
                            this.glyphs[gi].contour[i3].numPoints = (short)(endPoint - startPoint + 1);
                            this.glyphs[gi].contour[i3].point = new TTPoint[endPoint - startPoint + 1];
                            j = startPoint;
                            while (j <= endPoint) {
                                this.glyphs[gi].contour[i3].point[j - startPoint] = new TTPoint();
                                ++j;
                            }
                            j = startPoint;
                            while (j <= endPoint) {
                                currentFlag = flags[j];
                                this.glyphs[gi].contour[i3].point[j - startPoint].type = Bitwise.isBitSet(currentFlag, 0) ? (byte)2 : (byte)1;
                                if (Bitwise.isBitSet(currentFlag, 1)) {
                                    short xByte = this.fontData[pos];
                                    if (xByte < 0) {
                                        xByte = (short)(256 + xByte);
                                    }
                                    ++pos;
                                    this.glyphs[gi].contour[i3].point[j - startPoint].x = Bitwise.isBitSet(currentFlag, 4) ? xByte : (short)(-xByte);
                                } else if (Bitwise.isBitSet(currentFlag, 4)) {
                                    this.glyphs[gi].contour[i3].point[j - startPoint].x = 0;
                                } else {
                                    short xWord = Bitwise.toSHORT(this.fontData[pos], this.fontData[pos + 1]);
                                    pos += 2;
                                    this.glyphs[gi].contour[i3].point[j - startPoint].x = xWord;
                                }
                                ++j;
                            }
                            startPoint = (short)(endPoint + 1);
                            ++i3;
                        }
                        startPoint = 0;
                        i3 = 0;
                        while (i3 < numberOfContours) {
                            endPoint = endPtsOfContours[i3];
                            j = startPoint;
                            while (j <= endPoint) {
                                currentFlag = flags[j];
                                if (Bitwise.isBitSet(currentFlag, 2)) {
                                    short yByte = this.fontData[pos];
                                    if (yByte < 0) {
                                        yByte = (short)(256 + yByte);
                                    }
                                    ++pos;
                                    this.glyphs[gi].contour[i3].point[j - startPoint].y = Bitwise.isBitSet(currentFlag, 5) ? yByte : (short)(-yByte);
                                } else if (Bitwise.isBitSet(currentFlag, 5)) {
                                    this.glyphs[gi].contour[i3].point[j - startPoint].y = 0;
                                } else {
                                    short yWord = Bitwise.toSHORT(this.fontData[pos], this.fontData[pos + 1]);
                                    pos += 2;
                                    this.glyphs[gi].contour[i3].point[j - startPoint].y = yWord;
                                }
                                ++j;
                            }
                            startPoint = (short)(endPoint + 1);
                            ++i3;
                        }
                    }
                }
                ++gi;
            }
            int i = 0;
            while (i < this.numGlyphs) {
                short tx = 0;
                short ty = 0;
                if (this.glyphs[i].numContours > 0) {
                    int j = 0;
                    while (j < this.glyphs[i].numContours) {
                        int k = 0;
                        while (k < this.glyphs[i].contour[j].numPoints) {
                            tx = (short)(tx + this.glyphs[i].contour[j].point[k].x);
                            ty = (short)(ty + this.glyphs[i].contour[j].point[k].y);
                            this.glyphs[i].contour[j].point[k].x = tx;
                            this.glyphs[i].contour[j].point[k].y = ty;
                            ++k;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (TrueTypeBusinessException e) {
            throw e;
        }
        catch (TrueTypeTechnicalException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new TrueTypeTechnicalException("Throwable!" + t.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public short getGlyphIndex(short c) throws TrueTypeBusinessException, TrueTypeTechnicalException {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        try {
            if (this.cmap == null) {
                throw new TrueTypeBusinessException("Character map is NULL!");
            }
            switch (this.cmapFormat) {
                case 0: {
                    int glyphIdArrayCMAPindex = 6;
                    short result = c < 256 ? (short)this.cmap[glyphIdArrayCMAPindex + c] : (short)0;
                    if (result >= 0) return result;
                    return (short)(256 + result);
                }
                case 4: {
                    int index;
                    short range;
                    short delta;
                    short start;
                    short segCount = (short)(Bitwise.toUSHORT(this.cmap[6], this.cmap[7]) / 2);
                    int endCountCMAPindex = 14;
                    int startCountCMAPindex = 16 + 2 * segCount;
                    int idDeltaCMAPindex = 16 + 4 * segCount;
                    int idRangeOffsetCMAPindex = 16 + 6 * segCount;
                    int seg = 0;
                    short end = Bitwise.toUSHORT(this.cmap[endCountCMAPindex], this.cmap[endCountCMAPindex + 1]);
                    while (true) {
                        if (end >= c) {
                            start = Bitwise.toUSHORT(this.cmap[startCountCMAPindex + seg * 2], this.cmap[startCountCMAPindex + seg * 2 + 1]);
                            delta = Bitwise.toUSHORTsigned(this.cmap[idDeltaCMAPindex + seg * 2], this.cmap[idDeltaCMAPindex + seg * 2 + 1]);
                            range = Bitwise.toUSHORT(this.cmap[idRangeOffsetCMAPindex + seg * 2], this.cmap[idRangeOffsetCMAPindex + seg * 2 + 1]);
                            if (start <= c) break;
                            return 0;
                        }
                        end = Bitwise.toUSHORT(this.cmap[endCountCMAPindex + ++seg * 2], this.cmap[endCountCMAPindex + seg * 2 + 1]);
                    }
                    if (range == 0) {
                        index = c + (short)delta;
                        return (short)index;
                    }
                    index = range + (c - start) * 2 + (16 + 6 * segCount + seg * 2);
                    if ((index = (int)Bitwise.toUSHORT(this.cmap[index], this.cmap[index + 1])) == 0) return (short)index;
                    index = (short)index + (short)delta;
                    return (short)index;
                }
                case 6: {
                    int index = 6;
                    short firstCode = Bitwise.toUSHORT(this.cmap[index], this.cmap[index + 1]);
                    index = 8;
                    short entryCount = Bitwise.toUSHORT(this.cmap[index], this.cmap[index + 1]);
                    int glyphIdArrayCMAPindex = 10;
                    if (c < firstCode) return 0;
                    if (c - firstCode >= entryCount) return 0;
                    int pos = glyphIdArrayCMAPindex + (c - firstCode) * 2;
                    short result = Bitwise.toUSHORT(this.cmap[pos], this.cmap[pos + 1]);
                    return result;
                }
            }
            return 0;
        }
        catch (TrueTypeBusinessException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new TrueTypeTechnicalException("Throwable!" + t.getMessage());
        }
    }

    public short getUnitsPerMSqr() {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        return this.unitsPerMSqr;
    }

    public short getXMax() {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        return this.xMax;
    }

    public short getXMin() {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        return this.xMin;
    }

    public short getYMax() {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        return this.yMax;
    }

    public short getYMin() {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        return this.yMin;
    }

    public short getAscender() {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        return this.ascender;
    }

    public short getDescender() {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        return this.descender;
    }

    public short getLineGap() {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        return this.lineGap;
    }

    public byte[] getCopyright() {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        return this.copyright;
    }

    public byte[] getFamilyName() {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        return this.familyName;
    }

    public byte[] getFullName() {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        return this.fullName;
    }

    public byte[] getSubfamilyName() {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        return this.subfamilyName;
    }

    public byte[] getUniqueName() {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        return this.uniqueName;
    }

    public byte[] getVersionName() {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        return this.versionName;
    }

    public short getNumGlyphs() {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        return this.numGlyphs;
    }

    public short getNumContours(short glyphIndex) {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        if (this.numGlyphs > 0 && glyphIndex >= 0 && glyphIndex < this.numGlyphs) {
            return this.glyphs[glyphIndex].numContours;
        }
        return 0;
    }

    public short getNumPoints(short glyphIndex, short contourIndex) {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        if (this.numGlyphs > 0 && glyphIndex >= 0 && glyphIndex < this.numGlyphs && this.glyphs[glyphIndex].numContours > 0 && contourIndex < this.glyphs[glyphIndex].numContours) {
            return this.glyphs[glyphIndex].contour[contourIndex].numPoints;
        }
        return 0;
    }

    public int getFontPointX(short glyphIndex, short contourIndex, short pointIndex) {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        if (this.numGlyphs > 0 && glyphIndex >= 0 && glyphIndex < this.numGlyphs && this.glyphs[glyphIndex].numContours > 0 && contourIndex < this.glyphs[glyphIndex].numContours && this.glyphs[glyphIndex].contour[contourIndex].numPoints > 0) {
            return this.glyphs[glyphIndex].contour[contourIndex].point[pointIndex].x;
        }
        return 0;
    }

    public int getFontPointY(short glyphIndex, short contourIndex, short pointIndex) {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        if (this.numGlyphs > 0 && glyphIndex >= 0 && glyphIndex < this.numGlyphs && this.glyphs[glyphIndex].numContours > 0 && contourIndex < this.glyphs[glyphIndex].numContours && this.glyphs[glyphIndex].contour[contourIndex].numPoints > 0) {
            return this.glyphs[glyphIndex].contour[contourIndex].point[pointIndex].y;
        }
        return 0;
    }

    public short getFontPointType(short glyphIndex, short contourIndex, short pointIndex) {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        if (this.numGlyphs > 0 && glyphIndex >= 0 && glyphIndex < this.numGlyphs && this.glyphs[glyphIndex].numContours > 0 && contourIndex < this.glyphs[glyphIndex].numContours && this.glyphs[glyphIndex].contour[contourIndex].numPoints > 0) {
            return this.glyphs[glyphIndex].contour[contourIndex].point[pointIndex].type;
        }
        return 0;
    }

    public short getGlyphAdvanceWidth(short glyphIndex) {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        if (this.numGlyphs > 0 && glyphIndex >= 0 && glyphIndex < this.numGlyphs) {
            return this.glyphs[glyphIndex].advanceWidth;
        }
        return 0;
    }

    public short getGlyphXMin(short glyphIndex) {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        if (this.numGlyphs > 0 && glyphIndex >= 0 && glyphIndex < this.numGlyphs) {
            return this.glyphs[glyphIndex].xMin;
        }
        return 0;
    }

    public short getGlyphYMin(short glyphIndex) {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        if (this.numGlyphs > 0 && glyphIndex >= 0 && glyphIndex < this.numGlyphs) {
            return this.glyphs[glyphIndex].yMin;
        }
        return 0;
    }

    public short getGlyphXMax(short glyphIndex) {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        if (this.numGlyphs > 0 && glyphIndex >= 0 && glyphIndex < this.numGlyphs) {
            return this.glyphs[glyphIndex].xMax;
        }
        return 0;
    }

    public short getGlyphYMax(short glyphIndex) {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        if (this.numGlyphs > 0 && glyphIndex >= 0 && glyphIndex < this.numGlyphs) {
            return this.glyphs[glyphIndex].yMax;
        }
        return 0;
    }

    public short mapCharacterToGlyph(short c) throws TrueTypeBusinessException, TrueTypeTechnicalException {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        return this.getGlyphIndex(c);
    }

    public short findKerning(short idx1, short idx2) throws TrueTypeTechnicalException {
        block8: {
            if (!this.loadingCompleted) {
                throw new IllegalStateException("Loading NOT completed!");
            }
            if (this.numKernPairs != 0) break block8;
            return 0;
        }
        try {
            int combined = idx1 * 65536 + idx2;
            int beg = 0;
            int end = this.numKernPairs;
            int mid = 0;
            boolean found = false;
            while (!found && beg <= end) {
                mid = (end + beg) / 2;
                short currentLeft = this.kernPairs[mid].left;
                short currentRight = this.kernPairs[mid].right;
                int currentCombined = currentLeft * 65536 + currentRight;
                if (combined == currentCombined) {
                    found = true;
                    break;
                }
                if (combined < currentCombined) {
                    end = mid - 1;
                    continue;
                }
                beg = mid + 1;
            }
            if (found) {
                return this.kernPairs[mid].value;
            }
            return 0;
        }
        catch (Throwable t) {
            throw new TrueTypeTechnicalException("Throwable!" + t.getMessage());
        }
    }

    public TTGlyph getGlyph(short code) throws TrueTypeBusinessException, TrueTypeTechnicalException {
        block6: {
            if (!this.loadingCompleted) {
                throw new IllegalStateException("Loading NOT completed!");
            }
            if (this.glyphs != null) break block6;
            return null;
        }
        try {
            return this.glyphs[this.getGlyphIndex(code)];
        }
        catch (TrueTypeBusinessException e) {
            throw e;
        }
        catch (TrueTypeTechnicalException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new TrueTypeTechnicalException("Throwable!" + t.getMessage());
        }
    }
}

