/*
 * Decompiled with CFR 0.152.
 */
package ntr.ttme;

import ntr.ttme.BezierCurveRenderer;
import ntr.ttme.DoubleMatrix3x3;
import ntr.ttme.DoublePolygon;
import ntr.ttme.NtrPolygonFiller;
import ntr.ttme.PolygonFiller;
import ntr.ttme.SplineCurveRenderer;
import ntr.ttme.TrueTypeBusinessException;
import ntr.ttme.TrueTypeDefinition;
import ntr.ttme.TrueTypeTechnicalException;

public class TrueTypeRenderer {
    private static PolygonFiller POLYGON_FILLER = new NtrPolygonFiller();
    protected SplineCurveRenderer spline = new SplineCurveRenderer(10);
    protected BezierCurveRenderer bezier = new BezierCurveRenderer();
    protected int[] x = new int[4];
    protected int[] y = new int[4];
    protected double[] fx = new double[4];
    protected double[] fy = new double[4];
    protected short[] t = new short[4];
    public DoublePolygon curves = new DoublePolygon();
    public DoublePolygon transformedCurves = new DoublePolygon();
    public DoublePolygon worldPoints = new DoublePolygon();

    public void renderStringToPolygon(TrueTypeDefinition ttf, double xBase, double yBase, String textToDraw, double pointSize, double charSpacing) throws TrueTypeBusinessException, TrueTypeTechnicalException {
        this.worldPoints.numberOfPoints = 0;
        this.curves.numberOfPoints = 0;
        double xpos = xBase;
        double scale = pointSize / (double)(72 * ttf.getUnitsPerMSqr());
        charSpacing *= (double)ttf.getXMax() * scale;
        int i = 0;
        while (i < textToDraw.length()) {
            char ch = textToDraw.charAt(i);
            double advance = this.renderCharToPolygon(ttf, xpos, yBase, ch, scale);
            xpos += Math.max(charSpacing, advance);
            ++i;
        }
        this.transformedCurves = this.curves.duplicate();
    }

    protected double renderCharToPolygon(TrueTypeDefinition ttf, double xBase, double yBase, char ch, double scale) throws TrueTypeBusinessException, TrueTypeTechnicalException {
        double sx = Double.MAX_VALUE;
        double sy = 0.0;
        double offX = 0.0;
        double offY = 0.0;
        double firstX = 0.0;
        double firstY = 0.0;
        short glyphIdx = ttf.mapCharacterToGlyph((short)ch);
        double advance = (double)ttf.getGlyphAdvanceWidth(glyphIdx) * scale;
        short numberOfContours = ttf.getNumContours(glyphIdx);
        short c = 0;
        while (c < numberOfContours) {
            short numberOfPoints = ttf.getNumPoints(glyphIdx, c);
            if (numberOfPoints > 1) {
                double bottom = yBase;
                boolean contourStarted = false;
                boolean startedWithOffCurve = false;
                int lastFilledPoint = -1;
                short p = 0;
                while (p <= numberOfPoints) {
                    short pnt;
                    short s = pnt = p < numberOfPoints ? p : (short)(p - numberOfPoints);
                    if (++lastFilledPoint > 2) {
                        String msg = "Font contains bad point-sequence! ";
                        int i = 0;
                        while (i < lastFilledPoint) {
                            msg = String.valueOf(msg) + this.t[i] + ";";
                            ++i;
                        }
                        throw new TrueTypeBusinessException(msg);
                    }
                    this.fx[lastFilledPoint] = xBase + (double)ttf.getFontPointX(glyphIdx, c, pnt) * scale;
                    this.fy[lastFilledPoint] = bottom - (double)ttf.getFontPointY(glyphIdx, c, pnt) * scale;
                    this.t[lastFilledPoint] = ttf.getFontPointType(glyphIdx, c, pnt);
                    if (lastFilledPoint == 1 && this.t[0] == 1) {
                        startedWithOffCurve = true;
                        offX = this.fx[0];
                        offY = this.fy[0];
                        if (this.t[1] == 2) {
                            this.fx[0] = this.fx[1];
                            this.fy[0] = this.fy[1];
                            this.t[0] = this.t[1];
                            lastFilledPoint = 0;
                        } else {
                            this.fx[0] = (this.fx[0] + this.fx[1]) / 2.0;
                            this.fy[0] = (this.fy[0] + this.fy[1]) / 2.0;
                            this.t[0] = 2;
                        }
                        firstX = this.fx[0];
                        firstY = this.fy[0];
                    }
                    if (lastFilledPoint == 1) {
                        if (this.t[0] == 2 && this.t[1] == 2) {
                            if (!contourStarted) {
                                sy = this.fy[0];
                                this.worldPoints.addPoint(sx, sy);
                                this.worldPoints.addPoint(this.fx[0], this.fy[0]);
                                this.curves.addPoint(this.fx[0], this.fy[0]);
                                contourStarted = true;
                            }
                            this.worldPoints.addPoint(this.fx[1], this.fy[1]);
                            this.curves.addPoint(this.fx[1], this.fy[1]);
                            this.curves.addPoint(sx, 1.0);
                            this.fx[0] = this.fx[1];
                            this.fy[0] = this.fy[1];
                            this.t[0] = this.t[1];
                            lastFilledPoint = 0;
                        }
                    } else if (lastFilledPoint == 2 && this.t[0] == 2 && this.t[1] == 1) {
                        if (this.t[2] == 2) {
                            this.spline.calculateWorldSpline(this.fx[0], this.fy[0], this.fx[1], this.fy[1], this.fx[2], this.fy[2]);
                            if (!contourStarted) {
                                sy = this.spline.worldPoints.yPoints[0];
                                this.worldPoints.addPoint(sx, sy);
                                this.worldPoints.addPoint(this.spline.worldPoints.xPoints[0], this.spline.worldPoints.yPoints[0]);
                                this.curves.addPoint(this.fx[0], this.fy[0]);
                                contourStarted = true;
                            }
                            int i = 1;
                            while (i < this.spline.worldPoints.numberOfPoints) {
                                this.worldPoints.addPoint(this.spline.worldPoints.xPoints[i], this.spline.worldPoints.yPoints[i]);
                                ++i;
                            }
                            this.curves.addPoint(this.fx[1], this.fy[1]);
                            this.curves.addPoint(this.fx[2], this.fy[2]);
                            this.curves.addPoint(sx, 2.0);
                            this.fx[0] = this.fx[2];
                            this.fy[0] = this.fy[2];
                            this.t[0] = this.t[2];
                            lastFilledPoint = 0;
                        } else {
                            double tX = (this.fx[1] + this.fx[2]) / 2.0;
                            double tY = (this.fy[1] + this.fy[2]) / 2.0;
                            int tType = 2;
                            this.spline.calculateWorldSpline(this.fx[0], this.fy[0], this.fx[1], this.fy[1], tX, tY);
                            if (!contourStarted) {
                                sy = this.spline.worldPoints.yPoints[0];
                                this.worldPoints.addPoint(sx, sy);
                                this.worldPoints.addPoint(this.spline.worldPoints.xPoints[0], this.spline.worldPoints.yPoints[0]);
                                this.curves.addPoint(this.fx[0], this.fy[0]);
                                contourStarted = true;
                            }
                            int i = 1;
                            while (i < this.spline.worldPoints.numberOfPoints) {
                                this.worldPoints.addPoint(this.spline.worldPoints.xPoints[i], this.spline.worldPoints.yPoints[i]);
                                ++i;
                            }
                            this.curves.addPoint(this.fx[1], this.fy[1]);
                            this.curves.addPoint(tX, tY);
                            this.curves.addPoint(sx, 2.0);
                            this.fx[0] = tX;
                            this.fy[0] = tY;
                            this.t[0] = tType;
                            this.fx[1] = this.fx[2];
                            this.fy[1] = this.fy[2];
                            this.t[1] = this.t[2];
                            lastFilledPoint = 1;
                        }
                    }
                    p = (short)(p + 1);
                }
                if (startedWithOffCurve) {
                    if (this.t[lastFilledPoint] == 2) {
                        double lastX = this.fx[lastFilledPoint];
                        double lastY = this.fy[lastFilledPoint];
                        this.spline.calculateWorldSpline(lastX, lastY, offX, offY, firstX, firstY);
                        if (!contourStarted) {
                            sy = this.spline.worldPoints.yPoints[0];
                            this.worldPoints.addPoint(sx, sy);
                            this.worldPoints.addPoint(this.spline.worldPoints.xPoints[0], this.spline.worldPoints.yPoints[0]);
                            this.curves.addPoint(lastX, lastY);
                            contourStarted = true;
                        }
                        int i = 1;
                        while (i < this.spline.worldPoints.numberOfPoints) {
                            this.worldPoints.addPoint(this.spline.worldPoints.xPoints[i], this.spline.worldPoints.yPoints[i]);
                            ++i;
                        }
                        this.curves.addPoint(offX, offY);
                        this.curves.addPoint(firstX, firstY);
                        this.curves.addPoint(sx, 2.0);
                    } else {
                        this.spline.calculateWorldSpline(this.fx[lastFilledPoint - 1], this.fy[lastFilledPoint - 1], this.fx[lastFilledPoint], this.fy[lastFilledPoint], firstX, firstY);
                        if (!contourStarted) {
                            sy = this.spline.worldPoints.yPoints[0];
                            this.worldPoints.addPoint(sx, sy);
                            this.worldPoints.addPoint(this.spline.worldPoints.xPoints[0], this.spline.worldPoints.yPoints[0]);
                            this.curves.addPoint(this.fx[lastFilledPoint - 1], this.fy[lastFilledPoint - 1]);
                            contourStarted = true;
                        }
                        int i = 1;
                        while (i < this.spline.worldPoints.numberOfPoints) {
                            this.worldPoints.addPoint(this.spline.worldPoints.xPoints[i], this.spline.worldPoints.yPoints[i]);
                            ++i;
                        }
                        this.curves.addPoint(this.fx[lastFilledPoint], this.fy[lastFilledPoint]);
                        this.curves.addPoint(firstX, firstY);
                        this.curves.addPoint(sx, 2.0);
                    }
                }
                this.worldPoints.addPoint(sx, sy);
                this.curves.addPoint(sx, 0.0);
            }
            c = (short)(c + 1);
        }
        return advance;
    }

    public void transformCurves(DoubleMatrix3x3 ctm) {
        this.transformedCurves.numberOfPoints = 0;
        int i = 0;
        while (i < this.curves.numberOfPoints) {
            if (this.curves.xPoints[i] != Double.MAX_VALUE) {
                this.transformedCurves.addPoint(ctm.element[0][0] * this.curves.xPoints[i] + ctm.element[0][1] * this.curves.yPoints[i] + ctm.element[0][2], ctm.element[1][0] * this.curves.xPoints[i] + ctm.element[1][1] * this.curves.yPoints[i] + ctm.element[1][2]);
            } else {
                this.transformedCurves.addPoint(this.curves.xPoints[i], this.curves.yPoints[i]);
            }
            ++i;
        }
    }

    public void decodeCurves() {
        this.worldPoints.numberOfPoints = 0;
        boolean contourStarted = false;
        int lastFilledPoint = -1;
        int i = 0;
        while (i < this.transformedCurves.numberOfPoints) {
            if (this.transformedCurves.xPoints[i] == Double.MAX_VALUE) {
                int j;
                if (this.transformedCurves.yPoints[i] == 1.0) {
                    if (lastFilledPoint >= 1) {
                        if (!contourStarted) {
                            this.worldPoints.addPoint(Double.MAX_VALUE, this.fy[lastFilledPoint - 1]);
                            this.worldPoints.addPoint(this.fx[lastFilledPoint - 1], this.fy[lastFilledPoint - 1]);
                            contourStarted = true;
                        }
                        this.worldPoints.addPoint(this.fx[lastFilledPoint], this.fy[lastFilledPoint]);
                        this.fx[0] = this.fx[lastFilledPoint];
                        this.fy[0] = this.fy[lastFilledPoint];
                        lastFilledPoint = 0;
                    }
                } else if (this.transformedCurves.yPoints[i] == 2.0) {
                    if (lastFilledPoint == 2) {
                        this.spline.calculateWorldSpline(this.fx[0], this.fy[0], this.fx[1], this.fy[1], this.fx[2], this.fy[2]);
                        if (!contourStarted) {
                            this.worldPoints.addPoint(Double.MAX_VALUE, this.spline.worldPoints.yPoints[0]);
                            this.worldPoints.addPoint(this.spline.worldPoints.xPoints[0], this.spline.worldPoints.yPoints[0]);
                            contourStarted = true;
                        }
                        j = 1;
                        while (j < this.spline.worldPoints.numberOfPoints) {
                            this.worldPoints.addPoint(this.spline.worldPoints.xPoints[j], this.spline.worldPoints.yPoints[j]);
                            ++j;
                        }
                        this.fx[0] = this.fx[2];
                        this.fy[0] = this.fy[2];
                        lastFilledPoint = 0;
                    }
                } else if (this.transformedCurves.yPoints[i] == 3.0) {
                    if (lastFilledPoint == 3) {
                        this.bezier.worldCalculateBezier(this.fx[0], this.fy[0], this.fx[1], this.fy[1], this.fx[2], this.fy[2], this.fx[3], this.fy[3]);
                        if (!contourStarted) {
                            this.worldPoints.addPoint(Double.MAX_VALUE, this.bezier.worldPoints.yPoints[0]);
                            this.worldPoints.addPoint(this.bezier.worldPoints.xPoints[0], this.bezier.worldPoints.yPoints[0]);
                            contourStarted = true;
                        }
                        j = 1;
                        while (j < this.bezier.worldPoints.numberOfPoints) {
                            this.worldPoints.addPoint(this.bezier.worldPoints.xPoints[j], this.bezier.worldPoints.yPoints[j]);
                            ++j;
                        }
                        this.fx[0] = this.fx[3];
                        this.fy[0] = this.fy[3];
                        lastFilledPoint = 0;
                    }
                } else if (this.transformedCurves.yPoints[i] == 0.0) {
                    if (contourStarted) {
                        if (this.worldPoints.numberOfPoints > 0) {
                            this.worldPoints.addPoint(Double.MAX_VALUE, this.worldPoints.yPoints[this.worldPoints.numberOfPoints - 1]);
                        }
                        contourStarted = false;
                    }
                    lastFilledPoint = -1;
                }
            } else if (lastFilledPoint < 3) {
                this.fx[++lastFilledPoint] = this.transformedCurves.xPoints[i];
                this.fy[lastFilledPoint] = this.transformedCurves.yPoints[i];
            }
            ++i;
        }
        this.worldPoints.calculateBounds();
    }

    public double calculateTextWidth(TrueTypeDefinition ttf, String textToMeasure, double pointSize, double charSpacing) throws TrueTypeBusinessException, TrueTypeTechnicalException {
        double width = 0.0;
        double scale = pointSize / (double)(72 * ttf.getUnitsPerMSqr());
        charSpacing *= (double)ttf.getXMax() * scale;
        int i = 0;
        while (i < textToMeasure.length()) {
            char ch = textToMeasure.charAt(i);
            short glyphIdx = ttf.mapCharacterToGlyph((short)ch);
            double advance = (double)ttf.getGlyphAdvanceWidth(glyphIdx) * scale;
            if (i != textToMeasure.length() - 1) {
                width += Math.max(charSpacing, advance);
            }
            ++i;
        }
        return width;
    }

    public static void setPolygonFiller(PolygonFiller polygonFiller) {
        POLYGON_FILLER = polygonFiller;
    }

    public static PolygonFiller getPolygonFiller() {
        return POLYGON_FILLER;
    }

    public static double calculateWorldAscender(TrueTypeDefinition ttf, double pointSize) {
        double scale = pointSize / (72.0 * (double)ttf.getUnitsPerMSqr());
        return (double)ttf.getAscender() * scale;
    }

    public static double calculateWorldDescender(TrueTypeDefinition ttf, double pointSize) {
        double scale = pointSize / (72.0 * (double)ttf.getUnitsPerMSqr());
        return (double)ttf.getDescender() * scale;
    }
}

