/*
 * Decompiled with CFR 0.152.
 */
package ntr.ttme;

import javax.microedition.lcdui.Graphics;
import ntr.ttme.DoubleRectangle;
import ntr.ttme.IntPolygon;
import ntr.ttme.PolygonFiller;
import ntr.ttme.TrueTypeBusinessException;
import ntr.ttme.TrueTypeDefinition;
import ntr.ttme.TrueTypeRegistry;
import ntr.ttme.TrueTypeRenderer;
import ntr.ttme.TrueTypeTechnicalException;
import ntr.ttme.VectorGraphicsAdapter;
import ntr.ttme.View;

public class TrueTypeText
extends VectorGraphicsAdapter {
    private TrueTypeDefinition ttf;
    private Integer color;
    private Integer fillColor;
    private double worldAscender;
    private double worldDescender;
    private TrueTypeRenderer renderer;
    private double textWorldWidth;
    private IntPolygon viewPoints;

    public TrueTypeText(String token, double x, double y, String text, double sizeInPoints, Integer color) throws TrueTypeBusinessException, TrueTypeTechnicalException {
        this(token, x, y, text, sizeInPoints, color, null, 0.02);
    }

    public TrueTypeText(String token, double x, double y, String text, double sizeInPoints, Integer color, Integer fillColor) throws TrueTypeBusinessException, TrueTypeTechnicalException {
        this(token, x, y, text, sizeInPoints, color, fillColor, 0.02);
    }

    public TrueTypeText(String token, double x, double y, String text, double sizeInPoints, Integer color, Integer fillColor, double characterSpacing) throws TrueTypeBusinessException, TrueTypeTechnicalException {
        this.ttf = TrueTypeRegistry.instance.get(token);
        if (this.ttf == null) {
            throw new TrueTypeBusinessException("TrueType token='" + token + "' is NOT registered!");
        }
        this.translate(0.0, 0.0);
        this.color = color;
        this.fillColor = fillColor;
        this.renderer = new TrueTypeRenderer();
        this.renderer.renderStringToPolygon(this.ttf, x, y, text, sizeInPoints, characterSpacing);
        this.textWorldWidth = this.renderer.calculateTextWidth(this.ttf, text, sizeInPoints, characterSpacing);
        this.worldAscender = TrueTypeRenderer.calculateWorldAscender(this.ttf, sizeInPoints);
        this.worldDescender = TrueTypeRenderer.calculateWorldDescender(this.ttf, sizeInPoints);
    }

    public void draw(View view, Graphics g) {
        if (this.viewPoints == null || this.modified) {
            if (this.modified) {
                this.renderer.transformCurves(this.ctm);
                this.renderer.decodeCurves();
            }
            int nPoints = this.renderer.worldPoints.numberOfPoints;
            int[] xPoints = new int[nPoints];
            int[] yPoints = new int[nPoints];
            int i = 0;
            while (i < nPoints) {
                xPoints[i] = view.convertXWorldToView(this.renderer.worldPoints.xPoints[i]);
                yPoints[i] = view.convertYWorldToView(this.renderer.worldPoints.yPoints[i]);
                ++i;
            }
            this.viewPoints = new IntPolygon(xPoints, yPoints, nPoints);
            this.modified = false;
        }
        if (this.color != null) {
            if (this.fillColor != null) {
                g.setColor(this.fillColor.intValue());
                PolygonFiller filler = TrueTypeRenderer.getPolygonFiller();
                if (filler != null) {
                    filler.fillPolygon(g, this.viewPoints.xpoints, this.viewPoints.ypoints, this.viewPoints.npoints);
                }
            }
            if (this.color != null) {
                g.setColor(this.color.intValue());
            } else if (this.fillColor != null) {
                g.setColor(this.fillColor.intValue());
            }
            int i = 0;
            while (i < this.viewPoints.npoints - 1) {
                if (this.renderer.worldPoints.xPoints[i] != Double.MAX_VALUE && this.renderer.worldPoints.xPoints[i + 1] != Double.MAX_VALUE) {
                    g.drawLine(this.viewPoints.xpoints[i], this.viewPoints.ypoints[i], this.viewPoints.xpoints[i + 1], this.viewPoints.ypoints[i + 1]);
                }
                ++i;
            }
        }
    }

    public static String intArrayToString(int[] a) {
        if (a.length == 0) {
            return "";
        }
        String result = "" + a[0];
        int i = 1;
        while (i < a.length) {
            result = String.valueOf(result) + "," + a[i];
            ++i;
        }
        return result;
    }

    public double getTextWorldWidth() {
        return this.textWorldWidth;
    }

    public DoubleRectangle getBounds() {
        if (this.renderer.worldPoints == null) {
            return null;
        }
        return this.renderer.worldPoints.bounds;
    }

    public double getWorldAscender() {
        return this.worldAscender;
    }

    public double getWorldDescender() {
        return this.worldDescender;
    }

    public int getViewAscender(View view) {
        return view.convertYDistanceWorldToView(this.worldAscender);
    }

    public int getWorldDescender(View view) {
        return view.convertYDistanceWorldToView(this.worldDescender);
    }
}

