/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Palette {
    PhotoCanvas canvas;
    Image palette = null;
    int[] palaray = null;
    int posX;
    int posY;
    int paletteW;
    int paletteH;
    int thiscol;

    public void init() throws  {
        try {
            this.palette = Image.createImage((String)"/res/palette.png");
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
        this.paletteW = this.palette.getWidth();
        this.paletteH = this.palette.getHeight();
        this.posX = this.paletteW - 9;
        this.posY = this.paletteH / 2;
        this.palaray = new int[this.paletteW * this.paletteH];
        this.palette.getRGB(this.palaray, 0, this.paletteW, 0, 0, this.paletteW, this.paletteH);
        this.readColor(this.posX, this.posY);
    }

    public void readColor(int n, int n2) throws  {
        int n3 = this.palaray[n + n2 * this.paletteW] >> 16 & 0xFF;
        int n4 = this.palaray[n + n2 * this.paletteW] >> 8 & 0xFF;
        int n5 = this.palaray[n + n2 * this.paletteW] & 0xFF;
        this.thiscol = n3 << 16 | n4 << 8 | n5;
    }

    public int getColor() throws  {
        return this.thiscol;
    }

    public void drawPalette(Graphics graphics, int n, int n2) throws  {
        graphics.setColor(0x656565);
        graphics.drawImage(this.palette, n, n2, 24);
        graphics.drawRect(n - this.paletteW + this.posX - 1, n2 + this.posY - 1, 2, 2);
        graphics.setColor(this.thiscol);
        graphics.fillRect(n - this.paletteW - this.paletteH / 2, n2, this.paletteH / 2, this.paletteH);
        graphics.setColor(0x656565);
        graphics.drawRect(n - this.paletteW - this.paletteH / 2, n2, this.paletteW + this.paletteH / 2, this.paletteH);
        graphics.drawLine(n - this.paletteW, n2, n - this.paletteW, n2 + this.paletteH);
    }

    public void select() throws  {
        this.canvas.stringColor(this.thiscol);
    }

    public void moveUp() throws  {
        --this.posY;
        if (this.posY < 1) {
            this.posY = 1;
        }
        this.readColor(this.posX, this.posY);
    }

    public void moveDown() throws  {
        ++this.posY;
        if (this.posY > this.paletteH - 1) {
            this.posY = this.paletteH - 1;
        }
        this.readColor(this.posX, this.posY);
    }

    public void moveLeft() throws  {
        --this.posX;
        if (this.posX < 1) {
            this.posX = 1;
        }
        this.readColor(this.posX, this.posY);
    }

    public void moveRight() throws  {
        ++this.posX;
        if (this.posX > this.paletteW - 1) {
            this.posX = this.paletteW - 1;
        }
        this.readColor(this.posX, this.posY);
    }

    public Palette(PhotoCanvas photoCanvas) throws  {
        this.canvas = photoCanvas;
        this.init();
    }
}

