/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class PhotoAdjust
extends Canvas
implements Runnable {
    PhotoEditorMIDlet midlet;
    int width;
    int height;
    boolean started = false;
    Thread prThread;
    int valueX = 0;
    int histY = 0;
    int valMin = -128;
    int valMax = 128;
    int saturation = 0;
    int contrast = 0;
    int brightness = 0;
    int alpha = 255;
    int histwhite = 0;
    int histblack = 0;
    int rotate = 0;
    Image image;
    Image show;
    int newW = 128;
    int newH = 128;
    int mode = 1;
    String type;
    boolean graph = false;
    boolean histmove = false;
    boolean red = false;
    boolean gray = false;
    boolean blue = false;
    int histmode = 0;
    boolean PRESS_UP = false;
    boolean PRESS_DOWN = false;
    boolean PRESS_LEFT = false;
    boolean PRESS_RIGHT = false;
    Font small_bold_Font = Font.getFont((int)0, (int)1, (int)8);
    int font_small_bold_Height = this.small_bold_Font.getHeight();

    public void paint(Graphics graphics) throws  {
        graphics.setColor(0x222426);
        graphics.fillRect(0, 0, this.width, this.height);
        if (this.mode == 5 || this.mode == 6) {
            this.show = ImageChanels.histogram(this.image, this.histwhite, this.histblack, this.graph);
            if (!this.graph && this.histmove) {
                this.histmove = false;
                this.nextMode();
            }
            if (this.histmove && this.graph) {
                graphics.drawImage(this.show, this.width / 2 + this.histY, this.height / 2, 3);
            } else {
                graphics.drawImage(this.show, this.width / 2, this.height / 2, 3);
            }
        } else {
            this.show = this.mode == 7 ? ImageChanels.rotateImage(this.image, this.valueX) : (this.mode == 8 ? ImageChanels.invertChanels(this.image, this.red, this.gray, this.blue) : ImageChanels.chanel(this.image, this.valueX, this.mode));
            graphics.drawImage(this.show, this.width / 2, this.height / 2, 3);
        }
        graphics.setColor(0x656565);
        if ((this.mode == 5 || this.mode == 6) && this.histmove && this.graph) {
            graphics.drawRect(this.histY + this.width / 2 - this.show.getWidth() / 2 - 1, this.height / 2 - this.show.getHeight() / 2 - 1, this.show.getWidth() + 1, this.show.getHeight() + 1);
        } else {
            graphics.drawRect(this.width / 2 - this.show.getWidth() / 2 - 1, this.height / 2 - this.show.getHeight() / 2 - 1, this.show.getWidth() + 1, this.show.getHeight() + 1);
        }
        graphics.drawRect(1, this.font_small_bold_Height - 1, this.width - 3, this.height - this.font_small_bold_Height * 2);
        graphics.setColor(0xCECBCE);
        graphics.drawLine(0, 0, 0, this.height);
        graphics.drawLine(this.width - 1, 0, this.width - 1, this.height);
        this.drawGradient(graphics, 0, 0, this.width, this.font_small_bold_Height, 0, 0xCECECE);
        this.drawGradient(graphics, 0, this.height - this.font_small_bold_Height, this.width, this.font_small_bold_Height + 1, 0xCECECE, 0);
        graphics.setFont(this.small_bold_Font);
        graphics.setColor(0xEEEEEE);
        graphics.drawString(this.midlet.lng.getString(Language.TXT_ADJUST_TITLE), 2, 0, 20);
        if (this.mode == 8) {
            graphics.drawString(this.type, this.width / 2, this.height - this.font_small_bold_Height - 2, 33);
        } else {
            graphics.drawString(String.valueOf(this.type).concat(String.valueOf(Integer.toString(this.valueX))), this.width / 2, this.height - this.font_small_bold_Height - 2, 33);
        }
        graphics.drawString(this.midlet.lng.getString(Language.TXT_ADJUST_OK), 2, this.height, 36);
        graphics.drawString(this.midlet.lng.getString(Language.TXT_ADJUST_CANCEL), this.width - 2, this.height, 40);
    }

    public void drawGradient(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) throws  {
        int n7 = n5 >> 8 & 0xFF00;
        int n8 = n5 & 0xFF00;
        int n9 = n5 << 8 & 0xFF00;
        int n10 = ((n6 >> 8 & 0xFF00) - n7) / n4;
        int n11 = ((n6 & 0xFF00) - n8) / n4;
        int n12 = ((n6 << 8 & 0xFF00) - n9) / n4;
        int n13 = n + n3 - 1;
        int n14 = n2 + n4 - 1;
        while (n2 < n14) {
            graphics.setColor((n7 & 0xFF00) << 8 | n8 & 0xFF00 | n9 >> 8);
            graphics.drawLine(n, n2, n13, n2);
            n7 += n10;
            n8 += n11;
            n9 += n12;
            ++n2;
        }
    }

    public void nextMode() throws  {
        if (this.mode == 2) {
            this.valueX = this.contrast;
            this.valMin = -128;
            this.valMax = 128;
            this.type = this.midlet.lng.getString(Language.TXT_ADJUST_CONTRAST);
        } else if (this.mode == 3) {
            this.valueX = this.brightness;
            this.valMin = -128;
            this.valMax = 128;
            this.type = this.midlet.lng.getString(Language.TXT_ADJUST_BRIGHTNESS);
        } else if (this.mode == 1) {
            this.valueX = this.saturation;
            this.valMin = -128;
            this.valMax = 128;
            this.type = this.midlet.lng.getString(Language.TXT_ADJUST_SATURATION);
        } else if (this.mode == 4) {
            this.valueX = this.alpha;
            this.valMin = 0;
            this.valMax = 255;
            this.type = this.midlet.lng.getString(Language.TXT_ADJUST_ALPHA);
        } else if (this.mode == 5) {
            this.valMin = -128;
            this.valMax = 128;
            if (this.histmove) {
                this.valueX = this.histY;
                this.type = this.midlet.lng.getString(Language.TXT_ADJUST_HISTOGRAM);
            } else {
                this.valueX = this.histwhite;
                this.type = this.midlet.lng.getString(Language.TXT_ADJUST_RANGE_WHITE);
            }
        } else if (this.mode == 6) {
            this.valMin = -128;
            this.valMax = 128;
            if (this.histmove) {
                this.valueX = this.histY;
                this.type = this.midlet.lng.getString(Language.TXT_ADJUST_HISTOGRAM);
            } else {
                this.valueX = this.histblack;
                this.type = this.midlet.lng.getString(Language.TXT_ADJUST_RANGE_BLACK);
            }
        } else if (this.mode == 7) {
            this.valueX = this.rotate;
            this.valMin = 0;
            this.valMax = 360;
            this.type = this.midlet.lng.getString(Language.TXT_ADJUST_ROTATE);
        } else if (this.mode == 8) {
            this.type = this.midlet.lng.getString(Language.TXT_ADJUST_INVERS);
        }
    }

    public void keyPressed(int n) throws  {
        if (this.getGameAction(n) == 8) {
            this.select();
        } else if (this.getGameAction(n) == 1) {
            this.PRESS_UP = true;
        } else if (this.getGameAction(n) == 6) {
            this.PRESS_DOWN = true;
        } else if (this.getGameAction(n) == 2) {
            --this.mode;
            if (this.mode < 1) {
                this.mode = 8;
            }
            this.nextMode();
        } else if (this.getGameAction(n) == 5) {
            ++this.mode;
            if (this.mode > 8) {
                this.mode = 1;
            }
            this.nextMode();
        } else if (this.midlet.LEFT_SOFT_KEY(n)) {
            this.select();
        } else if (this.midlet.RIGHT_SOFT_KEY(n)) {
            this.midlet.closeAdjust();
            boolean bl = false;
        } else if (this.midlet.CLEAR_KEY(n)) {
            this.valueX = 0;
        } else if (this.midlet.BACK_KEY(n)) {
            this.midlet.closeAdjust();
            boolean bl = false;
        } else if (n == 49) {
            if (this.mode == 5 || this.mode == 6) {
                this.graph = !this.graph;
                this.nextMode();
            } else if (this.mode == 8) {
                this.red = !this.red;
                this.nextMode();
            }
        } else if (n == 51) {
            if ((this.mode == 5 || this.mode == 6) && this.graph) {
                this.histmove = !this.histmove;
                this.nextMode();
            } else if (this.mode == 8) {
                this.gray = !this.gray;
                this.nextMode();
            }
        } else if (n == 57 && this.mode == 8) {
            this.blue = !this.blue;
            this.nextMode();
        }
    }

    public void keyReleased(int n) throws  {
        if (this.getGameAction(n) == 1) {
            this.PRESS_UP = false;
        } else if (this.getGameAction(n) == 6) {
            this.PRESS_DOWN = false;
        }
    }

    synchronized void processKeyState() throws  {
        if (this.PRESS_UP) {
            ++this.valueX;
            if (this.valueX > this.valMax) {
                this.valueX = this.valMax;
            }
        }
        if (this.PRESS_DOWN) {
            --this.valueX;
            if (this.valueX < this.valMin) {
                this.valueX = this.valMin;
            }
        }
        if (this.mode == 1) {
            this.saturation = this.valueX;
        } else if (this.mode == 2) {
            this.contrast = this.valueX;
        } else if (this.mode == 3) {
            this.brightness = this.valueX;
        } else if (this.mode == 4) {
            this.alpha = this.valueX;
        } else if (this.mode == 5) {
            if (this.histmove) {
                this.histY = this.valueX;
            } else {
                this.histwhite = this.valueX;
            }
        } else if (this.mode == 6) {
            if (this.histmove) {
                this.histY = this.valueX;
            } else {
                this.histblack = this.valueX;
            }
        } else if (this.mode == 7) {
            this.rotate = this.valueX;
        }
    }

    public void select() throws  {
        if (this.mode == 5 || this.mode == 6) {
            this.midlet.setHistogram(this.histwhite, this.histblack);
        } else if (this.mode == 8) {
            this.midlet.invertChanels(this.red, this.gray, this.blue);
        } else if (this.mode == 7) {
            this.midlet.rotateImage(this.valueX);
        } else {
            this.midlet.setAdjust(this.valueX, this.mode);
        }
        boolean bl = false;
    }

    public void run() throws  {
        while (this.started) {
            this.repaint();
            this.processKeyState();
            try {
                Thread.sleep(50);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public Image resizeImage(Image image, int n, int n2) throws  {
        if (image == null) {
            return null;
        }
        int n3 = image.getHeight();
        int n4 = image.getWidth();
        int n5 = (n3 << 8) / n2;
        int[] nArray = new int[]{};
        try {
            int[] nArray2 = new int[n4 * n3];
            nArray = new int[n * n2];
            image.getRGB(nArray2, 0, n4, 0, 0, n4, n3);
            int n6 = 0;
            while (n6 < n2) {
                int n7 = this.scalelog(n6 * n5 >> 8, n3);
                int n8 = n6 * n5 - (n7 << 8);
                int n9 = 0;
                while (n9 < n) {
                    int n10 = this.scalelog(n9 * n5 >> 8, n4);
                    int n11 = n9 * n5 - (n10 << 8);
                    int n12 = this.scalelog(n10 + 1, n4 - 1);
                    int n13 = this.scalelog(n7 + 1, n3 - 1);
                    int n14 = nArray2[n4 * n7 + n10];
                    int n15 = nArray2[n4 * n7 + n12];
                    int n16 = nArray2[n4 * n13 + n10];
                    int n17 = nArray2[n4 * n13 + n12];
                    int n18 = n * n6 + n9;
                    nArray[n18] = 0;
                    int n19 = 0;
                    while (n19 <= 16) {
                        int n20 = n18;
                        nArray[n20] = nArray[n20] + ((PhotoAdjust.l(n14, n19) * (255 - n11) * (255 - n8) + PhotoAdjust.l(n15, n19) * n11 * (255 - n8) + PhotoAdjust.l(n16, n19) * (255 - n11) * n8 + PhotoAdjust.l(n17, n19) * n11 * n8) / 65025 << n19);
                        n19 += 8;
                    }
                    ++n9;
                }
                ++n6;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Image.createRGBImage((int[])nArray, (int)n, (int)n2, (boolean)false);
    }

    public int scalelog(int n, int n2) throws  {
        if (n > n2) {
            return n2;
        }
        return n;
    }

    static int l(int n, int n2) throws  {
        return n >> n2 & 0xFF;
    }

    public PhotoAdjust(PhotoEditorMIDlet photoEditorMIDlet, Image image) throws  {
        this.midlet = photoEditorMIDlet;
        this.setFullScreenMode(true);
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.type = photoEditorMIDlet.lng.getString(Language.TXT_ADJUST_SATURATION);
        this.image = image;
        if (this.image.getWidth() > this.width - 4 || this.image.getHeight() > this.height - this.font_small_bold_Height * 2) {
            if (this.image.getWidth() > this.image.getHeight()) {
                this.newW = this.width - 4;
                this.newH = this.image.getHeight() * this.newW / this.image.getWidth();
            } else {
                this.newH = this.height - this.font_small_bold_Height * 2;
                this.newW = this.image.getWidth() * this.newH / this.image.getHeight();
            }
            this.image = this.resizeImage(image, this.newW, this.newH);
        }
        this.show = this.image;
        this.prThread = new Thread(this);
        this.prThread.start();
        this.started = true;
    }
}

