/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public class PhotoEditorMIDlet
extends MIDlet
implements CommandListener,
Runnable {
    Language lng = new Language(this);
    PhotoCanvas canvas;
    PhotoAdjust adjust;
    Display display;
    Timer timer;
    PhotoRepaint task;
    Thread thread = null;
    boolean stopped = true;
    int SONYERICSSON = 0;
    int NOKIA = 1;
    int MOTOROLA = 2;
    int SAMSUNG = 3;
    int SIEMENS = 4;
    int PLATFORM = 0;
    String platform;
    String patch;
    int FONT_SIZE = 0;
    int FONT_STYLE = 0;
    Command command_back;
    Command command_cancel;
    Command command_add_text;
    Command command_save;
    Command command_default;
    Command command_getheap;
    Command command_clearheap;
    Form form_info;
    Form form_setting;
    Form form_text;
    Form form_heap;
    ChoiceGroup cg_fontsize;
    ChoiceGroup cg_fontstyle;
    Command command_web;
    TextField tb_new;
    TextField tb_icon;
    TextField tb_frame;
    TextField tb_save;
    TextField wordtext;
    String filec = "file:///";
    String frame = "Frames/";
    String icon = "Icons/";
    String patch_new = null;
    String patch_icon = null;
    String patch_frame = null;
    String patch_save = null;
    int firstmem;

    public void startApp() throws  {
        this.canvas = new PhotoCanvas(this);
        this.timer = new Timer();
        this.task = new PhotoRepaint(this.canvas);
        this.timer.scheduleAtFixedRate((TimerTask)this.task, 40, (long)40);
        this.display = Display.getDisplay((MIDlet)this);
        this.display.setCurrent((Displayable)this.canvas);
    }

    public void adjust(Image image) throws  {
        this.adjust = new PhotoAdjust(this, image);
        this.display.setCurrent((Displayable)this.adjust);
    }

    public void setAdjust(int n, int n2) throws  {
        this.canvas.setAdjust(n, n2);
        this.adjust = null;
        this.display.setCurrent((Displayable)this.canvas);
    }

    public void setHistogram(int n, int n2) throws  {
        this.canvas.setHistogram(n, n2);
        this.adjust = null;
        this.display.setCurrent((Displayable)this.canvas);
    }

    public void rotateImage(int n) throws  {
        this.canvas.rotateImage(n);
        this.adjust = null;
        this.display.setCurrent((Displayable)this.canvas);
    }

    public void invertChanels(boolean bl, boolean bl2, boolean bl3) throws  {
        this.canvas.invertChanels(bl, bl2, bl3);
        this.adjust = null;
        this.display.setCurrent((Displayable)this.canvas);
    }

    public void closeAdjust() throws  {
        this.adjust = null;
        this.display.setCurrent((Displayable)this.canvas);
    }

    public void commandAction(Command command, Displayable displayable) throws  {
        if (command == this.command_back) {
            this.display.setCurrent((Displayable)this.canvas);
        }
        if (command == this.command_cancel) {
            this.display.setCurrent((Displayable)this.canvas);
        }
        if (command == this.command_add_text) {
            switch (this.cg_fontsize.getSelectedIndex()) {
                case 0: {
                    this.FONT_SIZE = 8;
                    break;
                }
                case 1: {
                    this.FONT_SIZE = 0;
                    break;
                }
                case 2: {
                    this.FONT_SIZE = 16;
                    break;
                }
            }
            this.FONT_STYLE = 0;
            if (this.cg_fontstyle.isSelected(2)) {
                this.FONT_STYLE += 4;
            }
            if (this.cg_fontstyle.isSelected(1)) {
                this.FONT_STYLE += 2;
            }
            if (this.cg_fontstyle.isSelected(0)) {
                ++this.FONT_STYLE;
            }
            this.canvas.srcString(this.wordtext.getString());
            this.display.setCurrent((Displayable)this.canvas);
        }
        if (command == this.command_save) {
            this.getSetting();
            this.saveSetting();
            this.display.setCurrent((Displayable)this.canvas);
        }
        if (command == this.command_default) {
            this.defaultSetting();
            this.display.setCurrent((Displayable)this.canvas);
        }
        if (command == this.command_web) {
            try {
                this.platformRequest("http://www.supanitsky.narod.ru/");
            }
            catch (Exception exception) {
                System.out.println("Start browser:".concat(String.valueOf(exception.toString())));
            }
        }
        if (command == this.command_getheap) {
            PhotoEditorMIDlet.clearHeap$(this, true);
            this.refresh();
        }
        if (command == this.command_clearheap) {
            PhotoEditorMIDlet.clearHeap$(this, false);
            this.refresh();
        }
    }

    public void loading() throws  {
        this.command_back = new Command(this.lng.getString(Language.TXT_BACK), 2, 3);
        this.command_cancel = new Command(this.lng.getString(Language.TXT_CANCEL), 3, 2);
        this.command_add_text = new Command(this.lng.getString(Language.TXT_ADD_TEXT), 4, 1);
        this.command_save = new Command(this.lng.getString(Language.TXT_SAVE), 7, 1);
        this.command_default = new Command(this.lng.getString(Language.TXT_DEFAULT), 7, 3);
        this.command_web = new Command(this.lng.getString(Language.TXT_TO_SITE), 7, 2);
        this.command_getheap = new Command(this.lng.getString(Language.TXT_GET_HEAP), 7, 1);
        this.command_clearheap = new Command(this.lng.getString(Language.TXT_CLEAR_HEAP), 7, 2);
        this.tb_new = new TextField(this.lng.getString(Language.TXT_PIC_FOLDER), this.patch_new, 256, 0);
        this.tb_icon = new TextField(this.lng.getString(Language.TXT_ICON_FOLDER), this.patch_icon, 256, 0);
        this.tb_frame = new TextField(this.lng.getString(Language.TXT_FRAME_FOLDER), this.patch_frame, 256, 0);
        this.tb_save = new TextField(this.lng.getString(Language.TXT_SAVED_FOLDER), this.patch_save, 256, 0);
        this.form_setting = new Form(this.lng.getString(Language.TXT_TITLE_SETTINGS_FORM));
        this.form_setting.append(this.lng.getString(Language.TXT_SETTING_INFO));
        this.form_setting.append((Item)this.tb_new);
        this.form_setting.append((Item)this.tb_icon);
        this.form_setting.append((Item)this.tb_frame);
        this.form_setting.append((Item)this.tb_save);
        this.form_setting.addCommand(this.command_back);
        this.form_setting.addCommand(this.command_save);
        this.form_setting.addCommand(this.command_default);
        this.form_setting.setCommandListener((CommandListener)this);
        this.form_info = new Form(this.lng.getString(Language.TXT_TITLE_ABOUT_FORM));
        StringItem stringItem = new StringItem("Photo Snap Mobile\n", "j2me photo editor\nby\nEdward Supanitsky\n\nVersion".concat(String.valueOf(this.getAppProperty("MIDlet-Version"))).concat("\n\nsea.dik@gmail.com\nwww.supanitsky.narod.ru\n (c) 2009 Supanitsky"));
        stringItem.setLayout(3);
        this.form_info.append((Item)stringItem);
        this.form_info.addCommand(this.command_back);
        this.form_info.addCommand(this.command_web);
        this.form_info.setCommandListener((CommandListener)this);
        this.firstmem = (int)Runtime.getRuntime().totalMemory();
        this.form_heap = new Form(this.lng.getString(Language.TXT_TITLE_HEAP_CONTROL_FORM));
        this.form_heap.append((Item)new StringItem("\n".concat(String.valueOf(this.lng.getString(Language.TXT_HEAP_TOTAL))), Long.toString(Runtime.getRuntime().totalMemory())));
        this.form_heap.append((Item)new StringItem("\n".concat(String.valueOf(this.lng.getString(Language.TXT_HEAP_FREE))), Long.toString(Runtime.getRuntime().freeMemory())));
        this.form_heap.append((Item)new StringItem("\n".concat(String.valueOf(this.lng.getString(Language.TXT_HEAP_GETTING))), String.valueOf(Long.toString(Runtime.getRuntime().totalMemory() - (long)this.firstmem)).concat("\n")));
        this.form_heap.addCommand(this.command_getheap);
        this.form_heap.addCommand(this.command_clearheap);
        this.form_heap.addCommand(this.command_back);
        this.form_heap.setCommandListener((CommandListener)this);
        this.cg_fontsize = new ChoiceGroup(this.lng.getString(Language.TXT_FONT_SIZE), 1);
        this.cg_fontsize.append(this.lng.getString(Language.TXT_FONT_SMALL), null);
        this.cg_fontsize.append(this.lng.getString(Language.TXT_FONT_MEDIUM), null);
        this.cg_fontsize.append(this.lng.getString(Language.TXT_FONT_LARGE), null);
        this.cg_fontstyle = new ChoiceGroup(this.lng.getString(Language.TXT_FONT_STYLE), 2);
        this.cg_fontstyle.append(this.lng.getString(Language.TXT_FONT_BOLD), null);
        this.cg_fontstyle.append(this.lng.getString(Language.TXT_FONT_ITALIC), null);
        this.cg_fontstyle.append(this.lng.getString(Language.TXT_FONT_UNDERLINED), null);
        this.wordtext = new TextField("", "", 512, 0);
        this.form_text = new Form(this.lng.getString(Language.TXT_TITLE_TEXT_FORM));
        this.form_text.append(this.lng.getString(Language.TXT_ENTRY_TEXT));
        this.form_text.append((Item)this.wordtext);
        this.form_text.append((Item)this.cg_fontsize);
        this.form_text.append((Item)this.cg_fontstyle);
        this.form_text.addCommand(this.command_add_text);
        this.form_text.addCommand(this.command_cancel);
        this.form_text.setCommandListener((CommandListener)this);
    }

    public void init() throws  {
        this.platform = this.getProperty("microedition.platform");
        if (this.getProperty("com.sonyericsson.IMEI") != null || this.getProperty("com.sonyericsson.imei") != null) {
            this.PLATFORM = this.SONYERICSSON;
        } else if (this.forName("com.motorola.phonebook.PhoneBookRecord") || this.forName("com.motorola.Dialer") || this.forName("com.motorola.phone.Dialer") || this.forName("com.motorola.graphics.j3d.Light") || this.forName("com.motorola.lwt.ComponentScreen") || this.forName("com.motorola.game.GameScreen") || this.forName("com.motorola.funlight.FunLight") || this.forName("com.motorola.multimedia.Lighting") || this.forName("com.motorola.io.ConnectorEvent") || this.forName("com.motorola.extensions.ScalableJPGImage")) {
            this.PLATFORM = this.MOTOROLA;
        } else if (this.forName("com.siemens.mp.lcdui.Image")) {
            this.PLATFORM = this.SIEMENS;
        }
        if (this.getProperty("microedition.io.file.FileConnection.version") != null) {
            this.patch = this.inpatch(System.getProperty("fileconn.dir.graphics"));
        } else if (this.PLATFORM == this.SIEMENS) {
            this.patch = System.getProperty("com.systemfolder.pictures");
        } else if (this.patch == null) {
            this.patch = "/";
        }
        if (this.patch != null) {
            if (this.patch_new == null) {
                this.patch_new = this.patch;
            }
            this.patch_icon = this.patch_icon == null && this.patch.length() > 1 ? String.valueOf(this.patch).concat(String.valueOf(this.icon)) : this.patch;
            this.patch_frame = this.patch_frame == null && this.patch.length() > 1 ? String.valueOf(this.patch).concat(String.valueOf(this.frame)) : this.patch;
            if (this.patch_save == null) {
                this.patch_save = this.patch;
            }
        }
        this.loadSetting();
        this.loading();
    }

    public boolean LEFT_SOFT_KEY(int n) throws  {
        return n == -6 || n == -21 || n == 21 || n == 105 || n == -202 || n == 113 || n == 57345 || n == -1 && this.PLATFORM == this.SIEMENS;
    }

    public boolean RIGHT_SOFT_KEY(int n) throws  {
        return n == -7 || n == -22 || n == 22 || n == 106 || n == -203 || n == 112 || n == 57346 || n == -4 && this.PLATFORM == this.SIEMENS;
    }

    public boolean CLEAR_KEY(int n) throws  {
        return n == -8 || n == -11 && this.PLATFORM == this.SIEMENS || n == 8 && this.platform.indexOf("nokiae61") != -1 || n == -16 || n == -19 || n == -204;
    }

    public boolean BACK_KEY(int n) throws  {
        return n == -11 && this.PLATFORM == this.SONYERICSSON || n == -12 && this.PLATFORM == this.SIEMENS;
    }

    public void getSetting() throws  {
        this.patch_new = this.tb_new.getString();
        this.patch_icon = this.tb_icon.getString();
        this.patch_frame = this.tb_frame.getString();
        this.patch_save = this.tb_save.getString();
        if (this.patch_new.length() < 1) {
            this.patch_new = "/";
        }
        if (this.patch_icon.length() < 1) {
            this.patch_icon = "/";
        }
        if (this.patch_frame.length() < 1) {
            this.patch_frame = "/";
        }
        if (this.patch_save.length() < 1) {
            this.patch_save = "/";
        }
    }

    public void defaultSetting() throws  {
        try {
            RecordStore.deleteRecordStore((String)"settings");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getProperty(String string) throws  {
        return System.getProperty(string);
    }

    public boolean forName(String string) throws  {
        boolean bl = false;
        try {
            Class.forName(string);
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public String inpatch(String string) throws  {
        if (!string.startsWith("file:")) {
            return string;
        }
        String string2 = "";
        int n = this.filec.length();
        while (n < string.length()) {
            char c = string.charAt(n);
            string2 = String.valueOf(string2).concat(String.valueOf(String.valueOf(c)));
            ++n;
        }
        if (string2.length() > 0) {
            return string2;
        }
        return "/";
    }

    static void clearHeap$(PhotoEditorMIDlet photoEditorMIDlet, boolean bl) throws  {
        if (bl) {
            boolean bl2;
            int n = 0;
            int[] nArray = null;
            do {
                bl2 = false;
                n += 10240;
                try {
                    nArray = new int[n];
                    bl2 = true;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    // empty catch block
                }
            } while (bl2);
            nArray = null;
        }
        System.gc();
        Runtime.getRuntime().gc();
        photoEditorMIDlet.form_heap.set(0, (Item)new StringItem("\n".concat(String.valueOf(photoEditorMIDlet.lng.getString(Language.TXT_HEAP_TOTAL))), Long.toString(Runtime.getRuntime().totalMemory())));
        photoEditorMIDlet.form_heap.set(1, (Item)new StringItem("\n".concat(String.valueOf(photoEditorMIDlet.lng.getString(Language.TXT_HEAP_FREE))), Long.toString(Runtime.getRuntime().freeMemory())));
        photoEditorMIDlet.form_heap.set(2, (Item)new StringItem("\n".concat(String.valueOf(photoEditorMIDlet.lng.getString(Language.TXT_HEAP_GETTING))), String.valueOf(Long.toString(Runtime.getRuntime().totalMemory() - (long)photoEditorMIDlet.firstmem)).concat("\n")));
    }

    public void refresh() throws  {
        this.form_heap.set(0, (Item)new StringItem("\n".concat(String.valueOf(this.lng.getString(Language.TXT_HEAP_TOTAL))), Long.toString(Runtime.getRuntime().totalMemory())));
        this.form_heap.set(1, (Item)new StringItem("\n".concat(String.valueOf(this.lng.getString(Language.TXT_HEAP_FREE))), Long.toString(Runtime.getRuntime().freeMemory())));
        this.form_heap.set(2, (Item)new StringItem("\n".concat(String.valueOf(this.lng.getString(Language.TXT_HEAP_GETTING))), String.valueOf(Long.toString(Runtime.getRuntime().totalMemory() - (long)this.firstmem)).concat("\n")));
    }

    void starttread() throws  {
        if (this.stopped) {
            this.thread = new Thread(this);
            this.stopped = false;
            this.thread.start();
        }
    }

    public void run() throws  {
        while (!this.stopped) {
            PhotoEditorMIDlet.clearHeap$(this, false);
            if (this.display == this.form_heap) {
                this.refresh();
            }
            try {
                Thread.sleep(5000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void saveSetting() throws  {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"settings", (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeUTF(this.patch_new);
            dataOutputStream.writeUTF(this.patch_icon);
            dataOutputStream.writeUTF(this.patch_frame);
            dataOutputStream.writeUTF(this.patch_save);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream.close();
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void loadSetting() throws  {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"settings", (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                recordStore.closeRecordStore();
                this.saveSetting();
            } else {
                byte[] byArray = recordStore.getRecord(1);
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                this.patch_new = dataInputStream.readUTF();
                this.patch_icon = dataInputStream.readUTF();
                this.patch_frame = dataInputStream.readUTF();
                this.patch_save = dataInputStream.readUTF();
                dataInputStream.close();
                recordStore.closeRecordStore();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void pauseApp() throws  {
    }

    public void destroyApp(boolean bl) throws  {
        this.notifyDestroyed();
    }

    public PhotoEditorMIDlet() throws  {
        this.lng.loadTexts();
        this.init();
        this.starttread();
    }
}

