/*
 * Decompiled with CFR 0.152.
 */
package com.gowtham.jmp3tag;

import com.gowtham.jmp3tag.APICTag;
import com.gowtham.jmp3tag.FileBrowser;
import com.gowtham.jmp3tag.FileBrowserEvent;
import com.gowtham.jmp3tag.Frame;
import com.gowtham.jmp3tag.Logger;
import com.gowtham.jmp3tag.Preferences;
import com.gowtham.jmp3tag.SettingsEvent;
import com.gowtham.jmp3tag.SettingsForm;
import com.gowtham.jmp3tag.Tag;
import java.io.IOException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.lcdui.Ticker;
import javax.microedition.midlet.MIDlet;

public class Mp3Tag
extends MIDlet
implements CommandListener,
FileBrowserEvent,
Runnable,
SettingsEvent {
    private Gauge gauge;
    private Form progressForm;
    private Form tagEditor;
    private Command cmdBrowseFile;
    private Command cmdSaveTags;
    private Command cmdExit;
    private Command cmdAbout;
    private TextField textFieldPath;
    private TextField textFieldTitle;
    private TextField textFieldAlbum;
    private TextField textFieldArtist;
    private TextField textFieldYear;
    private TextField textFieldComposer;
    private Command cmdHelp;
    private Command cmdCancel;
    private Ticker ticker;
    private Tag tag;
    private FileBrowser fileBrowser;
    private FileBrowser imageBrowser;
    private Command replaceArtCommand;
    private Form imageForm = null;
    private Command showImageCmd = null;
    private Command backFromImageFormCmd = null;
    private Logger logger = new Logger("\u041b\u043e\u0433", this);
    private Command showLogCommand;
    private SettingsForm settingsForm;
    private Preferences pref;
    private Command configureSettingsCmd = null;
    private Command deleteArtCmd = null;

    public Mp3Tag() {
        this.initialize();
        this.ticker = new Ticker("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 MP3 \u0444\u0430\u0439\u043b");
        this.tagEditor.setTicker(this.ticker);
        if (this.progressForm == null) {
            this.progressForm = new Form("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435...");
        }
        if (this.gauge == null) {
            this.gauge = new Gauge("\u041f\u0440\u043e\u0446\u0435\u0441\u0441", false, 100, 0);
            this.gauge.setLabel("\u041f\u0440\u043e\u0446\u0435\u0441\u0441");
        }
        this.progressForm.append((Item)this.gauge);
        this.showLogCommand = new Command("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u043b\u043e\u0433", 1, 10);
        if (this.fileBrowser == null) {
            this.fileBrowser = new FileBrowser("MP3", this, "/", new String[]{"mp3"}, false, this);
        }
        if (this.imageBrowser == null) {
            this.imageBrowser = new FileBrowser("\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435", this, "/", new String[]{"jpg", "png", "bmp", "gif"}, false, this);
        }
        if (this.imageForm == null) {
            this.imageForm = new Form("Album Art");
        }
        this.replaceArtCommand = new Command("\u0417\u0430\u043c\u0435\u043d\u0438\u0442\u044c", 1, 0);
        this.imageForm.addCommand(this.replaceArtCommand);
        this.showImageCmd = new Command("\u0418\u0437\u043e\u0431\u0440...", "\u0418\u0437\u043e\u0431\u0440...", 1, 100);
        this.backFromImageFormCmd = new Command("\u041d\u0430\u0437\u0430\u0434", "\u041d\u0430\u0437\u0430\u0434", 1, 0);
        this.deleteArtCmd = new Command("\u0423\u0434\u0430\u043b\u0438\u0442\u044c", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435", 1, 1);
        this.imageForm.addCommand(this.backFromImageFormCmd);
        this.imageForm.setCommandListener((CommandListener)this);
        this.tagEditor.addCommand(this.showImageCmd);
        this.tagEditor.addCommand(this.showLogCommand);
        this.settingsForm = new SettingsForm(this);
        this.settingsForm.setListener(this);
        this.printf("\u041f\u0440\u0435\u0434\u043f\u043e\u0447\u0442\u0435\u043d\u0438\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438");
        try {
            String string;
            String string2;
            this.pref = new Preferences("settings");
            String string3 = this.pref.get("overwrite");
            this.printf("\u0420\u0435\u0436\u0438\u043c \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0438\u0441\u0438 : " + string3);
            if (string3 != null) {
                this.settingsForm.setOvewrite(string3);
            }
            if ((string2 = this.pref.get("sort")) != null) {
                this.printf("\u0420\u0435\u0436\u0438\u043c \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438: " + string2);
                this.settingsForm.setSort(string2);
            }
            if ((string = this.pref.get("showticker")) != null) {
                this.printf("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0442\u0438\u043a\u0435\u0440: " + string);
                this.settingsForm.setShowTicker(string);
                if (string.equalsIgnoreCase("\u041d\u0435\u0442")) {
                    this.tagEditor.setTicker(null);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.configureSettingsCmd = new Command("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438...", "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438...", 1, 10);
        this.tagEditor.addCommand(this.configureSettingsCmd);
        this.setupImages();
    }

    public void populateTextBoxes(Tag tag) {
        try {
            this.textFieldAlbum.setString(tag.getAlbum());
            this.textFieldArtist.setString(tag.getArtist());
            this.textFieldTitle.setString(tag.getTitile());
            this.textFieldYear.setString(tag.getYear());
            this.textFieldComposer.setString(tag.getComposer());
        }
        catch (Exception exception) {
            this.ticker.setString(exception.toString());
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.tagEditor) {
            if (command == this.cmdBrowseFile) {
                this.fileBrowser.show(this.getDisplay().getCurrent());
            } else if (command == this.cmdExit) {
                this.exitMIDlet();
            } else if (command == this.cmdAbout) {
                this.info("JMp3Tag v0.8 by Gowtham, built on 3 May 2011\n\nEmail: gowthamgowtham@gmail.com", "\u041e \u043f\u0440\u043e\u0433\u0435");
            } else if (command == this.cmdSaveTags) {
                new Thread(new Runnable(){

                    public void run() {
                        Mp3Tag.this.handleSave();
                    }
                }).start();
            } else if (command == this.cmdHelp) {
                this.info("\u042d\u0442\u0430 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430 \u043f\u043e\u0437\u0432\u043e\u043b\u044f\u0435\u0442 \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c\u0442\u0435\u0433\u0438 \u0432 MP3-\u0444\u0430\u0439\u043b\u044b.\u0422\u0432\u043e\u0439 \u0442\u0435\u043b\u0435\u0444\u043e\u043d \u0434\u043e\u043b\u0436\u0435\u043d \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0442\u044c JSR-75 API. \u0414\u043b\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0442\u0435\u0433\u043e\u0432 \u0432\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0440\u0430\u0437\u0440\u0435\u0448\u0438\u0442\u044c \u0427\u0442\u0435\u043d\u0438\u0435/\u0417\u0430\u043f\u0438\u0441\u044c \u0434\u0430\u043d\u043d\u044b\u0445.", "\u041f\u043e\u043c\u043e\u0449\u044c");
            } else if (command == this.showImageCmd) {
                this.loadImage();
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.imageForm);
            } else if (command == this.configureSettingsCmd) {
                this.settingsForm.show();
            } else if (command == this.showLogCommand) {
                this.logger.show((Displayable)this.tagEditor);
            }
        } else if (displayable == this.imageForm) {
            if (command == this.backFromImageFormCmd) {
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.tagEditor);
            } else if (command == this.deleteArtCmd) {
                this.tag.deleteAPICFrame();
                this.ticker.setString("\u041d\u0435 \u0437\u0430\u0431\u0443\u0434\u044c\u0442\u0435 \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c,\u0447\u0442\u043e\u0431\u044b \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u0442\u0430\u0440\u044b\u0435 \u0442\u0435\u0433\u0438");
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.tagEditor);
            } else if (command == this.replaceArtCommand) {
                this.logger.log("\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0439");
                this.imageBrowser.show((Displayable)this.imageForm);
            }
        }
    }

    private void initialize() {
        this.getDisplay().setCurrent((Displayable)this.get_tagEditor());
    }

    public Display getDisplay() {
        return Display.getDisplay((MIDlet)this);
    }

    public void exitMIDlet() {
        this.getDisplay().setCurrent(null);
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public Form get_tagEditor() {
        if (this.tagEditor == null) {
            this.tagEditor = new Form("JMp3Tag", new Item[]{this.get_textFieldPath(), this.get_textFieldTitle(), this.get_textFieldAlbum(), this.get_textFieldArtist(), this.get_textFieldYear(), this.get_textFieldComposer()});
            this.tagEditor.addCommand(this.get_cmdBrowseFile());
            this.tagEditor.addCommand(this.get_cmdSaveTags());
            this.tagEditor.addCommand(this.get_cmdExit());
            this.tagEditor.addCommand(this.get_cmdAbout());
            this.tagEditor.addCommand(this.get_cmdHelp());
            this.tagEditor.setCommandListener((CommandListener)this);
        }
        return this.tagEditor;
    }

    public Command get_cmdBrowseFile() {
        if (this.cmdBrowseFile == null) {
            this.cmdBrowseFile = new Command("\u041e\u0431\u0437\u043e\u0440", 1, 1);
        }
        return this.cmdBrowseFile;
    }

    public Command get_cmdSaveTags() {
        if (this.cmdSaveTags == null) {
            this.cmdSaveTags = new Command("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c", 1, 1);
        }
        return this.cmdSaveTags;
    }

    public Command get_cmdExit() {
        if (this.cmdExit == null) {
            this.cmdExit = new Command("\u0412\u044b\u0445\u043e\u0434", 7, 1);
        }
        return this.cmdExit;
    }

    public Command get_cmdAbout() {
        if (this.cmdAbout == null) {
            this.cmdAbout = new Command("\u041e \u043f\u0440\u043e\u0433\u0435", 1, 1);
        }
        return this.cmdAbout;
    }

    public TextField get_textFieldPath() {
        if (this.textFieldPath == null) {
            this.textFieldPath = new TextField("MP3 \u0444\u0430\u0439\u043b", "", 1000, 131072);
        }
        return this.textFieldPath;
    }

    public TextField get_textFieldTitle() {
        if (this.textFieldTitle == null) {
            this.textFieldTitle = new TextField("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", null, 120, 0);
        }
        return this.textFieldTitle;
    }

    public TextField get_textFieldAlbum() {
        if (this.textFieldAlbum == null) {
            this.textFieldAlbum = new TextField("\u0410\u043b\u044c\u0431\u043e\u043c", null, 120, 0);
        }
        return this.textFieldAlbum;
    }

    public TextField get_textFieldArtist() {
        if (this.textFieldArtist == null) {
            this.textFieldArtist = new TextField("\u0410\u0440\u0442\u0438\u0441\u0442", null, 120, 0);
        }
        return this.textFieldArtist;
    }

    public TextField get_textFieldYear() {
        if (this.textFieldYear == null) {
            this.textFieldYear = new TextField("\u0413\u043e\u0434", null, 120, 0);
        }
        return this.textFieldYear;
    }

    public TextField get_textFieldComposer() {
        if (this.textFieldComposer == null) {
            this.textFieldComposer = new TextField("\u041a\u043e\u043c\u043f\u043e\u0437\u0438\u0442\u043e\u0440", null, 120, 0);
        }
        return this.textFieldComposer;
    }

    public Command get_cmdHelp() {
        if (this.cmdHelp == null) {
            this.cmdHelp = new Command("\u041f\u043e\u043c\u043e\u0449\u044c", 1, 1);
        }
        return this.cmdHelp;
    }

    public Command get_cmdCancel() {
        if (this.cmdCancel == null) {
            this.cmdCancel = new Command("\u0417\u0430\u043a\u0440\u044b\u0442\u044c", 1, 1);
        }
        return this.cmdCancel;
    }

    public void startApp() {
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
        this.saveSettings();
    }

    public void run() {
    }

    public void handleSave() {
        if (this.tag != null) {
            try {
                this.gauge.setValue(0);
                this.getDisplay().setCurrent((Displayable)this.progressForm);
                this.tag.setAlbum(this.textFieldAlbum.getString());
                this.tag.setArtist(this.textFieldArtist.getString());
                this.tag.setTitile(this.textFieldTitle.getString());
                this.tag.setYear(this.textFieldYear.getString());
                this.tag.setComposer(this.textFieldComposer.getString());
                this.ticker.setString("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435... \u0416\u0434\u0438\u0442\u0435");
                this.tag.\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c(this.gauge, this.settingsForm.canOverwrite());
                this.ticker.setString("\u0422\u0435\u0433\u0438 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u044b");
                this.getDisplay().setCurrent((Displayable)this.tagEditor);
            }
            catch (Exception exception) {
                this.ticker.setString(exception.toString());
                this.getDisplay().setCurrent((Displayable)this.tagEditor);
            }
        } else {
            this.ticker.setString("MP3 \u0444\u0430\u0439\u043b \u043d\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d!");
        }
    }

    public void info(String string, String string2) {
        Alert alert = new Alert(string2);
        alert.setType(AlertType.INFO);
        alert.setString(string);
        alert.setTimeout(-2);
        this.getDisplay().setCurrent((Displayable)alert);
    }

    public void debug(String string) {
        Alert alert = new Alert("DEBUG");
        alert.setType(AlertType.INFO);
        alert.setString(string);
        alert.setTimeout(-2);
        this.getDisplay().setCurrent((Displayable)alert);
    }

    public void error(String string) {
        Alert alert = new Alert("ERROR");
        alert.setType(AlertType.ERROR);
        alert.setString(string);
        alert.setTimeout(3000);
        this.getDisplay().setCurrent((Displayable)alert);
    }

    public void handleRead() {
        this.tag = new Tag(this.textFieldPath.getString());
        try {
            this.tag.Read();
            if (this.tag.tagExists()) {
                this.ticker.setString("\u0422\u0435\u0433\u0438 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u044b");
            } else {
                this.ticker.setString("\u0422\u0435\u0433\u043e\u0432 \u043d\u0435\u0442");
            }
        }
        catch (Exception exception) {
            this.ticker.setString(exception.toString());
        }
        this.populateTextBoxes(this.tag);
    }

    public void someThingSelected(FileBrowser fileBrowser, String string) {
        if (fileBrowser == this.fileBrowser) {
            this.textFieldPath.setString(string);
            this.handleRead();
        }
        if (fileBrowser == this.imageBrowser) {
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.imageForm);
            this.replaceAlbumArt(string);
        }
    }

    private void loadImage() {
        this.imageForm.deleteAll();
        this.imageForm.removeCommand(this.deleteArtCmd);
        StringItem stringItem = new StringItem("\u041e\u0448\u0438\u0431\u043a\u0430: ", "");
        StringItem stringItem2 = new StringItem("\u0422\u0438\u043f \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f: ", "");
        StringItem stringItem3 = new StringItem("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435: ", "");
        if (this.tag == null) {
            this.imageForm.append((Item)stringItem);
            stringItem.setText("\u041d\u0435\u0442 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043d\u044b\u0445 MP3 \u0444\u0430\u0439\u043b\u043e\u0432");
            return;
        }
        if (!this.tag.tagExists()) {
            this.imageForm.append((Item)stringItem);
            stringItem.setText("\u041d\u0435\u0442 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043d\u044b\u0445 \u0442\u0435\u0433\u043e\u0432");
            return;
        }
        byte[] byArray = this.tag.getFrame("APIC");
        if (byArray == null) {
            this.imageForm.append((Item)stringItem);
            stringItem.setText("\u041d\u0435\u0442 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043d\u044b\u0445 \u0430\u043b\u044c\u0431\u043e\u043c\u043d\u044b\u0445 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0439 ");
            return;
        }
        this.printf("\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
        this.printf("\u0420\u0430\u0437\u043c\u0435\u0440 : " + byArray.length);
        APICTag aPICTag = new APICTag(byArray);
        this.printf(aPICTag.getMimeType());
        this.printf(aPICTag.getDescription());
        stringItem2.setText(aPICTag.getMimeType());
        stringItem3.setText(aPICTag.getDescription());
        int n = aPICTag.getImageStartIndex();
        this.printf("Image length = " + aPICTag.getImageLength());
        this.printf("\u0411\u0430\u0439\u0442: " + Integer.toHexString(byArray[n] & 0xFF) + Integer.toHexString(byArray[n + 1] & 0xFF));
        Image image = Image.createImage((byte[])byArray, (int)n, (int)aPICTag.getImageLength());
        this.imageForm.append((Item)stringItem2);
        this.imageForm.append((Item)stringItem3);
        this.imageForm.append(image);
        this.imageForm.addCommand(this.deleteArtCmd);
    }

    private void printf(String string) {
        System.out.println(string);
    }

    public void settingsSaved() {
        String string = this.settingsForm.canOverwriteString();
        this.printf("\u0420\u0435\u0436\u0438\u043c \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0438\u0441\u0438: " + string);
        if (string != null) {
            this.pref.put("overwrite", string);
        }
        String string2 = this.settingsForm.canSortString();
        this.printf("\u0420\u0435\u0436\u0438\u043c \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438: " + string2);
        if (string2 != null) {
            this.pref.put("sort", string2);
            this.fileBrowser.setSort(this.settingsForm.canSort());
        }
        String string3 = this.settingsForm.canShowTickerString();
        this.printf("\u0422\u0438\u043a\u0435\u0440: " + string3);
        if (string3 != null) {
            this.pref.put("showticker", string3);
        }
        if (this.settingsForm.canShowTicker()) {
            this.tagEditor.setTicker(this.ticker);
        } else {
            this.tagEditor.setTicker(null);
        }
    }

    private void saveSettings() {
        try {
            this.pref.save();
            this.printf("\u0421\u043e\u0445\u0440 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e");
        }
        catch (Exception exception) {
            this.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0445\u0440 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a: " + exception.toString());
        }
    }

    private void replaceAlbumArt(String string) {
        this.tag.deleteAPICFrame();
        try {
            APICTag aPICTag = new APICTag(string);
            aPICTag.setLogger(this.logger);
            byte[] byArray = aPICTag.toByteArray();
            Frame frame = new Frame("APIC", new byte[]{0, 0}, null, byArray, false);
            this.tag.addTag(frame);
            int n = aPICTag.getImageOffset();
            Image image = Image.createImage((byte[])byArray, (int)n, (int)(byArray.length - n));
            this.imageForm.deleteAll();
            StringItem stringItem = new StringItem("\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435:", string);
            this.imageForm.append((Item)stringItem);
            this.imageForm.append(image);
            this.ticker.setString("\u041d\u0435 \u0437\u0430\u0431\u0443\u0434\u044c\u0442\u0435 \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f");
        }
        catch (IOException iOException) {
            this.logger.log(iOException.toString());
        }
    }

    private void setupImages() {
        try {
            Image image = Image.createImage((String)"folder.png");
            Image image2 = Image.createImage((String)"music.png");
            Image image3 = Image.createImage((String)"up.png");
            Image image4 = Image.createImage((String)"image.png");
            this.fileBrowser.setFileImage(image2);
            this.fileBrowser.setUpImage(image3);
            this.fileBrowser.setFolderImage(image);
            this.imageBrowser.setFileImage(image4);
            this.imageBrowser.setUpImage(image3);
            this.imageBrowser.setFolderImage(image);
        }
        catch (Exception exception) {
            this.logger.log(exception.toString());
        }
    }
}

