/*
 * Decompiled with CFR 0.152.
 */
package com.gowtham.jmp3tag;

import com.gowtham.jmp3tag.Logger;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class APICTag {
    private byte[] bytes;
    private int offset;
    private String mimeType;
    private String description;
    private int pictureType;
    private int textEncoding;
    private int imageStartIndex;
    private int imageLength;
    private String path;
    private Logger logger;

    public APICTag(String string) {
        this.path = string;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public byte[] toByteArray() throws IOException {
        FileConnection fileConnection = (FileConnection)Connector.open((String)this.path, (int)1);
        if (!fileConnection.exists()) {
            throw new IOException("\u0424\u0430\u0439\u043b " + this.path + "  \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!");
        }
        InputStream inputStream = fileConnection.openInputStream();
        char[] cArray = this.getMimeTypeForImage().toCharArray();
        byte[] byArray = new byte[1 + (cArray.length + 1) + 1 + 1 + (int)fileConnection.fileSize()];
        int n = 0;
        byArray[n++] = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            byArray[n] = (byte)cArray[n2];
            ++n2;
            ++n;
        }
        byArray[n++] = 0;
        byArray[n++] = 3;
        byArray[n++] = 0;
        this.offset = n;
        n2 = -1;
        while ((n2 = inputStream.read()) != -1) {
            byArray[n++] = (byte)n2;
        }
        inputStream.close();
        fileConnection.close();
        return byArray;
    }

    public int getImageOffset() {
        return this.offset;
    }

    public APICTag(byte[] byArray) {
        int n = 0;
        this.textEncoding = byArray[n];
        int n2 = 0;
        int n3 = ++n;
        while (byArray[n3] != 0) {
            ++n2;
            ++n3;
        }
        this.mimeType = new String(byArray, n, n2);
        this.pictureType = byArray[n += n2 + 1];
        int n4 = 0;
        n3 = ++n;
        while (byArray[n3] != 0) {
            ++n4;
            ++n3;
        }
        this.description = new String(byArray, n, n4);
        this.imageStartIndex = n += n4 + 1;
        this.imageLength = byArray.length - this.imageStartIndex;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getDescription() {
        return this.description;
    }

    public int getImageStartIndex() {
        return this.imageStartIndex;
    }

    public int getImageLength() {
        return this.imageLength;
    }

    private String getMimeTypeForImage() {
        int n = this.path.lastIndexOf(46);
        String string = this.path.substring(n + 1);
        if (string.equalsIgnoreCase("jpg") || string.equalsIgnoreCase("jpeg")) {
            return "image/jpeg";
        }
        if (string.equalsIgnoreCase("png")) {
            return "image/png";
        }
        if (string.equalsIgnoreCase("bmp")) {
            return "image/bmp";
        }
        if (string.equalsIgnoreCase("gif")) {
            return "image/gif";
        }
        return "";
    }
}

