/*
 * Decompiled with CFR 0.152.
 */
package mwnw.sg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import mwnw.sg.Globals;

public class SoundPlayer {
    public static int THEME = 0;
    public static int THEME2 = 1;
    public static int PFIRE = 0;
    public static int PDEAD = 1;
    public static int GOPEN = 2;
    static int NUM_OF_MID = 2;
    static int NUM_OF_EFF = 3;
    public static Player[] midi = null;
    public static Player[] effect = null;
    public static boolean valid = false;
    public static String[] MIDI_NAME = new String[]{"/stargate.mid", "/theme.mid"};
    public static String[] EFF_NAME = new String[]{"/pfire.amr", "/play-d.amr", "/gateopen.amr"};
    public static int CURRENT_SOUND_TYPE = 0;
    public static int CURRENT_SOUND_INDEX = -1;
    public static int vibStarted = 0;

    public static void loadSounds() {
        ByteArrayInputStream byteArrayInputStream;
        int n;
        midi = new Player[NUM_OF_MID];
        try {
            for (n = 0; n < midi.length; ++n) {
                byteArrayInputStream = new ByteArrayInputStream(SoundPlayer.readResource(MIDI_NAME[n]));
                SoundPlayer.midi[n] = Manager.createPlayer((InputStream)byteArrayInputStream, (String)"audio/midi");
            }
        }
        catch (Exception exception) {
            System.out.println("midi loading fail!");
        }
        effect = new Player[NUM_OF_EFF];
        try {
            for (n = 0; n < effect.length; ++n) {
                byteArrayInputStream = new ByteArrayInputStream(SoundPlayer.readResource(EFF_NAME[n]));
                SoundPlayer.effect[n] = Manager.createPlayer((InputStream)byteArrayInputStream, (String)"audio/amr");
            }
        }
        catch (Exception exception) {
            System.out.println("fail load");
            exception.printStackTrace();
        }
    }

    public static byte[] readResource(String string) {
        byte[] byArray = null;
        InputStream inputStream = Thread.currentThread().getClass().getResourceAsStream(string);
        if (inputStream != null) {
            try {
                int n;
                byte[] byArray2 = new byte[1024];
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while ((n = inputStream.read(byArray2)) > 0) {
                    byteArrayOutputStream.write(byArray2, 0, n);
                }
                byArray = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("fail readResource");
                iOException.printStackTrace();
            }
        }
        return byArray;
    }

    public static void stopPlayer() {
        if (CURRENT_SOUND_INDEX != -1) {
            if (CURRENT_SOUND_TYPE == 0) {
                try {
                    midi[CURRENT_SOUND_INDEX].stop();
                    midi[CURRENT_SOUND_INDEX].deallocate();
                }
                catch (MediaException mediaException) {}
            } else {
                try {
                    effect[CURRENT_SOUND_INDEX].stop();
                    effect[CURRENT_SOUND_INDEX].deallocate();
                }
                catch (MediaException mediaException) {
                    // empty catch block
                }
            }
            CURRENT_SOUND_INDEX = -1;
        }
    }

    public static void playMidi(int n) {
        if (!Globals.vibrateActive) {
            return;
        }
        if (CURRENT_SOUND_TYPE == 0 && n == CURRENT_SOUND_INDEX) {
            try {
                midi[n].stop();
                midi[n].setLoopCount(-1);
                midi[n].start();
            }
            catch (MediaException mediaException) {
                SoundPlayer.stopPlayer();
            }
        } else {
            SoundPlayer.stopPlayer();
            try {
                midi[n].prefetch();
                midi[n].setLoopCount(-1);
                midi[n].start();
                CURRENT_SOUND_TYPE = 0;
                CURRENT_SOUND_INDEX = n;
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
    }

    public static void playEffect(int n) {
        if (!Globals.vibrateActive) {
            return;
        }
        if (CURRENT_SOUND_TYPE == 1 && n == CURRENT_SOUND_INDEX) {
            if (effect[n].getState() != 400) {
                try {
                    effect[n].start();
                }
                catch (MediaException mediaException) {
                    SoundPlayer.stopPlayer();
                }
            }
        } else {
            SoundPlayer.stopPlayer();
            try {
                effect[n].prefetch();
                effect[n].setLoopCount(1);
                effect[n].setMediaTime(0L);
                effect[n].start();
                CURRENT_SOUND_TYPE = 1;
                CURRENT_SOUND_INDEX = n;
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
    }
}

