/*
 * Decompiled with CFR 0.152.
 */
package mwnw.sg;

import javax.microedition.lcdui.Graphics;
import mwnw.sg.Globals;
import mwnw.sg.Graphic;
import mwnw.sg.Point;
import mwnw.sg.Projectile;
import mwnw.sg.SoundPlayer;

class ProjectileMgr {
    public static final byte MAX_PROJECTILES = 17;
    public static final byte MAX_BULLETS = 5;
    public static final byte MAX_POWERUPS = 5;
    public static final short EXPLOSION_ANIM_TIMER = 110;
    public static final byte PROJECTILE_HEALTH = 0;
    public static final byte PROJECTILE_KEYCARD = 1;
    public static final byte PROJECTILE_BULLET = 2;
    public static final byte MAX_PROJECTILE_GFX = 3;
    public static final byte PROJECTILE_STARGATE = 15;
    public static final byte PROJECTILE_SCENERY = 16;
    public static final byte PROJECTILE_SPECIAL_NORMAL = 0;
    public static final byte PROJECTILE_SPECIAL_GUY = 1;
    public static final byte STATE_DELETED = 0;
    public static final byte STATE_NORMAL = 1;
    public static final byte STATE_EXPLODE = 2;
    public static final byte STATE_STILL = 3;
    Graphic[] graphics = new Graphic[3];
    Projectile[] projectiles = new Projectile[17];
    byte curBulletsActive = 0;
    byte powerupsActive = 0;
    long animTimer = 0L;

    ProjectileMgr() {
    }

    public boolean Init() {
        this.Reset();
        for (int i = 0; i < 3; ++i) {
            this.graphics[i] = new Graphic();
            this.graphics[i].Load("/misc/" + i + ".png");
        }
        this.graphics[2].SetFrameInfo((byte)4, (byte)1);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void Update() {
        short s = (short)(Globals.deltaMs / 4L);
        short s2 = (short)(Globals.deltaMs / 8L);
        block19: for (int i = 0; i < 17; ++i) {
            block35: {
                block36: {
                    if (this.projectiles[i] == null) continue;
                    if (this.projectiles[i].state != 1) break block35;
                    if (this.projectiles[i].shooterId != 0) break block36;
                    short s3 = Globals.enemyMgr.CheckCollision(this.projectiles[i].x, this.projectiles[i].y, (short)16);
                    if (s3 != -1) {
                        this.projectiles[i].state = (byte)2;
                        Globals.enemyMgr.AddDamageToEnemy(s3, this.GetDamage(this.projectiles[i].type));
                        break block35;
                    } else if (!Globals.curMap.ValidPosition(this.projectiles[i].x, this.projectiles[i].y)) {
                        this.projectiles[i].state = (byte)2;
                    }
                    break block35;
                }
                if (this.projectiles[i].shooterId == 1 && Globals.thePlayer.CheckCollision(this.projectiles[i].x, this.projectiles[i].y, (short)16)) {
                    this.projectiles[i].state = (byte)2;
                    Globals.thePlayer.ModifyDamage(-this.GetDamage(this.projectiles[i].type));
                }
            }
            if (this.projectiles[i].animSpeedMs != 0) {
                this.UpdateAnim(this.projectiles[i]);
            }
            if (this.projectiles[i].state == 3) {
                this.projectiles[i].di.y = this.projectiles[i].y;
                Globals.drawSort.Add(this.projectiles[i].di);
                if (this.projectiles[i].type == 16 || !Globals.thePlayer.CheckCollision(this.projectiles[i].x, this.projectiles[i].y, (short)16)) continue;
                switch (this.projectiles[i].type) {
                    case 0: {
                        Globals.GetGameCanvas().SetMessage("Got Health", 0);
                        Globals.thePlayer.ModifyDamage(5);
                        break;
                    }
                    case 1: {
                        switch (this.projectiles[i].special) {
                            case 0: {
                                Globals.GetGameCanvas().SetMessage("Got Naquadria", 0);
                                Globals.enemyMgr.ExitAndRunScript(3000);
                                break;
                            }
                            case 1: {
                                Globals.enemyMgr.ExitAndRunScript(20);
                                break;
                            }
                        }
                        this.KillProjectile(i);
                        continue block19;
                    }
                    case 15: {
                        if (Globals.curMap.stargateTile != -1 && Globals.curMap.tiles[Globals.curMap.stargateTile].frameDelay == 1) continue block19;
                        Globals.logic.EnteredStargate();
                        continue block19;
                    }
                }
                Globals.thePlayer.GiveItem(this.projectiles[i].type);
                this.KillProjectile(i);
                continue;
            }
            if (this.projectiles[i].state == 1) {
                switch (this.projectiles[i].dir) {
                    case 1: {
                        this.projectiles[i].x = (short)(this.projectiles[i].x + s);
                        break;
                    }
                    case 0: {
                        this.projectiles[i].x = (short)(this.projectiles[i].x - s);
                        break;
                    }
                    case 2: {
                        this.projectiles[i].y = (short)(this.projectiles[i].y - s2);
                        break;
                    }
                    case 3: {
                        this.projectiles[i].y = (short)(this.projectiles[i].y + s2);
                        break;
                    }
                    case 6: {
                        this.projectiles[i].x = (short)(this.projectiles[i].x - s);
                        this.projectiles[i].y = (short)(this.projectiles[i].y - s2);
                        break;
                    }
                    case 7: {
                        this.projectiles[i].x = (short)(this.projectiles[i].x - s);
                        this.projectiles[i].y = (short)(this.projectiles[i].y + s2);
                        break;
                    }
                    case 4: {
                        this.projectiles[i].x = (short)(this.projectiles[i].x + s);
                        this.projectiles[i].y = (short)(this.projectiles[i].y - s2);
                        break;
                    }
                    case 5: {
                        this.projectiles[i].x = (short)(this.projectiles[i].x + s);
                        this.projectiles[i].y = (short)(this.projectiles[i].y + s2);
                        break;
                    }
                }
                if (!Globals.curMap.PositionIsOnScreen(this.projectiles[i].x, this.projectiles[i].y, (byte)20)) {
                    this.KillProjectile(i);
                    continue;
                }
            } else if (this.projectiles[i].state == 2) {
                int n = 4;
                if (this.graphics[this.projectiles[i].type].framesX == 5 && this.projectiles[i].curFrame == 0) {
                    this.projectiles[i].curFrame = (byte)(this.projectiles[i].curFrame + 1);
                }
                if (this.animTimer < Globals.GetTick()) {
                    this.projectiles[i].curFrame = (byte)(this.projectiles[i].curFrame + 1);
                    if (this.projectiles[i].curFrame > n - 1) {
                        this.KillProjectile(i);
                    }
                }
                if (this.projectiles[i].animSpeedMs != 0) {
                    this.UpdateAnim(this.projectiles[i]);
                }
            }
            if (this.projectiles[i].state == 0) continue;
            this.projectiles[i].di.y = this.projectiles[i].y;
            Globals.drawSort.Add(this.projectiles[i].di);
        }
        if (this.animTimer < Globals.GetTick()) {
            this.animTimer = Globals.GetTick() + 110L;
        }
    }

    private void UpdateAnim(Projectile projectile) {
        if (projectile.animSpeedMs != 0 && projectile.animTimer < Globals.GetTick()) {
            projectile.animTimer = Globals.GetTick() + (long)projectile.animSpeedMs;
            projectile.curFrame = (byte)((projectile.curFrame + 1) % projectile.graphic.framesX);
        }
    }

    public void Reset() {
        for (int i = 0; i < 17; ++i) {
            if (this.projectiles[i] == null) continue;
            this.projectiles[i].state = 0;
            if (this.projectiles[i].graphic == null) continue;
            this.projectiles[i].graphic = null;
        }
        this.curBulletsActive = 0;
        this.powerupsActive = 0;
        System.gc();
    }

    public void KillProjectileByType(byte by) {
        for (int i = 0; i < 17; ++i) {
            if (this.projectiles[i] == null || this.projectiles[i].type != by) continue;
            this.KillProjectile(i);
        }
    }

    public void KillProjectile(int n) {
        if (this.projectiles[n] == null) {
            return;
        }
        this.projectiles[n].state = 0;
        switch (this.projectiles[n].type) {
            case 2: {
                this.curBulletsActive = (byte)(this.curBulletsActive - 1);
                break;
            }
            default: {
                this.powerupsActive = (byte)(this.powerupsActive - 1);
            }
        }
    }

    public void RenderProjectile(Graphics graphics, byte by) {
        if (this.projectiles[by] == null) {
            return;
        }
        Point point = Globals.curMap.WorldToScreen(this.projectiles[by].x, this.projectiles[by].y);
        if (this.projectiles[by].graphic != null) {
            this.UpdateAnim(this.projectiles[by]);
            this.projectiles[by].graphic.blit(graphics, point.x, point.y - this.projectiles[by].heightOffGround, this.projectiles[by].curFrame, 0, true);
        } else if (this.projectiles[by].type < 3) {
            this.graphics[this.projectiles[by].type].blit(graphics, point.x, point.y - this.projectiles[by].heightOffGround, this.projectiles[by].curFrame, 0, true);
        }
    }

    public void SetDepthSortMod(int n, short s) {
        if (this.projectiles[n] == null) {
            return;
        }
        this.projectiles[n].heightOffGround = (short)(this.projectiles[n].heightOffGround + s);
        this.projectiles[n].y = (short)(this.projectiles[n].y + s);
    }

    public void SetFrame(int n, byte by) {
        if (this.projectiles[n] == null) {
            return;
        }
        this.projectiles[n].curFrame = by;
    }

    public void SetSpecial(int n, byte by) {
        if (this.projectiles[n] == null) {
            return;
        }
        this.projectiles[n].special = by;
    }

    public int Add(byte by, byte by2, byte by3, short s, short s2, Graphic graphic) {
        short s3 = s;
        short s4 = s2;
        int n = -1;
        for (int i = 0; i < 17; ++i) {
            if (this.projectiles[i] == null) {
                this.projectiles[i] = new Projectile();
                this.projectiles[i].di.index = (byte)i;
            }
            if (this.projectiles[i].state != 0) continue;
            this.projectiles[i].curFrame = 0;
            this.projectiles[i].animSpeedMs = 0;
            this.projectiles[i].animTimer = 0L;
            this.projectiles[i].special = 0;
            n = i;
            switch (by3) {
                case 2: {
                    if (this.curBulletsActive > 5) {
                        return -1;
                    }
                    this.curBulletsActive = (byte)(this.curBulletsActive + 1);
                    this.projectiles[i].state = 1;
                    this.projectiles[i].heightOffGround = (short)15;
                    if (by2 != 0) break;
                    SoundPlayer.playEffect(SoundPlayer.PFIRE);
                    break;
                }
                default: {
                    if (by3 != 1 && by3 != 16 && this.powerupsActive > 5 && by3 != 15) {
                        return -1;
                    }
                    this.powerupsActive = (byte)(this.powerupsActive + 1);
                    this.projectiles[i].state = (byte)3;
                    this.projectiles[i].heightOffGround = 0;
                }
            }
            this.projectiles[i].shooterId = by2;
            this.projectiles[i].dir = by;
            this.projectiles[i].x = s3;
            this.projectiles[i].y = s4;
            this.projectiles[i].di.y = s4;
            this.projectiles[i].type = by3;
            this.projectiles[i].graphic = graphic != null ? graphic : (this.projectiles[i].type < 3 ? this.graphics[this.projectiles[i].type] : null);
            switch (this.projectiles[i].type) {
                case 16: {
                    this.projectiles[i].state = (byte)3;
                }
            }
            return n;
        }
        return n;
    }

    byte GetDamage(byte by) {
        return 5;
    }
}

