/*
 * Decompiled with CFR 0.152.
 */
package engine;

import engine.SpriteAnimation;
import engine.SpriteAnimationSet;
import engine.TilesImage;
import engine.utilities.UtilGraphics;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class AnimatedSprite {
    public SpriteAnimationSet spriteAnimations;
    private int fpImageHeightScale;
    public SpriteAnimation currentSpriteAnimation;
    public int animationTime;
    public int currentFrame;

    public AnimatedSprite(SpriteAnimationSet spriteAnimations, int spriteSize, int fpImageHeightScale) {
        this.spriteAnimations = spriteAnimations;
        this.fpImageHeightScale = fpImageHeightScale;
    }

    public void setAnimationFrame(int frameNumber) {
        this.currentFrame = frameNumber;
    }

    public void updateAnimation(int stepTime) {
        if (this.currentSpriteAnimation == null) {
            return;
        }
        this.setAnimationTime(this.animationTime + stepTime, false);
    }

    public void setAnimationTime(int time) {
        this.setAnimationTime(time, false);
    }

    private int setAnimationTime(int animationTime, boolean changeAnimation) {
        this.animationTime = animationTime;
        this.currentFrame = animationTime / this.currentSpriteAnimation.frameTime;
        if (this.currentFrame >= this.currentSpriteAnimation.animationFramesCount || this.currentFrame < 0) {
            if (this.currentSpriteAnimation.animationContinue == 0) {
                if ((animationTime %= this.currentSpriteAnimation.fullAnimationTime) < 0) {
                    animationTime += this.currentSpriteAnimation.fullAnimationTime;
                }
                this.currentFrame = animationTime / this.currentSpriteAnimation.frameTime;
            } else {
                this.currentFrame = this.currentSpriteAnimation.animationFramesCount - 1;
            }
            if (this.currentFrame < 0 || !changeAnimation || this.currentSpriteAnimation.nextAnimationName == null || this.currentSpriteAnimation.nextAnimationName.trim().compareTo("-") == 0) {
                return -1;
            }
            return this.currentSpriteAnimation.nextAnimationId;
        }
        return -1;
    }

    public void setAnimation(String name, int animationTime) {
        SpriteAnimation animation = null;
        if (this.currentSpriteAnimation == null || this.currentSpriteAnimation.animationName.compareTo(name) != 0) {
            animation = this.spriteAnimations.returnSpriteAnimation(name);
            if (animation == null) {
                this.currentSpriteAnimation = null;
            }
            this.currentSpriteAnimation = animation;
        }
        this.setAnimationTime(animationTime);
    }

    public void setAnimation(int id, int animationTime) {
        SpriteAnimation animation = null;
        if (this.currentSpriteAnimation == null || this.currentSpriteAnimation.animationId != -1) {
            animation = this.spriteAnimations.returnSpriteAnimation(id);
            if (animation == null) {
                this.currentSpriteAnimation = null;
            }
            this.currentSpriteAnimation = animation;
        }
        this.setAnimationTime(animationTime);
    }

    public void draw(Graphics g, int x, int y, int transform) {
        for (int i = 0; i < this.currentSpriteAnimation.animationFrames[this.currentFrame].tilesCount; ++i) {
            int dx = this.currentSpriteAnimation.animationFrames[this.currentFrame].drawX[i];
            if (transform == 2) {
                dx = -(this.currentSpriteAnimation.animationFrames[this.currentFrame].tiles[i].width + this.currentSpriteAnimation.animationFrames[this.currentFrame].drawX[i]);
            }
            UtilGraphics.drawRegionRGB(g, this.spriteAnimations.tilesImage.layerTiles[this.currentSpriteAnimation.animationFrames[this.currentFrame].tiles[i].id], this.currentSpriteAnimation.animationFrames[this.currentFrame].tiles[i].width, 0, 0, this.currentSpriteAnimation.animationFrames[this.currentFrame].tiles[i].width, this.currentSpriteAnimation.animationFrames[this.currentFrame].tiles[i].height, transform, x + dx, y + this.currentSpriteAnimation.animationFrames[this.currentFrame].drawY[i]);
        }
    }

    public void draw(Graphics g, int x, int y, int transform, TilesImage img) {
        for (int i = 0; i < this.currentSpriteAnimation.animationFrames[this.currentFrame].tilesCount; ++i) {
            int dx = this.currentSpriteAnimation.animationFrames[this.currentFrame].drawX[i];
            if (transform == 2) {
                dx = -(this.currentSpriteAnimation.animationFrames[this.currentFrame].tiles[i].width + this.currentSpriteAnimation.animationFrames[this.currentFrame].drawX[i]);
            }
            UtilGraphics.drawRegionRGB(g, img.layerTiles[this.currentSpriteAnimation.animationFrames[this.currentFrame].tiles[i].id], this.currentSpriteAnimation.animationFrames[this.currentFrame].tiles[i].width, 0, 0, this.currentSpriteAnimation.animationFrames[this.currentFrame].tiles[i].width, this.currentSpriteAnimation.animationFrames[this.currentFrame].tiles[i].height, transform, x + dx, y + this.currentSpriteAnimation.animationFrames[this.currentFrame].drawY[i]);
        }
    }

    public void prerenderAllAnimations(TilesImage img) {
        Image img1 = Image.createImage((int)200, (int)200);
        Graphics g = img1.getGraphics();
        for (int i = 0; i < this.spriteAnimations.spriteAnimationsCount; ++i) {
            this.currentSpriteAnimation = this.spriteAnimations.spriteAnimations[i];
            int j = 0;
            while (j < this.currentSpriteAnimation.animationFramesCount) {
                this.currentFrame = j++;
                this.draw(g, 100, 100, 0, img);
                this.draw(g, 100, 100, 2, img);
            }
            System.out.println(this.currentSpriteAnimation.animationName);
        }
        img1 = null;
        g = null;
    }

    public void clear() {
        this.spriteAnimations = null;
        this.currentSpriteAnimation = null;
    }
}

