/*
 * Decompiled with CFR 0.152.
 */
package framework.sound;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class Music {
    public static final int MIN_VOLUME = 0;
    public static final int MID_VOLUME = 50;
    public static final int MAX_VOLUME = 100;
    public static final int NO_MUSIC = -1;
    private static final Hashtable fileNames = new Hashtable();
    private static final Object dummy = new Object();
    private static Integer currentMusicId = null;
    private static Player currentPlayer = null;
    private static int previousVolume = -1;

    public static Integer addMusicTrack(String fileName) throws IOException, MediaException {
        Integer key = new Integer(fileNames.size());
        fileNames.put(key, fileName);
        return key;
    }

    public static void playMusic() {
        Music.playMusic(currentMusicId);
    }

    public static void playMusic(Integer musicId) {
        Music.playMusic(musicId, -1);
    }

    public static void playMusic(Integer musicId, int loopCount) {
        if (musicId == null) {
            return;
        }
        try {
            if (currentMusicId == musicId) {
                currentPlayer = Music.ensurePlayerNotClosed(currentPlayer, musicId);
                currentPlayer.stop();
                if (currentPlayer.getState() != 400) {
                    currentPlayer.start();
                }
                return;
            }
            if (currentPlayer != null) {
                currentPlayer.close();
                currentPlayer = null;
                currentMusicId = null;
            }
            currentPlayer = Music.ensurePlayerNotClosed(currentPlayer, musicId);
            currentPlayer.prefetch();
            currentPlayer.setLoopCount(loopCount);
            currentPlayer.stop();
            currentPlayer.start();
            currentMusicId = musicId;
            if (previousVolume != -1) {
                Music.setVolume(previousVolume);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void stopMusic() {
        if (currentMusicId == null) {
            return;
        }
        try {
            currentPlayer.stop();
            currentMusicId = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static VolumeControl getVolCtrl() {
        if (currentPlayer == null) {
            return null;
        }
        VolumeControl volumeControl = (VolumeControl)currentPlayer.getControl("VolumeControl");
        if (volumeControl == null) {
            // empty if block
        }
        return volumeControl;
    }

    public static void setVolume(int volume) {
        if (currentPlayer == null) {
            return;
        }
        VolumeControl volumeControl = Music.getVolCtrl();
        if (volumeControl != null) {
            volumeControl.setLevel(volume);
            previousVolume = volume;
        }
    }

    public static int getVolume() {
        if (currentPlayer == null) {
            return -1;
        }
        VolumeControl volumeControl = Music.getVolCtrl();
        if (volumeControl != null) {
            return volumeControl.getLevel();
        }
        return 0;
    }

    public static Integer getIdOfMusicBeingPlayed() {
        return currentPlayer != null && currentPlayer.getState() == 400 ? currentMusicId : null;
    }

    public static Integer getIdOfLoadedMusic() {
        return currentPlayer != null ? currentMusicId : null;
    }

    public static void removeMusicTrack(Integer musicId) {
        if (musicId == null) {
            return;
        }
        fileNames.remove(musicId);
    }

    public static void removeAllMusicTracks() {
        Enumeration e = fileNames.keys();
        while (e.hasMoreElements()) {
            Integer n = (Integer)e.nextElement();
        }
        fileNames.clear();
        if (currentPlayer != null) {
            currentPlayer.close();
            currentPlayer = null;
        }
    }

    private static Player createPlayer(String fileName) throws IOException, MediaException {
        InputStream inputStream = dummy.getClass().getResourceAsStream(fileName);
        Player player = Manager.createPlayer((InputStream)inputStream, (String)"audio/midi");
        player.realize();
        return player;
    }

    private static Player ensurePlayerNotClosed(Player player, Integer musicId) throws IOException, MediaException {
        if (player == null || player.getState() == 0) {
            Player newPlayer = Music.createPlayer((String)fileNames.get(musicId));
            return newPlayer;
        }
        return player;
    }
}

