/*
 * Decompiled with CFR 0.152.
 */
package engine.world;

import app.GameAppState;
import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import engine.utilities.UtilGraphics;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SimpleAnimation {
    public static int[][] frames = new int[][]{{1, 25, 14, 14, 126, 22, 29, 18, 125, 0, 20, 22, 126, 22, 18, 18}, {0, 0, 24, 16, 24, 0, 25, 40, 49, 0, 25, 40, 74, 0, 28, 40, 102, 0, 24, 39, 0, 16, 16, 8, 16, 16, 7, 7}, {0, 40, 32, 32, 32, 40, 32, 32, 64, 40, 32, 32, 96, 40, 32, 32, 0, 40, 32, 32, 32, 40, 32, 32, 64, 40, 32, 32, 96, 40, 32, 32}, {96, 40, 32, 32, 64, 40, 32, 32, 32, 40, 32, 32, 0, 40, 32, 32, 96, 40, 32, 32, 64, 40, 32, 32, 32, 40, 32, 32, 0, 40, 32, 32}, {128, 40, 16, 16, 128, 56, 16, 16, 128, 72, 16, 16}, {235, 111, 7, 7, 220, 160, 1, 1, 235, 103, 8, 8, 220, 160, 1, 1, 235, 79, 18, 24, 220, 160, 1, 1, 202, 79, 33, 49, 220, 160, 1, 1, 202, 0, 55, 78, 0, 0, 201, 206, 202, 0, 55, 78, 0, 0, 201, 206, 202, 0, 55, 78, 0, 0, 201, 206, 202, 0, 55, 78, 0, 0, 201, 206, 0, 0, 201, 206, 0, 0, 201, 206, 0, 0, 201, 206}, {155, 0, 28, 46, 162, 0, 21, 46, 169, 0, 14, 46, 176, 0, 7, 46, 176, 0, 7, 46, 169, 0, 14, 46, 162, 0, 21, 46}, {155, 46, 28, 45, 162, 46, 21, 45, 169, 46, 14, 45, 176, 46, 7, 45, 176, 46, 7, 45, 169, 46, 14, 45, 162, 46, 21, 45}, {183, 0, 28, 53, 190, 0, 21, 53, 197, 0, 14, 53, 204, 0, 7, 53}, {211, 0, 31, 53, 218, 0, 24, 53, 225, 0, 17, 53, 232, 0, 10, 53}, {183, 53, 8, 26, 191, 53, 11, 17, 191, 70, 8, 7}, {90, 72, 8, 7, 98, 72, 8, 8, 106, 72, 7, 8, 51, 72, 8, 8, 59, 72, 8, 7, 67, 72, 8, 8, 75, 72, 8, 8, 82, 72, 8, 8}, {97, 80, 16, 3, 86, 80, 11, 11, 48, 70, 3, 16, 75, 80, 11, 11}, {51, 80, 8, 3, 59, 80, 7, 6, 66, 80, 3, 8, 51, 83, 7, 6, 59, 88, 8, 3, 59, 80, 7, 6, 66, 80, 3, 8, 51, 83, 7, 6}, {9, 72, 8, 8, 17, 72, 8, 10, 25, 72, 8, 8, 17, 72, 8, 10, 32, 72, 8, 8, 17, 72, 8, 10, 40, 72, 8, 8, 17, 72, 8, 10}, {29, 80, 19, 9}, {97, 83, 7, 7, 104, 83, 7, 7}, {69, 80, 4, 4, 69, 84, 4, 4}, {0, 91, 80, 12, 2, 91, 80, 12, 5, 91, 80, 12}, {5, 91, 80, 12, 2, 91, 80, 12, 0, 91, 80, 12}, {202, 53, 8, 8, 202, 61, 8, 8, 202, 69, 8, 8, 202, 77, 8, 8}, {210, 53, 8, 8, 210, 61, 8, 8, 210, 69, 8, 8, 210, 77, 8, 8}, {218, 53, 8, 8, 218, 61, 8, 8, 218, 69, 8, 8, 218, 77, 8, 8}, {13, 82, 16, 8}, {242, 12, 40, 48, 242, 8, 40, 48, 242, 4, 40, 48, 242, 0, 40, 48}, {242, 64, 40, 16}, {0, 0, 1, 1, 226, 53, 7, 15, 226, 69, 16, 16, 189, 87, 24, 16, 214, 87, 40, 16, 113, 87, 40, 16}, {0, 71, 1, 9}, {102, 92, 8, 11, 88, 91, 22, 12, 254, 80, 19, 23, 0, 0, 1, 1}};
    static boolean initialized = false;
    public static short[] image;
    public static int width;
    public static byte ALIGN_TOP_LEFT;
    public static byte ALIGN_CENTER;
    public static byte ALIGN_BOTTOM_CENTER;
    public static short FRAME_TIME;
    public byte frame = 0;
    public short currentFrameTime = FRAME_TIME;
    public byte anchor;
    public byte anim;
    public byte state;
    public boolean visible;
    public static final byte ANIM_LOOP = 0;
    public static final byte ANIM_LOOP_BWD = 6;
    public static final byte ANIM_PLAY_FWD_STOP_AT_START = 1;
    public static final byte ANIM_PLAY_FWD_STOP_AT_END = 3;
    public static final byte ANIM_PLAY_BWD = 4;
    public static final byte ANIM_PLAY_FWD_AND_BACK = 5;
    public static final byte ANIM_STOPPED = 2;

    public SimpleAnimation(byte anim, byte anchor) {
        this.anchor = anchor;
        this.anim = anim;
        this.state = 0;
        this.visible = true;
    }

    public static void initialize(String file) {
        try {
            Image img = Image.createImage((String)file);
            Image tmp = Image.createImage((int)img.getWidth(), (int)img.getHeight());
            tmp.getGraphics().drawImage(img, 0, 0, 0);
            width = img.getWidth();
            img = null;
            DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)tmp.getGraphics());
            image = new short[tmp.getWidth() * tmp.getHeight()];
            dg.getPixels(image, 0, tmp.getWidth(), 0, 0, tmp.getWidth(), tmp.getHeight(), 4444);
            for (int i = 0; i < image.length; ++i) {
                if (image[i] != -1) continue;
                SimpleAnimation.image[i] = 0;
            }
            tmp = null;
            Object var3_6 = null;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (!initialized) {
            for (int i = 0; i < frames.length; ++i) {
                for (int j = 0; j < frames[i].length; ++j) {
                    SimpleAnimation.frames[i][j] = GameAppState.scaleValue(frames[i][j]);
                }
            }
            initialized = true;
        }
    }

    public void setState(byte s) {
        this.state = s;
    }

    public void setToStart() {
        this.frame = 0;
    }

    public void setToEnd() {
        this.frame = (byte)(frames[this.anim].length - 4);
    }

    public boolean update(int deltaTime) {
        if (this.state != 2) {
            this.currentFrameTime = (short)(this.currentFrameTime - deltaTime);
            if (this.currentFrameTime <= 0) {
                this.currentFrameTime = FRAME_TIME;
                if (this.state == 0 || this.state == 1 || this.state == 3 || this.state == 5) {
                    this.frame = (byte)(this.frame + 4);
                    if (this.frame >= frames[this.anim].length) {
                        if (this.state == 0) {
                            this.frame = 0;
                        } else if (this.state == 1) {
                            this.frame = 0;
                            this.state = (byte)2;
                        } else if (this.state == 3) {
                            this.frame = (byte)(this.frame - 4);
                            this.state = (byte)2;
                        } else if (this.state == 5) {
                            this.frame = (byte)(this.frame - 4);
                            this.state = (byte)4;
                        }
                        return false;
                    }
                } else {
                    this.frame = (byte)(this.frame - 4);
                    if (this.frame <= 0) {
                        if (this.state == 4) {
                            this.frame = 0;
                            this.state = (byte)2;
                        } else if (this.state == 6) {
                            this.setToEnd();
                        }
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public void setAnimation(byte anim, byte anchor) {
        this.anim = anim;
        this.anchor = anchor;
        this.frame = 0;
        this.currentFrameTime = FRAME_TIME;
    }

    public void paint(Graphics g, int x, int y, int trans) {
        if (this.visible) {
            if (this.anim == 5) {
                if (frames[this.anim][this.frame] == 0) {
                    UtilGraphics.drawRegionRGB(g, image, width, frames[this.anim][this.frame], frames[this.anim][this.frame + 1], frames[this.anim][this.frame + 2], frames[this.anim][this.frame + 3], trans, x - GameAppState.cameraX - (frames[this.anim][this.frame + 2] >> 1) + 4, y - GameAppState.cameraY - (frames[this.anim][this.frame + 3] >> 1) + 5);
                } else {
                    UtilGraphics.drawRegionRGB(g, image, width, frames[this.anim][this.frame], frames[this.anim][this.frame + 1], frames[this.anim][this.frame + 2], frames[this.anim][this.frame + 3], trans, x - GameAppState.cameraX - (frames[this.anim][this.frame + 2] >> 1), y - GameAppState.cameraY - (frames[this.anim][this.frame + 3] >> 1));
                }
                return;
            }
            if (this.anchor == ALIGN_BOTTOM_CENTER) {
                UtilGraphics.drawRegionRGB(g, image, width, frames[this.anim][this.frame], frames[this.anim][this.frame + 1], frames[this.anim][this.frame + 2], frames[this.anim][this.frame + 3], trans, GameAppState.scaleValue(x - GameAppState.cameraX - (frames[this.anim][this.frame + 2] >> 1)), GameAppState.scaleValue(y - GameAppState.cameraY - frames[this.anim][this.frame + 3]));
            } else if (this.anchor == ALIGN_CENTER) {
                UtilGraphics.drawRegionRGB(g, image, width, frames[this.anim][this.frame], frames[this.anim][this.frame + 1], frames[this.anim][this.frame + 2], frames[this.anim][this.frame + 3], trans, GameAppState.scaleValue(x - GameAppState.cameraX - (frames[this.anim][this.frame + 2] >> 1)), GameAppState.scaleValue(y - GameAppState.cameraY - (frames[this.anim][this.frame + 3] >> 1)));
            } else {
                UtilGraphics.drawRegionRGB(g, image, width, frames[this.anim][this.frame], frames[this.anim][this.frame + 1], frames[this.anim][this.frame + 2], frames[this.anim][this.frame + 3], trans, GameAppState.scaleValue(x - GameAppState.cameraX), GameAppState.scaleValue(y - GameAppState.cameraY));
            }
        }
    }

    public static void paintFrame(Graphics g, int x, int y, int w, int h, int trans, int dx, int dy, int anchor) {
        UtilGraphics.drawRegionRGB(g, image, width, x, y, w, h, trans, dx, dy);
    }

    public void Serialize(DataOutputStream out) {
        try {
            out.writeByte(this.frame);
            out.writeShort(this.currentFrameTime);
            out.writeByte(this.anchor);
            out.writeByte(this.anim);
            out.writeByte(this.state);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void DeSerialize(DataInputStream in) {
        try {
            this.frame = in.readByte();
            this.currentFrameTime = in.readShort();
            this.anchor = in.readByte();
            this.anim = in.readByte();
            this.state = in.readByte();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    static {
        ALIGN_TOP_LEFT = 0;
        ALIGN_CENTER = 1;
        ALIGN_BOTTOM_CENTER = (byte)2;
        FRAME_TIME = (short)150;
    }
}

