/*
 * Decompiled with CFR 0.152.
 */
package engine.world;

import engine.utilities.UtilGraphics;
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TiledLayer {
    public int layerWidth;
    public int layerHeight;
    public int tileWidth;
    public int tileHeight;
    public int tilesInRow;
    public int tilesInColumn;
    private int screenWidth;
    private int screenHeight;
    private int cameraX;
    private int cameraY;
    private short[] tileMap;
    private Image tileSetImage;
    private int tileSetImageTilesInRow;
    boolean useLayerImage;
    private Image layerImage;
    private int layerImageWidth;
    private int layerImageHeight;
    private Graphics layerImageGraphics;
    private int cameraLayerImageX;
    private int cameraLayerImageY;
    private int layerImageWidthInTiles;
    private int layerImageHeightInTiles;
    public int layerImageMinTileX;
    public int layerImageMinTileY;

    public TiledLayer(DataInputStream disLevFile, boolean useLayerImage, int screenWidth, int screenHeight) throws Exception {
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.useLayerImage = useLayerImage;
        this.layerWidth = disLevFile.readShort();
        this.layerHeight = disLevFile.readShort();
        this.tileWidth = disLevFile.readByte();
        this.tileHeight = disLevFile.readByte();
        this.tilesInRow = this.layerWidth / this.tileWidth;
        this.tilesInColumn = this.layerHeight / this.tileHeight;
        if (this.layerWidth % this.tileWidth != 0 || this.layerHeight % this.tileHeight != 0) {
            throw new Exception("LayerWidth or layerHeight size incorrect");
        }
        this.tileMap = new short[this.tilesInColumn * this.tilesInRow];
        for (int i = 0; i < this.tilesInColumn * this.tilesInRow; ++i) {
            this.tileMap[i] = disLevFile.readShort();
        }
        if (useLayerImage) {
            this.createLayerImage();
        }
    }

    public TiledLayer(short[] tileMap, byte[] tileProperties, int tilesInRow, int tilesInColumn, int tileWidth, int tileHeight, boolean useLayerImage, int screenWidth, int screenHeight) {
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.tileMap = tileMap;
        this.tilesInRow = tilesInRow;
        this.tilesInColumn = tilesInColumn;
        this.layerWidth = tilesInRow * tileWidth;
        this.layerHeight = tilesInColumn * tileHeight;
        this.useLayerImage = useLayerImage;
        if (useLayerImage) {
            this.createLayerImage();
        }
    }

    public void createLayerImage() {
        this.layerImageWidthInTiles = this.screenWidth / this.tileWidth + 1;
        if (this.screenWidth % this.tileWidth != 0) {
            ++this.layerImageWidthInTiles;
        }
        this.layerImageHeightInTiles = this.screenHeight / this.tileHeight + 1;
        if (this.screenHeight % this.tileHeight != 0) {
            ++this.layerImageHeightInTiles;
        }
        this.layerImageWidth = this.layerImageWidthInTiles * this.tileWidth;
        this.layerImageHeight = this.layerImageHeightInTiles * this.tileHeight;
        this.layerImage = Image.createImage((int)this.layerImageWidth, (int)this.layerImageHeight);
        this.layerImageGraphics = this.layerImage.getGraphics();
        this.layerImageMinTileX = -1;
        this.layerImageMinTileY = -1;
    }

    public void setTileImage(Image tileSetImage) throws Exception {
        this.tileSetImage = tileSetImage;
        this.tileSetImageTilesInRow = tileSetImage.getWidth() / this.tileWidth;
    }

    public void paint(Graphics g) {
        if (this.useLayerImage) {
            int regionHeight;
            int regionWidth = this.layerImageWidthInTiles * this.tileWidth - this.cameraLayerImageX;
            if (regionWidth > this.screenWidth) {
                regionWidth = this.screenWidth;
            }
            if ((regionHeight = this.layerImageHeightInTiles * this.tileHeight - this.cameraLayerImageY) > this.screenHeight) {
                regionHeight = this.screenHeight;
            }
            UtilGraphics.drawRegion(g, this.layerImage, this.cameraLayerImageX, this.cameraLayerImageY, regionWidth, regionHeight, 0, 0, 0, 20);
            if (regionWidth < this.screenWidth) {
                UtilGraphics.drawRegion(g, this.layerImage, 0, this.cameraLayerImageY, this.screenWidth - regionWidth, regionHeight, 0, regionWidth, 0, 20);
                if (regionHeight < this.screenHeight) {
                    UtilGraphics.drawRegion(g, this.layerImage, 0, 0, this.screenWidth - regionWidth, this.screenHeight - regionHeight, 0, regionWidth, regionHeight, 20);
                }
            }
            if (regionHeight < this.screenHeight) {
                UtilGraphics.drawRegion(g, this.layerImage, this.cameraLayerImageX, 0, regionWidth, this.screenHeight - regionHeight, 0, 0, regionHeight, 20);
            }
        } else {
            int minTileY = this.cameraY / this.tileHeight;
            int minTileX = this.cameraX / this.tileWidth;
            int dy = this.cameraY % this.tileHeight;
            int dx = this.cameraX % this.tileWidth;
            int maxTileY = (this.cameraY + 168) / this.tileHeight + 1;
            int maxTileX = (this.cameraX + 176) / this.tileWidth + 1;
            if (maxTileY > this.tilesInColumn) {
                maxTileY = this.tilesInColumn;
            }
            if (maxTileX > this.tilesInRow) {
                maxTileX = this.tilesInRow;
            }
            for (int y = minTileY; y < maxTileY; ++y) {
                for (int x = minTileX; x < maxTileX; ++x) {
                    int tile = this.getTileImageIndex(x, y);
                    UtilGraphics.drawRegion(g, this.tileSetImage, tile % this.tileSetImageTilesInRow * this.tileWidth, tile / this.tileSetImageTilesInRow * this.tileHeight, this.tileWidth, this.tileHeight, 0, (x - minTileX) * this.tileWidth - dx, (y - minTileY) * this.tileHeight - dy, 20);
                }
            }
        }
    }

    public void moveLayer(int deltaX, int deltaY) {
        this.setLayerPosition(this.cameraX + deltaX, this.cameraY + deltaY);
    }

    public void setLayerPosition(int newCameraX, int newCameraY) {
        int deltaX = newCameraX - this.cameraX;
        int deltaY = newCameraY - this.cameraY;
        this.cameraX = newCameraX;
        this.cameraY = newCameraY;
        if (this.useLayerImage) {
            if (this.layerImageMinTileX < 0 || deltaX > this.layerImageWidth >> 1 || deltaX < -(this.layerWidth >> 1) || deltaY > this.layerHeight >> 1 || deltaY < -(this.layerHeight >> 1)) {
                this.updateFullLayerImage();
            } else {
                int row;
                int newLayerImageMinTileY;
                int i;
                int column;
                if (deltaX == 0 && deltaY == 0) {
                    return;
                }
                this.cameraLayerImageX += deltaX;
                if (this.cameraLayerImageX < 0) {
                    this.cameraLayerImageX = this.layerImageWidth + this.cameraLayerImageX;
                }
                while (this.cameraLayerImageX >= this.layerImageWidth) {
                    this.cameraLayerImageX -= this.layerImageWidth;
                }
                int newLayerImageMinTileX = this.cameraX / this.tileWidth;
                if (newLayerImageMinTileX < this.layerImageMinTileX) {
                    column = this.cameraLayerImageX / this.tileWidth;
                    for (i = newLayerImageMinTileX; i < this.layerImageMinTileX; ++i) {
                        if (column >= this.layerImageWidthInTiles) {
                            column = 0;
                        }
                        this.replaceLayerImageColumn(column++, i);
                    }
                    this.layerImageMinTileX = newLayerImageMinTileX;
                } else if (newLayerImageMinTileX > this.layerImageMinTileX) {
                    column = this.cameraLayerImageX / this.tileWidth - 1;
                    for (i = newLayerImageMinTileX - 1; i >= this.layerImageMinTileX; --i) {
                        if (column < 0) {
                            column = this.layerImageWidthInTiles - 1;
                        }
                        this.replaceLayerImageColumn(column--, i + this.layerImageWidthInTiles);
                    }
                    this.layerImageMinTileX = newLayerImageMinTileX;
                }
                this.cameraLayerImageY += deltaY;
                if (this.cameraLayerImageY < 0) {
                    this.cameraLayerImageY = this.layerImageHeight + this.cameraLayerImageY;
                }
                if (this.cameraLayerImageY >= this.layerImageHeight) {
                    this.cameraLayerImageY -= this.layerImageHeight;
                }
                if ((newLayerImageMinTileY = this.cameraY / this.tileHeight) < this.layerImageMinTileY) {
                    row = this.cameraLayerImageY / this.tileHeight;
                    for (int i2 = newLayerImageMinTileY; i2 < this.layerImageMinTileY; ++i2) {
                        this.replaceLayerImageRow(row++, i2);
                        if (row < this.layerImageHeightInTiles) continue;
                        row = 0;
                    }
                    this.layerImageMinTileY = newLayerImageMinTileY;
                } else if (newLayerImageMinTileY > this.layerImageMinTileY) {
                    row = this.cameraLayerImageY / this.tileHeight - 1;
                    for (int i3 = newLayerImageMinTileY - 1; i3 >= this.layerImageMinTileY; --i3) {
                        if (row < 0) {
                            row = this.layerImageHeightInTiles - 1;
                        }
                        this.replaceLayerImageRow(row--, i3 + this.layerImageHeightInTiles);
                    }
                    this.layerImageMinTileY = newLayerImageMinTileY;
                }
            }
        }
    }

    private void replaceLayerImageColumn(int imageX, int layerX) {
        if (layerX < 0 || layerX >= this.tilesInRow) {
            return;
        }
        int imageY = this.cameraLayerImageY / this.tileHeight;
        int layerImageMaxTileY = this.layerImageMinTileY + this.layerImageHeightInTiles;
        if (layerImageMaxTileY > this.tilesInColumn) {
            layerImageMaxTileY = this.tilesInColumn;
        }
        for (int y = this.layerImageMinTileY; y < layerImageMaxTileY; ++y) {
            this.updateLayerImageTile(imageX, imageY, this.getTileImageIndex(layerX, y));
            if (++imageY < this.layerImageHeightInTiles) continue;
            imageY = 0;
        }
    }

    private void replaceLayerImageRow(int imageY, int layerY) {
        if (layerY < 0 || layerY >= this.tilesInColumn) {
            return;
        }
        int imageX = this.cameraLayerImageX / this.tileWidth;
        int layerImageMaxTileX = this.layerImageMinTileX + this.layerImageWidthInTiles;
        if (layerImageMaxTileX > this.tilesInRow) {
            layerImageMaxTileX = this.tilesInRow;
        }
        for (int x = this.layerImageMinTileX; x < layerImageMaxTileX; ++x) {
            this.updateLayerImageTile(imageX, imageY, this.getTileImageIndex(x, layerY));
            if (++imageX < this.layerImageWidthInTiles) continue;
            imageX = 0;
        }
    }

    public void updateFullLayerImage() {
        this.layerImageMinTileX = this.cameraX / this.tileWidth;
        if (this.layerImageMinTileX > this.tilesInRow - this.layerImageWidthInTiles) {
            this.layerImageMinTileX = this.tilesInRow - this.layerImageWidthInTiles;
        }
        this.layerImageMinTileY = this.cameraY / this.tileHeight;
        if (this.layerImageMinTileY > this.tilesInColumn - this.layerImageHeightInTiles) {
            this.layerImageMinTileY = this.tilesInColumn - this.layerImageHeightInTiles;
        }
        if (this.layerImageMinTileY < 0) {
            this.layerImageMinTileY = 0;
        }
        if (this.layerImageMinTileX < 0) {
            this.layerImageMinTileX = 0;
        }
        this.cameraLayerImageX = this.cameraX - this.layerImageMinTileX * this.tileWidth;
        this.cameraLayerImageY = this.cameraY - this.layerImageMinTileY * this.tileHeight;
        for (int y = 0; y < this.layerImageHeightInTiles; ++y) {
            for (int x = 0; x < this.layerImageWidthInTiles; ++x) {
                int tile = this.getTileImageIndex(this.layerImageMinTileX + x, this.layerImageMinTileY + y);
                this.updateLayerImageTile(x, y, tile);
            }
        }
    }

    public void clear() {
        this.tileSetImage = null;
        this.layerImage = null;
        this.layerImageGraphics = null;
    }

    private void updateLayerImageTile(int x, int y, int tile) {
        UtilGraphics.drawRegion(this.layerImageGraphics, this.tileSetImage, tile % this.tileSetImageTilesInRow * this.tileWidth, tile / this.tileSetImageTilesInRow * this.tileHeight, this.tileWidth, this.tileHeight, 0, x * this.tileWidth, y * this.tileHeight, 20);
    }

    private int getTileImageIndex(int x, int y) {
        int r = 0;
        try {
            if (x >= this.tilesInRow) {
                x = this.tilesInRow - 1;
            }
            if (y >= this.tilesInColumn) {
                y = this.tilesInColumn - 1;
            }
            r = this.tileMap[x + y * this.tilesInRow];
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }
}

