/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class M4ATagWriter {
    private static final int BUFFER_SIZE = 1024;

    private void copyBytes(InputStream of, OutputStream nf, int nbytes) throws IOException {
        int n = nbytes;
        byte[] b = new byte[1024];
        int rb = 1024;
        while (n > 0) {
            rb = n < 1024 ? n : 1024;
            if ((rb = of.read(b, 0, rb)) > 0) {
                nf.write(b, 0, rb);
            }
            n -= rb;
        }
    }

    private void copyUntilEOF(InputStream of, OutputStream nf) throws IOException {
        byte[] b = new byte[1024];
        int rb = 1024;
        while ((rb = of.read(b, 0, 1024)) > 0) {
            nf.write(b, 0, rb);
        }
    }

    private void seekAndCopyId(InputStream of, OutputStream nf, M4ABox box, String id, int sizeDelta) throws IOException {
        box.read(of);
        while (!box.getId().equals(id)) {
            box.write(nf);
            this.copyBytes(of, nf, box.getOffset() - 8);
            box.read(of);
        }
        int oldOffset = box.getOffset();
        box.setOffset(oldOffset + sizeDelta);
        box.write(nf);
        box.setOffset(oldOffset);
    }

    public boolean writeTags(String fileName, Hashtable tags, int readSize) {
        FileConnection nfc;
        FileConnection fc;
        boolean doneOK = false;
        String tmpFileName = String.valueOf(String.valueOf(new Random().nextInt())) + ".m4a";
        try {
            fc = (FileConnection)Connector.open((String)fileName, (int)3);
            if (!fc.exists()) {
                throw new IOException("\u0424\u0430\u0439\u043b \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!");
            }
            nfc = (FileConnection)Connector.open((String)(String.valueOf(fileName) + tmpFileName), (int)3);
            nfc.create();
            if (!nfc.canWrite()) {
                throw new IOException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u0444\u0430\u0439\u043b!");
            }
            try {
                Vector<M4ABox> newAtoms = new Vector<M4ABox>(tags.size());
                int newAtomSize = 0;
                Enumeration tagIDs = tags.keys();
                while (tagIDs.hasMoreElements()) {
                    String tagId = (String)tagIDs.nextElement();
                    String tagData = (String)tags.get(tagId);
                    int dataLen = tagData.length();
                    if (dataLen <= 0) continue;
                    int newOffset = 24 + tagData.length();
                    newAtomSize += newOffset;
                    newAtoms.addElement(new M4ABox(tagId, newOffset, tagData));
                }
                int sizeDelta = newAtomSize - readSize;
                InputStream of = fc.openInputStream();
                OutputStream nf = nfc.openOutputStream();
                try {
                    M4ABox box = new M4ABox();
                    this.seekAndCopyId(of, nf, box, "moov", sizeDelta);
                    this.seekAndCopyId(of, nf, box, "udta", sizeDelta);
                    this.seekAndCopyId(of, nf, box, "meta", sizeDelta);
                    byte[] metaFlags = new byte[4];
                    of.read(metaFlags);
                    if (metaFlags[0] != 0) {
                        throw new IOException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0447\u0442\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430!");
                    }
                    nf.write(metaFlags);
                    this.seekAndCopyId(of, nf, box, "ilst", sizeDelta);
                    int len = box.getOffset() - 8;
                    int read = 0;
                    int fieldlen = 0;
                    boolean wroteTags = false;
                    while (read < len) {
                        box.read(of);
                        fieldlen = box.getOffset() - 8;
                        if (tags.containsKey(box.getId())) {
                            box.readData(of);
                        } else {
                            if (!wroteTags && box.getId().equals("chpl")) {
                                this.writeNewAtoms(newAtoms, nf);
                                wroteTags = true;
                            }
                            box.write(nf);
                            this.copyBytes(of, nf, fieldlen);
                        }
                        read += 8 + fieldlen;
                    }
                    if (!wroteTags) {
                        this.writeNewAtoms(newAtoms, nf);
                        wroteTags = true;
                    }
                    this.copyUntilEOF(of, nf);
                    nf.flush();
                    doneOK = wroteTags;
                }
                finally {
                    of.close();
                    nf.close();
                }
            }
            finally {
                fc.close();
                nfc.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (doneOK) {
            try {
                fc = (FileConnection)Connector.open((String)fileName);
                nfc = (FileConnection)Connector.open((String)(String.valueOf(fileName) + tmpFileName));
                try {
                    String fName = fc.getName();
                    fc.delete();
                    nfc.rename(fName);
                }
                finally {
                    fc.close();
                    nfc.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return doneOK;
    }

    private void writeNewAtoms(Vector newAtoms, OutputStream nf) throws IOException {
        Enumeration e = newAtoms.elements();
        while (e.hasMoreElements()) {
            M4ABox atom = (M4ABox)e.nextElement();
            atom.write(nf);
            atom.writeData(nf);
        }
    }
}

