/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class M4ABox {
    private String id;
    private int offset;
    private String data;
    private byte[] bOffset = new byte[4];
    private byte[] bId = new byte[4];

    private int bswap(byte[] b) {
        int n = 0;
        int i = 0;
        while (i < 4) {
            n += (b[3 - i] & 0xFF) << i * 8;
            ++i;
        }
        return n;
    }

    private void makeBytes(byte[] dest, int value) {
        int i = 0;
        while (i < 4) {
            dest[i] = (byte)(value >> (3 - i) * 8 & 0xFF);
            ++i;
        }
    }

    public M4ABox() {
    }

    public M4ABox(String id, int offset, String data) {
        this.setId(id);
        this.setOffset(offset);
        this.setData(data);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
        this.bId = this.id.getBytes();
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int value) {
        this.offset = value;
        this.makeBytes(this.bOffset, value);
    }

    public String getData() {
        return this.data;
    }

    public void setData(String value) {
        this.data = value;
    }

    public void read(InputStream src) throws IOException {
        src.read(this.bOffset);
        this.offset = this.bswap(this.bOffset);
        src.read(this.bId);
        this.id = new String(this.bId);
    }

    public void write(OutputStream dest) throws IOException {
        dest.write(this.bOffset);
        dest.write(this.bId);
    }

    public void copy(InputStream src, OutputStream dest) throws IOException {
        this.read(src);
        this.write(dest);
    }

    public void readData(InputStream src) throws IOException {
        M4ABox dataBox = new M4ABox();
        dataBox.read(src);
        if (!dataBox.id.equals("data")) {
            throw new IOException("Bad data for " + this.id + "!");
        }
        src.skip(8L);
        byte[] b = new byte[dataBox.offset - 16];
        src.read(b);
        this.data = new String(b);
    }

    public void writeData(OutputStream dest) throws IOException {
        M4ABox dataBox = new M4ABox("data", this.data.length() + 16, null);
        dataBox.write(dest);
        byte[] byArray = new byte[8];
        byArray[3] = 1;
        byte[] flags = byArray;
        dest.write(flags);
        byte[] b = this.data.getBytes();
        dest.write(b);
    }
}

