/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Enumeration;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public abstract class FileBrowser
extends MIDlet
implements CommandListener {
    private boolean isAPIAvailable = System.getProperty("microedition.io.file.FileConnection.version") != null;
    private String currDirName = "/";
    private static final String UP_DIRECTORY = "..";
    private static final String MEGA_ROOT = "/";
    private static final String SEP_STR = "/";
    private static final char SEP = '/';
    private List frmSelect;
    private Command cmdExit;
    private Command cmdBack;
    private Command cmdView;
    private Image imgFile;
    private Image imgFolder;

    public abstract void viewFile(String var1);

    protected String getTitle() {
        return "File Browser";
    }

    protected String getExtension() {
        return null;
    }

    protected List getSelectionForm() {
        return this.frmSelect;
    }

    protected void startApp() throws MIDletStateChangeException {
        this.cmdExit = new Command("Exit", 7, 1);
        if (this.isAPIAvailable) {
            try {
                String ext = this.getExtension();
                if (ext != null) {
                    this.imgFile = Image.createImage((String)("/" + ext + ".png"));
                }
                this.imgFolder = Image.createImage((String)"/folder.png");
                this.frmSelect = new List(this.getTitle(), 3);
                this.cmdBack = new Command("Back", 2, 1);
                this.cmdView = new Command("View", 4, 1);
                this.frmSelect.addCommand(this.cmdExit);
                this.frmSelect.setSelectCommand(this.cmdView);
                this.frmSelect.setCommandListener((CommandListener)this);
                this.showDir(this.currDirName);
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.frmSelect);
            }
            catch (SecurityException ext) {
            }
            catch (Exception ext) {}
        } else {
            Alert frmNoAPI = new Alert(null, "FileConnection API not available!", null, AlertType.ERROR);
            frmNoAPI.setTimeout(3000);
            frmNoAPI.addCommand(this.cmdExit);
            frmNoAPI.setCommandListener((CommandListener)this);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)frmNoAPI);
        }
    }

    protected void destroyApp(boolean arg0) throws MIDletStateChangeException {
        this.exit();
    }

    protected void pauseApp() {
    }

    public void exit() {
        this.notifyDestroyed();
    }

    protected void showDir(String newDirName) {
        FileConnection currDir = null;
        this.frmSelect.deleteAll();
        try {
            Enumeration e;
            if ("/".equals(newDirName)) {
                e = FileSystemRegistry.listRoots();
                this.frmSelect.removeCommand(this.cmdBack);
            } else {
                currDir = (FileConnection)Connector.open((String)("file://localhost/" + this.currDirName));
                e = currDir.list();
                this.frmSelect.addCommand(this.cmdBack);
            }
            String ext = this.getExtension();
            while (e.hasMoreElements()) {
                int len;
                String fileName = (String)e.nextElement();
                if (fileName.charAt((len = fileName.length()) - 1) == '/') {
                    this.frmSelect.append(fileName.substring(0, len - 1), this.imgFolder);
                    continue;
                }
                if (!fileName.endsWith(ext)) continue;
                this.frmSelect.append(fileName, this.imgFile);
            }
            if (currDir != null) {
                currDir.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void enterDir(String newDirName) {
        if (this.currDirName.equals("/")) {
            if (newDirName.equals(UP_DIRECTORY)) {
                return;
            }
            this.currDirName = newDirName;
        } else {
            int i;
            this.currDirName = newDirName.equals(UP_DIRECTORY) ? ((i = this.currDirName.lastIndexOf(47, this.currDirName.length() - 2)) != -1 ? this.currDirName.substring(0, i + 1) : "/") : String.valueOf(this.currDirName) + newDirName;
        }
        this.showDir(this.currDirName);
    }

    protected String getCurrentDirName() {
        return this.currDirName;
    }

    public void commandAction(Command arg0, Displayable arg1) {
        if (arg0 == this.cmdExit) {
            this.exit();
        } else if (arg0 == this.cmdView) {
            final String currFile = this.frmSelect.getString(this.frmSelect.getSelectedIndex());
            new Thread(new Runnable(){

                public void run() {
                    if (currFile.endsWith(FileBrowser.this.getExtension())) {
                        FileBrowser.this.viewFile(currFile);
                    } else if (currFile.equals(FileBrowser.UP_DIRECTORY)) {
                        FileBrowser.this.enterDir(FileBrowser.UP_DIRECTORY);
                    } else {
                        FileBrowser.this.enterDir(String.valueOf(currFile) + "/");
                    }
                }
            }).start();
        } else if (arg0 == this.cmdBack) {
            new Thread(new Runnable(){

                public void run() {
                    FileBrowser.this.enterDir(FileBrowser.UP_DIRECTORY);
                }
            }).start();
        }
    }
}

