/*
 * Decompiled with CFR 0.152.
 */
package game;

import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;

public class HandlerSounds {
    byte _curSound;
    Player[] _libSound;
    byte _maxSounds;
    byte _nbrSounds;

    public HandlerSounds(byte by) {
        this._maxSounds = by;
        this._nbrSounds = 0;
        this._curSound = (byte)-1;
        this._libSound = new Player[this._maxSounds];
    }

    public void clear() {
        this.stopSound();
        byte by = 0;
        while (by < this._nbrSounds) {
            this._libSound[by] = null;
            by = (byte)(by + 1);
        }
        this._nbrSounds = 0;
        System.gc();
    }

    public void delete() {
        this.clear();
        this._libSound = null;
    }

    public byte loadSound(String string, boolean bl) {
        block9: {
            if (this._nbrSounds >= this._maxSounds) {
                System.out.println("Sound Error - Loading Failed !");
                System.out.println("There is no much place for another sound");
                return -1;
            }
            String string2 = "";
            if (string.length() < 5) {
                System.out.println("Sound Error - Loading Failed !");
                System.out.println("Incorrect URL");
                return -1;
            }
            int n = 4;
            while (n > 0) {
                string2 = string2 + string.charAt(string.length() - n);
                --n;
            }
            try {
                if (string2.compareTo(".mid") == 0) {
                    this._libSound[this._nbrSounds] = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream(string), (String)"audio/midi");
                    this._libSound[this._nbrSounds].realize();
                    break block9;
                }
                System.out.println("Sound Error - Loading Failed !");
                System.out.println("Currently Sound class support :");
                System.out.println(".Midi files");
                return -1;
            }
            catch (MediaException mediaException) {
                System.out.println("Sound Error - Loading Failed !");
                mediaException.printStackTrace();
                return -1;
            }
            catch (IOException iOException) {
                System.out.println("Sound Error - Loading Failed !");
                iOException.printStackTrace();
                return -1;
            }
        }
        if (bl) {
            this._libSound[this._nbrSounds].setLoopCount(-1);
        } else {
            this._libSound[this._nbrSounds].setLoopCount(1);
        }
        byte by = this._nbrSounds;
        this._nbrSounds = (byte)(by + 1);
        return by;
    }

    public void startSound(byte by) {
        if (by < 0 || by >= this._nbrSounds || this._libSound[by] == null) {
            return;
        }
        try {
            this._curSound = by;
            this._libSound[by].start();
        }
        catch (MediaException mediaException) {
            System.out.println("Sound Error - Play Failed !");
            mediaException.printStackTrace();
        }
    }

    public void stopSound() {
        if (this._curSound == -1) {
            return;
        }
        try {
            this._libSound[this._curSound].stop();
            this._curSound = (byte)-1;
        }
        catch (MediaException mediaException) {
            System.out.println("Sound Error - Stop Failed !");
            mediaException.printStackTrace();
        }
    }
}

