/*
 * Decompiled with CFR 0.152.
 */
package z;

import javax.microedition.m3g.Group;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.World;
import z.AABB;
import z.AVPartInfo;
import z.AdvanceBB;
import z.CameraWaypoint;
import z.GameEngine;
import z.HumanInfo;
import z.Math3D;
import z.PowerUpInfo;
import z.SniperMIDlet;
import z.Vector3D;

public class AdvanceSceneObject {
    public static final float HumanBBSize = 15.0f;
    public static final CameraWaypoint[][] FINALBOSSESPATH = new CameraWaypoint[][]{{new CameraWaypoint(0.78f, 0.0f, 0.88f, 160.0f, 0.0f, 0), new CameraWaypoint(1.24f, 0.0f, -0.35f, 160.0f, 0.0f, 12000), new CameraWaypoint(1.24f, 0.0f, -0.35f, -94.0f, 0.0f, 12000), new CameraWaypoint(-0.74f, 0.0f, -0.45f, -90.0f, 0.0f, 12000), new CameraWaypoint(-0.74f, 0.0f, -0.45f, 40.0f, 0.0f, 12000), new CameraWaypoint(-0.22f, 0.0f, 0.16f, 40.0f, 0.0f, 12000), new CameraWaypoint(-0.22f, 0.0f, 0.16f, 110.0f, 0.0f, 12000), new CameraWaypoint(1.24f, 0.0f, -0.35f, 110.0f, 0.0f, 12000)}, {new CameraWaypoint(5.05f, 0.0f, -0.76f, -90.0f, 0.0f, 0), new CameraWaypoint(2.24f, 0.0f, -0.77f, -90.0f, 0.0f, 12000), new CameraWaypoint(1.88f, 0.0f, -0.7f, -3.0f, 0.0f, 8000), new CameraWaypoint(1.99f, 0.0f, -0.42f, 90.0f, 0.0f, 8000), new CameraWaypoint(3.57f, 0.0f, -0.44f, 90.0f, 0.0f, 8000), new CameraWaypoint(3.67f, 0.0f, -0.58f, -180.0f, 0.0f, 8000), new CameraWaypoint(3.57f, 0.0f, -0.79f, -90.0f, 0.0f, 8000)}, {new CameraWaypoint(2.2f, 0.0f, -1.21f, -91.0f, 0.0f, 0), new CameraWaypoint(-1.0f, 0.0f, -1.08f, 38.0f, 0.0f, 12000), new CameraWaypoint(-1.0f, 0.0f, -1.08f, 38.0f, 0.0f, 4000), new CameraWaypoint(-0.83f, 0.0f, 0.93f, 133.0f, 0.0f, 12000), new CameraWaypoint(-0.83f, 0.0f, 0.93f, 45.0f, 0.0f, 4000), new CameraWaypoint(1.19f, 0.0f, 0.91f, -126.0f, 0.0f, 12000), new CameraWaypoint(1.19f, 0.0f, 0.91f, -146.0f, 0.0f, 4000), new CameraWaypoint(1.2f, 0.0f, -1.17f, -1.0f, 0.0f, 12000), new CameraWaypoint(1.2f, 0.0f, -1.17f, -1.0f, 0.0f, 12000)}, {new CameraWaypoint(-3.26f, 0.12f, -0.48f, 90.0f, 0.0f, 0), new CameraWaypoint(-3.26f, 0.8f, -0.73f, 90.0f, 0.0f, 8000), new CameraWaypoint(-0.85f, 0.49f, -0.77f, 90.0f, 0.0f, 12000), new CameraWaypoint(-0.85f, 0.49f, -0.77f, 135.0f, 0.0f, 12000), new CameraWaypoint(0.37f, 1.7f, -2.45f, -20.0f, 0.0f, 8000), new CameraWaypoint(0.52f, 0.84f, -2.5f, 16.0f, 0.0f, 8000), new CameraWaypoint(-0.6f, 0.47f, -2.18f, 60.0f, 0.0f, 12000), new CameraWaypoint(-1.22f, 0.84f, -1.6f, 85.0f, 0.0f, 12000), new CameraWaypoint(-1.22f, 0.84f, -1.6f, 85.0f, 0.0f, 12000)}};
    public static final int _First_Valid_Category_ = 0;
    public static final int _Building_Category_ = 0;
    public static final int _Human_Category_ = 1;
    public static final int _PowerUp_Category_ = 2;
    public static final int _ArmoredVehicle_Category_ = 3;
    public static final int _Vehicle_Category_ = 4;
    public static final int _Others_Category_ = 5;
    public static final int _Last_Valid_Category_ = 5;
    public static final int _First_Valid_Building_Type_ = 10;
    public static final int _Building_A_Type_ = 10;
    public static final int _Building_B_Type_ = 11;
    public static final int _Building_C_Type_ = 12;
    public static final int _Building_D_Type_ = 13;
    public static final int _Building_E_Type_ = 14;
    public static final int _Building_F_Type_ = 15;
    public static final int _Last_Valid_Building_Type_ = 15;
    public static final int _Firts_Valid_Vehicle_Type_ = 20;
    public static final int _Vehicle_Car_Type_ = 20;
    public static final int _Vehicle_Bus_Type_ = 21;
    public static final int _Last_Valid_Vehicle_Type_ = 21;
    public static final int _First_Valid_AV_Type_ = 30;
    public static final int _AV_A_Type_ = 30;
    public static final int _AV_B_Type_ = 31;
    public static final int _AV_C_Type_ = 32;
    public static final int _AV_D_Type_ = 33;
    public static final int _Last_Valid_AV_Type_ = 33;
    public static final int _First_Valid_Human_Type_ = 50;
    public static final int _Human_Innocent_Type_ = 50;
    public static final int _Human_Terrorist1_Type_ = 51;
    public static final int _Human_Terrorist2_Type_ = 52;
    public static final int _Human_Terrorist3_Type_ = 53;
    public static final int _Human_FinalBoss_Type_ = 54;
    public static final int _Last_Valid_Human_Type_ = 54;
    public static final int _First_Valid_PWRUP_Type_ = 60;
    public static final int _PWRUP_ExtraLife_Type_ = 60;
    public static final int _PWRUP_Boom_Type_ = 61;
    public static final int _PWRUP_BulletProofVest_Type_ = 62;
    public static final int _PWRUP_SpecialBullets_Type_ = 63;
    public static final int _Last_Valid_PWRUP_Type_ = 63;
    public static final int _First_Valid_AVExtremity_Type_ = 70;
    public static final int _AVExtremity_Body_Type_ = 70;
    public static final int _AVExtremity_WeaponBase_Type_ = 71;
    public static final int _AVExtremity_HeavyWeapon_Type_ = 72;
    public static final int _AVExtremity_LightWeapon_Type_ = 73;
    public static final int _Last_Valid_AVExtremity_Type_ = 73;
    public static final byte _BUILDING_Mesh_ID_ = 29;
    public static final byte _PARK_Mesh_ID_ = 24;
    public static final byte _BUS_Mesh_ID_ = 19;
    public static final int _TANK_Body_Mesh_ID_ = 54;
    public static final int _TANK_Weapon_Base_ID_ = 56;
    public static final int _TANK_Weapon0_Mesh_ID_ = 58;
    public static final int _TANK_Weapon1_Mesh_ID_ = 60;
    public static final int _TANK_Weapon2_Mesh_ID_ = 62;
    public static final int _TANK_Weapon3_Mesh_ID_ = 64;
    public static final int _HUMMER_Body_Mesh_ID_ = 47;
    public static final int _HUMMER_Weapon0_Mesh_ID_ = 49;
    public static final int _HUMMER_Weapon1_Mesh_ID_ = 51;
    public static final int _HUMMER_Weapon2_Base_ID_ = 53;
    public static final int _HUMMER_Weapon2_Mesh_ID_ = 55;
    public static final int _ROBOT_Body_Mesh_ID_ = 54;
    public static final int _ROBOT_Weapon_Base_ID_ = 56;
    public static final int _ROBOT_Weapon0_Mesh_ID_ = 58;
    public static final int _ROBOT_Weapon1_Mesh_ID_ = 60;
    public static final int _ROBOT_Weapon2_Mesh_ID_ = 62;
    public static final int _ROBOT_Weapon3_Mesh_ID_ = 64;
    public static final int _HOVERCRAFT_Body_Mesh_ID_ = 54;
    public static final int _HOVERCRAFT_Weapon_Base_ID_ = 60;
    public static final int _HOVERCRAFT_Weapon0_Mesh_ID_ = 58;
    public static final int _HOVERCRAFT_Weapon1_Mesh_ID_ = 56;
    public static final int _HOVERCRAFT_Weapon2_Mesh_ID_ = 62;
    public static final int _HOVERCRAFT_Weapon3_Mesh_ID_ = 64;
    private static final int _WEAPON_LIFE_ = 2;
    private int id;
    private int positionIndex;
    protected int category;
    protected int subCategory;
    private float objectScale;
    protected float actHeading;
    private float headDeg;
    protected Vector3D position;
    protected AdvanceBB billboard;
    protected Group camGroup;
    protected World worldRef;
    protected Mesh[] objectMeshes;
    protected AABB[] bboxes;
    protected CameraWaypoint[] waypoints;
    protected long initMovementTime;
    protected long movementTime;
    protected int actualWaypoint;
    protected int nextWaypoint;
    protected int initLoop;
    protected boolean specialRoute;
    protected int incr;
    protected AdvanceSceneObject nextLinked;
    protected AdvanceSceneObject prevLinked;

    public AdvanceSceneObject(int objectId) {
        this.id = objectId;
    }

    public final void dropElement() {
        this.nextLinked = null;
        this.prevLinked = null;
        this.waypoints = null;
        this.bboxes = null;
        this.billboard = null;
        this.camGroup = null;
        this.worldRef = null;
        this.objectMeshes = null;
        System.gc();
    }

    public final void setPositionIndex(int index) {
        this.positionIndex = index;
    }

    public final int getPositionIndex() {
        return this.positionIndex;
    }

    public final boolean hasASpecialRoute() {
        return this.specialRoute;
    }

    public final void setSpecialRoute(boolean aValue) {
        this.specialRoute = aValue;
        this.incr = 1;
    }

    public final void initSceneObject(int objectCategory, int objectSubcategory, float x, float y, float z, float scale, float heading, Group cameraGroup, World scene) {
        this.category = objectCategory;
        this.subCategory = objectSubcategory;
        this.objectScale = scale;
        this.actHeading = heading;
        this.camGroup = cameraGroup;
        this.worldRef = scene;
        if (this.category == 1) {
            y -= 1.875f;
        }
        this.position = new Vector3D(x, y, z);
        this.makeObjectGeometry();
    }

    public final void addObjectToScene(World scene) {
        for (int i = 0; i < this.objectMeshes.length; ++i) {
            scene.addChild((Node)this.objectMeshes[i]);
        }
    }

    public final void removeObjectFromScene() {
        if (this.category == 3) {
            return;
        }
        for (int i = 0; i < this.objectMeshes.length; ++i) {
            SniperMIDlet.setOtherAttributes(false, false, this.objectMeshes[i]);
        }
    }

    public final void removeFinalBossFromScene() {
        for (int i = 0; i < this.objectMeshes.length; ++i) {
            SniperMIDlet.setOtherAttributes(false, false, this.objectMeshes[i]);
        }
    }

    public final void updateBillBoardAnimation() {
        this.billboard.update(GameEngine.getGameTime());
    }

    private final void resetPowerUpAnimation() {
        this.billboard.setFrameToShow(0);
        this.billboard.setVisible(true);
    }

    public final void desactivateBillBoard() {
        this.billboard.setVisible(false);
        this.billboard.resetAnimationAttributes();
        SniperMIDlet.setOtherAttributes(false, false, this.objectMeshes[0]);
    }

    public final Vector3D getPos() {
        return this.position;
    }

    private final int getLimit() {
        if (this.specialRoute) {
            switch (this.incr) {
                case 1: {
                    return this.waypoints.length - 1;
                }
                case -1: {
                    return this.initLoop;
                }
            }
            return this.waypoints.length - 1;
        }
        return this.waypoints.length - 1;
    }

    private final void changeIncr() {
        this.incr = this.specialRoute ? (this.incr *= -1) : 1;
    }

    private final void determineNextPoint() {
        if (this.specialRoute) {
            switch (this.incr) {
                case 1: {
                    this.nextWaypoint = this.waypoints.length - 1 - 1;
                    break;
                }
                case -1: {
                    this.nextWaypoint = 1;
                }
            }
        } else {
            this.nextWaypoint = this.initLoop;
        }
    }

    public final void move() {
        Transform trans = new Transform();
        this.headDeg += 0.1f;
        long actualT = GameEngine.getGameTime();
        long elapsedTime = actualT - this.initMovementTime;
        float coef = (float)elapsedTime * 1.0f / ((float)this.movementTime * 1.0f);
        if (coef >= 1.0f) {
            this.actualWaypoint = this.nextWaypoint;
            if (this.nextWaypoint == this.getLimit()) {
                this.determineNextPoint();
                this.changeIncr();
                this.initMovementTime = this.category == 4 ? actualT + (long)Math3D.getRandNumber(3000, 10000) : actualT;
            } else {
                this.initMovementTime = actualT;
                this.nextWaypoint += this.incr;
            }
            this.movementTime = this.waypoints[this.nextWaypoint].getTime();
            coef = 0.0f;
        }
        for (int i = 0; i < this.objectMeshes.length; ++i) {
            SniperMIDlet.adjustModelPosition(-this.position.getX(), -this.position.getY(), -this.position.getZ(), this.objectScale, -this.actHeading, this.objectMeshes[i]);
        }
        this.position.setX(Math3D.linearInterpolation(this.waypoints[this.actualWaypoint].getX(), this.waypoints[this.nextWaypoint].getX(), coef));
        if (this.category == 3 && this.subCategory == 33) {
            float yDesp = (float)Math.sin(this.headDeg) / 50.0f;
            this.position.setY(Math3D.linearInterpolation(this.waypoints[this.actualWaypoint].getY(), this.waypoints[this.nextWaypoint].getY(), coef) + yDesp);
        } else {
            this.position.setY(Math3D.linearInterpolation(this.waypoints[this.actualWaypoint].getY(), this.waypoints[this.nextWaypoint].getY(), coef));
        }
        this.position.setZ(Math3D.linearInterpolation(this.waypoints[this.actualWaypoint].getZ(), this.waypoints[this.nextWaypoint].getZ(), coef));
        this.actHeading = Math3D.linearInterpolation(this.waypoints[this.actualWaypoint].getHeadingAngle(), this.waypoints[this.nextWaypoint].getHeadingAngle(), coef);
        this.applyTransformationsToTheObject();
    }

    private final void applyTransformationsToTheObject() {
        for (int i = 0; i < this.objectMeshes.length; ++i) {
            SniperMIDlet.adjustModelPosition(this.position.getX(), this.position.getY(), this.position.getZ(), this.objectScale, this.actHeading, this.objectMeshes[i]);
        }
    }

    public final AABB getBoundingBox(int i) {
        return this.bboxes[i];
    }

    public final int getObjectId() {
        return this.id;
    }

    public final int getObjectCategory() {
        return this.category;
    }

    public final int getObjectSubCategory() {
        return this.subCategory;
    }

    public final void setRenderingAttribute(boolean value) {
        for (int i = 0; i < this.objectMeshes.length; ++i) {
            this.objectMeshes[i].setRenderingEnable(value);
        }
    }

    private final void allocateMemory(int size) {
        if (size > 0) {
            if (this.objectMeshes == null) {
                this.objectMeshes = new Mesh[size];
                switch (this.category) {
                    case 1: 
                    case 2: 
                    case 3: {
                        this.bboxes = new AABB[size];
                        break;
                    }
                    default: {
                        this.bboxes = null;
                        break;
                    }
                }
            } else if (size != this.objectMeshes.length) {
                this.bboxes = null;
                this.objectMeshes = null;
                this.objectMeshes = new Mesh[size];
                switch (this.category) {
                    case 1: 
                    case 2: 
                    case 3: {
                        this.bboxes = new AABB[size];
                        break;
                    }
                    default: {
                        this.bboxes = null;
                    }
                }
            }
        }
    }

    private final void makeObjectGeometry() {
        switch (this.category) {
            case 3: {
                this.generateAVGeometry();
                break;
            }
            case 4: {
                break;
            }
            case 1: {
                this.generateHumanGeometry();
                break;
            }
            case 2: {
                this.generatePowerUpGeometry();
                break;
            }
        }
    }

    private final void generateAVGeometry() {
        this.incr = 1;
        this.specialRoute = false;
        switch (this.subCategory) {
            case 30: {
                int[] avParts = new int[]{70, 71, 72, 73, 73};
                this.objectMeshes = GameEngine.bossModel;
                this.bboxes = new AABB[this.objectMeshes.length];
                int weaponIndex = 0;
                for (int i = 0; i < this.objectMeshes.length; ++i) {
                    SniperMIDlet.adjustModelPosition(this.position.getX(), this.position.getY(), this.position.getZ(), this.objectScale, this.actHeading, this.objectMeshes[i]);
                    SniperMIDlet.setOtherAttributes(true, true, this.objectMeshes[i]);
                    if (avParts[i] == 72 || avParts[i] == 73) {
                        if (avParts[i] == 72) {
                            this.objectMeshes[i].setUserObject((Object)new AVPartInfo(this.id, avParts[i], 4, weaponIndex));
                        } else {
                            this.objectMeshes[i].setUserObject((Object)new AVPartInfo(this.id, avParts[i], 2, weaponIndex));
                        }
                        ++weaponIndex;
                    } else {
                        this.objectMeshes[i].setUserObject((Object)new AVPartInfo(this.id, avParts[i], 2, -1));
                    }
                    this.bboxes[i] = AABB.generateAABB(this.objectMeshes[i], this.position.getX(), this.position.getY(), this.position.getZ(), this.actHeading);
                }
                break;
            }
            case 31: {
                int[] avParts = new int[]{70, 71, 72, 72, 73, 72};
                this.objectMeshes = GameEngine.bossModel;
                this.bboxes = new AABB[this.objectMeshes.length];
                int weaponIndex = 0;
                for (int i = 0; i < this.objectMeshes.length; ++i) {
                    SniperMIDlet.adjustModelPosition(this.position.getX(), this.position.getY(), this.position.getZ(), this.objectScale, this.actHeading, this.objectMeshes[i]);
                    SniperMIDlet.setOtherAttributes(true, true, this.objectMeshes[i]);
                    if (avParts[i] == 72 || avParts[i] == 73) {
                        if (avParts[i] == 72) {
                            this.objectMeshes[i].setUserObject((Object)new AVPartInfo(this.id, avParts[i], 4, weaponIndex));
                        } else {
                            this.objectMeshes[i].setUserObject((Object)new AVPartInfo(this.id, avParts[i], 2, weaponIndex));
                        }
                        ++weaponIndex;
                    } else {
                        this.objectMeshes[i].setUserObject((Object)new AVPartInfo(this.id, avParts[i], 2, -1));
                    }
                    this.bboxes[i] = AABB.generateAABB(this.objectMeshes[i], this.position.getX(), this.position.getY(), this.position.getZ(), this.actHeading);
                }
                break;
            }
            case 32: {
                int[] avParts = new int[]{70, 71, 73, 73, 72, 72};
                this.objectMeshes = GameEngine.bossModel;
                this.bboxes = new AABB[this.objectMeshes.length];
                int weaponIndex = 0;
                for (int i = 0; i < this.objectMeshes.length; ++i) {
                    SniperMIDlet.adjustModelPosition(this.position.getX(), this.position.getY(), this.position.getZ(), this.objectScale, this.actHeading, this.objectMeshes[i]);
                    SniperMIDlet.setOtherAttributes(true, true, this.objectMeshes[i]);
                    if (avParts[i] == 72 || avParts[i] == 73) {
                        if (avParts[i] == 72) {
                            this.objectMeshes[i].setUserObject((Object)new AVPartInfo(this.id, avParts[i], 4, weaponIndex));
                        } else {
                            this.objectMeshes[i].setUserObject((Object)new AVPartInfo(this.id, avParts[i], 2, weaponIndex));
                        }
                        ++weaponIndex;
                    } else {
                        this.objectMeshes[i].setUserObject((Object)new AVPartInfo(this.id, avParts[i], 2, -1));
                    }
                    this.bboxes[i] = AABB.generateAABB(this.objectMeshes[i], this.position.getX(), this.position.getY(), this.position.getZ(), this.actHeading);
                }
                break;
            }
            case 33: {
                int[] avParts = new int[]{70, 71, 73, 73, 72, 72};
                this.objectMeshes = GameEngine.bossModel;
                this.bboxes = new AABB[this.objectMeshes.length];
                int weaponIndex = 0;
                for (int i = 0; i < this.objectMeshes.length; ++i) {
                    SniperMIDlet.adjustModelPosition(this.position.getX(), this.position.getY(), this.position.getZ(), this.objectScale, this.actHeading, this.objectMeshes[i]);
                    SniperMIDlet.setOtherAttributes(true, true, this.objectMeshes[i]);
                    if (avParts[i] == 72 || avParts[i] == 73) {
                        if (avParts[i] == 72) {
                            this.objectMeshes[i].setUserObject((Object)new AVPartInfo(this.id, avParts[i], 4, weaponIndex));
                        } else {
                            this.objectMeshes[i].setUserObject((Object)new AVPartInfo(this.id, avParts[i], 2, weaponIndex));
                        }
                        ++weaponIndex;
                    } else {
                        this.objectMeshes[i].setUserObject((Object)new AVPartInfo(this.id, avParts[i], 2, -1));
                    }
                    this.bboxes[i] = AABB.generateAABB(this.objectMeshes[i], this.position.getX(), this.position.getY(), this.position.getZ(), this.actHeading);
                }
                break;
            }
        }
    }

    public final void setTrafficMovementAttributes(CameraWaypoint[] path, int initLoopIndex) {
        this.waypoints = path;
        this.initLoop = initLoopIndex;
        this.actualWaypoint = 0;
        this.nextWaypoint = 1;
        this.initMovementTime = GameEngine.getGameTime();
    }

    private final void generateVehicleGeometry() {
        switch (this.subCategory) {
            case 21: {
                this.allocateMemory(1);
                this.objectMeshes[0] = SniperMIDlet.loadComplexModel("/x/mesh_bus.m3g", 19);
                SniperMIDlet.adjustModelPosition(this.position.getX(), this.position.getY(), this.position.getZ(), this.objectScale, this.actHeading, this.objectMeshes[0]);
                SniperMIDlet.setOtherAttributes(true, true, this.objectMeshes[0]);
                this.worldRef.addChild((Node)this.objectMeshes[0]);
                break;
            }
        }
    }

    public final void removeTrafficFromScene() {
        SniperMIDlet.setOtherAttributes(false, false, this.objectMeshes[0]);
        this.worldRef.removeChild((Node)this.objectMeshes[0]);
    }

    private final void generateHumanGeometry() {
        this.allocateMemory(1);
        boolean shootable = true;
        boolean animated = true;
        switch (this.subCategory) {
            case 50: {
                this.billboard = new AdvanceBB(GameEngine.textureUnits[0], this.camGroup, 15.0f, 0.5f, shootable);
                this.objectMeshes[0] = this.billboard.getAdvanceBBMesh();
                this.objectMeshes[0].setUserObject((Object)new HumanInfo(this.id, 50));
                break;
            }
            case 51: {
                this.billboard = new AdvanceBB(GameEngine.textureUnits[1], this.camGroup, 15.0f, 0.5f, shootable);
                this.objectMeshes[0] = this.billboard.getAdvanceBBMesh();
                this.objectMeshes[0].setUserObject((Object)new HumanInfo(this.id, 51));
                break;
            }
            case 52: {
                this.billboard = new AdvanceBB(GameEngine.textureUnits[2], this.camGroup, 15.0f, 0.5f, shootable);
                this.objectMeshes[0] = this.billboard.getAdvanceBBMesh();
                this.objectMeshes[0].setUserObject((Object)new HumanInfo(this.id, 52));
                break;
            }
            case 53: {
                this.billboard = new AdvanceBB(GameEngine.textureUnits[3], this.camGroup, 15.0f, 0.5f, shootable);
                this.objectMeshes[0] = this.billboard.getAdvanceBBMesh();
                this.objectMeshes[0].setUserObject((Object)new HumanInfo(this.id, 53));
                break;
            }
        }
        this.billboard.setPosition(this.position.getX(), this.position.getY(), this.position.getZ());
        this.bboxes[0] = AABB.generateAABB(this.objectMeshes[0], this.position.getX(), this.position.getY() + this.billboard.getScale(), this.position.getZ(), this.actHeading);
        this.worldRef.addChild((Node)this.objectMeshes[0]);
    }

    private final void generatePowerUpGeometry() {
        this.allocateMemory(1);
        boolean animated = false;
        boolean shootable = true;
        float size = 5.0f;
        switch (this.subCategory) {
            case 61: {
                this.billboard = new AdvanceBB(GameEngine.textureUnits[9], this.camGroup, size, 1.0f, shootable);
                this.objectMeshes[0] = this.billboard.getAdvanceBBMesh();
                this.objectMeshes[0].setUserObject((Object)new PowerUpInfo(this.id));
                break;
            }
            case 62: {
                this.billboard = new AdvanceBB(GameEngine.textureUnits[10], this.camGroup, size, 1.0f, shootable);
                this.objectMeshes[0] = this.billboard.getAdvanceBBMesh();
                this.objectMeshes[0].setUserObject((Object)new PowerUpInfo(this.id));
                break;
            }
            case 60: {
                this.billboard = new AdvanceBB(GameEngine.textureUnits[7], this.camGroup, size, 1.0f, shootable);
                this.objectMeshes[0] = this.billboard.getAdvanceBBMesh();
                this.objectMeshes[0].setUserObject((Object)new PowerUpInfo(this.id));
                break;
            }
            case 63: {
                this.billboard = new AdvanceBB(GameEngine.textureUnits[8], this.camGroup, size, 1.0f, shootable);
                this.objectMeshes[0] = this.billboard.getAdvanceBBMesh();
                this.objectMeshes[0].setUserObject((Object)new PowerUpInfo(this.id));
                break;
            }
        }
        this.resetPowerUpAnimation();
        this.billboard.setPosition(this.position.getX(), this.position.getY(), this.position.getZ());
        this.bboxes[0] = AABB.generateAABB(this.objectMeshes[0], this.position.getX(), this.position.getY() + this.billboard.getScale(), this.position.getZ(), this.actHeading);
        this.worldRef.addChild((Node)this.objectMeshes[0]);
    }

    public final AdvanceBB getAnimatedBillboard() {
        return this.billboard;
    }

    public static final float[][] getBuildingBorder(AABB box) {
        float deltaX = Math.abs(box.getMax().getX() - box.getMin().getX());
        float deltaZ = Math.abs(box.getMax().getZ() - box.getMin().getZ());
        float centerX = 0.0f;
        float centerY = 0.0f;
        float centerZ = 0.0f;
        float borderSeparation = 0.05f;
        float gapX = deltaX / 2.0f;
        float gapZ = deltaZ / 2.0f;
        gapX -= borderSeparation;
        gapZ -= borderSeparation;
        float[][] pos = new float[4][3];
        for (int i = 0; i < 4; ++i) {
            switch (i) {
                case 0: {
                    pos[i][0] = centerX - gapX;
                    pos[i][2] = centerZ - gapZ;
                    break;
                }
                case 1: {
                    pos[i][0] = centerX - gapX;
                    pos[i][2] = centerZ + gapZ;
                    break;
                }
                case 2: {
                    pos[i][0] = centerX + gapX;
                    pos[i][2] = centerZ - gapZ;
                    break;
                }
                case 3: {
                    pos[i][0] = centerX + gapX;
                    pos[i][2] = centerZ + gapZ;
                }
            }
            pos[i][1] = 0.0f;
        }
        return pos;
    }

    public final AdvanceSceneObject getNextLinked() {
        return this.nextLinked;
    }

    public final AdvanceSceneObject getPrevLinked() {
        return this.prevLinked;
    }

    public final void setNextLinked(AdvanceSceneObject aNextLinked) {
        this.nextLinked = aNextLinked;
    }

    public final void setPrevLinked(AdvanceSceneObject aPrevLinked) {
        this.prevLinked = aPrevLinked;
    }
}

