/*
 * Decompiled with CFR 0.152.
 */
package z;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Sprite3D;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.World;
import z.Console;
import z.GameEngine;
import z.Input;
import z.LoadingCanvas;
import z.Math3D;
import z.MenuCanvas;
import z.Resources;
import z.SniperMIDlet;
import z.SpriteObject;

public class SniperCanvas
extends GameCanvas
implements Runnable {
    public static final int[] Cheating_GodMode = new int[]{16384, 32768, 32, 32768};
    public static final int[] Cheating_UnlockAll = new int[]{16384, 32768, 128, 32768};
    public static final int[] Cheating_PassSubstage = new int[]{16384, 32768, 16, 32768};
    public static final boolean ENABLE_BLOOD = false;
    public static final boolean ENABLE_HAND = true;
    private static final int STRONG_RENDERING_HITS = 14;
    private static final int WEAK_RENDERING_HITS = 0;
    public static final int RENDERING_HITS = 0;
    public static final int TOPLEFT_LAYOUT = 20;
    public static final int CENTER_LAYOUT = 3;
    public static final long SLEEP_TIME = 60L;
    public static final int DEVICEWRES = 240;
    public static final int DEVICEHRES = 320;
    public static final int UP_FRAME_H = 48;
    public static final int DOWN_FRAME_H = 48;
    public static final int X_CENTER_SCOPE = 120;
    public static final int Y_CENTER_SCOPE = 160;
    private static final int[][][] HEAVY_WEAPON = new int[][][]{new int[][]{{46, 44}, {110, 29}, {46, 78}, {110, 79}}, new int[][]{{65, 38}, {44, 27}, {44, 50}, {121, 31}, {109, 27}, {133, 27}, {43, 79}, {65, 84}, {108, 79}, {132, 80}}, new int[][]{{48, 35}, {48, 54}, {105, 89}, {123, 89}}, new int[][]{{34, 21}, {33, 57}, {88, 30}, {122, 30}, {34, 82}, {88, 82}, {122, 82}}};
    private static final int[][][] LIGHT_WEAPON = new int[][][]{new int[][]{{64, 38}, {64, 51}, {103, 30}, {118, 30}, {64, 79}, {103, 79}, {118, 79}}, new int[][]{{39, 39}, {120, 22}, {38, 75}, {119, 75}}, new int[][]{{28, 29}, {28, 60}, {28, 83}, {100, 83}, {127, 83}}, new int[][]{{37, 28}, {37, 49}, {96, 17}, {115, 17}, {37, 69}, {96, 68}, {116, 68}}};
    public static final int ASPECT_CTE = 1000;
    public static final int V_ASPECTRATIO = 1538;
    public static final int H_ASPECTRATIO = 1363;
    public static final int WORLDWINPOSX = 0;
    public static final int WORLDWINPOSY = 48;
    public static final int WORLDWINRESX = 240;
    public static final int WORLDWINRESY = 224;
    public static final int WORLDWINCENTERX = 120;
    public static final int WORLDWINCENTERY = 112;
    public static final int _HumanBody_W_ = 27;
    public static final int _HumanBody_H_ = 41;
    public static final int _HumanBody_X_Pos_ = 5;
    public static final int _HumanBody_Y_Pos_ = 274;
    public static final int _MESSAGEFRAME_W_ = 124;
    public static final int _MESSAGEFRAME_H_ = 78;
    public static final int _MESSAGEFRAME_X_ = 58;
    public static final int _MESSAGEFRAME_Y_ = 121;
    private static final int _SELECT_CURSOR_X_ = 70;
    private static final int _SELECT_CURSOR_Y_ = 133;
    private static final int _FIRST_OPTION_X_ = 86;
    private static final int _FIRST_OPTION_Y_ = 133;
    private static final int _OPTION_GAP_ = 14;
    public static final int _Interlace_Image_W_ = 144;
    public static final int _Interlace_Image_H_ = 138;
    public static final short CROSS_HAIR_R = 0;
    public static final int CURSOR_MIN_X = 0;
    public static final int CURSOR_MIN_Y = 48;
    public static final int CURSOR_MAX_X = 240;
    public static final int CURSOR_MAX_Y = 272;
    public static final int CURSOR_INIT_X = 120;
    public static final int CURSOR_INIT_Y = 160;
    public static final short CLP_LIFES_X = 14;
    public static final short CLP_LIFES_Y = 1;
    public static final short CLP_LIFES_W = 29;
    public static final short CLP_LIFES_H = 16;
    public static final short CLP_POINTS_X = 0;
    public static final short CLP_POINTS_Y = 0;
    public static final short CLP_POINTS_W = 68;
    public static final short CLP_POINTS_H = 16;
    public static final short CLP_ENEMIES_X = 146;
    public static final short CLP_ENEMIES_Y = 1;
    public static final short CLP_ENEMIES_W = 22;
    public static final short CLP_ENEMIES_H = 16;
    public static final int DEFAULT_BULLET_SIZE = 10;
    private static final int MAGAZINE_X_POS = 189;
    private static final int MAGAZINE_Y_POS = 255;
    private static final int FIRST_BULLET_X_POS = 192;
    private static final int FIRST_BULLET_Y_POS = 256;
    private static final byte BULLET_Y_DIF = 5;
    private static final byte MAX_Y_OFFSET = 3;
    private static final byte MAX_X_OFFSET = 3;
    public static final byte _First_Valid_Canvas_Mode_ = 0;
    public static final byte _Canvas_InPause_ = 0;
    public static final byte _Canvas_FadeIn_ = 1;
    public static final byte _Canvas_Deploying_Banners_ = 2;
    public static final byte _Canvas_Playing_ = 3;
    public static final byte _Canvas_Removing_Banners_ = 4;
    public static final byte _Canvas_FadeOut_ = 5;
    public static final byte _Last_Valid_Canvas_Mode_ = 5;
    public byte pauseMenuStatus = 0;
    public static final byte PauseStatus_Pause = 0;
    public static final byte PauseStatus_Help = 1;
    public static final byte PauseStatus_ConfirmExit = 2;
    public int helpTextScroll;
    private static final int _Time_FADES_ = 500;
    private static final int _Time_BANNERS_ = 2000;
    public static final byte CROSSHAIR_SIZE = 4;
    public static final int TEXT_Y_GAP = 10;
    public static final int POINTS_X_POS = 52;
    public static final int POINTS_Y_POS = 3;
    public static final int LIFE_X_POS = 14;
    public static final int LIFE_Y_POS = 0;
    public static final int MGZN_X_POS = 0;
    public static final int MGZN_Y_POS = 10;
    public static final int TIME_X_POS = 0;
    public static final int TIME_Y_POS = 0;
    public static final int BULLETS_X_POS = 149;
    public static final int BULLETS_Y_POS = 168;
    public static final int BULLETS_DIF_X = 3;
    public static final int BULLETS_DIF_Y = 7;
    public static final short IZ_INIT_X_POS = 4;
    public static final short IZ_INIT_Y_POS = 169;
    public static final int _PWR_BAR_X_ = 193;
    public static final int _PWR_BAR_Y_ = 2;
    public static final short _BulletHole_W_ = 36;
    public static final short _BulletHole_H_ = 33;
    public static final int BACKGROUND_COLOR = -16777216;
    public static final int LETTER_COLOR = -1;
    public static final int CROSSHAIR_COLOR = -65536;
    private boolean running;
    private boolean initTimes;
    private Graphics3D iG3D;
    private long tInitStateTime;
    private int yBanner;
    private int xOffset;
    private SniperMIDlet midletRef;
    private GameEngine gameEngine;
    private Graphics aux;
    private byte canvasMode;
    private int cursorXOffest;
    private int cursorYOffset;
    private int introBossW;
    private int introBossH;
    private int introBossX;
    private int introBossY;
    private int bulletVerticalOffset;
    private int bulletHorizontalOffset;
    private Image iScope;
    private Image iHand;
    private Image iCameraView;
    private Image iWall;
    private Image iUpBanner;
    private Image iBullet;
    private Image iCursor;
    private Image iImpactZones;
    private Image iBulletHole;
    private Image iBlood;
    private Image iPwrUpSpecialBullets;
    private Image iPwrUpBulletProofVest;
    private Image iMagazine;
    private Image iSpecialBulletHead;
    private Image iHumanBody;
    private Image iFade;
    private Image iFrame;
    private Image iBossBlueprint;
    private Image iPrimaryWeapon;
    private Image iSecondaryWeapon;
    private Image iIconBack;
    private Image iSelectionCursor;
    private SpriteObject bodyImpacts;
    private SpriteObject bullets;
    private long currentTime;
    private boolean firstTime;
    private boolean playBulletAnimation;
    private boolean moveBullets;
    private boolean resourcesLoaded = false;
    private int visible = 0;
    private LoadingCanvas loadingCanvas;
    Background m_background;
    public static int KEY_CODE;
    long lastTime = 0L;
    long startTime = 0L;
    public static int elapsedTime;
    public static int aimTick;
    private int breatheTick;
    private int breatheOffsetX;
    private int breatheOffsetY;
    private int breatheDir = 1;
    private int handFrameIndex;

    public SniperCanvas(SniperMIDlet midlet, GameEngine engine, LoadingCanvas lCanvas) {
        super(false);
        this.setFullScreenMode(true);
        this.midletRef = midlet;
        this.loadingCanvas = lCanvas;
        this.gameEngine = engine;
        this.firstTime = true;
        this.build3DWorldOutputWindow();
        this.iG3D = Graphics3D.getInstance();
        this.m_background = new Background();
        this.m_background.setColor(-6573607);
        this.m_background.setColorClearEnable(true);
        this.m_background.setDepthClearEnable(true);
        this.gameEngine.getWorld().setBackground(this.m_background);
        this.buildWall();
        this.loadingCanvas.udpateActualStep();
        this.loadImagesResources();
        this.loadingCanvas.udpateActualStep();
        this.resourcesLoaded = true;
        this.yBanner = -48;
        this.buildFadeOutImage(240, 224, 255);
        this.initTimes = true;
    }

    private void loadImagesResources() {
        this.iScope = Resources.loadImage("/x/scope.png");
        this.iBulletHole = Resources.loadImage("/x/bullethole.png");
        this.iBullet = Resources.loadImage("/x/bullets.png");
        this.bullets = new SpriteObject(this.iBullet);
        this.bullets.initBulletsSprites();
        this.iMagazine = Resources.loadImage("/x/magazine.png");
        this.iCursor = Resources.loadImage("/x/cursor.png");
        this.iImpactZones = Resources.loadImage("/x/impactZones.png");
        this.iHand = Resources.loadImage("/x/hand.png");
        this.iUpBanner = Resources.loadImage("/x/upBanner.png");
        this.iSpecialBulletHead = Resources.loadImage("/x/specialBulletHead.png");
        this.iHumanBody = Resources.loadImage("/x/humanBody.png");
        this.iPwrUpBulletProofVest = Resources.loadImage("/x/iconBulletProofVest.png");
        this.iPwrUpSpecialBullets = Resources.loadImage("/x/iconBullets.png");
        this.iSelectionCursor = Resources.loadImage("/x/menuCursor.png");
        this.iFrame = Resources.loadImage("/x/messageFrame.png");
        this.iIconBack = Resources.loadImage("/x/iconBack.png");
        this.bodyImpacts = new SpriteObject(this.iImpactZones);
        this.bodyImpacts.initImpactZonesSprites((short)5, (short)274);
        this.cursorXOffest = this.iCursor.getWidth() / 2;
        this.cursorYOffset = this.iCursor.getHeight() / 2;
        System.gc();
    }

    public void pauseGame() {
        SniperMIDlet.setInitPauseTime(GameEngine.gameTime);
        this.setCanvasMode((byte)0);
        SniperMIDlet.inPause = true;
    }

    public final void hideNotify() {
        Input.InitKey();
        this.pauseGame();
    }

    public final void setCanvasMode(byte state) {
        this.canvasMode = state;
    }

    public final byte getActualCanvasMode() {
        return this.canvasMode;
    }

    public final void showNotify() {
        SniperMIDlet.inPause = false;
    }

    private void unloadImageResources() {
        this.iScope = null;
        this.iCameraView = null;
        this.iWall = null;
        this.iSpecialBulletHead = null;
        this.iUpBanner = null;
        this.iBullet = null;
        this.iCursor = null;
        this.iImpactZones = null;
        this.iHand = null;
        this.iBulletHole = null;
        this.iPwrUpSpecialBullets = null;
        this.iPwrUpBulletProofVest = null;
        this.iMagazine = null;
        this.iSelectionCursor = null;
        this.iHumanBody = null;
        this.iFade = null;
        this.iFrame = null;
        this.iPrimaryWeapon = null;
        this.iSecondaryWeapon = null;
        this.iBossBlueprint = null;
        this.iIconBack = null;
        this.bullets = null;
        this.bodyImpacts = null;
        this.midletRef = null;
        this.gameEngine = null;
        this.aux = null;
        this.loadingCanvas = null;
        this.iG3D = null;
        SniperMIDlet.cleanMemory();
    }

    public final boolean isInsideScreenCoordinates() {
        return this.firstTime;
    }

    public final void setFirstTime(boolean aValue) {
        this.firstTime = aValue;
    }

    public static final boolean isInsideScreenCoordinates(int x, int y) {
        return x >= 0 && x < 240 && y >= 0 && y < 224;
    }

    public final void resetShootingProcess(long shotTime) {
        this.playBulletAnimation = true;
        this.moveBullets = false;
        this.bulletVerticalOffset = 0;
        this.bulletHorizontalOffset = 0;
        this.bullets.startingTime = shotTime;
    }

    private void buildWall() {
        int i;
        Image iSill = Resources.loadImage("/x/sill.png");
        Image iWallTexture = Resources.loadImage("/x/wall.png");
        int w1 = iSill.getWidth();
        int h1 = iSill.getHeight();
        int w2 = iWallTexture.getWidth();
        int h2 = iWallTexture.getHeight();
        int wallW = 240;
        int wallH = 225;
        this.iWall = Image.createImage((int)wallW, (int)wallH);
        int nSills = 240 / w1 + 1;
        for (i = 0; i < nSills; ++i) {
            this.iWall.getGraphics().drawImage(iSill, i * w1, 0, 20);
        }
        int nC = wallW / w2 + 1;
        int nR = (wallH - h1) / h2 + 1;
        for (i = 0; i < nR; ++i) {
            for (int j = 0; j < nC; ++j) {
                this.iWall.getGraphics().drawImage(iWallTexture, j * w2, h1 + i * h2, 20);
            }
        }
        iSill = null;
        iWallTexture = null;
        SniperMIDlet.cleanMemory();
    }

    private final void build3DWorldOutputWindow() {
        this.iCameraView = Image.createImage((int)240, (int)224);
        this.aux = this.iCameraView.getGraphics();
    }

    protected void keyPressed(int keyCode) {
        Input.keyPressed(keyCode);
        if (this.running && (this.canvasMode == 3 || this.canvasMode == 0) && !this.gameEngine.isBossIntro()) {
            KEY_CODE = keyCode;
            int gameActionCode = -1000;
            if (keyCode == 55 || keyCode == -1000) {
                this.gameEngine.pressedKey(6);
            } else if (keyCode == 53 || gameActionCode == 8 || keyCode == -5) {
                this.gameEngine.pressedKey(4);
            } else if (keyCode == 50 || gameActionCode == 1 || keyCode == -1) {
                this.gameEngine.pressedKey(0);
            } else if (keyCode == 56 || gameActionCode == 6 || keyCode == -2) {
                this.gameEngine.pressedKey(1);
            } else if (keyCode == 52 || gameActionCode == 2 || keyCode == -3) {
                this.gameEngine.pressedKey(2);
            } else if (keyCode == 54 || gameActionCode == 5 || keyCode == -4) {
                this.gameEngine.pressedKey(3);
            } else if (keyCode == 57 || keyCode == -1000) {
                this.gameEngine.pressedKey(5);
            } else if (keyCode == -6) {
                // empty if block
            }
            return;
        }
    }

    protected void keyReleased(int keyCode) {
        Input.keyReleased(keyCode);
        if (this.running && (this.canvasMode == 3 || this.canvasMode == 0)) {
            int gameActionCode = -1000;
            if (keyCode == 55 || keyCode == -1000) {
                this.gameEngine.releaseKey(6);
            } else if (keyCode == 53 || gameActionCode == 8 || keyCode == -5) {
                this.gameEngine.releaseKey(4);
            } else if (keyCode == 50 || gameActionCode == 1 || keyCode == -1) {
                this.gameEngine.releaseKey(0);
            } else if (keyCode == 56 || gameActionCode == 6 || keyCode == -2) {
                this.gameEngine.releaseKey(1);
            } else if (keyCode == 52 || gameActionCode == 2 || keyCode == -3) {
                this.gameEngine.releaseKey(2);
            } else if (keyCode == 54 || gameActionCode == 5 || keyCode == -4) {
                this.gameEngine.releaseKey(3);
            } else if (keyCode == 57 || keyCode == -1000) {
                this.gameEngine.releaseKey(5);
            } else if (keyCode == -6) {
                // empty if block
            }
            return;
        }
    }

    private void renderWorld(Graphics3D graphics3D, World world) {
        graphics3D.clear(world.getBackground());
        Camera camera = world.getActiveCamera();
        Transform tmp_transform = new Transform();
        camera.getTransformTo((Node)world, tmp_transform);
        graphics3D.setCamera(camera, tmp_transform);
        graphics3D.resetLights();
        this.renderGroup(graphics3D, world, (Group)world);
    }

    private void renderGroup(Graphics3D graphics3D, World world, Group group) {
        int childCount = group.getChildCount();
        Node node = null;
        for (int i = 0; i < childCount; ++i) {
            node = group.getChild(i);
            if (node instanceof Group) {
                this.renderGroup(graphics3D, world, (Group)node);
                continue;
            }
            if (!(node instanceof Sprite3D) && !(node instanceof Mesh)) continue;
            this.renderNode(graphics3D, world, node);
        }
    }

    private void renderNode(Graphics3D graphics3D, World world, Node node) {
        Transform tmp_transform = new Transform();
        if (node.getTransformTo((Node)world, tmp_transform)) {
            graphics3D.render(node, tmp_transform);
        } else {
            graphics3D.render(node, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paint(Graphics g) {
        this.startTime = System.currentTimeMillis();
        elapsedTime = (int)(this.startTime - this.lastTime);
        this.lastTime = this.startTime;
        if (elapsedTime > 200) {
            elapsedTime = 200;
        }
        int posX = 0;
        if (this.running && this.resourcesLoaded) {
            try {
                this.iG3D.bindTarget((Object)this.aux, true, 0);
                this.iG3D.clear(this.m_background);
                this.iG3D.render(this.gameEngine.getWorld());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.iG3D.releaseTarget();
            }
            if (!this.gameEngine.isDemoModeActive() && this.aux != null) {
                this.gameEngine.renderWarningHUDS(this.aux);
                if (this.gameEngine.amIImmortal() && !this.gameEngine.isBossIntro()) {
                    this.renderImpact(this.aux);
                    this.xOffset += 15;
                    posX = (int)(Math.sin(this.xOffset) * 2.0);
                } else {
                    posX = 0;
                }
            }
            g.drawImage(this.iCameraView, posX, 48, 20);
            if (this.firstTime) {
                SniperCanvas.cleanRegion(g, 0, 0, 240, 320, null);
                if (!this.gameEngine.isDemoModeActive()) {
                    this.renderUpBanner(g);
                    this.renderDownBanner(g);
                    this.renderPlayerInfo(g);
                    this.renderActivePowerUpsIcons(g);
                    this.renderCursor(g);
                } else {
                    SniperMIDlet.gameFont.drawString(g, Resources.getString(33), 0, 0, 240, 48, 3);
                    SniperMIDlet.gameFont.drawString(g, Resources.getString(34), 0, 272, 240, 48, 3);
                }
                this.firstTime = false;
            } else if (!this.gameEngine.isDemoModeActive()) {
                if (this.gameEngine.haveToUpdateUpBanner()) {
                    SniperCanvas.cleanRegion(g, 0, 0, 240, 48, null);
                    this.renderUpBanner(g);
                    this.renderActivePowerUpsIcons(g);
                    this.gameEngine.setUpdateUpBanner(false);
                }
                this.renderPlayerInfo(g);
                this.renderCrossHair(g);
                if (this.gameEngine.haveToUpdateDownBanner()) {
                    this.renderDownBanner(g);
                    this.gameEngine.setUpdateDownBanner(false);
                }
                if (this.gameEngine.areWeChangingTheMagazine()) {
                    this.renderWall(g);
                }
                this.renderGun(g);
                if (this.playBulletAnimation && this.gameEngine.getCamera().isZoomActive()) {
                    this.playBulletAnimation(g);
                } else {
                    this.renderDownBanner(g);
                    this.renderHumanBody(g);
                    this.renderMagazine(g, 0, 0);
                }
                g.setClip(0, 0, 240, 320);
                this.renderImpactZones(g);
                if (this.gameEngine.isBossIntro()) {
                    if (this.visible == 0) {
                        this.renderMessage(g);
                    }
                } else {
                    this.renderMessage(g);
                }
                if (this.canvasMode == 0) {
                    this.renderPauseMenu(g);
                }
                if (this.gameEngine.isBossIntro()) {
                    this.renderBossIntro(g);
                }
                if (!this.gameEngine.amIImmortal() || !this.gameEngine.isBossIntro()) {
                    // empty if block
                }
            }
            switch (this.canvasMode) {
                case 1: 
                case 5: {
                    g.drawImage(this.iFade, 0, 48, 20);
                }
            }
        } else {
            SniperCanvas.cleanRegion(g, 0, 0, 240, 320, null);
        }
        Console.draw(g);
    }

    private final void renderGun(Graphics g) {
        g.setClip(0, 48, 240, 224);
        if (!this.gameEngine.getCamera().isZoomActive()) {
            if (this.gameEngine.getCamera().getZoomState() == 3 && aimTick < 4) {
                ++aimTick;
                this.renderHandAim(g, true);
            } else {
                this.renderCursor(g);
                this.renderHandBreathe(g);
            }
        }
    }

    private final void renderImpact(Graphics g) {
        g.drawImage(this.iBulletHole, this.gameEngine.getBulletHoleXPos(), this.gameEngine.getBulletHoleYPos(), 20);
    }

    private final void renderUpBanner(Graphics g) {
        g.drawImage(this.iUpBanner, 0, this.yBanner, 20);
    }

    private final void renderDownBanner(Graphics g) {
        g.setClip(0, 0, 240, 320);
        g.setColor(-16777216);
        g.fillRect(0, 272, 240, 48);
        if (this.canvasMode == 0) {
            if (this.pauseMenuStatus == 2) {
                SniperMIDlet.gameFont.drawString(g, Resources.getString(36), 1, 319, 36);
                SniperMIDlet.gameFont.drawString(g, Resources.getString(37), 239, 319, 40);
            } else if (this.pauseMenuStatus == 0) {
                SniperMIDlet.gameFont.drawString(g, Resources.getString(38), 1, 319, 36);
                SniperMIDlet.gameFont.drawString(g, Resources.getString(88), 239, 319, 40);
            } else if (this.pauseMenuStatus == 1) {
                SniperMIDlet.gameFont.drawString(g, Resources.getString(38), 1, 319, 36);
            }
        } else {
            g.setColor(-921904);
            boolean x = true;
            int y = 313;
            g.fillTriangle(1, 313, 7, 313, 4, 319);
        }
    }

    private final void renderCursor(Graphics g) {
        int xC = this.gameEngine.getCamera().getCursorXPos();
        int yC = this.gameEngine.getCamera().getCursorYPos();
        g.setClip(0, 48, 240, 224);
        g.drawImage(this.iCursor, xC - this.cursorXOffest, yC - this.cursorYOffset, 20);
    }

    private final void renderCrossHair(Graphics g) {
        g.setClip(0, 0, 240, 320);
        if (this.gameEngine.getCamera().isZoomActive()) {
            if (aimTick < 4) {
                ++aimTick;
                this.renderHandAim(g, false);
            } else {
                g.drawImage(this.iScope, 120, 160, 3);
                if (this.gameEngine.aimedObjType >= 0) {
                    g.setColor(65280);
                    g.setClip(0, 0, 1000, 1000);
                    g.fillRect(115, 159, 10, 2);
                    g.fillRect(119, 155, 2, 10);
                }
            }
        }
    }

    private void renderHandBreathe(Graphics g) {
        int MaxOffset = 18;
        boolean breatheFrameCount = true;
        int aimFrameCount = 2;
        int imageWidth = this.iHand.getWidth();
        int imageHeight = this.iHand.getHeight();
        int frameWidth = imageWidth / 3;
        SniperCanvas.drawImage(g, this.iHand, 246 + this.breatheOffsetX / 4, 278 + this.breatheOffsetY / 4, this.handFrameIndex * frameWidth, 0, frameWidth, imageHeight, 40);
        ++this.breatheTick;
        if (this.breatheTick > 18) {
            this.breatheDir = -this.breatheDir;
            this.breatheTick = 0;
        }
        this.breatheOffsetX += this.breatheDir;
        this.breatheOffsetY += this.breatheDir;
        if (this.breatheOffsetX > 18) {
            this.breatheOffsetX = 18;
        } else if (this.breatheOffsetX < -1) {
            this.breatheOffsetX = -1;
        }
        if (this.breatheOffsetY > 18) {
            this.breatheOffsetY = 18;
        } else if (this.breatheOffsetY < -1) {
            this.breatheOffsetY = -1;
        }
    }

    private boolean renderHandAim(Graphics g, boolean isReverse) {
        boolean breatheFrameCount = true;
        int aimFrameCount = 2;
        int imageWidth = this.iHand.getWidth();
        int imageHeight = this.iHand.getHeight();
        int frameWidth = imageWidth / 3;
        SniperCanvas.drawImage(g, this.iHand, 240, 272, (this.handFrameIndex + 1) * frameWidth, 0, frameWidth, imageHeight, 40);
        if (++this.breatheTick > 2) {
            this.handFrameIndex = isReverse ? --this.handFrameIndex : ++this.handFrameIndex;
            if (this.handFrameIndex > 1 || this.handFrameIndex < 0) {
                if (this.handFrameIndex > 1) {
                    this.handFrameIndex = 1;
                }
                if (this.handFrameIndex < 0) {
                    this.handFrameIndex = 0;
                }
                return true;
            }
            this.breatheTick = 0;
        }
        return false;
    }

    public static final void drawImage(Graphics g, Image img, int x, int y, int sx, int sy, int w, int h, int align) {
        if (align == 0) {
            g.setClip(x, y, w, h);
            g.drawImage(img, x - sx, y - sy, align);
        } else {
            int tmp;
            w = w > img.getWidth() ? img.getWidth() : w;
            h = h > img.getHeight() ? img.getHeight() : h;
            int cx = x;
            int cy = y;
            int cw = w;
            int ch = h;
            int dx = x - sx;
            int dy = y - sy;
            if (sx > 0) {
                tmp = img.getWidth() - sx;
                int n = cw = tmp > w ? w : tmp;
            }
            if (sy > 0) {
                tmp = img.getHeight() - sy;
                int n = ch = tmp > h ? h : tmp;
            }
            if ((align & 8) != 0) {
                cx -= cw;
                dx += img.getWidth() - cw;
            } else if ((align & 1) != 0) {
                cx -= cw >> 1;
                dx += (img.getWidth() >> 1) - (cw >> 1);
            }
            if ((align & 0x20) != 0) {
                cy -= ch;
                dy += img.getHeight() - ch;
            } else if ((align & 2) != 0) {
                cy -= ch >> 1;
                dy += (img.getHeight() >> 1) - (ch >> 1);
            }
            g.setClip(cx, cy, cw, ch);
            g.drawImage(img, dx, dy, align);
        }
    }

    private final void renderHumanBody(Graphics g) {
        if (!this.gameEngine.isBoosStage() && this.gameEngine.getCamera().isZoomActive()) {
            g.drawImage(this.iHumanBody, 5, 274, 20);
        }
    }

    private final void renderImpactZones(Graphics g) {
        if (this.gameEngine.getCamera().isZoomActive() && !this.gameEngine.isBoosStage()) {
            this.renderHumanBody(g);
            if (this.gameEngine.renderImpactZone()) {
                g.setClip(0, 0, 240, 320);
                switch (this.gameEngine.getImpactZone()) {
                    case 0: {
                        this.bodyImpacts.drawSpecifiedFrame(g, 1);
                        break;
                    }
                    case 1: {
                        this.bodyImpacts.drawSpecifiedFrame(g, 0);
                        break;
                    }
                    case 2: {
                        this.bodyImpacts.drawSpecifiedFrame(g, 3);
                        break;
                    }
                    case 3: {
                        this.bodyImpacts.drawSpecifiedFrame(g, 2);
                        break;
                    }
                    case 4: {
                        this.bodyImpacts.drawSpecifiedFrame(g, 5);
                        break;
                    }
                    case 5: {
                        this.bodyImpacts.drawSpecifiedFrame(g, 4);
                        break;
                    }
                    default: {
                        this.renderHumanBody(g);
                    }
                }
            }
        }
    }

    private final void renderWall(Graphics g) {
        g.setClip(0, 48, 240, 224);
        g.drawImage(this.iWall, this.gameEngine.getWallXCoordinate(), this.gameEngine.getWallYCoordinate(), 20);
    }

    private final void renderMessage(Graphics g) {
        String msg = this.gameEngine.getMessageToRender();
        if (msg != null) {
            g.setClip(0, 0, 240, 320);
            SniperMIDlet.messageFont.drawString(g, msg, 0, 48, 240, 224, 3);
        }
    }

    private final void renderActivePowerUpsIcons(Graphics g) {
        int Y = MenuCanvas.toPixelY(8);
        int pwractives = 0;
        g.setClip(0, 0, 240, 320);
        if (this.gameEngine.specialBulletsActive() || SniperMIDlet.specialBullets) {
            g.drawImage(this.iPwrUpSpecialBullets, MenuCanvas.toPixelX(90), Y, 3);
            ++pwractives;
        }
        if (this.gameEngine.bulletProovVestActive()) {
            g.drawImage(this.iPwrUpBulletProofVest, MenuCanvas.toPixelX(80), Y, 3);
        }
    }

    private final void renderPlayerInfo(Graphics g) {
        this.renderPlayerPoints(g);
        this.renderPlayerLife(g);
    }

    private final void renderPauseMenu(Graphics g) {
        if (this.pauseMenuStatus == 0) {
            g.drawImage(this.iFrame, 120, 160, 3);
            int itemY = 160 - 4 * SniperMIDlet.gameFont.fontHeight / 2;
            block7: for (int i = 0; i < 5; ++i) {
                if (i == this.gameEngine.getActualSelection()) {
                    g.drawImage(this.iSelectionCursor, 70, itemY + i * SniperMIDlet.gameFont.fontHeight, 6);
                }
                switch (i) {
                    case 0: {
                        SniperMIDlet.gameFont.drawString(g, Resources.getString(12), 120, itemY, 3);
                        continue block7;
                    }
                    case 1: {
                        SniperMIDlet.gameFont.drawString(g, Resources.getString(2), 120, itemY + SniperMIDlet.gameFont.fontHeight, 3);
                        continue block7;
                    }
                    case 2: {
                        String soundStatus = SniperMIDlet.instance.soundEngine.isMusicEnable() ? Resources.getString(10) : Resources.getString(11);
                        SniperMIDlet.gameFont.drawString(g, soundStatus, 120, itemY + SniperMIDlet.gameFont.fontHeight * 2, 3);
                        continue block7;
                    }
                    case 3: {
                        SniperMIDlet.gameFont.drawString(g, Resources.getString(13), 120, itemY + SniperMIDlet.gameFont.fontHeight * 3, 3);
                        continue block7;
                    }
                    case 4: {
                        SniperMIDlet.gameFont.drawString(g, Resources.getString(3), 120, itemY + SniperMIDlet.gameFont.fontHeight * 4, 3);
                        continue block7;
                    }
                }
            }
        } else if (this.pauseMenuStatus == 1) {
            g.setColor(-16777216);
            g.fillRect(0, 0, 240, 320);
            int soundtxtid = 96;
            SniperMIDlet.gameFont.drawString(g, Resources.getString(59) + Resources.getString(soundtxtid), 12, this.helpTextScroll * 14, 216, 9000, 20);
            g.fillRect(0, 320 - this.iIconBack.getHeight() * 3 / 2, 240, this.iIconBack.getHeight() * 3 / 2);
            g.drawImage(this.iIconBack, 239, 319, 40);
        } else if (this.pauseMenuStatus == 2) {
            g.drawImage(this.iFrame, 120, 160, 3);
            SniperMIDlet.gameFont.drawString(g, Resources.getString(87), 120, 160, 3);
        }
        this.renderDownBanner(g);
    }

    private final void renderBossIntro(Graphics g) {
        switch (this.gameEngine.getIntroState()) {
            case 0: {
                this.visible = (this.visible + 1) % 2;
                break;
            }
            case 1: {
                g.setColor(-8421505);
                g.fillRoundRect(this.introBossX, this.introBossY, this.introBossW, this.introBossH, 3, 3);
                g.setColor(-16777216);
                g.fillRoundRect(this.introBossX + 3, this.introBossY + 3, this.introBossW - 6, this.introBossH - 6, 3, 3);
                g.setClip(0, 0, 240, 320);
                SniperMIDlet.gameFont.drawString(g, this.gameEngine.getInfo(), this.introBossX + 3, this.introBossY + 3, this.introBossW - 6, this.introBossH - 6, 3);
                break;
            }
            case 2: {
                g.setColor(-8421505);
                g.fillRoundRect(this.introBossX, this.introBossY, this.introBossW, this.introBossH, 3, 3);
                g.setColor(-16777216);
                g.fillRoundRect(this.introBossX + 3, this.introBossY + 3, this.introBossW - 6, this.introBossH - 6, 3, 3);
                g.setClip(0, 0, 240, 320);
                SniperMIDlet.gameFont.drawString(g, Resources.getString(73), this.introBossX + 8, this.introBossY + 16, this.introBossW / 2 - 16, this.introBossH - 32, 20);
                SniperMIDlet.gameFont.drawString(g, this.gameEngine.getInfo(), this.introBossX + 8 + this.introBossW / 2 - 10, this.introBossY + 16, this.introBossW / 2 - 16 + 10, this.introBossH - 32, 20);
                break;
            }
            case 3: {
                g.setColor(-16777216);
                g.fillRect(this.introBossX, this.introBossY, this.introBossW, this.introBossH);
                g.drawImage(this.iBossBlueprint, this.introBossX, this.introBossY, 20);
                if (this.visible == 0) {
                    int i;
                    for (i = 0; i < HEAVY_WEAPON[SniperMIDlet.getStageToLoad()].length; ++i) {
                        g.drawImage(this.iPrimaryWeapon, this.introBossX + HEAVY_WEAPON[SniperMIDlet.getStageToLoad()][i][0] - 8, this.introBossY + HEAVY_WEAPON[SniperMIDlet.getStageToLoad()][i][1] - 7, 20);
                    }
                    for (i = 0; i < LIGHT_WEAPON[SniperMIDlet.getStageToLoad()].length; ++i) {
                        g.drawImage(this.iSecondaryWeapon, this.introBossX + LIGHT_WEAPON[SniperMIDlet.getStageToLoad()][i][0] - 4, this.introBossY + LIGHT_WEAPON[SniperMIDlet.getStageToLoad()][i][1] - 4, 20);
                    }
                }
                this.visible = (this.visible + 1) % 2;
                break;
            }
            case 4: {
                this.visible = (this.visible + 1) % 2;
            }
        }
    }

    private final void renderPlayerPoints(Graphics g) {
        int Y = MenuCanvas.toPixelY(8);
        g.setClip(0, 0, 240, 320);
        if (this.canvasMode == 3) {
            SniperMIDlet.gameFont.drawString(g, Integer.toString(this.gameEngine.getTotalPoints()), MenuCanvas.toPixelX(45), Y, 3);
        }
    }

    private final void renderPlayerLife(Graphics g) {
        int Y = MenuCanvas.toPixelY(8);
        g.setClip(0, 0, 240, 320);
        if (this.canvasMode == 3) {
            SniperMIDlet.gameFont.drawString(g, Integer.toString(this.gameEngine.getPlayerLife()), MenuCanvas.toPixelX(10), Y, 3);
        }
    }

    private final void renderMagazine(Graphics g, int xOffset, int yOffset) {
        if (this.gameEngine.getCamera().isZoomActive()) {
            for (int i = 0; i < this.gameEngine.getBulletsInsideMagazine(); ++i) {
                switch (i) {
                    case 0: {
                        if (!this.moveBullets) {
                            this.bullets.despX = (short)195;
                            break;
                        }
                        this.bullets.despX = (short)(192 + xOffset);
                        break;
                    }
                    default: {
                        this.bullets.despX = (short)192;
                    }
                }
                if (this.playBulletAnimation) {
                    if (this.moveBullets) {
                        g.setClip(0, 0, 240, 320);
                        this.bullets.despY = (short)(256 + i * 5 - yOffset + 5);
                        this.bullets.drawSpecifiedSprite(g, 0);
                    } else {
                        if (i == 0) {
                            this.bullets.despX = (short)192;
                        }
                        g.setClip(0, 0, 240, 320);
                        this.bullets.despY = (short)(256 + i * 5 - yOffset + 5);
                        this.bullets.drawSpecifiedSprite(g, 0);
                    }
                    if (!this.gameEngine.specialBulletsActive()) continue;
                    g.setClip(0, 0, 240, 320);
                    g.drawImage(this.iSpecialBulletHead, this.bullets.despX + 19, this.bullets.despY + 1, 20);
                    continue;
                }
                g.setClip(0, 0, 240, 320);
                this.bullets.despY = (short)(256 + i * 5 - yOffset);
                this.bullets.drawSpecifiedSprite(g, 0);
                if (!this.gameEngine.specialBulletsActive()) continue;
                g.setClip(0, 0, 240, 320);
                g.drawImage(this.iSpecialBulletHead, this.bullets.despX + 19, this.bullets.despY + 1, 20);
            }
            g.setClip(0, 0, 240, 320);
            g.drawImage(this.iMagazine, 189, 255, 20);
        }
    }

    private final void playBulletAnimation(Graphics g) {
        this.bullets.despX = 0;
        this.bullets.despY = 0;
        g.setClip(0, 0, 240, 320);
        this.renderDownBanner(g);
        g.drawImage(this.iMagazine, 189, 255, 20);
        if (!this.bullets.draw(g, GameEngine.getGameTime())) {
            if (!this.moveBullets) {
                this.moveBullets = true;
            }
            if (!this.gameEngine.isBoosStage()) {
                this.renderHumanBody(g);
            }
            if (this.moveBullets) {
                this.moveTheRemainingBullets(g);
            }
        } else {
            this.renderMagazine(g, 0, 0);
        }
    }

    private final void moveTheRemainingBullets(Graphics g) {
        if (this.bulletVerticalOffset < 3) {
            ++this.bulletVerticalOffset;
            this.renderMagazine(g, this.bulletHorizontalOffset, this.bulletVerticalOffset);
        } else if (this.bulletHorizontalOffset < 3) {
            ++this.bulletHorizontalOffset;
            this.renderMagazine(g, this.bulletHorizontalOffset, this.bulletVerticalOffset);
        } else {
            this.playBulletAnimation = false;
            this.moveBullets = false;
            this.renderMagazine(g, 0, 0);
        }
    }

    public final void setRunningValue(boolean newValue) {
        this.running = newValue;
    }

    public final void exitToMainMenu() {
        this.running = false;
        this.midletRef.setNewMode((short)0);
        if (this.gameEngine.isDemoModeActive()) {
            this.midletRef.setNextMenuToLoad((short)21);
        } else if (this.gameEngine.isGameOver()) {
            this.midletRef.setNextMenuToLoad((short)17);
        } else if (this.gameEngine.isStageComplete()) {
            this.midletRef.setNextMenuToLoad((short)7);
        }
        Console.output("exitToMainMenu()");
    }

    private final void buildFadeOutImage(int w, int h, int alpha) {
        int[] temp = new int[w * h];
        int color = (alpha <<= 24) | 0;
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                temp[i * w + j] = color;
            }
        }
        this.iFade = Image.createRGBImage((int[])temp, (int)w, (int)h, (boolean)true);
    }

    public void run() {
        try {
            this.running = true;
            this.canvasMode = 1;
            try {
                while (this.running) {
                    Input.UpdateKey();
                    if (!SniperMIDlet.inPause) {
                        this.currentTime += 66L;
                    }
                    if (this.canvasMode == 0 || this.canvasMode == 3) {
                        // empty if block
                    }
                    switch (this.canvasMode) {
                        case 0: {
                            this.gameEngine.processKeys();
                            break;
                        }
                        case 1: {
                            long tElapsed;
                            long tActual = this.currentTime;
                            if (this.initTimes) {
                                this.tInitStateTime = this.currentTime;
                                this.initTimes = false;
                            }
                            if ((tElapsed = tActual - this.tInitStateTime) > 500L) {
                                this.canvasMode = (byte)2;
                                this.tInitStateTime = tActual;
                                break;
                            }
                            float coef = (float)tElapsed * 1.0f / 500.0f;
                            int alpha = Math3D.linearInterpolation(255, 0, coef);
                            this.buildFadeOutImage(240, 224, alpha);
                            break;
                        }
                        case 2: {
                            long tActual = this.currentTime;
                            long tElapsed = tActual - this.tInitStateTime;
                            if (tElapsed > 2000L) {
                                this.canvasMode = (byte)3;
                                this.tInitStateTime = tActual;
                                break;
                            }
                            float coef = (float)tElapsed * 1.0f / 2000.0f;
                            this.yBanner = Math3D.linearInterpolation(-48, 0, coef);
                            this.gameEngine.setUpdateUpBanner(true);
                            break;
                        }
                        case 5: {
                            long tActual = this.currentTime;
                            long tElapsed = tActual - this.tInitStateTime;
                            if (tElapsed > 500L) {
                                this.exitToMainMenu();
                                break;
                            }
                            float coef = (float)tElapsed * 1.0f / 500.0f;
                            int alpha = Math3D.linearInterpolation(0, 255, coef);
                            this.buildFadeOutImage(240, 224, alpha);
                            break;
                        }
                        case 4: {
                            long tActual = this.currentTime;
                            long tElapsed = tActual - this.tInitStateTime;
                            if (tElapsed > 2000L) {
                                this.canvasMode = (byte)5;
                                this.tInitStateTime = tActual;
                                this.buildFadeOutImage(240, 224, 0);
                                break;
                            }
                            float coef = (float)tElapsed * 1.0f / 2000.0f;
                            this.yBanner = Math3D.linearInterpolation(0, -48, coef);
                            this.gameEngine.setUpdateUpBanner(true);
                            break;
                        }
                        case 3: {
                            if (Input.IsKeyCombo(Cheating_GodMode)) {
                                boolean bl = SniperMIDlet.godMode = !SniperMIDlet.godMode;
                            }
                            if (!this.gameEngine.isStageComplete() && !this.gameEngine.isGameOver()) {
                                this.gameEngine.processGameWorld(this.currentTime);
                                break;
                            }
                            this.canvasMode = (byte)4;
                            this.tInitStateTime = this.currentTime;
                            break;
                        }
                    }
                    this.repaint();
                    try {
                        Thread.sleep(60L);
                    }
                    catch (InterruptedException ie) {}
                }
            }
            catch (Exception ie) {
                ie.printStackTrace();
            }
            this.unloadImageResources();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void cleanRegion(Graphics g, int x, int y, int width, int height, Image image) {
        g.setClip(x, y, width, height);
        if (image != null) {
            g.drawImage(image, 0, 0, 20);
        } else {
            g.setColor(-16777216);
            g.fillRect(x, y, width, height);
        }
        g.setClip(0, 0, width, height);
    }

    public static final void renderLoading(Graphics g, Image backgroundImage) {
        g.setClip(0, 0, 240, 320);
        if (backgroundImage == null) {
            g.setColor(-16777216);
            g.fillRect(0, 0, 240, 320);
        } else {
            g.drawImage(backgroundImage, 0, 0, 20);
        }
        int width = SniperMIDlet.gameFont.getLineWidth(Resources.getString(31).toCharArray());
        SniperMIDlet.gameFont.drawString(g, Resources.getString(31), (240 - width) / 2, 160, 20);
    }

    static {
        elapsedTime = 0;
    }
}

