/*
 * Decompiled with CFR 0.152.
 */
package SAF_GUI;

import SAF_Core.Anim;
import SAF_Core.C;
import SAF_Core.Txt;
import SAF_GUI.LayoutBox;
import SAF_GUI.MenuItem;
import SAF_GUI.MenuPage;
import SAF_GUI.TextBox;
import java.io.DataInputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

public class Menu {
    public static final String N = "";
    public static final String EXT = ".smi";
    public static final int ON_SOFT_LEFT = 0;
    public static final int ON_SOFT_RIGHT = 1;
    public static final int ON_LEFT = 2;
    public static final int ON_RIGHT = 3;
    public static final int ON_UP = 4;
    public static final int ON_DOWN = 5;
    public static final int ON_FIRE = 6;
    public static final int ON_SELECT = 7;
    private static final int CFG_MIN_DYNAMIC_TEXT_TABLE_SIZE = 10;
    public Txt text;
    public Anim guiGfx;
    private Vector pages;
    private MenuPage pageCurrent;
    char[][] textTable;
    boolean[] conditionsTable;
    TextBox textBox = null;
    private Vector layoutBoxes;
    private LayoutBox layoutBoxCurrent = null;

    public LayoutBox getLayoutBoxCurrent() {
        return this.layoutBoxCurrent;
    }

    public Menu() {
        this.pages = new Vector();
        this.layoutBoxes = new Vector();
    }

    public Menu(int n, int n2) {
        this.textTable = new char[n2][];
        this.conditionsTable = new boolean[n];
        this.pages = new Vector();
        this.layoutBoxes = new Vector();
    }

    public void paint(Graphics graphics) {
        if (this.pageCurrent != null) {
            this.pageCurrent.paint(graphics);
        }
    }

    public int addPage(MenuPage menuPage) {
        this.pages.addElement(menuPage);
        menuPage.setMenuSystem(this);
        return this.pages.size();
    }

    public int removePage(int n) {
        this.pages.removeElementAt(n);
        return this.pages.size();
    }

    public MenuPage getPage(int n) {
        if (n < this.pages.size()) {
            return (MenuPage)this.pages.elementAt(n);
        }
        return null;
    }

    public int getPageId(MenuPage menuPage) {
        if (menuPage != null) {
            for (int i = 0; i < this.pages.size(); ++i) {
                if (menuPage != (MenuPage)this.pages.elementAt(i)) continue;
                return i;
            }
        }
        return -1;
    }

    public int getCurrentPageId() {
        return this.getPageId(this.pageCurrent);
    }

    public MenuPage getCurrentPage() {
        return this.pageCurrent;
    }

    public void setCurrentPage(int n) {
        this.pageCurrent = (MenuPage)this.pages.elementAt(n);
        this.pageCurrent.selectionTest();
    }

    public void setCurrentPage(MenuPage menuPage) {
        this.pageCurrent = menuPage;
        this.pageCurrent.selectionTest();
    }

    public Txt getText() {
        return this.text;
    }

    public void setText(Txt txt) {
        this.text = txt;
        for (int i = 0; i < this.layoutBoxes.size(); ++i) {
            ((LayoutBox)this.layoutBoxes.elementAt(i)).setText(txt);
        }
    }

    public void setGuiGfx(Anim anim) {
        this.guiGfx = anim;
        for (int i = 0; i < this.layoutBoxes.size(); ++i) {
            ((LayoutBox)this.layoutBoxes.elementAt(i)).setGuiGfx(anim);
        }
    }

    public Vector getCommands(int n) {
        if (this.pageCurrent != null) {
            return this.pageCurrent.getCommands(n);
        }
        return null;
    }

    public Vector getCommandsPageOnly(int n) {
        if (this.pageCurrent != null) {
            return this.pageCurrent.getCommandsPageOnly(n);
        }
        return null;
    }

    public Vector getCommandsItemOnly(int n) {
        if (this.pageCurrent != null) {
            return this.pageCurrent.getCommandsItemOnly(n);
        }
        return null;
    }

    public int getCommandsCount(int n) {
        if (this.pageCurrent != null && n >= 0) {
            return this.pageCurrent.getCommandsCount(n);
        }
        return 0;
    }

    public int getCommandsCountOnPageSelect() {
        if (this.pageCurrent != null) {
            return this.pageCurrent.getCommandscountPageOnly(7);
        }
        return 0;
    }

    public int getCommandsCountOnItemSelect() {
        if (this.pageCurrent != null) {
            return this.pageCurrent.getCommandsCountItemOnly(7);
        }
        return 0;
    }

    public char[] getTextFromTable(int n) {
        return this.textTable[n];
    }

    public void setTextForTable(char[] cArray, int n) {
        this.textTable[n] = cArray;
    }

    public boolean getCondition(int n) {
        return this.conditionsTable[n];
    }

    public void setCondition(int n, boolean bl) {
        this.conditionsTable[n] = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(MIDlet mIDlet, String string) {
        int n = 10;
        int n2 = 0;
        DataInputStream dataInputStream = new DataInputStream(mIDlet.getClass().getResourceAsStream(string));
        try {
            int n3;
            this.textTable = null;
            this.conditionsTable = null;
            dataInputStream.readByte();
            dataInputStream.readByte();
            dataInputStream.readByte();
            dataInputStream.readByte();
            int n4 = dataInputStream.readUnsignedByte();
            int[] nArray = new int[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                nArray[n3] = dataInputStream.readUnsignedByte();
            }
            n3 = dataInputStream.readUnsignedByte();
            for (int i = 0; i < n3; ++i) {
                MenuPage menuPage = new MenuPage(this);
                this.addPage(menuPage);
                menuPage.setSoftLeft(dataInputStream.readByte());
                menuPage.setSoftRight(dataInputStream.readByte());
                int n5 = dataInputStream.readUnsignedByte();
                for (int j = 0; j < n5; ++j) {
                    MenuItem menuItem = new MenuItem();
                    int n6 = dataInputStream.readUnsignedByte();
                    menuItem.setTextId(n6);
                    byte by = (byte)dataInputStream.readUnsignedByte();
                    menuItem.setFlag(by);
                    if (menuItem.isTextDynamic && n6 > n) {
                        n = n6;
                    }
                    if (menuItem.isConditional) {
                        int n7 = dataInputStream.readUnsignedByte();
                        menuItem.setConditionId(n7);
                        if (n7 > n2) {
                            n2 = n7;
                        }
                    }
                    for (int k = 0; k < 8; ++k) {
                        int n8 = dataInputStream.readUnsignedByte();
                        for (int i2 = 0; i2 < n8; ++i2) {
                            int n9 = dataInputStream.readUnsignedByte();
                            int[] nArray2 = new int[nArray[n9] + 1];
                            nArray2[0] = n9;
                            for (int i3 = 0; i3 < nArray[n9]; ++i3) {
                                short s = dataInputStream.readShort();
                                nArray2[i3 + 1] = s;
                            }
                            menuItem.addCommand(k, nArray2);
                        }
                    }
                    if (j == 0) {
                        menuPage.setPageCommands(menuItem);
                        continue;
                    }
                    menuPage.addItem(menuItem);
                }
            }
            this.textTableAlloc(n + 1);
            this.conditionsTableAlloc(n2 + 1);
        }
        catch (Exception exception) {
            C.err(N, "blad odczytu pliku: " + string, exception);
        }
        finally {
            if (dataInputStream != null) {
                try {
                    dataInputStream.close();
                }
                catch (Exception exception) {}
                dataInputStream = null;
            }
        }
    }

    public void textTableAlloc(int n) {
        this.textTable = ++n > 0 ? (Object)new char[n][] : (char[][])null;
    }

    public void conditionsTableAlloc(int n) {
        this.conditionsTable = (boolean[])(++n > 0 ? new boolean[n] : null);
    }

    public static int[] commandCreate(int n, int n2) {
        int[] nArray = new int[n2 + 1];
        nArray[0] = n;
        return nArray;
    }

    public void textMenuCreate(int n, boolean bl) {
        this.textBox = new TextBox();
        this.textBox.init(this.text);
        if (bl) {
            this.textBox.setText(this.getTextFromTable(n));
        } else {
            this.textBox.setText(this.text.getText(n));
        }
    }

    public void textMenuInit() {
        this.textBox = new TextBox();
        this.textBox.init(this.text);
        if (this.getCurrentLayoutBox() != null) {
            this.textBox.setPositionX(this.getCurrentLayoutBox().getPositionX() + this.getCurrentLayoutBox().getInnerMarginleft());
            this.textBox.setPositionY(this.getCurrentLayoutBox().getCurrentPositionY() + this.getCurrentLayoutBox().getInnerMarginTop());
            this.textBox.setWidth(this.getCurrentLayoutBox().getWidth() - this.getCurrentLayoutBox().getInnerMarginleft() - this.getCurrentLayoutBox().getInnerMarginRight() - 10);
            this.textBox.setHeight(this.getCurrentLayoutBox().getCurrentHeight() - this.getCurrentLayoutBox().getInnerMarginTop() - this.getCurrentLayoutBox().getInnerMarginBottom());
            this.textBox.setTextAlignment(this.getCurrentLayoutBox().getTextAdjust());
        }
    }

    public void textMenuSetText(int n, boolean bl) {
        if (bl) {
            this.textBox.setText(this.getTextFromTable(n));
        } else {
            this.textBox.setText(this.text.getText(n));
        }
        this.getCurrentLayoutBox().calculateSize(this.textBox.getTextHeight(), 1);
        this.textBox.setPositionX(this.getCurrentLayoutBox().getPositionX() + this.getCurrentLayoutBox().getInnerMarginleft());
        this.textBox.setPositionY(this.getCurrentLayoutBox().getCurrentPositionY() + this.getCurrentLayoutBox().getInnerMarginTop());
        this.textBox.setWidth(this.getCurrentLayoutBox().getWidth() - this.getCurrentLayoutBox().getInnerMarginleft() - this.getCurrentLayoutBox().getInnerMarginRight() - 10);
        this.textBox.setHeight(this.getCurrentLayoutBox().getCurrentHeight() - this.getCurrentLayoutBox().getInnerMarginTop() - this.getCurrentLayoutBox().getInnerMarginBottom());
        this.textBox.setTextAlignment(this.getCurrentLayoutBox().getTextAdjust());
        this.textBox.setScrollBarVisibility(true);
        this.textBox.setScrollBarSize(10, this.getCurrentLayoutBox().getCurrentHeight() - this.getCurrentLayoutBox().getInnerMarginTop() - this.getCurrentLayoutBox().getInnerMarginBottom());
        this.textBox.setScrollBarParameters(2, 1, 1, 0xFFFFFF, 0);
        this.textBox.calculateSlideSize();
    }

    public TextBox getTextBox() {
        return this.textBox;
    }

    public void LangNamesToDynamicTable() {
        if (this.text != null) {
            for (int i = 0; i < this.text.getLanguageCount(); ++i) {
                this.setTextForTable(this.text.getLanguageName(i), i);
            }
        }
    }

    public void addLayoutBox(LayoutBox layoutBox, boolean bl, boolean bl2) {
        if (bl) {
            layoutBox.setGuiGfx(this.guiGfx);
        }
        if (bl2) {
            layoutBox.setText(this.text);
        }
        this.layoutBoxes.addElement(layoutBox);
    }

    public LayoutBox getLayoutBox(int n) {
        if (n >= 0 && n < this.layoutBoxes.size()) {
            return (LayoutBox)this.layoutBoxes.elementAt(n);
        }
        return null;
    }

    public LayoutBox getCurrentLayoutBox() {
        return this.layoutBoxCurrent;
    }

    public void setCurrentLayoutBox(int n) {
        if (n >= 0 && n < this.layoutBoxes.size()) {
            this.layoutBoxCurrent = (LayoutBox)this.layoutBoxes.elementAt(n);
        }
    }

    public void setCurrentLayoutBox(LayoutBox layoutBox) {
        this.layoutBoxCurrent = layoutBox;
    }
}

