/*
 * Decompiled with CFR 0.152.
 */
package Game;

import Game.Car;
import Game.Enemy;
import Game.HotSpot;
import Game.Mafia;
import Game.Sprite;
import Game.Vect;
import SAF_Util.Util;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import javax.microedition.midlet.MIDlet;

public class Player2
extends Sprite {
    public static final String N = "";
    static final byte STATE_IDLE_AND_WAITING_FOR_RELOAD_WEAPON = 0;
    static final byte STATE_IDLE = 1;
    static final byte STATE_RUN = 2;
    static final byte STATE_PREPARE_TO_SHOOT = 3;
    static final byte STATE_SHOOT = 4;
    static final byte STATE_AFTER_SHOOT_WAITING = 5;
    static final byte STATE_HOLDING_WEAPON = 6;
    static final byte STATE_RELOAD_WEAPON = 7;
    static final byte STATE_HIDE_WEAPON = 8;
    static final byte STATE_HIDEN_WEAPON = 9;
    static final byte STATE_SHOW_WEAPON = 10;
    static final byte STATE_SHOW_WEAPON_TO_RELOAD = 11;
    static final byte STATE_DEATH = 12;
    static final byte STATS_HEALTH = 0;
    static final byte STATS_HEALTH_MAX = 1;
    static final byte STATS_SCORE = 2;
    static final byte STATS_CURRENT_CASH = 3;
    static final byte STATS_CURRENT_ENEMIES = 4;
    static final byte STATS_CURRENT_NPC = 5;
    static final byte STATS_CURRENT_CARS = 6;
    static final byte STATS_CURRENT_COPS = 7;
    static final byte STATS_CURRENT_MISSION_TIME = 8;
    static final byte STATS_TOTAL_CASH = 9;
    static final byte STATS_TOTAL_ENEMIES = 10;
    static final byte STATS_TOTAL_NPC = 11;
    static final byte STATS_TOTAL_CARS = 12;
    static final byte STATS_TOTAL_COPS = 13;
    static final byte STATS_TOTAL_MISSION_TIME = 14;
    static final byte STATS_COUNT = 15;
    static final byte WEAPON_TYPE_FIST = 0;
    static final byte WEAPON_TYPE_MAGNUM = 1;
    static final byte WEAPON_TYPE_REMINGTON = 2;
    static final byte WEAPON_TYPE_TOMMY_GUN = 3;
    static final byte WEAPON_TYPE_SNIPER = 4;
    static final byte MEDICAL_TYPE_MEDICAMENTS_1 = 0;
    static final byte MEDICAL_TYPE_MEDICAMENTS_2 = 1;
    static final byte MEDICAL_TYPE_MEDKIT_1 = 2;
    static final byte MEDICAL_TYPE_MEDKIT_2 = 3;
    static final byte MEDICAL_TYPES_NUMBER = 4;
    static final byte WEAPON_INFO_AMMO_CLIP_CURRENT = 0;
    static final byte WEAPON_INFO_AMMO_CLIP_MAX = 1;
    static final byte WEAPON_INFO_AMMO_BACKPACK_CURRENT = 2;
    static final byte WEAPON_INFO_AMMO_BACKPACK_MAX = 3;
    static final byte WEAPON_INFO_CROSSHAIR_RANGE = 4;
    static final byte WEAPON_INFO_SHOOT_RANGE_Q = 5;
    static final byte WEAPON_INFO_RELOAD_TIME_MS = 6;
    static final byte WEAPON_INFO_NUMBER_OF_BULLETS = 7;
    static final byte WEAPON_INFO_SHOOT_TIME_MS = 8;
    static final byte WEAPON_INFO_DAMAGE_MIN = 9;
    static final byte WEAPON_INFO_DAMAGE_MAX = 10;
    static final byte INVENTORY_ACTION_RESULT_OK = 0;
    static final byte INVENTORY_ACTION_RESULT_NOTUSEABLE = 1;
    static final byte INVENTORY_ACTION_RESULT_INSUFFICIENT = 2;
    private static final byte SEQUENCE_IDLE = 0;
    private static final byte SEQUENCE_RUN = 4;
    private static final byte SEQUENCE_DEATH = 72;
    private static final byte SEQUENCE_FIST_TAKEUP = 8;
    private static final byte SEQUENCE_FIST_AIM = 12;
    private static final byte SEQUENCE_FIST_SHOOT = 16;
    private static final byte SEQUENCE_FIST_RELOAD = 20;
    private static final byte SEQUENCE_MAGNUM_TAKEUP = 24;
    private static final byte SEQUENCE_MAGNUM_AIM = 28;
    private static final byte SEQUENCE_MAGNUM_SHOOT = 32;
    private static final byte SEQUENCE_MAGNUM_RELOAD = 36;
    private static final byte SEQUENCE_REMINGTON_TAKEUP = 40;
    private static final byte SEQUENCE_REMINGTON_AIM = 44;
    private static final byte SEQUENCE_REMINGTON_SHOOT = 48;
    private static final byte SEQUENCE_REMINGTON_RELOAD = 52;
    private static final byte SEQUENCE_TOMMY_GUN_TAKEUP = 56;
    private static final byte SEQUENCE_TOMMY_GUN_AIM = 60;
    private static final byte SEQUENCE_TOMMY_GUN_SHOOT = 64;
    private static final byte SEQUENCE_TOMMY_GUN_RELOAD = 68;
    private static final byte CROSSHAIR_STATE_FREE = 0;
    private static final byte CROSSHAIR_STATE_SEEK = 1;
    private static final byte CROSSHAIR_STATE_TARGET = 2;
    private static final byte CROSSHAIR_STATE_RELEASE = 3;
    static int[] stats;
    private short[] inventory;
    int speedXf;
    int speedYf;
    int stateTimePrepareToShot;
    int stateTimeHoldingOutWeapon;
    int stateTimeHidingWeapon;
    int stateTimeHiddenWeaponOnSwap;
    int stateTimeShowingWeapon;
    int stateTimeReloadAfterIdle;
    int stateTimeDeath;
    int stateTimeDeathInCar;
    int carEnterRangeQF;
    boolean weaponChangeBlocked;
    short[] medicalHealPoints;
    boolean controlIsBlocked;
    private byte state;
    long stateTime;
    byte weapon;
    byte weaponBulletsShooted;
    int speedCurrentXf;
    int speedCurrentYf;
    private byte crosshairState;
    int[][] weaponInfo;
    Car car;
    boolean isInCar;
    boolean carExitIsBlocked;
    Enemy targetEnemy;
    int crosshairVerticalOffsetF;
    int crosshairAngleSpeedF;
    int crosshairRangeSpeedF;
    int crosshairTargetSpeedF;
    Vect crosshairPositionDefault;
    Vect crosshairPosition;
    Vect crosshairPositionTemp;
    int crosshairAngleDestF;
    int crosshairAngleCurrentF;
    int crosshairRangeCurrentF;
    int spatialZoneNearX1;
    int spatialZoneNearX2;
    int spatialZoneNearY1;
    int spatialZoneNearY2;
    HotSpot hotSpotBlocked;
    private static int auxX;
    private static int auxY;
    public static int statsEnemies;
    public static int statsNpc;
    public static int statsCars;
    public static int statsCups;
    public static int statsMissionTm;
    byte weaponNext;

    void init(MIDlet mIDlet, String string) {
        block8: {
            this.type = 0;
            statsEnemies = 0;
            statsNpc = 0;
            statsCars = 0;
            statsCups = 0;
            statsMissionTm = 0;
            this.medicalHealPoints = new short[4];
            stats = new int[15];
            for (int i = 0; i < stats.length; ++i) {
                Player2.stats[i] = 0;
            }
            FilterInputStream filterInputStream = null;
            try {
                filterInputStream = new DataInputStream(mIDlet.getClass().getResourceAsStream(string));
                ((DataInputStream)filterInputStream).readChar();
                ((DataInputStream)filterInputStream).readChar();
                ((DataInputStream)filterInputStream).readChar();
                ((DataInputStream)filterInputStream).readByte();
                ((DataInputStream)filterInputStream).readByte();
                ((DataInputStream)filterInputStream).readByte();
                ((DataInputStream)filterInputStream).readShort();
                ((DataInputStream)filterInputStream).readShort();
                ((DataInputStream)filterInputStream).readShort();
                this.setStatistic(1, ((DataInputStream)filterInputStream).readShort());
                short s = ((DataInputStream)filterInputStream).readShort();
                this.speedXf = s;
                this.speedYf = s;
                this.crosshairAngleSpeedF = ((DataInputStream)filterInputStream).readShort() << 10;
                this.crosshairRangeSpeedF = ((DataInputStream)filterInputStream).readShort();
                this.crosshairTargetSpeedF = ((DataInputStream)filterInputStream).readShort();
                this.crosshairVerticalOffsetF = ((DataInputStream)filterInputStream).readShort();
                this.stateTimeHoldingOutWeapon = ((DataInputStream)filterInputStream).readShort();
                this.stateTimePrepareToShot = ((DataInputStream)filterInputStream).readShort();
                this.stateTimeHidingWeapon = ((DataInputStream)filterInputStream).readShort();
                this.stateTimeHiddenWeaponOnSwap = ((DataInputStream)filterInputStream).readShort();
                this.stateTimeShowingWeapon = ((DataInputStream)filterInputStream).readShort();
                this.stateTimeReloadAfterIdle = ((DataInputStream)filterInputStream).readShort();
                this.stateTimeDeath = ((DataInputStream)filterInputStream).readShort();
                this.stateTimeDeathInCar = ((DataInputStream)filterInputStream).readShort();
                this.carEnterRangeQF = ((DataInputStream)filterInputStream).readShort();
                this.carEnterRangeQF *= this.carEnterRangeQF;
                this.carEnterRangeQF >>= 10;
                this.medicalHealPoints[0] = ((DataInputStream)filterInputStream).readShort();
                this.medicalHealPoints[1] = ((DataInputStream)filterInputStream).readShort();
                this.medicalHealPoints[2] = ((DataInputStream)filterInputStream).readShort();
                this.medicalHealPoints[3] = ((DataInputStream)filterInputStream).readShort();
                int n = ((DataInputStream)filterInputStream).readShort();
                ((DataInputStream)filterInputStream).readShort();
                this.weaponInfo = new int[n][11];
                for (int i = 0; i < n; ++i) {
                    if (i == 0) {
                        this.weaponInfo[i][0] = -1;
                        this.weaponInfo[i][2] = -1;
                    } else {
                        this.weaponInfo[i][0] = 0;
                        this.weaponInfo[i][2] = 0;
                    }
                    this.weaponInfo[i][1] = ((DataInputStream)filterInputStream).readShort();
                    this.weaponInfo[i][3] = ((DataInputStream)filterInputStream).readShort();
                    this.weaponInfo[i][4] = ((DataInputStream)filterInputStream).readShort();
                    this.weaponInfo[i][6] = ((DataInputStream)filterInputStream).readShort();
                    this.weaponInfo[i][7] = ((DataInputStream)filterInputStream).readShort();
                    this.weaponInfo[i][8] = ((DataInputStream)filterInputStream).readShort();
                    this.weaponInfo[i][5] = ((DataInputStream)filterInputStream).readShort();
                    this.weaponInfo[i][5] = this.weaponInfo[i][5] * this.weaponInfo[i][5] >> 10;
                    this.weaponInfo[i][9] = ((DataInputStream)filterInputStream).readShort();
                    this.weaponInfo[i][10] = ((DataInputStream)filterInputStream).readShort();
                }
                filterInputStream.close();
            }
            catch (Exception exception) {
                if (filterInputStream == null) break block8;
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.weapon = 0;
        this.car = null;
        this.direction = (byte)3;
        this.hotSpotBlocked = null;
        this.setStatistic(0, this.getStatistic((byte)1));
        this.inventoryClear();
        this.crosshairState = 0;
        this.crosshairRangeCurrentF = 0;
        this.crosshairPosition = new Vect();
        this.crosshairPositionTemp = new Vect();
        this.crosshairInit();
    }

    private void stateInit() {
        switch (this.state) {
            case 0: {
                this.speedCurrentXf = 0;
                this.speedCurrentYf = 0;
                break;
            }
            case 7: {
                this.setTarget(null);
                this.weaponBulletsShooted = (byte)(this.weaponBulletsShooted ^ this.weaponBulletsShooted);
                break;
            }
            case 6: {
                this.weaponBulletsShooted = (byte)(this.weaponBulletsShooted ^ this.weaponBulletsShooted);
                break;
            }
            case 9: {
                this.setTarget(null);
            }
        }
    }

    public void stateChange(byte by) {
        if (by != this.state) {
            this.animationFrameCounterReset();
            this.state = by;
            this.stateTime ^= this.stateTime;
            this.stateInit();
            this.controlBlock();
        }
    }

    public byte getState() {
        return this.state;
    }

    void reset() {
        statsEnemies = 0;
        statsNpc = 0;
        statsCars = 0;
        statsCups = 0;
        statsMissionTm = 0;
        for (int i = 0; i < 9; ++i) {
            if (i == 1) continue;
            Player2.stats[i] = 0;
        }
        this.weapon = 0;
        this.isInCar = false;
        this.car = null;
        this.direction = (byte)3;
        this.hotSpotBlocked = null;
        this.setStatistic(0, this.getStatistic((byte)1));
        this.inventoryClear();
        this.crosshairState = 0;
        this.crosshairRangeCurrentF = 0;
        this.crosshairPosition = new Vect();
        this.crosshairPositionTemp = new Vect();
        this.crosshairInit();
        this.stateChange((byte)1);
        this.weaponChangeBlocked = false;
    }

    void update(int n) {
        this.stateTime += (long)n;
        this.animationFrameCounterUpdate(n);
    }

    int getDamageDeal() {
        return Util.getRandom(this.weaponInfo[this.weapon][9], this.weaponInfo[this.weapon][10]);
    }

    void controlBlock() {
        this.controlIsBlocked = true;
    }

    int getStatistic(byte by) {
        return stats[by];
    }

    void setStatistic(int n, int n2) {
        Player2.stats[n] = n2;
        if (n == 0) {
            if (stats[n] > 0 && stats[n] > stats[1]) {
                Player2.stats[n] = stats[1];
            }
        } else if (stats[n] < 0) {
            Player2.stats[n] = 0;
        }
    }

    void statisticValueAdd(int n, int n2) {
        this.setStatistic(n, stats[n] + n2);
    }

    boolean damageTake(int n) {
        if (this.state != 12) {
            if (this.isInCar) {
                if (this.car.damageTake(n)) {
                    this.stateChange((byte)12);
                    return true;
                }
            } else {
                stats[0] = stats[0] - n;
                if (stats[0] <= 0) {
                    this.stateChange((byte)12);
                    return true;
                }
            }
        }
        return false;
    }

    void inventoryClear() {
        int n;
        this.inventory = new short[21];
        for (n = 0; n < this.inventory.length; ++n) {
            this.inventory[n] = 0;
        }
        for (n = 0; n < this.weaponInfo.length; ++n) {
            this.weaponInfo[n][2] = 0;
            this.weaponInfo[n][0] = 0;
        }
    }

    void inventorySet(byte by, int n) {
        if (n < 0) {
            n = 0;
        }
        switch (by) {
            case 9: {
                this.weaponSetAmmo((byte)1, n);
                break;
            }
            case 10: {
                this.weaponSetAmmo((byte)2, n);
                break;
            }
            case 11: {
                this.weaponSetAmmo((byte)3, n);
                break;
            }
            case 12: {
                this.weaponSetAmmo((byte)4, n);
                break;
            }
            default: {
                switch (by) {
                    case 13: 
                    case 14: {
                        if (n <= 1) break;
                        n = 1;
                    }
                }
                this.inventory[by] = (short)n;
            }
        }
    }

    void inventoryAdd(byte by, int n) {
        if (n > 0) {
            switch (by) {
                case 9: {
                    this.weaponCollect((byte)1, n);
                    break;
                }
                case 10: {
                    this.weaponCollect((byte)2, n);
                    break;
                }
                case 11: {
                    this.weaponCollect((byte)3, n);
                    break;
                }
                case 12: {
                    this.weaponCollect((byte)4, n);
                    break;
                }
                default: {
                    this.inventorySet(by, this.inventoryGetAmount(by) + n);
                    break;
                }
            }
        } else if (n < 0) {
            this.inventorySet(by, this.inventoryGetAmount(by) + n);
        }
    }

    int inventoryGetAmount(byte by) {
        switch (by) {
            case 9: {
                return this.weaponInfo[1][2] + this.weaponInfo[1][0];
            }
            case 10: {
                return this.weaponInfo[2][2] + this.weaponInfo[2][0];
            }
            case 11: {
                return this.weaponInfo[3][2] + this.weaponInfo[3][0];
            }
            case 12: {
                return this.weaponInfo[4][2] + this.weaponInfo[4][0];
            }
        }
        return this.inventory[by];
    }

    void heal(byte by) {
        stats[0] = stats[0] + this.medicalHealPoints[by];
        if (stats[0] > stats[1]) {
            Player2.stats[0] = stats[1];
        }
    }

    byte inventoryItemUse(byte by) {
        byte by2 = -1;
        switch (by) {
            case 0: {
                by2 = 0;
                break;
            }
            case 1: {
                by2 = 1;
                break;
            }
            case 2: {
                by2 = 2;
                break;
            }
            case 3: {
                by2 = 3;
            }
        }
        if (by2 >= 0) {
            if (this.inventory[by] > 0) {
                this.heal(by2);
                byte by3 = by;
                this.inventory[by3] = (short)(this.inventory[by3] - 1);
                return 0;
            }
            return 2;
        }
        return 1;
    }

    void setTarget(Enemy enemy) {
        if (enemy != this.targetEnemy) {
            this.targetEnemy = enemy;
            if (this.targetEnemy != null) {
                if (this.weapon != 0) {
                    this.crosshairState = 1;
                }
            } else {
                this.crosshairState = (byte)3;
            }
        }
    }

    boolean isTarget() {
        return this.crosshairState == 2;
    }

    boolean isAnimLoop() {
        return this.getState() != 4 && this.getState() != 12 && this.getState() != 5;
    }

    byte getCurrentFrame() {
        return this.animationFrameCounter;
    }

    byte getCurrentSequence() {
        int n = 0;
        block0 : switch (this.state) {
            case 2: {
                n = 4;
                break;
            }
            case 4: 
            case 5: {
                switch (this.weapon) {
                    case 0: {
                        n = 16;
                        break block0;
                    }
                    case 1: {
                        n = 32;
                        break block0;
                    }
                    case 2: {
                        n = 48;
                        break block0;
                    }
                    case 3: {
                        n = 64;
                        break block0;
                    }
                }
                break;
            }
            case 6: {
                switch (this.weapon) {
                    case 0: {
                        n = 12;
                        break;
                    }
                    case 1: {
                        n = 28;
                        break;
                    }
                    case 2: {
                        n = 44;
                        break;
                    }
                    case 3: {
                        n = 60;
                    }
                }
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 11: {
                switch (this.weapon) {
                    case 0: {
                        n = 8;
                        break;
                    }
                    case 1: {
                        n = 24;
                        break;
                    }
                    case 2: {
                        n = 40;
                        break;
                    }
                    case 3: {
                        n = 56;
                    }
                }
                break;
            }
            case 7: {
                switch (this.weapon) {
                    case 0: {
                        n = 20;
                        break;
                    }
                    case 1: {
                        n = 36;
                        break;
                    }
                    case 2: {
                        n = 52;
                        break;
                    }
                    case 3: {
                        n = 68;
                    }
                }
                break;
            }
            case 12: {
                return 72;
            }
            default: {
                n = 0;
            }
        }
        return (byte)(n + this.direction);
    }

    public void weaponSwapNext() {
        this.weaponNext = (byte)(this.weapon + 1);
        while (this.weaponNext < 4 && this.weaponInfo[this.weaponNext][0] <= 0 && this.weaponInfo[this.weaponNext][2] <= 0) {
            this.weaponNext = (byte)(this.weaponNext + 1);
        }
        if (this.weaponNext > 3) {
            this.weaponNext = (byte)(this.weaponNext ^ this.weaponNext);
        }
    }

    public void weaponSwapBest() {
        this.weaponNext = (byte)3;
        while (this.weaponNext > 0 && this.weaponInfo[this.weaponNext][0] <= 0 && this.weaponInfo[this.weaponNext][2] <= 0) {
            this.weaponNext = (byte)(this.weaponNext - 1);
        }
    }

    public boolean weaponCollect(byte by, int n) {
        if (this.weaponInfo[by][2] == this.weaponInfo[by][3] && this.weaponInfo[by][0] == this.weaponInfo[by][1]) {
            return false;
        }
        int[] nArray = this.weaponInfo[by];
        nArray[0] = nArray[0] + n;
        if (this.weaponInfo[by][0] > this.weaponInfo[by][1]) {
            int[] nArray2 = this.weaponInfo[by];
            nArray2[2] = nArray2[2] + (this.weaponInfo[by][0] - this.weaponInfo[by][1]);
            this.weaponInfo[by][0] = this.weaponInfo[by][1];
            if (this.weaponInfo[by][2] > this.weaponInfo[by][3]) {
                this.weaponInfo[by][2] = this.weaponInfo[by][3];
            }
        }
        if (by > this.weapon) {
            this.weaponNext = by;
            if (this.getState() == 6) {
                this.stateChange((byte)8);
            } else {
                this.stateChange((byte)9);
            }
        }
        return true;
    }

    public void weaponSetAmmo(byte by, int n) {
        int n2 = this.weaponInfo[by][0] = n < this.weaponInfo[by][1] ? n : this.weaponInfo[by][1];
        if ((n -= this.weaponInfo[by][1]) < 0) {
            n = 0;
        }
        int n3 = this.weaponInfo[by][2] = n < this.weaponInfo[by][3] ? n : this.weaponInfo[by][3];
        if (n > 0 && by > this.weapon) {
            this.weaponNext = by;
            if (this.getState() == 6) {
                this.stateChange((byte)8);
            } else {
                this.stateChange((byte)9);
            }
        } else if (n == 0) {
            this.weaponSwapBest();
            if (this.getState() == 6) {
                this.stateChange((byte)8);
            } else {
                this.stateChange((byte)9);
            }
        }
    }

    void crosshairInit() {
        this.crosshairPositionDefault = new Vect(0, 1024);
        this.crosshairCalculateDestinationAngle();
        this.crosshairAngleCurrentF = this.crosshairAngleDestF;
        this.crosshairPosition.rotate(this.crosshairPositionDefault, this.crosshairAngleCurrentF);
        this.crosshairPosition.x = this.crosshairPosition.x * this.crosshairRangeCurrentF >> 10;
        this.crosshairPosition.y = this.crosshairPosition.y * this.crosshairRangeCurrentF >> 10;
        this.crosshairPosition.y -= this.crosshairVerticalOffsetF;
    }

    public void crosshairCalculateDestinationAngle() {
        switch (this.direction) {
            case 0: {
                this.crosshairAngleDestF = 92160;
                break;
            }
            case 1: {
                this.crosshairAngleDestF = 276480;
                break;
            }
            case 2: {
                this.crosshairAngleDestF = 184320;
                break;
            }
            default: {
                this.crosshairAngleDestF = 0;
            }
        }
        if (this.crosshairAngleCurrentF - this.crosshairAngleDestF >= 184320) {
            this.crosshairAngleCurrentF -= 368640;
        } else if (this.crosshairAngleDestF - this.crosshairAngleCurrentF > 184320) {
            this.crosshairAngleCurrentF += 368640;
        }
    }

    void crosshairUpdate(int n) {
        switch (this.crosshairState) {
            case 0: {
                boolean bl = false;
                if (this.crosshairAngleCurrentF < this.crosshairAngleDestF) {
                    this.crosshairAngleCurrentF += this.crosshairAngleSpeedF * n >> 10;
                    if (this.crosshairAngleCurrentF > this.crosshairAngleDestF) {
                        this.crosshairAngleCurrentF = this.crosshairAngleDestF;
                    }
                    bl = true;
                } else if (this.crosshairAngleCurrentF > this.crosshairAngleDestF) {
                    this.crosshairAngleCurrentF -= this.crosshairAngleSpeedF * n >> 10;
                    if (this.crosshairAngleCurrentF < this.crosshairAngleDestF) {
                        this.crosshairAngleCurrentF = this.crosshairAngleDestF;
                    }
                    bl = true;
                }
                if (this.crosshairRangeCurrentF < this.weaponInfo[this.weapon][4]) {
                    this.crosshairRangeCurrentF += this.crosshairRangeSpeedF * n >> 10;
                    if (this.crosshairRangeCurrentF > this.weaponInfo[this.weapon][4]) {
                        this.crosshairRangeCurrentF = this.weaponInfo[this.weapon][4];
                    }
                    bl = true;
                } else if (this.crosshairRangeCurrentF > this.weaponInfo[this.weapon][4]) {
                    this.crosshairRangeCurrentF -= this.crosshairRangeSpeedF * n >> 10;
                    if (this.crosshairRangeCurrentF < this.weaponInfo[this.weapon][4]) {
                        this.crosshairRangeCurrentF = this.weaponInfo[this.weapon][4];
                    }
                    bl = true;
                }
                if (!bl) break;
                this.crosshairPosition.rotate(this.crosshairPositionDefault, this.crosshairAngleCurrentF);
                this.crosshairPosition.x = this.crosshairPosition.x * this.crosshairRangeCurrentF >> 10;
                this.crosshairPosition.y = this.crosshairPosition.y * this.crosshairRangeCurrentF >> 10;
                this.crosshairPosition.y -= this.crosshairVerticalOffsetF;
                break;
            }
            case 1: {
                auxX = this.targetEnemy.positionXf - this.positionXf;
                auxY = this.targetEnemy.positionYf + this.targetEnemy.enemyType.crosshairOffsetVerticalF - this.positionYf;
                if (this.crosshairPosition.x > auxX) {
                    this.crosshairPosition.x -= this.crosshairTargetSpeedF * n >> 10;
                    if (this.crosshairPosition.x < auxX) {
                        this.crosshairPosition.x = auxX;
                    }
                } else if (this.crosshairPosition.x < auxX) {
                    this.crosshairPosition.x += this.crosshairTargetSpeedF * n >> 10;
                    if (this.crosshairPosition.x > auxX) {
                        this.crosshairPosition.x = auxX;
                    }
                }
                if (this.crosshairPosition.y > auxY) {
                    this.crosshairPosition.y -= this.crosshairTargetSpeedF * n >> 10;
                    if (this.crosshairPosition.y < auxY) {
                        this.crosshairPosition.y = auxY;
                    }
                } else if (this.crosshairPosition.y < auxY) {
                    this.crosshairPosition.y += this.crosshairTargetSpeedF * n >> 10;
                    if (this.crosshairPosition.y > auxY) {
                        this.crosshairPosition.y = auxY;
                    }
                }
                if (this.crosshairPosition.x != auxX || this.crosshairPosition.y != auxY) break;
                this.crosshairState = (byte)2;
                break;
            }
            case 2: {
                this.crosshairPosition.x = this.targetEnemy.positionXf - this.positionXf;
                this.crosshairPosition.y = this.targetEnemy.positionYf + this.targetEnemy.enemyType.crosshairOffsetVerticalF - this.positionYf;
                break;
            }
            case 3: {
                this.crosshairPositionTemp.rotate(this.crosshairPositionDefault, this.crosshairAngleDestF);
                this.crosshairPositionTemp.x = this.crosshairPositionTemp.x * this.weaponInfo[this.weapon][4] >> 10;
                this.crosshairPositionTemp.y = this.crosshairPositionTemp.y * this.weaponInfo[this.weapon][4] >> 10;
                auxX = this.crosshairPositionTemp.x;
                auxY = this.crosshairPositionTemp.y;
                auxY -= this.crosshairVerticalOffsetF;
                if (this.crosshairPosition.x > auxX) {
                    this.crosshairPosition.x -= this.crosshairTargetSpeedF * n >> 10;
                    if (this.crosshairPosition.x < auxX) {
                        this.crosshairPosition.x = auxX;
                    }
                } else if (this.crosshairPosition.x < auxX) {
                    this.crosshairPosition.x += this.crosshairTargetSpeedF * n >> 10;
                    if (this.crosshairPosition.x > auxX) {
                        this.crosshairPosition.x = auxX;
                    }
                }
                if (this.crosshairPosition.y > auxY) {
                    this.crosshairPosition.y -= this.crosshairTargetSpeedF * n >> 10;
                    if (this.crosshairPosition.y < auxY) {
                        this.crosshairPosition.y = auxY;
                    }
                } else if (this.crosshairPosition.y < auxY) {
                    this.crosshairPosition.y += this.crosshairTargetSpeedF * n >> 10;
                    if (this.crosshairPosition.y > auxY) {
                        this.crosshairPosition.y = auxY;
                    }
                }
                if (this.crosshairPosition.x != auxX || this.crosshairPosition.y != auxY) break;
                this.crosshairState = 0;
                this.crosshairAngleCurrentF = this.crosshairAngleDestF;
                this.crosshairRangeCurrentF = this.weaponInfo[this.weapon][4];
            }
        }
    }

    boolean isCrosshairVisible() {
        return this.crosshairPosition.x != 0 || this.crosshairPosition.y != -this.crosshairVerticalOffsetF;
    }

    int getShootRangeQ() {
        return this.weaponInfo[this.weapon][5];
    }

    boolean isShootPossible() {
        if (this.weapon == 0) {
            return true;
        }
        if (this.state == 7 || this.state == 5) {
            return false;
        }
        return this.weaponInfo[this.weapon][0] > 0;
    }

    public void shoot() {
        if (this.isShootPossible()) {
            if (this.state == 5) {
                return;
            }
            if (this.state == 6) {
                this.stateChange((byte)4);
            } else {
                this.stateChange((byte)3);
            }
        } else {
            this.stateChange((byte)6);
        }
    }

    boolean shotAmmoDecrease() {
        this.weaponBulletsShooted = (byte)(this.weaponBulletsShooted + 1);
        if (this.weapon != 0) {
            if (!Mafia.cheatCodeAmmoFlag) {
                int[] nArray = this.weaponInfo[this.weapon];
                nArray[0] = nArray[0] - 1;
            }
            if (this.weaponInfo[this.weapon][0] == 0) {
                return true;
            }
        }
        return false;
    }

    void init() {
    }

    public void clearLevelStats() {
        Player2.stats[6] = 0;
        Player2.stats[7] = 0;
        Player2.stats[4] = 0;
        Player2.stats[8] = 0;
        Player2.stats[5] = 0;
        Player2.stats[3] = 0;
    }

    public void addStatsCurrentToTotal() {
        stats[12] = stats[12] + stats[6];
        stats[13] = stats[13] + stats[7];
        stats[10] = stats[10] + stats[4];
        stats[14] = stats[14] + stats[8];
        stats[11] = stats[11] + stats[5];
        stats[9] = stats[9] + stats[3];
        this.clearLevelStats();
    }

    public int getTotalScore() {
        return stats[9] * 30 + stats[13] * 1 + stats[10] * 20 + stats[14] * 1 + stats[11] * 5 + stats[6] * 10 + (3600 - stats[9]) * 1;
    }
}

