/*
 * Decompiled with CFR 0.152.
 */
package SAF_GUI;

import SAF_Core.Txt;
import SAF_GUI.ScrollBar;
import javax.microedition.lcdui.Graphics;

public class TextBox {
    public static final String N = "";
    private Txt saftext = null;
    private char[] text;
    private char[][] txt;
    public int verticalOffsetF = 0;
    private int textRows;
    private int textHeight;
    private int textAlignment;
    private int positionX;
    private int positionY;
    private int width;
    private int height;
    private boolean isScrollBar;
    private boolean isScorllBarVisible;
    private ScrollBar scrollBar;
    private final int TXT_WIDTH_OFFSET;

    public TextBox() {
        this.TXT_WIDTH_OFFSET = 3;
    }

    public void init(Txt txt) {
        this.scrollBar = new ScrollBar();
        this.saftext = txt;
    }

    public void setText(char[][] cArray) {
        this.verticalOffsetF = 0;
        this.text = null;
        this.txt = cArray;
        this.textRows = this.txt.length;
        this.textHeight = this.textRows * this.saftext.getFont().getFontHeight();
        ++this.textHeight;
    }

    public void setText(char[] cArray) {
        if (cArray == null) {
            return;
        }
        this.verticalOffsetF = 0;
        this.text = cArray;
        this.txt = this.saftext.splitText(cArray, ' ', this.width);
        this.textRows = this.txt.length;
        this.textHeight = this.textRows * this.saftext.getFont().getFontHeight();
        ++this.textHeight;
    }

    public int getPosX() {
        return this.positionX;
    }

    public int getPosY() {
        return this.positionY;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public char[] getText() {
        return this.text;
    }

    public int getTextHeight() {
        return this.textHeight;
    }

    public void setPositionX(int n) {
        this.positionX = n;
    }

    public void setPositionY(int n) {
        this.positionY = n;
        if (this.isScrollBar) {
            this.scrollBar.setLayout(this.scrollBar.getPosX(), this.positionY + this.scrollBar.getInternalOffset() + this.scrollBar.getBordWidth(), this.scrollBar.getWidth(), this.scrollBar.getHeight());
        }
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public void setTextAlignment(int n) {
        this.textAlignment = n;
    }

    public void setScrollBarVisibility(boolean bl) {
        this.isScorllBarVisible = bl;
    }

    public void setFontPalette(int n) {
        this.saftext.getFont().gfx.setPalettesSetCurrent(n);
    }

    public void paint(Graphics graphics) {
        int n = 0;
        if (this.isScrollBar) {
            if (this.isScorllBarVisible) {
                this.scrollBar.paint(graphics);
            }
        } else if ((this.textAlignment & 2) != 0) {
            n = this.height - this.textHeight >> 1;
        } else if ((this.textAlignment & 0x20) != 0) {
            n = this.height - this.textHeight;
        }
        this.saftext.drawTextInRegion(graphics, this.txt, this.positionX, this.positionY + n, this.width + 3, this.height, this.verticalOffsetF >> 10, this.textAlignment);
    }

    public void scrollUp(int n) {
        if (this.isScrollBar) {
            this.verticalOffsetF += n;
            if (this.verticalOffsetF >> 10 > 0) {
                this.verticalOffsetF ^= this.verticalOffsetF;
            }
            this.scrollBar.setSlidePosition(ScrollBar.calculatePercentSHL(-this.verticalOffsetF >> 10, this.textHeight));
        }
    }

    public void scrollUp(int n, int n2) {
        int n3 = n2 > 0 ? n * n2 >> 10 : 1;
        this.scrollUp(n3);
    }

    public void scrollDown(int n) {
        if (this.isScrollBar) {
            this.verticalOffsetF -= n;
            if (this.verticalOffsetF >> 10 < -(this.textHeight - this.height)) {
                this.verticalOffsetF = -(this.textHeight - this.height) << 10;
            }
            this.scrollBar.setSlidePosition(ScrollBar.calculatePercentSHL(-(this.verticalOffsetF >> 10), this.textHeight));
        }
    }

    public void scrollDown(int n, int n2) {
        int n3 = n2 > 0 ? n * n2 >> 10 : 1;
        this.scrollDown(n3);
    }

    public void scrollReset() {
        this.verticalOffsetF = 0;
    }

    public boolean isScroll() {
        return this.isScrollBar;
    }

    public boolean isScrollDown() {
        return this.isScrollBar && this.verticalOffsetF > 0 - (this.textHeight - this.height);
    }

    public boolean isScrollUp() {
        return this.isScrollBar && this.verticalOffsetF < 0;
    }

    public void calculateSlideSize() {
        if (this.textHeight > this.height) {
            this.isScrollBar = true;
            this.scrollBar.setSlideSize(ScrollBar.calculatePercentSHL(this.height, this.textHeight));
            this.scrollBar.setSlidePosition(ScrollBar.calculatePercentSHL(-(this.verticalOffsetF >> 10), this.textHeight));
        } else {
            this.isScrollBar = false;
            this.verticalOffsetF = 0;
        }
    }

    public void setScrollBarSize(int n, int n2) {
        this.scrollBar.setLayout(this.positionX + this.width, this.positionY, n, n2);
    }

    public void setScrollBarParameters(int n, int n2, int n3, int n4, int n5) {
        this.scrollBar.setExternalOffset(n);
        this.scrollBar.setInternalOffset(n2);
        this.scrollBar.setBordWidth(n3);
        this.scrollBar.setColorSlide(n4);
        this.scrollBar.setColorBackground(n5);
    }
}

