package com.mglib.mission;

import java.io.*;

 /**
  * <p>Title: engine of RPG game</p>
  * <p>Description: RPG ϷĶ, v3.0ʱӵ</p>
  * <p>Copyright: Copyright (c) 2007</p>
  * <p>Company: mig</p>
  * @author lianghao chen
  * @version 1.0
 */
public class Mission
{
    /**Чֵ*/
    public static final short INVALIDATE_VALUE = -32768;

    /** ϵͳͶ */
    public static final byte TYPE_SM_MAIN_LINE = 0;
    public static final byte TYPE_SM_BRANCH_LINE = 1;
    public static final byte TYPE_SM_HIDE_LINE = 2;
    public static final byte TYPE_SM_ASSISTANT_LINE = 3;

    /** ɶ: RECEIVED,ACCOMPLISHED,SUBMITED */
    public static final byte TASK_VALUE_NOT_RECEIVED = 0;
    public static final byte TASK_VALUE_RECEIVED_NOT_ACCOMPLISHED = 1;
    public static final byte TASK_VALUE_ACCOMPLISHED_NOT_SUBMITED = 99;
    public static final byte TASK_VALUE_SUBMITED = 100;

    /**  */
    public static final byte COUNT_SYSTEM_TASK = 127;

    /** ϵͳе */
    public static Mission[] missions = new Mission[COUNT_SYSTEM_TASK];


    /** ɶcompletion */
    public short value;

    /**  */
    public byte type;
    /** , */
    public String name, desc;

    /** ܴʱĶԻ,ύʱĶԻ */
    public String acceptDlg, putInDlg;

    /** һ */
    public short awardPropertyIndex0;
    public byte awardPropertyCondition0;
    public short awardPropertyValue0;
    /** ڶ */
    public short awardPropertyIndex1;
    public byte awardPropertyCondition1;
    public short awardPropertyValue1;

    /** Ʒ */
    public short goodsID, goodsValue;

    /** װ */
    public short equipID, equipValue;

    /**
     * missionʼƶ
     */
    public Mission ()
    {
	//Чmission
	this.type = -1;

	this.awardPropertyIndex0 = INVALIDATE_VALUE;
	this.awardPropertyIndex1 = INVALIDATE_VALUE;
	this.goodsID = INVALIDATE_VALUE;
	this.equipID = INVALIDATE_VALUE;
    }

    /**
     * ȡ
     * @param dis DataInputStream
     */
    public static void loadMissions (DataInputStream dis)throws Exception
    {
	int count = dis.readShort ();
	for ( int i = 0; i < count; i++ )
	{
	    byte ov = dis.readByte ();
	    byte t = dis.readByte ();
	    Mission m = missions[ov] = new Mission();
	    m.type = t;
	    m.name = dis.readUTF ();
	    m.desc = dis.readUTF ();
	    //09-7-29 7:21, modified by lianghao chen, б
	    m.acceptDlg = dis.readUTF ();
	    m.putInDlg = dis.readUTF ();
	    //
	    // 1
	    if ( dis.readByte () == 1 )
	    {
		m.awardPropertyIndex0 = dis.readShort ();
		m.awardPropertyCondition0 = dis.readByte ();
		m.awardPropertyValue0 = dis.readShort ();
	    }
	    // 2
	    if ( dis.readByte () == 1 )
	    {
		m.awardPropertyIndex1 = dis.readShort ();
		m.awardPropertyCondition1 = dis.readByte ();
		m.awardPropertyValue1 = dis.readShort ();
	    }

	    //Ʒ
	    if ( dis.readByte () == 1 )
	    {
		m.goodsID = dis.readShort ();
		m.goodsValue = dis.readShort ();
	    }
	    //װ
	    if ( dis.readByte () == 1 )
	    {
		m.equipID = dis.readShort ();
		m.equipValue = dis.readShort ();
	    }
	}
    }
}
