/*
 * Decompiled with CFR 0.152.
 */
package res.smarts;

import bbs.framework.game.BBSSmartGame;
import bbs.framework.library.BBSSprite;
import bbs.framework.models.BBSGame;
import bbs.framework.models.BBSSmartSprite;
import game.SpaceKidGame;

public class Elevator
extends BBSSmartSprite {
    private BBSSprite marty;
    private final int fsStand;
    private boolean moveDown = false;
    private boolean moveUp = false;
    private static int[] levels = new int[3];
    private static int targetLevel;

    public Elevator(BBSSprite[] sprite, int x, int y, int sType, int oid) {
        super(sprite, sType, oid);
        this.fsStand = 1;
        this.zorder = -1;
        this.rSprite[0].addFrameSet(new int[]{0}, 210, true);
        this.rSprite[0].doAnimation(1, 1, 0, true);
    }

    public static BBSSmartSprite create(BBSGame game, int x, int y, int sType, int oid, String pngName, int l1, int l2, int l3) {
        int yAnchor = -100;
        if (pngName.equals("elevator2")) {
            yAnchor = 90;
        }
        Elevator.levels[0] = l1;
        Elevator.levels[1] = l2;
        Elevator.levels[2] = l3;
        targetLevel = y;
        return new Elevator(new BBSSprite[]{new BBSSprite(game, "sprites/" + pngName + ".sif", 0, yAnchor, 0, x, y, 0)}, 0, 0, sType, oid);
    }

    public void doAnimation(BBSSmartGame game, int time) {
        if (this.marty == null) {
            this.marty = ((SpaceKidGame)game).marty.rSprite[0];
        }
        this.rSprite[0].doAnimation(1, 0, time, true);
        if (this.moveUp) {
            if (this.rSprite[0].y > targetLevel) {
                --this.rSprite[0].y;
            } else {
                this.moveUp = false;
            }
        } else if (this.moveDown) {
            if (this.rSprite[0].y < targetLevel) {
                ++this.rSprite[0].y;
            } else {
                this.moveDown = false;
            }
        } else if (this.onceInMs(time, 3000)) {
            if (this.marty.y > this.rSprite[0].y + 50) {
                this.moveDown = true;
                this.setTargetLevel();
            }
            if (this.marty.y < this.rSprite[0].y - 50) {
                this.moveUp = true;
                this.setTargetLevel();
            }
        }
    }

    public void trigger(String command, int[] pars) {
        if (command.equals("moveUp")) {
            this.moveUp = true;
            this.setTargetLevel();
        }
        if (command.equals("moveDown")) {
            this.moveDown = true;
            this.setTargetLevel();
        }
    }

    public int interract(BBSSmartGame game, BBSSmartSprite sprite, int action) {
        if (action == 8 && game.factory.checkSpriteInteraction(sprite.rSprite[0], this.rSprite[0], 8)) {
            sprite.rSprite[0].y = this.rSprite[0].y + 6;
            return 1;
        }
        if (action == 1 && game.factory.checkSpriteInteraction(sprite.rSprite[0], this.rSprite[0], 8)) {
            this.moveUp = true;
            this.setTargetLevel();
            return 1;
        }
        if (action == 2 && game.factory.checkSpriteInteraction(sprite.rSprite[0], this.rSprite[0], 8)) {
            this.moveDown = true;
            this.setTargetLevel();
            return 1;
        }
        return 0;
    }

    private void setTargetLevel() {
        if (this.moveUp && this.rSprite[0].y > levels[0]) {
            targetLevel = this.rSprite[0].y > levels[1] ? levels[1] : levels[0];
        }
        if (this.moveDown) {
            targetLevel = this.rSprite[0].y < levels[1] ? levels[1] : levels[2];
        }
    }
}

