/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.color_game;

import com.siemens.mp.color_game.Layer;
import com.siemens.mp.color_game.TiledLayer;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Sprite
extends Layer {
    public static final int TRANS_NONE = 0;
    public static final int TRANS_ROT90 = 5;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_MIRROR_ROT90 = 7;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR_ROT270 = 4;
    private static final int INVERTED_AXES = 4;
    private static final int X_FLIP = 2;
    private static final int Y_FLIP = 1;
    private static final int ALPHA_BITMASK = -16777216;
    Image sourceImage;
    int numberFrames;
    int[] frameCoordsX;
    int[] frameCoordsY;
    int srcFrameWidth;
    int srcFrameHeight;
    int[] frameSequence;
    private int sequenceIndex;
    private boolean customSequenceDefined;
    int dRefX;
    int dRefY;
    int collisionRectX;
    int collisionRectY;
    int collisionRectWidth;
    int collisionRectHeight;
    int t_currentTransformation;

    public Sprite(Image image) {
        super(image.getWidth(), image.getHeight());
        this.initializeFrames(image, image.getWidth(), image.getHeight(), false);
        this.initCollisionRectBounds();
    }

    public Sprite(Image image, int frameWidth, int frameHeight) {
        super(frameWidth, frameHeight);
        if (frameWidth < 1 || frameHeight < 1 || image.getWidth() % frameWidth != 0 || image.getHeight() % frameHeight != 0) {
            throw new IllegalArgumentException();
        }
        this.initializeFrames(image, frameWidth, frameHeight, false);
        this.initCollisionRectBounds();
    }

    public Sprite(Sprite s2) {
        super(s2 != null ? s2.getWidth() : 0, s2 != null ? s2.getHeight() : 0);
        if (s2 == null) {
            throw new NullPointerException();
        }
        this.sourceImage = Image.createImage((Image)s2.sourceImage);
        this.numberFrames = s2.numberFrames;
        this.frameCoordsX = new int[this.numberFrames];
        this.frameCoordsY = new int[this.numberFrames];
        System.arraycopy(s2.frameCoordsX, 0, this.frameCoordsX, 0, s2.getRawFrameCount());
        System.arraycopy(s2.frameCoordsY, 0, this.frameCoordsY, 0, s2.getRawFrameCount());
        this.x = s2.getX();
        this.y = s2.getY();
        this.dRefX = s2.dRefX;
        this.dRefY = s2.dRefY;
        this.collisionRectX = s2.collisionRectX;
        this.collisionRectY = s2.collisionRectY;
        this.collisionRectWidth = s2.collisionRectWidth;
        this.collisionRectHeight = s2.collisionRectHeight;
        this.srcFrameWidth = s2.srcFrameWidth;
        this.srcFrameHeight = s2.srcFrameHeight;
        this.setVisible(s2.isVisible());
        this.frameSequence = new int[s2.getFrameSequenceLength()];
        this.setFrameSequence(s2.frameSequence);
        this.setFrame(s2.getFrame());
        this.setRefPixelPosition(s2.getRefPixelX(), s2.getRefPixelY());
    }

    public void defineReferencePixel(int x2, int y2) {
        this.dRefX = x2;
        this.dRefY = y2;
    }

    public void setRefPixelPosition(int x2, int y2) {
        this.x = x2 - this.dRefX;
        this.y = y2 - this.dRefY;
    }

    public int getRefPixelX() {
        return this.x + this.dRefX;
    }

    public int getRefPixelY() {
        return this.y + this.dRefY;
    }

    public void setFrame(int sequenceIndex) {
        if (sequenceIndex < 0 || sequenceIndex >= this.frameSequence.length) {
            throw new IndexOutOfBoundsException();
        }
        this.sequenceIndex = sequenceIndex;
    }

    public final int getFrame() {
        return this.sequenceIndex;
    }

    public int getRawFrameCount() {
        return this.numberFrames;
    }

    public int getFrameSequenceLength() {
        return this.frameSequence.length;
    }

    public void nextFrame() {
        this.sequenceIndex = (this.sequenceIndex + 1) % this.frameSequence.length;
    }

    public void prevFrame() {
        this.sequenceIndex = this.sequenceIndex == 0 ? this.frameSequence.length - 1 : --this.sequenceIndex;
    }

    public final void paint(Graphics g2) {
        if (g2 == null) {
            throw new NullPointerException();
        }
        if (this.visible) {
            int clipX = g2.getClipX();
            int clipY = g2.getClipY();
            int clipW = g2.getClipWidth();
            int clipH = g2.getClipHeight();
            g2.setClip(this.x, this.y, this.srcFrameWidth, this.srcFrameHeight);
            g2.drawImage(this.sourceImage, this.x - this.frameCoordsX[this.frameSequence[this.sequenceIndex]], this.y - this.frameCoordsY[this.frameSequence[this.sequenceIndex]], 20);
            g2.setClip(clipX, clipY, clipW, clipH);
        }
    }

    public void setFrameSequence(int[] sequence) {
        if (sequence == null) {
            this.sequenceIndex = 0;
            this.customSequenceDefined = false;
            this.frameSequence = new int[this.numberFrames];
            for (int i2 = 0; i2 < this.numberFrames; ++i2) {
                this.frameSequence[i2] = i2;
            }
            return;
        }
        if (sequence.length < 1) {
            throw new IllegalArgumentException();
        }
        for (int i3 = 0; i3 < sequence.length; ++i3) {
            if (sequence[i3] >= 0 && sequence[i3] < this.numberFrames) continue;
            throw new ArrayIndexOutOfBoundsException();
        }
        this.customSequenceDefined = true;
        this.frameSequence = new int[sequence.length];
        System.arraycopy(sequence, 0, this.frameSequence, 0, sequence.length);
        this.sequenceIndex = 0;
    }

    public void setImage(Image img, int frameWidth, int frameHeight) {
        if (frameWidth < 1 || frameHeight < 1 || img.getWidth() % frameWidth != 0 || img.getHeight() % frameHeight != 0) {
            throw new IllegalArgumentException();
        }
        int noOfFrames = img.getWidth() / frameWidth * (img.getHeight() / frameHeight);
        boolean maintainCurFrame = true;
        if (noOfFrames < this.numberFrames) {
            maintainCurFrame = false;
            this.customSequenceDefined = false;
        }
        if (this.srcFrameWidth != frameWidth || this.srcFrameHeight != frameHeight) {
            int oldX = this.x + this.dRefX;
            int oldY = this.y + this.dRefY;
            this.setWidthImpl(frameWidth);
            this.setHeightImpl(frameHeight);
            this.initializeFrames(img, frameWidth, frameHeight, maintainCurFrame);
            this.initCollisionRectBounds();
            this.x = oldX - this.dRefX;
            this.y = oldY - this.dRefY;
        } else {
            this.initializeFrames(img, frameWidth, frameHeight, maintainCurFrame);
        }
    }

    public void defineCollisionRectangle(int x2, int y2, int width, int height) {
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException();
        }
        this.collisionRectX = x2;
        this.collisionRectY = y2;
        this.collisionRectWidth = width;
        this.collisionRectHeight = height;
    }

    public void setTransform(int transform) {
    }

    public final boolean collidesWith(Sprite s2, boolean pixelLevel) {
        if (!s2.visible || !this.visible) {
            return false;
        }
        int otherLeft = s2.x + s2.collisionRectX;
        int otherTop = s2.y + s2.collisionRectY;
        int otherRight = otherLeft + s2.collisionRectWidth;
        int otherBottom = otherTop + s2.collisionRectHeight;
        int left = this.x + this.collisionRectX;
        int top = this.y + this.collisionRectY;
        int right = left + this.collisionRectWidth;
        int bottom = top + this.collisionRectHeight;
        return this.intersectRect(otherLeft, otherTop, otherRight, otherBottom, left, top, right, bottom);
    }

    public final boolean collidesWith(TiledLayer t2, boolean pixelLevel) {
        if (!t2.visible || !this.visible) {
            return false;
        }
        int tLx1 = t2.x;
        int tLy1 = t2.y;
        int tLx2 = tLx1 + t2.width;
        int tLy2 = tLy1 + t2.height;
        int tW = t2.cellWidth;
        int tH = t2.cellHeight;
        int sx1 = this.x + this.collisionRectX;
        int sy1 = this.y + this.collisionRectY;
        int sx2 = sx1 + this.collisionRectWidth;
        int sy2 = sy1 + this.collisionRectHeight;
        int tNumCols = t2.columns;
        int tNumRows = t2.rows;
        if (!this.intersectRect(tLx1, tLy1, tLx2, tLy2, sx1, sy1, sx2, sy2)) {
            return false;
        }
        int startCol = sx1 <= tLx1 ? 0 : (sx1 - tLx1) / tW;
        int startRow = sy1 <= tLy1 ? 0 : (sy1 - tLy1) / tH;
        int endCol = sx2 < tLx2 ? (sx2 - 1 - tLx1) / tW : tNumCols - 1;
        int endRow = sy2 < tLy2 ? (sy2 - 1 - tLy1) / tH : tNumRows - 1;
        for (int row = startRow; row <= endRow; ++row) {
            for (int col = startCol; col <= endCol; ++col) {
                if (t2.cellMatrix[row][col] == 0) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean collidesWith(Image image, int x2, int y2, boolean pixelLevel) {
        int bottom;
        int right;
        int top;
        int left;
        int otherBottom;
        if (!this.visible) {
            return false;
        }
        int otherLeft = x2;
        int otherTop = y2;
        int otherRight = x2 + image.getWidth();
        return this.intersectRect(otherLeft, otherTop, otherRight, otherBottom = y2 + image.getHeight(), left = this.x + this.collisionRectX, top = this.y + this.collisionRectY, right = left + this.collisionRectWidth, bottom = top + this.collisionRectHeight);
    }

    private void initializeFrames(Image image, int fWidth, int fHeight, boolean maintainCurFrame) {
        int imageW = image.getWidth();
        int imageH = image.getHeight();
        int numHorizontalFrames = imageW / fWidth;
        int numVerticalFrames = imageH / fHeight;
        this.sourceImage = image;
        this.srcFrameWidth = fWidth;
        this.srcFrameHeight = fHeight;
        this.numberFrames = numHorizontalFrames * numVerticalFrames;
        this.frameCoordsX = new int[this.numberFrames];
        this.frameCoordsY = new int[this.numberFrames];
        if (!maintainCurFrame) {
            this.sequenceIndex = 0;
        }
        if (!this.customSequenceDefined) {
            this.frameSequence = new int[this.numberFrames];
        }
        int currentFrame = 0;
        for (int yy = 0; yy < imageH; yy += fHeight) {
            for (int xx = 0; xx < imageW; xx += fWidth) {
                this.frameCoordsX[currentFrame] = xx;
                this.frameCoordsY[currentFrame] = yy;
                if (!this.customSequenceDefined) {
                    this.frameSequence[currentFrame] = currentFrame;
                }
                ++currentFrame;
            }
        }
    }

    private void initCollisionRectBounds() {
        this.collisionRectX = 0;
        this.collisionRectY = 0;
        this.collisionRectWidth = this.width;
        this.collisionRectHeight = this.height;
    }

    private boolean intersectRect(int r1x1, int r1y1, int r1x2, int r1y2, int r2x1, int r2y1, int r2x2, int r2y2) {
        return r2x1 < r1x2 && r2y1 < r1y2 && r2x2 > r1x1 && r2y2 > r1y1;
    }
}

