/*
 * Decompiled with CFR 0.152.
 */
package com.bsg.dm2.nokiacolor;

import com.bsg.nokiacolor.BSCanvas;
import com.nokia.mid.sound.Sound;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DiamondMine2Canvas
extends BSCanvas
implements Runnable {
    private Image statusImage;
    private Image[] tiles;
    private Image[][] playerImages;
    private Image[][] enemyImages;
    private Image[] teleportImages;
    private Image livesImage;
    private Image diamondImage;
    private Image slashImage;
    private Image optionsImage;
    private Image[] digits;
    private Graphics statusGraphics;
    private Thread instance;
    private boolean running;
    private int screenWidth;
    private int halfScreenWidth;
    private int screenHeight;
    private int halfScreenHeight;
    private int statusHeight = 7;
    private int levelWidth;
    private int levelHeight;
    private int levelDiamonds;
    private int xOffSet;
    private int xOffSetAdjust;
    private int xOffSetAdjustValue = 0;
    private int xOffSetCounter;
    private int yOffSet;
    private int yOffSetAdjust;
    private int yOffSetAdjustValue = 13;
    private int yOffSetCounter;
    private int tileWidth;
    private int halfTileWidth;
    private int tileHeight;
    private int halfTileHeight;
    private int[][][] level;
    private int[][] spiders;
    private int currentLevel;
    private int difficulty;
    private int exitX;
    private int exitY;
    private int[][] teleporters;
    private int teleportFrame;
    private int fallingCounter;
    private int backBufferSegmentWidth;
    private int backBufferSegmentHeight;
    private int pXPos;
    private int pYPos;
    private int pDX;
    private int pDY;
    private int pSpeed;
    private int pDiamonds;
    private int pLives;
    private int pMove;
    private int pFrame;
    private int pCurrentTileX;
    private int pCurrentTileY;
    private int pMoveToTileX;
    private int pMoveToTileY;
    private Image endScreen;
    private String[] endString;
    private int endStringCenterX;
    private int endStringTop;
    private int[][] endGems;
    private int[] endBaddy;
    private boolean playerTalking;
    private boolean enemyTalking;
    private Font[] endStringFont;
    private boolean pInTile;
    private Vector fallingObjects;
    private final int[] P_FRAMES = new int[]{2, 2, 2, 2, 1};
    private final int P_UP;
    private final int P_DOWN;
    private final int P_LEFT;
    private final int P_RIGHT;
    private final int P_DEAD;
    private final int[] M_FRAMES = new int[]{2, 2, 2, 2};
    private final int M_UP;
    private final int M_DOWN;
    private final int M_LEFT;
    private final int M_RIGHT;
    private final int M_X;
    private final int M_Y;
    private final int M_DX;
    private final int M_DY;
    private final int M_SPEED;
    private final int M_MOVE_COUNTER;
    private final int M_MOVE;
    private final int M_FRAME;
    private final int DIAMOND_SCORE;
    private final int ENEMY_SCORE;
    private final int MAX_BUFFER_WIDTH;
    private final int MAX_BUFFER_HEIGHT;
    private boolean up;
    private boolean down;
    private boolean left;
    private boolean right;
    private boolean updateStatus;
    private boolean keyPressed;
    private boolean start;
    private boolean levelClear;
    private boolean blankScreen;
    private boolean won;
    private boolean dead;
    private boolean gameover;
    private boolean gamecomplete;
    private Sound[] sounds;
    private final byte[][] soundBytes = new byte[][]{{2, 74, 58, 81, -47, -107, -51, -48, 4, 0, 27, 32, 105, 5, 88, 98, 7, 24, -94, 48, 73, -56, 26, 97, 8, 26, 65, 86, 24, -126, 0, 0}, {2, 74, 58, 81, -47, -107, -51, -48, 4, 0, 27, 24, 77, 5, 80, 97, 5, -112, 65, -128, 0, 0}, {2, 74, 58, 81, -47, -107, -51, -48, 4, 0, 27, 32, 86, 0, 0}};
    private final int WON_MELODY;
    private final int DEAD_MELODY;
    private final int BEEP_MED;

    public DiamondMine2Canvas() {
        Image image;
        this.P_UP = 0;
        this.P_DOWN = 1;
        this.P_LEFT = 2;
        this.P_RIGHT = 3;
        this.P_DEAD = 4;
        this.M_UP = 0;
        this.M_DOWN = 1;
        this.M_LEFT = 2;
        this.M_RIGHT = 3;
        this.M_X = 0;
        this.M_Y = 1;
        this.M_DX = 2;
        this.M_DY = 3;
        this.M_SPEED = 4;
        this.M_MOVE_COUNTER = 5;
        this.M_MOVE = 6;
        this.M_FRAME = 7;
        this.DIAMOND_SCORE = 10;
        this.ENEMY_SCORE = 20;
        this.MAX_BUFFER_WIDTH = 1000;
        this.MAX_BUFFER_HEIGHT = 1000;
        this.WON_MELODY = 0;
        this.DEAD_MELODY = 1;
        this.BEEP_MED = 2;
        this.screenWidth = this.getWidth();
        this.halfScreenWidth = this.screenWidth / 2;
        this.screenHeight = this.getHeight() - this.statusHeight;
        this.halfScreenHeight = this.screenHeight / 2;
        this.statusImage = Image.createImage((int)this.screenWidth, (int)this.statusHeight);
        this.statusGraphics = this.statusImage.getGraphics();
        this.sounds = new Sound[this.soundBytes.length];
        for (int i2 = 0; i2 < this.sounds.length; ++i2) {
            this.sounds[i2] = new Sound(this.soundBytes[i2], 1);
            this.sounds[i2].init(this.soundBytes[i2], 1);
        }
        try {
            int n2;
            this.tiles = new Image[50];
            image = Image.createImage((String)"/Tiles.png");
            this.tileWidth = image.getWidth() / 10;
            this.halfTileWidth = this.tileWidth / 2;
            this.tileHeight = image.getHeight() / 5;
            this.halfTileHeight = this.tileHeight / 2;
            for (n2 = 10; n2 < 11; ++n2) {
                this.tiles[n2] = this.getImage(image, this.tileWidth, this.tileHeight, -(n2 - n2 / 10 * 10) * this.tileWidth, -(n2 / 10) * this.tileHeight);
            }
            for (n2 = 20; n2 < 25; ++n2) {
                this.tiles[n2] = this.getImage(image, this.tileWidth, this.tileHeight, -(n2 - n2 / 10 * 10) * this.tileWidth, -(n2 / 10) * this.tileHeight);
            }
            for (n2 = 29; n2 < 35; ++n2) {
                this.tiles[n2] = this.getImage(image, this.tileWidth, this.tileHeight, -(n2 - n2 / 10 * 10) * this.tileWidth, -(n2 / 10) * this.tileHeight);
            }
            for (n2 = 40; n2 < 45; ++n2) {
                this.tiles[n2] = this.getImage(image, this.tileWidth, this.tileHeight, -(n2 - n2 / 10 * 10) * this.tileWidth, -(n2 / 10) * this.tileHeight);
            }
            for (n2 = 48; n2 < 50; ++n2) {
                this.tiles[n2] = this.getImage(image, this.tileWidth, this.tileHeight, -(n2 - n2 / 10 * 10) * this.tileWidth, -(n2 / 10) * this.tileHeight);
            }
            Image image2 = Image.createImage((String)"/PlayerImages.png");
            this.playerImages = new Image[5][];
            for (int i3 = 0; i3 < 4; ++i3) {
                this.playerImages[i3] = new Image[]{this.getImage(image2, this.tileWidth, this.tileHeight, 0, -this.tileHeight * i3), this.getImage(image2, this.tileWidth, this.tileHeight, -this.tileWidth, -this.tileHeight * i3)};
            }
            this.playerImages[4] = new Image[]{this.getImage(image2, this.tileWidth, this.tileHeight, 0, -this.tileHeight * 4)};
            Image image3 = Image.createImage((String)"/EnemyImages.png");
            this.enemyImages = new Image[4][];
            for (int i4 = 0; i4 < 4; ++i4) {
                this.enemyImages[i4] = new Image[]{this.getImage(image3, this.tileWidth, this.tileHeight, 0, -this.tileHeight * i4), this.getImage(image3, this.tileWidth, this.tileHeight, -this.tileWidth, -this.tileHeight * i4)};
            }
            Image image4 = Image.createImage((String)"/TeleportImages.png");
            this.teleportImages = new Image[4];
            for (int i5 = 0; i5 < 4; ++i5) {
                this.teleportImages[i5] = this.getImage(image4, this.tileWidth, this.tileHeight, -this.tileWidth * i5, 0);
            }
            Image image5 = Image.createImage((String)"/Status.png");
            this.livesImage = this.getImage(image5, 7, 7, -30, 0);
            this.diamondImage = this.getImage(image5, 9, 7, -37, 0);
            this.slashImage = this.getImage(image5, 3, 5, -46, 0);
            this.optionsImage = this.getImage(image5, image5.getWidth() - 49, 7, -49, 0);
            this.digits = new Image[10];
            for (int i6 = 0; i6 < this.digits.length; ++i6) {
                this.digits[i6] = this.getImage(image5, 3, 5, -3 * i6, 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.endScreen = Image.createImage((int)this.screenWidth, (int)(this.screenHeight + this.statusHeight));
        image = this.endScreen.getGraphics();
        image.setColor(0xAA9988);
        image.fillRect(0, 0, this.screenWidth, this.screenHeight + this.statusHeight);
        int n3 = this.screenWidth / this.tileWidth + 1;
        for (int i7 = 0; i7 < n3; ++i7) {
            image.drawImage(this.tiles[20], i7 * this.tileWidth, 0, 20);
            image.drawImage(this.tiles[20], i7 * this.tileWidth, this.screenHeight + this.statusHeight, 36);
        }
        this.pSpeed = (this.tileWidth + this.tileHeight) / 6 + 1;
    }

    private Image getImage(Image image, int n2, int n3, int n4, int n5) {
        Image image2 = Image.createImage((int)n2, (int)n3);
        Graphics graphics = image2.getGraphics();
        graphics.drawImage(image, n4, n5, 20);
        return image2;
    }

    public void startGame(int n2, Gauge gauge) {
        this.difficulty = n2;
        this.currentLevel = 0;
        try {
            this.loadLevel(gauge);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pLives = 5;
        this.score = 0;
        gauge.setValue(100);
        this.commandListener.commandAction(BSCanvas.DISPLAY_CANVAS, (Displayable)this);
    }

    public void nextLevel(Gauge gauge) {
        if (!this.dead) {
            ++this.currentLevel;
        }
        try {
            this.loadLevel(gauge);
        }
        catch (Exception exception) {
            // empty catch block
        }
        gauge.setValue(100);
        this.commandListener.commandAction(BSCanvas.DISPLAY_CANVAS, (Displayable)this);
    }

    private void loadLevel(Gauge gauge) throws Exception {
        int n2;
        int n3;
        InputStream inputStream = this.getClass().getResourceAsStream(String.valueOf(String.valueOf(new StringBuffer("/Levels/level").append(this.currentLevel).append(".txt"))));
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        gauge.setValue(10);
        this.pXPos = dataInputStream.readInt() * this.tileWidth;
        this.pYPos = dataInputStream.readInt() * this.tileHeight;
        int n4 = dataInputStream.readInt();
        int n5 = dataInputStream.readInt();
        this.level = new int[n5][n4][1];
        this.levelWidth = n4 * this.tileWidth;
        this.levelHeight = n5 * this.tileHeight;
        int n6 = this.levelWidth < 1000 ? 1 : (n3 = this.levelWidth / 1000 + (this.levelWidth % 1000 == 0 ? 0 : 1));
        int n7 = this.levelHeight < 1000 ? 1 : this.levelHeight / 1000 + (this.levelHeight % 1000 == 0 ? 0 : 1);
        this.backBufferSegmentWidth = this.levelWidth / n3 + this.tileWidth - this.levelWidth / n3 % this.tileWidth;
        this.backBufferSegmentHeight = this.levelHeight / n7 + this.tileHeight - this.levelHeight / n7 % this.tileHeight;
        this.levelDiamonds = 0;
        this.fallingObjects = new Vector(10);
        Vector<int[]> vector = new Vector<int[]>(10);
        gauge.setValue(30);
        for (n2 = 0; n2 < this.level[0].length; ++n2) {
            for (int i2 = 0; i2 < this.level.length; ++i2) {
                this.level[i2][n2][0] = dataInputStream.readByte();
                if (this.level[i2][n2][0] == 0) continue;
                if (this.level[i2][n2][0] >= 30 && this.level[i2][n2][0] < 45) {
                    this.level[i2][n2] = new int[]{this.level[i2][n2][0], n2, i2, 0};
                }
                if (this.level[i2][n2][0] >= 40 && this.level[i2][n2][0] < 45) {
                    ++this.levelDiamonds;
                }
                if (this.level[i2][n2][0] == 29) {
                    this.exitX = n2;
                    this.exitY = i2;
                }
                if (this.level[i2][n2][0] < 50 || this.level[i2][n2][0] >= 60) continue;
                vector.addElement(new int[]{n2 * this.tileWidth, i2 * this.tileHeight, 0, -(this.pSpeed - (3 - this.difficulty)), this.pSpeed - (3 - this.difficulty), 0, 0, 0});
                this.level[i2][n2] = new int[]{0};
            }
        }
        gauge.setValue(50);
        this.teleporters = new int[dataInputStream.readByte() * 2][];
        for (n2 = 0; n2 < this.teleporters.length / 2; ++n2) {
            int[] nArray = new int[]{dataInputStream.readByte(), dataInputStream.readByte(), dataInputStream.readByte(), dataInputStream.readByte()};
            this.teleporters[n2 * 2] = new int[]{nArray[0], nArray[1], nArray[2], nArray[3]};
            this.teleporters[n2 * 2 + 1] = new int[]{nArray[2], nArray[3], nArray[0], nArray[1]};
        }
        this.spiders = new int[vector.size()][];
        for (n2 = 0; n2 < this.spiders.length; ++n2) {
            this.spiders[n2] = (int[])vector.elementAt(n2);
        }
        dataInputStream.close();
        gauge.setValue(70);
        this.pCurrentTileX = this.pXPos / this.tileWidth;
        this.pCurrentTileY = this.pYPos / this.tileHeight;
        this.pMoveToTileX = this.pXPos / this.tileWidth;
        this.pMoveToTileY = this.pYPos / this.tileHeight;
        this.pDX = 0;
        this.pDY = 0;
        this.pDiamonds = 0;
        this.pMove = 3;
        this.pFrame = 0;
        this.pInTile = true;
        this.xOffSet = this.levelWidth < this.screenWidth ? (this.screenWidth - this.levelWidth) / 2 : 0;
        this.yOffSet = this.levelHeight < this.screenHeight ? (this.screenHeight - this.levelHeight) / 2 : 0;
        this.updateStatus = true;
        this.won = false;
        this.levelClear = false;
        this.dead = false;
        this.gameover = false;
        this.gamecomplete = false;
        this.start = true;
        this.xOffSetCounter = 0;
        this.xOffSetAdjust = -this.xOffSetAdjustValue;
        this.yOffSetCounter = 0;
        this.yOffSetAdjust = 0;
        this.fallingCounter = 0;
    }

    public void loadGame(byte[] byArray, Gauge gauge) throws Exception {
        int n2;
        int n3;
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        this.currentLevel = dataInputStream.readByte();
        this.difficulty = dataInputStream.readByte();
        this.loadLevel(gauge);
        this.pXPos = dataInputStream.readInt();
        this.pYPos = dataInputStream.readInt();
        this.pDX = dataInputStream.readByte();
        this.pDY = dataInputStream.readByte();
        this.pSpeed = dataInputStream.readByte();
        this.pDiamonds = dataInputStream.readByte();
        this.pLives = dataInputStream.readByte();
        this.pMove = dataInputStream.readByte();
        this.pFrame = dataInputStream.readByte();
        this.pCurrentTileX = dataInputStream.readByte();
        this.pCurrentTileY = dataInputStream.readByte();
        this.pMoveToTileX = dataInputStream.readByte();
        this.pMoveToTileY = dataInputStream.readByte();
        gauge.setValue(80);
        for (n3 = 0; n3 < this.level[0].length; ++n3) {
            for (n2 = 0; n2 < this.level.length; ++n2) {
                byte by = dataInputStream.readByte();
                this.level[n2][n3] = by >= 30 && by < 45 ? new int[]{by, dataInputStream.readByte(), dataInputStream.readByte(), dataInputStream.readByte()} : new int[]{by};
            }
        }
        gauge.setValue(90);
        n3 = dataInputStream.readByte();
        this.fallingObjects = new Vector(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            this.fallingObjects.addElement(this.level[dataInputStream.readByte()][dataInputStream.readByte()]);
        }
        for (n2 = 0; n2 < this.spiders.length; ++n2) {
            if (dataInputStream.readByte() == -1) {
                this.spiders[n2] = null;
                continue;
            }
            this.spiders[n2][0] = dataInputStream.readInt();
            this.spiders[n2][1] = dataInputStream.readInt();
            this.spiders[n2][2] = dataInputStream.readByte();
            this.spiders[n2][3] = dataInputStream.readByte();
            this.spiders[n2][4] = dataInputStream.readByte();
            this.spiders[n2][5] = dataInputStream.readByte();
            this.spiders[n2][6] = dataInputStream.readByte();
            this.spiders[n2][7] = dataInputStream.readByte();
        }
        dataInputStream.close();
        gauge.setValue(100);
    }

    public byte[] saveGame(Gauge gauge) {
        try {
            int n2;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            gauge.setValue(10);
            dataOutputStream.writeByte(this.currentLevel);
            dataOutputStream.writeByte(this.difficulty);
            dataOutputStream.writeInt(this.pXPos);
            dataOutputStream.writeInt(this.pYPos);
            dataOutputStream.writeByte(this.pDX);
            dataOutputStream.writeByte(this.pDY);
            dataOutputStream.writeByte(this.pSpeed);
            dataOutputStream.writeByte(this.pDiamonds);
            dataOutputStream.writeByte(this.pLives);
            dataOutputStream.writeByte(this.pMove);
            dataOutputStream.writeByte(this.pFrame);
            dataOutputStream.writeByte(this.pCurrentTileX);
            dataOutputStream.writeByte(this.pCurrentTileY);
            dataOutputStream.writeByte(this.pMoveToTileX);
            dataOutputStream.writeByte(this.pMoveToTileY);
            gauge.setValue(20);
            for (n2 = 0; n2 < this.level[0].length; ++n2) {
                for (int i2 = 0; i2 < this.level.length; ++i2) {
                    dataOutputStream.writeByte(this.level[i2][n2][0]);
                    if (this.level[i2][n2][0] < 30 || this.level[i2][n2][0] >= 45) continue;
                    dataOutputStream.writeByte(this.level[i2][n2][1]);
                    dataOutputStream.writeByte(this.level[i2][n2][2]);
                    dataOutputStream.writeByte(this.level[i2][n2][3]);
                }
            }
            gauge.setValue(50);
            dataOutputStream.writeByte(this.fallingObjects.size());
            for (n2 = 0; n2 < this.fallingObjects.size(); ++n2) {
                int[] nArray = (int[])this.fallingObjects.elementAt(n2);
                dataOutputStream.writeByte(nArray[2]);
                dataOutputStream.writeByte(nArray[1]);
            }
            gauge.setValue(70);
            for (n2 = 0; n2 < this.spiders.length; ++n2) {
                if (this.spiders[n2] == null) {
                    dataOutputStream.writeByte(-1);
                    continue;
                }
                dataOutputStream.writeByte(0);
                dataOutputStream.writeInt(this.spiders[n2][0]);
                dataOutputStream.writeInt(this.spiders[n2][1]);
                dataOutputStream.writeByte(this.spiders[n2][2]);
                dataOutputStream.writeByte(this.spiders[n2][3]);
                dataOutputStream.writeByte(this.spiders[n2][4]);
                dataOutputStream.writeByte(this.spiders[n2][5]);
                dataOutputStream.writeByte(this.spiders[n2][6]);
                dataOutputStream.writeByte(this.spiders[n2][7]);
            }
            gauge.setValue(80);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception exception) {
            System.out.println("Saveing");
            byte[] byArray = null;
            return byArray;
        }
    }

    protected void paint(Graphics graphics) {
        if (!this.gamecomplete) {
            int n2;
            int n3;
            int n4;
            int n5;
            if (this.updateStatus) {
                this.statusGraphics.setColor(0xFFFFFF);
                this.statusGraphics.fillRect(0, 0, this.screenWidth, this.statusHeight);
                this.statusGraphics.drawImage(this.optionsImage, this.screenWidth - this.optionsImage.getWidth(), 0, 20);
                n5 = 0;
                n4 = 10000;
                for (n3 = 5; n3 > 0; --n3) {
                    this.statusGraphics.drawImage(this.digits[this.score / n4 % 10], n5, 1, 20);
                    n4 /= 10;
                    n5 += this.digits[0].getWidth() + 1;
                }
                this.statusGraphics.drawImage(this.livesImage, n5, 0, 20);
                this.statusGraphics.drawImage(this.digits[this.pLives / 10 % 10], n5 += this.livesImage.getWidth() + 1, 1, 20);
                this.statusGraphics.drawImage(this.digits[this.pLives % 10], n5 += this.digits[0].getWidth() + 1, 1, 20);
                this.statusGraphics.drawImage(this.diamondImage, n5 += this.digits[0].getWidth() + 1, 0, 20);
                this.statusGraphics.drawImage(this.digits[this.pDiamonds / 10 % 10], n5 += this.diamondImage.getWidth() + 1, 1, 20);
                this.statusGraphics.drawImage(this.digits[this.pDiamonds % 10], n5 += this.digits[0].getWidth() + 1, 1, 20);
                this.statusGraphics.drawImage(this.slashImage, n5 += this.digits[0].getWidth() + 1, 1, 20);
                this.statusGraphics.drawImage(this.digits[this.levelDiamonds / 10 % 10], n5 += this.slashImage.getWidth() + 1, 1, 20);
                this.statusGraphics.drawImage(this.digits[this.levelDiamonds % 10], n5 += this.digits[0].getWidth() + 1, 1, 20);
                this.updateStatus = false;
            }
            if (this.pXPos + this.halfTileWidth > this.halfScreenWidth + this.xOffSetAdjust - this.xOffSetCounter && this.levelWidth + this.xOffSet > this.screenWidth || this.pXPos + this.halfTileWidth < this.halfScreenWidth + this.xOffSetAdjust - this.xOffSetCounter - this.xOffSet && this.xOffSet < 0) {
                this.xOffSet = this.halfScreenWidth + this.xOffSetAdjust - this.xOffSetCounter - (this.pXPos + this.halfTileWidth);
                if (this.levelWidth + this.xOffSet < this.screenWidth) {
                    this.xOffSet = -(this.levelWidth - this.screenWidth);
                } else if (this.xOffSet > 0) {
                    this.xOffSet = 0;
                }
            }
            if (!this.won && !this.dead) {
                if (this.xOffSetCounter > 0) {
                    this.xOffSetCounter -= this.xOffSetCounter / 5 + 1;
                } else if (this.xOffSetCounter < 0) {
                    this.xOffSetCounter += -this.xOffSetCounter / 5 + 1;
                }
            }
            if (this.pYPos + this.halfTileHeight > this.halfScreenHeight + this.yOffSetAdjust - this.yOffSetCounter && this.levelHeight + this.yOffSet > this.screenHeight || this.pYPos + this.halfTileHeight < this.halfScreenHeight + this.yOffSetAdjust - this.yOffSetCounter - this.yOffSet && this.yOffSet < 0) {
                this.yOffSet = this.halfScreenHeight + this.yOffSetAdjust - this.yOffSetCounter - (this.pYPos + this.halfTileHeight);
                if (this.levelHeight + this.yOffSet < this.screenHeight) {
                    this.yOffSet = -(this.levelHeight - this.screenHeight);
                } else if (this.yOffSet > 0) {
                    this.yOffSet = 0;
                }
            }
            if (!this.won && !this.dead) {
                if (this.yOffSetCounter > 0) {
                    this.yOffSetCounter -= this.yOffSetCounter / 5 + 1;
                } else if (this.yOffSetCounter < 0) {
                    this.yOffSetCounter += -this.yOffSetCounter / 5 + 1;
                }
            }
            graphics.setColor(0xAA9988);
            graphics.fillRect(0, 0, this.screenWidth, this.screenHeight);
            n5 = this.screenWidth / this.tileWidth + 1;
            n4 = this.screenHeight / this.tileHeight + 1;
            n3 = -this.xOffSet / this.tileWidth;
            int n6 = -this.yOffSet / this.tileHeight;
            for (n2 = n3; n2 <= n3 + n5; ++n2) {
                for (int i2 = n6; i2 <= n6 + n4; ++i2) {
                    if (n2 < 0 || i2 < 0 || i2 >= this.level.length || n2 >= this.level[i2].length || this.level[i2][n2][0] <= 0) continue;
                    graphics.drawImage(this.tiles[this.level[i2][n2][0]], this.xOffSet + n2 * this.tileWidth, this.yOffSet + i2 * this.tileHeight, 20);
                }
            }
            for (n2 = 0; n2 < this.teleporters.length; ++n2) {
                graphics.drawImage(this.teleportImages[this.teleportFrame], this.xOffSet + this.teleporters[n2][0] * this.tileWidth, this.yOffSet + this.teleporters[n2][1] * this.tileHeight, 20);
            }
            for (n2 = 0; n2 < this.spiders.length; ++n2) {
                if (this.spiders[n2] == null) continue;
                graphics.drawImage(this.enemyImages[this.spiders[n2][6]][this.spiders[n2][7]], this.xOffSet + this.spiders[n2][0], this.yOffSet + this.spiders[n2][1], 20);
            }
            graphics.drawImage(this.playerImages[this.pMove][this.pFrame], this.xOffSet + this.pXPos, this.yOffSet + this.pYPos, 20);
            for (n2 = 0; n2 < this.fallingObjects.size(); ++n2) {
                int[] nArray = (int[])this.fallingObjects.elementAt(n2);
                graphics.drawImage(this.tiles[nArray[0]], this.xOffSet + nArray[1] * this.tileWidth, this.yOffSet + nArray[2] * this.tileHeight, 20);
            }
            graphics.drawImage(this.statusImage, 0, this.screenHeight, 20);
            if (this.levelClear) {
                this.drawText(graphics, this.parseString(this.langT[0]), this.getFont(this.langA[0]), true, this.halfScreenWidth, this.halfScreenHeight);
            } else if (this.gameover) {
                this.drawText(graphics, this.parseString(this.langT[1]), this.getFont(this.langA[1]), true, this.halfScreenWidth, this.halfScreenHeight);
            }
            if (this.start) {
                this.drawText(graphics, this.parseString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.langT[2]))).append(this.currentLevel + 1)))), this.getFont(this.langA[2]), true, this.halfScreenWidth, this.halfScreenHeight);
            }
            if (this.paused) {
                this.drawText(graphics, this.parseString(this.langT[3]), this.getFont(this.langA[3]), true, this.halfScreenWidth, this.halfScreenHeight);
            }
        } else {
            graphics.drawImage(this.endScreen, 0, 0, 20);
            for (int i3 = 0; i3 < this.endGems.length; ++i3) {
                graphics.drawImage(this.tiles[this.endGems[i3][0]], this.endGems[i3][1], this.endGems[i3][2], 20);
            }
            graphics.drawImage(this.playerImages[this.pMove][this.pFrame], this.pXPos, this.pYPos, 20);
            graphics.drawImage(this.enemyImages[this.endBaddy[0]][this.endBaddy[1]], this.endBaddy[2], this.endBaddy[3], 20);
            if (this.playerTalking) {
                graphics.drawLine(this.pXPos + this.halfTileWidth, this.pYPos - this.halfTileHeight, this.pXPos + this.tileWidth, this.pYPos - this.halfTileHeight - this.tileHeight);
            }
            if (this.enemyTalking) {
                graphics.drawLine(this.endBaddy[2] + this.halfTileWidth, this.endBaddy[3] - this.halfTileHeight, this.endBaddy[2], this.endBaddy[3] - this.halfTileHeight - this.tileHeight);
            }
            if (this.endString != null) {
                this.drawText(graphics, this.endString, this.endStringFont, true, this.endStringCenterX, this.endStringTop);
            }
        }
        if (this.blankScreen) {
            graphics.setColor(0xFFFFFF);
            graphics.setClip(0, 0, this.screenWidth, this.screenHeight + this.statusHeight);
            graphics.fillRect(0, 0, this.screenWidth, this.screenHeight + this.statusHeight);
            this.blankScreen = false;
        }
    }

    public void start() {
        if (this.instance == null || !this.running && !this.paused && !this.instance.isAlive()) {
            this.instance = new Thread(this);
            this.running = true;
            this.instance.start();
        } else if (this.instance.isAlive()) {
            this.running = true;
        }
    }

    public void stop() {
        this.running = false;
        this.keyPressed = false;
    }

    public void hideNotify() {
        this.stop();
    }

    public void showNotify() {
        this.start();
    }

    public void restartLevel() {
        BSCanvas.playSound(this.sounds[1]);
        BSCanvas.vibrate(50, 500);
        this.pMove = 4;
        this.pFrame = 0;
        this.dead = true;
        this.keyPressed = true;
    }

    private void moveSpiders() {
        for (int i2 = 0; i2 < this.spiders.length; ++i2) {
            if (this.spiders[i2] == null) continue;
            this.spiders[i2][0] = this.spiders[i2][0] + this.spiders[i2][2];
            this.spiders[i2][1] = this.spiders[i2][1] + this.spiders[i2][3];
            int n2 = 0;
            int n3 = 0;
            switch (this.spiders[i2][6]) {
                case 0: {
                    n2 = (this.spiders[i2][0] + this.halfTileWidth) / this.tileWidth;
                    n3 = this.spiders[i2][1] / this.tileHeight;
                    break;
                }
                case 1: {
                    n2 = (this.spiders[i2][0] + this.halfTileWidth) / this.tileWidth;
                    n3 = (this.spiders[i2][1] + this.tileHeight) / this.tileHeight;
                    break;
                }
                case 2: {
                    n2 = this.spiders[i2][0] / this.tileWidth;
                    n3 = (this.spiders[i2][1] + this.halfTileHeight) / this.tileHeight;
                    break;
                }
                case 3: {
                    n2 = (this.spiders[i2][0] + this.tileWidth) / this.tileWidth;
                    n3 = (this.spiders[i2][1] + this.halfTileHeight) / this.tileHeight;
                }
            }
            if (this.level[n3][n2][0] >= 10) {
                switch (this.spiders[i2][6]) {
                    case 0: {
                        this.spiders[i2][1] = n3 * this.tileHeight + this.tileHeight;
                        break;
                    }
                    case 1: {
                        this.spiders[i2][1] = n3 * this.tileHeight - this.tileHeight;
                        break;
                    }
                    case 2: {
                        this.spiders[i2][0] = n2 * this.tileWidth + this.tileWidth;
                        break;
                    }
                    case 3: {
                        this.spiders[i2][0] = n2 * this.tileWidth - this.tileWidth;
                    }
                }
                this.spiders[i2][6] = BSCanvas.getRandom(4);
                switch (this.spiders[i2][6]) {
                    case 0: {
                        this.spiders[i2][2] = 0;
                        this.spiders[i2][3] = -this.spiders[i2][4];
                        break;
                    }
                    case 1: {
                        this.spiders[i2][2] = 0;
                        this.spiders[i2][3] = this.spiders[i2][4];
                        break;
                    }
                    case 2: {
                        this.spiders[i2][2] = -this.spiders[i2][4];
                        this.spiders[i2][3] = 0;
                        break;
                    }
                    case 3: {
                        this.spiders[i2][2] = this.spiders[i2][4];
                        this.spiders[i2][3] = 0;
                    }
                }
            }
            if (this.pXPos + this.halfTileWidth < this.spiders[i2][0] || this.pXPos + this.halfTileWidth > this.spiders[i2][0] + this.tileWidth || this.pYPos + this.halfTileHeight < this.spiders[i2][1] || this.pYPos + this.halfTileHeight > this.spiders[i2][1] + this.tileHeight) continue;
            this.restartLevel();
        }
    }

    public void run() {
        while (this.running) {
            try {
                int n2;
                int n3;
                int n4;
                if (this.start) {
                    this.repaint();
                    Thread.sleep(2000L);
                    this.start = false;
                    this.repaint();
                }
                if (this.levelClear || this.gameover || !this.keyPressed) continue;
                ++this.teleportFrame;
                if (this.teleportFrame == this.teleportImages.length) {
                    this.teleportFrame = 0;
                }
                if (this.pInTile) {
                    if (this.up) {
                        this.pMoveToTileX = this.pCurrentTileX;
                        this.pMoveToTileY = this.pCurrentTileY - 1;
                        if (this.pMove != 0) {
                            this.pMove = 0;
                            this.yOffSetCounter = this.yOffSetAdjustValue - this.yOffSetAdjust + this.yOffSetCounter;
                            this.yOffSetAdjust = this.yOffSetAdjustValue;
                            this.xOffSetCounter = -this.xOffSetAdjust + this.xOffSetCounter;
                            this.xOffSetAdjust = 0;
                        }
                    } else if (this.down) {
                        this.pMoveToTileX = this.pCurrentTileX;
                        this.pMoveToTileY = this.pCurrentTileY + 1;
                        if (this.pMove != 1) {
                            this.pMove = 1;
                            this.yOffSetCounter = -this.yOffSetAdjustValue - this.yOffSetAdjust + this.yOffSetCounter;
                            this.yOffSetAdjust = -this.yOffSetAdjustValue;
                            this.xOffSetCounter = -this.xOffSetAdjust + this.xOffSetCounter;
                            this.xOffSetAdjust = 0;
                        }
                    } else if (this.left) {
                        this.pMoveToTileX = this.pCurrentTileX - 1;
                        this.pMoveToTileY = this.pCurrentTileY;
                        if (this.pMove != 2) {
                            this.pMove = 2;
                            this.xOffSetCounter = this.xOffSetAdjustValue - this.xOffSetAdjust + this.xOffSetCounter;
                            this.xOffSetAdjust = this.xOffSetAdjustValue;
                            this.yOffSetCounter = -this.yOffSetAdjust + this.yOffSetCounter;
                            this.yOffSetAdjust = 0;
                        }
                    } else if (this.right) {
                        this.pMoveToTileX = this.pCurrentTileX + 1;
                        this.pMoveToTileY = this.pCurrentTileY;
                        if (this.pMove != 3) {
                            this.pMove = 3;
                            this.xOffSetCounter = -this.xOffSetAdjustValue - this.xOffSetAdjust + this.xOffSetCounter;
                            this.xOffSetAdjust = -this.xOffSetAdjustValue;
                            this.yOffSetCounter = -this.yOffSetAdjust + this.yOffSetCounter;
                            this.yOffSetAdjust = 0;
                        }
                    }
                }
                int n5 = 0;
                int n6 = 0;
                if (this.level[this.pMoveToTileY][this.pMoveToTileX][0] < 20 || this.level[this.pMoveToTileY][this.pMoveToTileX][0] >= 40) {
                    n5 = this.pMoveToTileX * this.tileWidth - this.pXPos;
                    n6 = this.pMoveToTileY * this.tileHeight - this.pYPos;
                } else if (this.pCurrentTileY == this.pMoveToTileY && this.level[this.pMoveToTileY][this.pMoveToTileX][0] >= 30 && this.level[this.pMoveToTileY][this.pMoveToTileX][0] < 40) {
                    n4 = this.pMoveToTileX;
                    n4 = this.pMoveToTileX - this.pCurrentTileX > 0 ? ++n4 : --n4;
                    if (this.level[this.pMoveToTileY][n4][0] < 10) {
                        n3 = 0;
                        for (n2 = 0; n2 < this.spiders.length; ++n2) {
                            if (this.spiders[n2] == null || (this.spiders[n2][0] + this.halfTileWidth) / this.tileWidth != n4 || (this.spiders[n2][1] + this.halfTileHeight) / this.tileHeight != this.pMoveToTileY) continue;
                            n3 = 1;
                        }
                        if (n3 == 0) {
                            this.level[this.pMoveToTileY][n4] = this.level[this.pMoveToTileY][this.pMoveToTileX];
                            this.level[this.pMoveToTileY][this.pMoveToTileX] = new int[]{0};
                            this.level[this.pMoveToTileY][n4][1] = n4;
                            if (this.level[this.pMoveToTileY + 1][n4][0] < 10 || this.level[this.pMoveToTileY + 1][n4][0] >= 30 && this.level[this.pMoveToTileY + 1][n4][0] <= 45 && this.level[this.pMoveToTileY + 1][n4][3] == 1) {
                                this.fallingObjects.addElement(this.level[this.pMoveToTileY][n4]);
                                this.level[this.pMoveToTileY][n4][3] = 1;
                            }
                            n5 = this.pMoveToTileX * this.tileWidth - this.pXPos;
                            n6 = this.pMoveToTileY * this.tileHeight - this.pYPos;
                        } else {
                            this.pMoveToTileX = this.pCurrentTileX;
                            this.pMoveToTileY = this.pCurrentTileY;
                        }
                    } else {
                        this.pMoveToTileX = this.pCurrentTileX;
                        this.pMoveToTileY = this.pCurrentTileY;
                    }
                } else {
                    this.pMoveToTileX = this.pCurrentTileX;
                    this.pMoveToTileY = this.pCurrentTileY;
                }
                n4 = 0;
                if (n5 > 0) {
                    this.pDX = this.pSpeed;
                    if (this.pDX > n5) {
                        if (this.right && (this.level[this.pMoveToTileY][this.pMoveToTileX + 1][0] < 20 || this.level[this.pMoveToTileY][this.pMoveToTileX + 1][0] >= 40)) {
                            n4 = this.pDX - n5;
                        }
                        this.pDX = n5;
                    }
                } else if (n5 < 0) {
                    this.pDX = -this.pSpeed;
                    if (this.pDX < n5) {
                        if (this.left && (this.level[this.pMoveToTileY][this.pMoveToTileX - 1][0] < 20 || this.level[this.pMoveToTileY][this.pMoveToTileX - 1][0] >= 40)) {
                            n4 = this.pDX - n5;
                        }
                        this.pDX = n5;
                    }
                } else {
                    this.pDX = 0;
                }
                n3 = 0;
                if (n6 > 0) {
                    this.pDY = this.pSpeed;
                    if (this.pDY > n6) {
                        if (this.down && (this.level[this.pMoveToTileY + 1][this.pMoveToTileX][0] < 20 || this.level[this.pMoveToTileY + 1][this.pMoveToTileX][0] >= 40)) {
                            n3 = this.pDY - n6;
                        }
                        this.pDY = n6;
                    }
                } else if (n6 < 0) {
                    this.pDY = -this.pSpeed;
                    if (this.pDY < n6) {
                        if (this.up && (this.level[this.pMoveToTileY - 1][this.pMoveToTileX][0] < 20 || this.level[this.pMoveToTileY - 1][this.pMoveToTileX][0] >= 40)) {
                            n3 = this.pDY - n6;
                        }
                        this.pDY = n6;
                    }
                } else {
                    this.pDY = 0;
                }
                this.pXPos += this.pDX;
                this.pYPos += this.pDY;
                ++this.pFrame;
                if (this.pFrame == this.P_FRAMES[this.pMove]) {
                    this.pFrame = 0;
                }
                if (!this.pInTile && this.pXPos % this.tileWidth == 0 && this.pYPos % this.tileHeight == 0) {
                    if (this.level[this.pMoveToTileY][this.pMoveToTileX][0] >= 10 && this.level[this.pMoveToTileY][this.pMoveToTileX][0] < 20) {
                        this.level[this.pMoveToTileY][this.pMoveToTileX] = new int[]{0};
                    } else if (this.level[this.pMoveToTileY][this.pMoveToTileX][0] >= 40) {
                        if (this.level[this.pMoveToTileY][this.pMoveToTileX][0] < 45 && this.level[this.pMoveToTileY][this.pMoveToTileX][3] != 0) {
                            this.fallingObjects.removeElement(this.level[this.pMoveToTileY][this.pMoveToTileX]);
                        }
                        this.collect(this.pMoveToTileX, this.pMoveToTileY, this.level[this.pMoveToTileY][this.pMoveToTileX][0]);
                    }
                    if (this.pMoveToTileY - 1 >= 0 && this.level[this.pMoveToTileY - 1][this.pMoveToTileX][0] >= 40 && this.level[this.pMoveToTileY - 1][this.pMoveToTileX][0] < 45 && this.level[this.pMoveToTileY - 1][this.pMoveToTileX][3] == 0) {
                        for (n2 = this.pMoveToTileY - 1; n2 > 0 && this.level[n2][this.pMoveToTileX][0] >= 30 && this.level[n2][this.pMoveToTileX][0] < 45 && this.level[n2][this.pMoveToTileX][3] == 0; --n2) {
                            this.fallingObjects.addElement(this.level[n2][this.pMoveToTileX]);
                            this.level[n2][this.pMoveToTileX][3] = 1;
                        }
                    }
                    for (n2 = this.pCurrentTileY - 1; n2 > 0 && this.level[n2][this.pCurrentTileX][0] >= 30 && this.level[n2][this.pCurrentTileX][0] < 45 && this.level[n2][this.pCurrentTileX][3] == 0; --n2) {
                        this.fallingObjects.addElement(this.level[n2][this.pCurrentTileX]);
                        this.level[n2][this.pCurrentTileX][3] = 1;
                    }
                    this.pCurrentTileX = this.pXPos / this.tileWidth;
                    this.pCurrentTileY = this.pYPos / this.tileHeight;
                    this.pInTile = true;
                } else if (this.pInTile && (this.pXPos % this.tileWidth != 0 || this.pYPos % this.tileHeight != 0)) {
                    this.pInTile = false;
                }
                this.pXPos += n4;
                this.pYPos += n3;
                this.moveSpiders();
                for (n2 = 0; n2 < this.spiders.length; ++n2) {
                    if (this.spiders[n2] == null) continue;
                    int[] nArray = this.spiders[n2];
                    nArray[7] = nArray[7] + 1;
                    if (this.spiders[n2][7] != this.M_FRAMES[this.spiders[n2][6]]) continue;
                    this.spiders[n2][7] = 0;
                }
                ++this.fallingCounter;
                if (this.fallingCounter == 2) {
                    this.fallingCounter = 0;
                    this.checkDrop();
                }
                this.repaint();
                this.serviceRepaints();
                Thread.sleep(66L);
                if (this.won) {
                    this.stop();
                    BSCanvas.playSound(this.sounds[0]);
                    this.repaint();
                    Thread.sleep(1000L);
                    this.levelClear = true;
                    this.repaint();
                    Thread.sleep(1000L);
                    if (this.currentLevel == 11) {
                        this.runEndSequence();
                        continue;
                    }
                    this.blankScreen = true;
                    this.repaint();
                    this.serviceRepaints();
                    this.commandListener.commandAction(BSCanvas.LEVEL_ENDED, (Displayable)this);
                    continue;
                }
                if (!this.dead) continue;
                this.stop();
                --this.pLives;
                this.updateStatus = true;
                this.repaint();
                Thread.sleep(1000L);
                if (this.pLives == 0) {
                    this.gameover = true;
                    this.repaint();
                    Thread.sleep(3000L);
                    this.commandListener.commandAction(BSCanvas.GAME_ENDED, (Displayable)this);
                    continue;
                }
                this.commandListener.commandAction(BSCanvas.LEVEL_ENDED, (Displayable)this);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void runEndSequence() {
        try {
            int n2;
            this.gamecomplete = true;
            this.playerTalking = false;
            this.enemyTalking = false;
            this.endGems = new int[5][5];
            for (n2 = 0; n2 < this.endGems.length; ++n2) {
                this.endGems[n2][0] = 40 + n2;
                this.endGems[n2][1] = this.halfScreenWidth - this.halfTileWidth;
                this.endGems[n2][2] = this.screenHeight + this.statusHeight - this.tileHeight * 2;
                this.endGems[n2][3] = -2 + n2;
                this.endGems[n2][4] = -8;
            }
            this.endBaddy = new int[]{2, 0, this.screenWidth, this.screenHeight + this.statusHeight - this.tileHeight * 2, -8, 0};
            this.endString = null;
            this.pXPos = 0;
            this.pYPos = this.screenHeight + this.statusHeight - this.tileHeight * 2;
            this.pMove = 3;
            while (this.pXPos + this.halfTileWidth < this.halfScreenWidth) {
                this.repaint();
                Thread.sleep(66L);
                this.pXPos += 3;
                ++this.pFrame;
                if (this.pFrame != this.P_FRAMES[this.pMove]) continue;
                this.pFrame = 0;
            }
            this.endString = this.parseString(this.langT[5]);
            this.endStringFont = new Font[]{this.getFont(this.langA[5]), this.getFont(this.langA[6]), this.getFont(this.langA[7]), this.getFont(this.langA[8])};
            this.endStringCenterX = this.halfScreenWidth;
            this.endStringTop = this.pYPos - this.halfTileHeight - this.tileHeight - this.endStringFont[0].getHeight() * 3;
            this.playerTalking = true;
            this.pFrame = 1;
            this.repaint();
            Thread.sleep(3000L);
            this.endString = this.parseString(this.langT[6]);
            this.repaint();
            Thread.sleep(3000L);
            this.endString = this.parseString(this.langT[7]);
            this.repaint();
            Thread.sleep(3000L);
            this.endString = null;
            this.playerTalking = false;
            while (this.pXPos + this.tileWidth < this.endBaddy[2]) {
                this.endBaddy[2] = this.endBaddy[2] + this.endBaddy[4];
                this.endBaddy[1] = this.endBaddy[1] + 1;
                if (this.endBaddy[1] == this.enemyImages[this.endBaddy[0]].length) {
                    this.endBaddy[1] = 0;
                }
                this.repaint();
                Thread.sleep(66L);
            }
            this.endString = this.parseString(this.langT[8]);
            this.endStringTop = this.pYPos - this.halfTileHeight - this.tileHeight - this.endStringFont[0].getHeight();
            this.playerTalking = true;
            this.pMove = 1;
            this.pDX = -3;
            this.pDY = -8;
            do {
                this.endStringCenterX += this.pDX;
                this.endStringTop += this.pDY;
                this.pXPos += this.pDX;
                this.pYPos += this.pDY;
                ++this.pDY;
                ++this.pFrame;
                if (this.pFrame == this.P_FRAMES[this.pMove]) {
                    this.pFrame = 0;
                }
                for (n2 = 0; n2 < this.endGems.length; ++n2) {
                    int[] nArray = this.endGems[n2];
                    nArray[1] = nArray[1] + this.endGems[n2][3];
                    int[] nArray2 = this.endGems[n2];
                    nArray2[2] = nArray2[2] + this.endGems[n2][4];
                    int[] nArray3 = this.endGems[n2];
                    nArray3[4] = nArray3[4] + 1;
                }
                this.repaint();
                Thread.sleep(66L);
            } while (this.pYPos + this.tileHeight * 2 < this.screenHeight + this.statusHeight);
            this.endString = null;
            this.playerTalking = false;
            while (this.endBaddy[2] > this.endGems[0][1]) {
                this.endBaddy[2] = this.endBaddy[2] + this.endBaddy[4];
                this.endBaddy[1] = this.endBaddy[1] + 1;
                if (this.endBaddy[1] == this.enemyImages[this.endBaddy[0]].length) {
                    this.endBaddy[1] = 0;
                }
                this.repaint();
                Thread.sleep(66L);
            }
            this.endBaddy[0] = 3;
            this.endBaddy[4] = -this.endBaddy[4];
            while (this.endBaddy[2] < this.endGems[4][1]) {
                this.endBaddy[2] = this.endBaddy[2] + this.endBaddy[4];
                this.endBaddy[1] = this.endBaddy[1] + 1;
                if (this.endBaddy[1] == this.enemyImages[this.endBaddy[0]].length) {
                    this.endBaddy[1] = 0;
                }
                for (n2 = 0; n2 < this.endGems.length; ++n2) {
                    if (this.endBaddy[2] <= this.endGems[n2][1]) continue;
                    this.endGems[n2][2] = -this.tileHeight;
                }
                this.repaint();
                Thread.sleep(66L);
            }
            this.endBaddy[0] = 2;
            this.endBaddy[1] = 1;
            this.endString = this.parseString(this.langT[9]);
            this.endStringCenterX = this.halfScreenWidth;
            this.endStringTop = this.endBaddy[3] - this.halfTileHeight - this.tileHeight - this.endStringFont[0].getHeight() * 3;
            this.enemyTalking = true;
            this.repaint();
            Thread.sleep(3000L);
            this.endString = this.parseString(this.langT[10]);
            this.repaint();
            Thread.sleep(3000L);
            this.endString = this.parseString(this.langT[11]);
            this.repaint();
            Thread.sleep(3000L);
            this.pMove = 3;
            this.pDX = 8;
            this.endString = this.parseString(this.langT[12]);
            this.playerTalking = true;
            this.enemyTalking = false;
            this.repaint();
            Thread.sleep(3000L);
            this.endString = this.parseString(this.langT[13]);
            this.repaint();
            Thread.sleep(3000L);
            this.endString = this.parseString(this.langT[14]);
            this.endStringCenterX = this.pXPos + this.endStringFont[0].stringWidth(this.endString[1]) / 2;
            this.endBaddy[0] = 3;
            while (this.endStringCenterX - 10 - this.endStringFont[0].stringWidth(this.endString[0]) / 2 < this.screenWidth) {
                this.endStringCenterX += this.pDX;
                this.pXPos += this.pDX;
                ++this.pFrame;
                if (this.pFrame == this.P_FRAMES[this.pMove]) {
                    this.pFrame = 0;
                }
                this.endBaddy[2] = this.endBaddy[2] + this.endBaddy[4];
                this.endBaddy[1] = this.endBaddy[1] + 1;
                if (this.endBaddy[1] == this.enemyImages[this.endBaddy[0]].length) {
                    this.endBaddy[1] = 0;
                }
                this.repaint();
                Thread.sleep(66L);
            }
            Thread.sleep(1000L);
            this.endString = this.parseString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.langT[15]))).append(",").append(this.langT[16]))));
            this.endStringFont = new Font[]{this.getFont(this.langA[15]), this.getFont(this.langA[16])};
            this.endStringCenterX = this.halfScreenWidth;
            this.endStringTop = this.halfScreenHeight - this.getFont(this.langA[15]).getHeight();
            this.repaint();
            Thread.sleep(3000L);
            this.commandListener.commandAction(BSCanvas.GAME_ENDED, (Displayable)this);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void collect(int n2, int n3, int n4) {
        if (n4 == 48) {
            for (int i2 = 0; i2 < this.teleporters.length; ++i2) {
                if (n2 != this.teleporters[i2][0] || n3 != this.teleporters[i2][1]) continue;
                try {
                    int n5;
                    for (n5 = 0; n5 < 7; ++n5) {
                        switch (n5 % 4) {
                            case 0: {
                                this.pMove = 0;
                                break;
                            }
                            case 1: {
                                this.pMove = 3;
                                break;
                            }
                            case 2: {
                                this.pMove = 1;
                                break;
                            }
                            case 3: {
                                this.pMove = 2;
                            }
                        }
                        this.repaint();
                        Thread.sleep(100L);
                    }
                    this.pXPos = this.teleporters[i2][2] * this.tileWidth;
                    this.pYPos = this.teleporters[i2][3] * this.tileWidth;
                    this.pMoveToTileX = this.teleporters[i2][2];
                    this.pMoveToTileY = this.teleporters[i2][3];
                    for (n5 = 0; n5 < 7; ++n5) {
                        switch (n5 % 4) {
                            case 0: {
                                this.pMove = 0;
                                break;
                            }
                            case 1: {
                                this.pMove = 3;
                                break;
                            }
                            case 2: {
                                this.pMove = 1;
                                break;
                            }
                            case 3: {
                                this.pMove = 2;
                            }
                        }
                        this.repaint();
                        Thread.sleep(100L);
                    }
                    break;
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        } else {
            this.level[n3][n2] = new int[]{0};
            if (n4 >= 40 && n4 < 45) {
                BSCanvas.playSound(this.sounds[2]);
                ++this.pDiamonds;
                this.score += 10 * (this.difficulty + 1);
                this.updateStatus = true;
                if (this.pDiamonds >= this.levelDiamonds) {
                    this.level[this.exitY][this.exitX] = new int[]{49};
                }
            } else if (n4 == 49) {
                this.won = true;
            }
        }
    }

    private void checkDrop() {
        if (this.fallingObjects.size() > 0) {
            int n2 = (this.pXPos + this.halfTileWidth) / this.tileWidth;
            int n3 = (this.pYPos + this.halfTileHeight) / this.tileHeight;
            for (int i2 = 0; i2 < this.fallingObjects.size(); ++i2) {
                int n4;
                int[] nArray = (int[])this.fallingObjects.elementAt(i2);
                boolean bl = false;
                boolean bl2 = false;
                for (n4 = 0; n4 < this.spiders.length; ++n4) {
                    if (this.spiders[n4] == null) continue;
                    int n5 = (this.spiders[n4][0] + this.halfTileWidth) / this.tileWidth;
                    int n6 = (this.spiders[n4][1] + this.halfTileHeight) / this.tileHeight;
                    if (n5 == nArray[1] - 1 && n6 == nArray[2]) {
                        bl = true;
                        continue;
                    }
                    if (n5 != nArray[1] + 1 || n6 != nArray[2]) continue;
                    bl2 = true;
                }
                if (this.level[nArray[2] + 1][nArray[1]][0] < 10) {
                    if (nArray[1] == n2 && nArray[2] == n3 || nArray[1] == n2 && nArray[2] + 1 == n3) {
                        this.fallingObjects.removeElementAt(i2--);
                        if (nArray[0] >= 40) {
                            this.collect(nArray[1], nArray[2], nArray[0]);
                            continue;
                        }
                        this.level[nArray[2]][nArray[1]][3] = 0;
                        this.restartLevel();
                        continue;
                    }
                    for (n4 = 0; n4 < this.spiders.length; ++n4) {
                        if (this.spiders[n4] == null || nArray[1] != (this.spiders[n4][0] + this.halfTileWidth) / this.tileWidth || nArray[2] + 1 != (this.spiders[n4][1] + this.halfTileHeight) / this.tileHeight) continue;
                        this.spiders[n4] = null;
                        this.score += 20 * (this.difficulty + 1);
                        this.updateStatus = true;
                        break;
                    }
                    this.level[nArray[2] + 1][nArray[1]] = this.level[nArray[2]][nArray[1]];
                    this.level[nArray[2]][nArray[1]] = new int[]{0};
                    nArray[2] = nArray[2] + 1;
                    continue;
                }
                if (!(this.level[nArray[2] + 1][nArray[1]][0] < 30 || this.level[nArray[2] + 1][nArray[1]][0] >= 45 || this.level[nArray[2] + 1][nArray[1]][3] != 0 || n2 == nArray[1] + 1 && n3 == nArray[2] || this.level[nArray[2]][nArray[1] + 1][0] >= 10 || this.level[nArray[2] + 1][nArray[1] + 1][0] >= 10 || bl2)) {
                    this.level[nArray[2]][nArray[1] + 1] = this.level[nArray[2]][nArray[1]];
                    this.level[nArray[2]][nArray[1]] = new int[]{0};
                    nArray[1] = nArray[1] + 1;
                    continue;
                }
                if (!(this.level[nArray[2] + 1][nArray[1]][0] < 30 || this.level[nArray[2] + 1][nArray[1]][0] >= 45 || this.level[nArray[2] + 1][nArray[1]][3] != 0 || n2 == nArray[1] - 1 && n3 == nArray[2] || this.level[nArray[2]][nArray[1] - 1][0] >= 10 || this.level[nArray[2] + 1][nArray[1] - 1][0] >= 10 || bl)) {
                    this.level[nArray[2]][nArray[1] - 1] = this.level[nArray[2]][nArray[1]];
                    this.level[nArray[2]][nArray[1]] = new int[]{0};
                    nArray[1] = nArray[1] - 1;
                    continue;
                }
                if (this.level[nArray[2] + 1][nArray[1]][0] >= 30 && this.level[nArray[2] + 1][nArray[1]][0] < 45 && this.level[nArray[2] + 1][nArray[1]][3] != 0) continue;
                BSCanvas.vibrate(50, 100);
                this.fallingObjects.removeElementAt(i2--);
                this.level[nArray[2]][nArray[1]][3] = 0;
            }
        }
    }

    public void keyPressed(int n2) {
        if (!(this.won || this.dead || this.start)) {
            this.keyPressed = true;
            int n3 = this.getGameAction(n2);
            if (n2 == -7) {
                this.commandListener.commandAction(BSCanvas.DISPLAY_MENU, (Displayable)this);
            } else {
                block0 : switch (n3) {
                    case 1: {
                        this.up = true;
                        break;
                    }
                    case 6: {
                        this.down = true;
                        break;
                    }
                    case 2: {
                        this.left = true;
                        break;
                    }
                    case 5: {
                        this.right = true;
                        break;
                    }
                    default: {
                        switch (n2) {
                            case 50: {
                                this.up = true;
                                break block0;
                            }
                            case 56: {
                                this.down = true;
                                break block0;
                            }
                            case 52: {
                                this.left = true;
                                break block0;
                            }
                            case 54: {
                                this.right = true;
                            }
                        }
                    }
                }
            }
        }
    }

    public void keyReleased(int n2) {
        int n3 = this.getGameAction(n2);
        block0 : switch (n3) {
            case 1: {
                this.up = false;
                break;
            }
            case 6: {
                this.down = false;
                break;
            }
            case 2: {
                this.left = false;
                break;
            }
            case 5: {
                this.right = false;
                break;
            }
            default: {
                switch (n2) {
                    case 50: {
                        this.up = false;
                        break block0;
                    }
                    case 56: {
                        this.down = false;
                        break block0;
                    }
                    case 52: {
                        this.left = false;
                        break block0;
                    }
                    case 54: {
                        this.right = false;
                    }
                }
            }
        }
    }

    public String[] parseString(String string) {
        int n2 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) != ',') continue;
            ++n2;
        }
        String[] stringArray = new String[n2 + 1];
        for (int i3 = 0; i3 < n2; ++i3) {
            stringArray[i3] = string.substring(0, string.indexOf(44));
            string = string.substring(string.indexOf(44) + 1);
        }
        stringArray[n2] = string;
        return stringArray;
    }

    public void drawText(Graphics graphics, String[] stringArray, Font font, boolean bl, int n2, int n3) {
        Font[] fontArray = new Font[stringArray.length];
        for (int i2 = 0; i2 < fontArray.length; ++i2) {
            fontArray[i2] = font;
        }
        this.drawText(graphics, stringArray, fontArray, bl, n2, n3);
    }

    private void drawText(Graphics graphics, String[] stringArray, Font[] fontArray, boolean bl, int n2, int n3) {
        int n4;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        for (n4 = 0; n4 < stringArray.length; ++n4) {
            n6 = Math.max(fontArray[n4].stringWidth(stringArray[n4]), n6);
            n8 += fontArray[n4].getHeight();
        }
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(n2 - n6 / 2 - 2, n3 - 2, n6 + 2, n8 + 2);
        graphics.setColor(0);
        for (n4 = 0; n4 < stringArray.length; ++n4) {
            n5 = fontArray[n4].stringWidth(stringArray[n4]);
            graphics.setFont(fontArray[n4]);
            graphics.drawString(stringArray[n4], n2, n3 + n7, 17);
            n7 += fontArray[n4].getHeight();
        }
        if (bl) {
            graphics.drawRect(n2 - n6 / 2 - 2, n3 - 2, n6 + 2, n8 + 2);
        }
    }
}

