/*
 * Decompiled with CFR 0.152.
 */
package logosplash;

import component.CSoundPlayer;
import component.CUtility;
import component.customFont;
import component.gameData;
import game.CCanvas;
import game.CMainGameManager;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CLogoManager {
    private int intLogoTimer;
    private int iCurrentLogoState = 0;
    private int iSoundState;
    private boolean isSoundPlaying = false;
    private Image imageLogo_1;
    private Image imageLogo_2;
    private Image imageSplash;
    private Image imageSplashLogo;
    static final String[] strSound = new String[]{"/sound/menu.mid"};
    private CSoundPlayer objSplashSound;
    private boolean istouch = false;
    private int iBlinkCounter;
    private customFont objTapFont = new customFont(4);

    public CLogoManager() {
        this.intLogoTimer = CCanvas.FPS * 2;
        this.iSoundState = gameData.getData(4);
        this.objSplashSound = new CSoundPlayer();
    }

    public void LoadImages(int intLogoNumber) {
        switch (intLogoNumber) {
            case 0: {
                try {
                    this.imageLogo_1 = Image.createImage((String)"/logo.png");
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case 1: {
                try {
                    this.imageLogo_2 = Image.createImage((String)"/yrf_logo.png");
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case 2: {
                try {
                    this.imageSplash = Image.createImage((String)"/splash.png");
                    this.imageSplashLogo = Image.createImage((String)"/game_logo.png");
                    if (this.iSoundState != 0) break;
                    this.objSplashSound.loadSound(strSound);
                    break;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public void paint(Graphics g2) {
        switch (this.iCurrentLogoState) {
            case 0: {
                if (this.imageLogo_1 == null) {
                    this.LoadImages(0);
                }
                g2.setColor(0xFFFFFF);
                g2.fillRect(0, 0, CCanvas.iScreenW, CCanvas.iScreenH);
                g2.drawImage(this.imageLogo_1, CCanvas.iScreenW >> 1, CCanvas.iScreenH >> 1, 3);
                break;
            }
            case 1: {
                if (this.imageLogo_2 == null) {
                    this.LoadImages(1);
                }
                g2.setColor(0xFFFFFF);
                g2.fillRect(0, 0, CCanvas.iScreenW, CCanvas.iScreenH);
                g2.drawImage(this.imageLogo_2, CCanvas.iScreenW >> 1, CCanvas.iScreenH >> 1, 3);
                break;
            }
            case 2: {
                if (this.imageSplash == null) {
                    this.LoadImages(2);
                }
                if (this.iSoundState == 0 && !this.isSoundPlaying) {
                    this.objSplashSound.playSound(0, true);
                    this.isSoundPlaying = true;
                }
                g2.setColor(0);
                g2.fillRect(0, 0, CCanvas.iScreenW, CCanvas.iScreenH);
                g2.drawImage(this.imageSplash, CCanvas.iScreenW >> 1, CCanvas.iScreenH >> 1, 3);
                g2.drawImage(this.imageSplashLogo, CCanvas.iScreenW >> 1, this.imageSplashLogo.getHeight() >> 1, 3);
                if (this.iBlinkCounter % 4 == 0) break;
                String[] strSplitNext = CUtility.getTextRows("Press OK/Tap to continue ...", this.objTapFont, CCanvas.iScreenW - (CCanvas.iScreenW >> 3));
                for (int i2 = 0; i2 < strSplitNext.length; ++i2) {
                    this.objTapFont.drawString(strSplitNext[i2], CCanvas.iScreenW >> 1, CCanvas.iScreenH - (CCanvas.iScreenH >> 3) + this.objTapFont.getHeight() * i2, g2, 17);
                }
                break;
            }
        }
    }

    public void update() {
        if (this.intLogoTimer <= 0) {
            if (this.iCurrentLogoState != 2) {
                ++this.iCurrentLogoState;
            }
            this.intLogoTimer = CCanvas.FPS * 2;
        } else if (this.iCurrentLogoState != 2) {
            --this.intLogoTimer;
        }
        if (this.iCurrentLogoState == 2) {
            ++this.iBlinkCounter;
            this.iBlinkCounter %= 150;
            if (this.istouch) {
                CMainGameManager.getInstance().switchToStates(1);
            }
        }
    }

    public void handleInput(int key, boolean isPressed) {
        if (isPressed) {
            switch (key) {
                case 205: {
                    if (this.iCurrentLogoState != 2) break;
                    this.istouch = true;
                }
            }
        }
    }

    public void handleTouchInput(int pointerX, int pointerY, int iTouchState) {
        if (iTouchState == 2 && this.iCurrentLogoState == 2) {
            this.istouch = true;
        }
    }

    public void gameInterrupted(boolean state) {
        if (state) {
            if (this.iSoundState == 0) {
                this.objSplashSound.stopSound(0);
            }
        } else if (this.iSoundState == 0) {
            this.objSplashSound.playSound(0, true);
        }
    }

    public void UnLoadImages() {
        this.imageLogo_1 = null;
        this.imageLogo_2 = null;
        this.imageSplash = null;
        if (this.iSoundState == 0) {
            this.objSplashSound.stopSound(0);
        }
        this.objSplashSound.unloadSound();
        this.objSplashSound = null;
    }
}

